/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Revision;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.GitUtils;
import hudson.scm.SCM;
import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitBranchSCMHead;
import jenkins.plugins.git.GitBranchSCMRevision;
import jenkins.plugins.git.GitHooksConfiguration;
import jenkins.plugins.git.GitRefSCMHead;
import jenkins.plugins.git.GitRefSCMRevision;
import jenkins.plugins.git.GitRemoteHeadRefAction;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.plugins.git.GitSCMSourceRequest;
import jenkins.plugins.git.GitSCMTelescope;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.plugins.git.traits.GitSCMExtensionTrait;
import jenkins.plugins.git.traits.GitToolSCMSourceTrait;
import jenkins.plugins.git.traits.RemoteNameSCMSourceTrait;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import net.jcip.annotations.GuardedBy;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.Exported;

public abstract class AbstractGitSCMSource
extends SCMSource {
    public static final String DEFAULT_REMOTE_NAME = "origin";
    public static final String REF_SPEC_REMOTE_NAME_PLACEHOLDER_STR = "@{remote}";
    public static final String REF_SPEC_REMOTE_NAME_PLACEHOLDER = "(?i)" + Pattern.quote("@{remote}");
    public static final String REF_SPEC_DEFAULT = "+refs/heads/*:refs/remotes/@{remote}/*";
    private static final ConcurrentMap<String, Lock> cacheLocks = new ConcurrentHashMap<String, Lock>();
    private static final Logger LOGGER = Logger.getLogger(AbstractGitSCMSource.class.getName());

    public AbstractGitSCMSource() {
    }

    @Deprecated
    public AbstractGitSCMSource(String id) {
        this.setId(id);
    }

    @CheckForNull
    public abstract String getCredentialsId();

    public abstract String getRemote();

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public String getIncludes() {
        WildcardSCMHeadFilterTrait trait = (WildcardSCMHeadFilterTrait)SCMTrait.find(this.getTraits(), WildcardSCMHeadFilterTrait.class);
        return trait != null ? trait.getIncludes() : "*";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public String getExcludes() {
        WildcardSCMHeadFilterTrait trait = (WildcardSCMHeadFilterTrait)SCMTrait.find(this.getTraits(), WildcardSCMHeadFilterTrait.class);
        return trait != null ? trait.getExcludes() : "";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    @RestrictedSince(value="3.4.0")
    public GitRepositoryBrowser getBrowser() {
        GitBrowserSCMSourceTrait trait = (GitBrowserSCMSourceTrait)SCMTrait.find(this.getTraits(), GitBrowserSCMSourceTrait.class);
        return trait != null ? trait.getBrowser() : null;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    @RestrictedSince(value="3.4.0")
    public String getGitTool() {
        GitToolSCMSourceTrait trait = (GitToolSCMSourceTrait)SCMTrait.find(this.getTraits(), GitToolSCMSourceTrait.class);
        return trait != null ? trait.getGitTool() : null;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @NonNull
    @RestrictedSince(value="3.4.0")
    public List<GitSCMExtension> getExtensions() {
        ArrayList extensions = new ArrayList();
        for (SCMSourceTrait t : this.getTraits()) {
            if (!(t instanceof GitSCMExtensionTrait)) continue;
            extensions.add(((GitSCMExtensionTrait)t).getExtension());
        }
        return Collections.unmodifiableList(extensions);
    }

    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return Collections.emptyList();
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public String getRemoteName() {
        RemoteNameSCMSourceTrait trait = (RemoteNameSCMSourceTrait)SCMTrait.find(this.getTraits(), RemoteNameSCMSourceTrait.class);
        return trait != null ? trait.getRemoteName() : DEFAULT_REMOTE_NAME;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @CheckForNull
    @RestrictedSince(value="3.4.0")
    protected GitTool resolveGitTool() {
        return this.resolveGitTool(this.getGitTool());
    }

    @Deprecated
    @CheckForNull
    protected GitTool resolveGitTool(String gitTool) {
        return this.resolveGitTool(gitTool, TaskListener.NULL);
    }

    protected GitTool resolveGitTool(String gitTool, TaskListener listener) {
        Jenkins jenkins = Jenkins.get();
        return GitUtils.resolveGitTool(gitTool, (Node)jenkins, null, TaskListener.NULL);
    }

    @NonNull
    private <T, C extends GitSCMSourceContext<C, R>, R extends GitSCMSourceRequest> T doRetrieve(Retriever<T> retriever, @NonNull C context, @NonNull TaskListener listener, boolean prune) throws IOException, InterruptedException {
        return this.doRetrieve(retriever, context, listener, prune, (Item)this.getOwner(), false);
    }

    @NonNull
    private <T, C extends GitSCMSourceContext<C, R>, R extends GitSCMSourceRequest> T doRetrieve(Retriever<T> retriever, @NonNull C context, @NonNull TaskListener listener, boolean prune, @CheckForNull Item retrieveContext) throws IOException, InterruptedException {
        return this.doRetrieve(retriever, context, listener, prune, retrieveContext, false);
    }

    @NonNull
    private <T, C extends GitSCMSourceContext<C, R>, R extends GitSCMSourceRequest> T doRetrieve(Retriever<T> retriever, @NonNull C context, @NonNull TaskListener listener, boolean prune, boolean delayFetch) throws IOException, InterruptedException {
        return this.doRetrieve(retriever, context, listener, prune, (Item)this.getOwner(), delayFetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private <T, C extends GitSCMSourceContext<C, R>, R extends GitSCMSourceRequest> T doRetrieve(Retriever<T> retriever, @NonNull C context, @NonNull TaskListener listener, boolean prune, @CheckForNull Item retrieveContext, boolean delayFetch) throws IOException, InterruptedException {
        String cacheEntry = this.getCacheEntry();
        Lock cacheLock = AbstractGitSCMSource.getCacheLock(cacheEntry);
        cacheLock.lock();
        try {
            File cacheDir = AbstractGitSCMSource.getCacheDir(cacheEntry);
            Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars)).in(cacheDir);
            GitTool tool = this.resolveGitTool(context.gitTool(), listener);
            if (tool != null) {
                git.using(tool.getGitExe());
            }
            GitClient client = git.getClient();
            client.addDefaultCredentials((StandardCredentials)this.getCredentials(retrieveContext));
            if (!client.hasGitRepo(false)) {
                listener.getLogger().println("Creating git repository in " + cacheDir);
                client.init();
            }
            GitHooksConfiguration.configure(client, GitHooksConfiguration.get().isAllowedOnController());
            String remoteName = context.remoteName();
            listener.getLogger().println("Setting " + remoteName + " to " + this.getRemote());
            client.setRemoteUrl(remoteName, this.getRemote());
            listener.getLogger().println((prune ? "Fetching & pruning " : "Fetching ") + remoteName + "...");
            FetchCommand fetch = client.fetch_();
            fetch = fetch.prune(prune);
            URIish remoteURI = null;
            try {
                remoteURI = new URIish(remoteName);
            }
            catch (URISyntaxException ex) {
                listener.getLogger().println("URI syntax exception for '" + remoteName + "' " + ex);
            }
            FetchCommand fetchCommand = fetch.from(remoteURI, context.asRefSpecs());
            if (!delayFetch) {
                fetchCommand.execute();
            } else if (retriever instanceof Retriever2) {
                Object t = ((Retriever2)retriever).run(client, remoteName, fetchCommand);
                return t;
            }
            T t = retriever.run(client, remoteName);
            return t;
        }
        finally {
            cacheLock.unlock();
        }
    }

    @CheckForNull
    protected SCMRevision retrieve(final @NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        GitSCMSourceContext context = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits());
        GitSCMTelescope telescope = GitSCMTelescope.of(this);
        if (telescope != null) {
            String remote = this.getRemote();
            StandardUsernameCredentials credentials = this.getCredentials();
            telescope.validate(remote, (StandardCredentials)credentials);
            return telescope.getRevision(remote, (StandardCredentials)credentials, head);
        }
        return this.doRetrieve(new Retriever<SCMRevision>(){

            @Override
            public SCMRevision run(GitClient client, String remoteName) throws IOException, InterruptedException {
                if (head instanceof GitTagSCMHead) {
                    try {
                        ObjectId objectId = client.revParse("refs/tags/" + head.getName());
                        return new GitTagSCMRevision((GitTagSCMHead)head, objectId.name());
                    }
                    catch (GitException e) {
                        return null;
                    }
                }
                if (head instanceof GitBranchSCMHead) {
                    for (Branch b : client.getRemoteBranches()) {
                        String branchName = StringUtils.removeStart((String)b.getName(), (String)(remoteName + "/"));
                        if (!branchName.equals(head.getName())) continue;
                        return new GitBranchSCMRevision((GitBranchSCMHead)head, b.getSHA1String());
                    }
                } else {
                    if (head instanceof GitRefSCMHead) {
                        try {
                            ObjectId objectId = client.revParse(((GitRefSCMHead)head).getRef());
                            return new GitRefSCMRevision((GitRefSCMHead)head, objectId.name());
                        }
                        catch (GitException e) {
                            return null;
                        }
                    }
                    for (Branch b : client.getRemoteBranches()) {
                        String branchName = StringUtils.removeStart((String)b.getName(), (String)(remoteName + "/"));
                        if (!branchName.equals(head.getName())) continue;
                        return new SCMRevisionImpl(head, b.getSHA1String());
                    }
                }
                return null;
            }
        }, context, listener, false);
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Known non-serializable this")
    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        final GitSCMSourceContext context = (GitSCMSourceContext)new GitSCMSourceContext(criteria, observer).withTraits(this.getTraits());
        final GitSCMTelescope telescope = GitSCMTelescope.of(this);
        if (telescope != null) {
            final String remote = this.getRemote();
            final StandardUsernameCredentials credentials = this.getCredentials();
            telescope.validate(remote, (StandardCredentials)credentials);
            HashSet<GitSCMTelescope.ReferenceType> referenceTypes = new HashSet<GitSCMTelescope.ReferenceType>();
            if (context.wantBranches()) {
                referenceTypes.add(GitSCMTelescope.ReferenceType.HEAD);
            }
            if (context.wantTags()) {
                referenceTypes.add(GitSCMTelescope.ReferenceType.TAG);
            }
            if (!referenceTypes.isEmpty()) {
                block15: {
                    try (SCMSourceRequest request = context.newRequest(this, listener);){
                        int count;
                        listener.getLogger().println("Listing remote references...");
                        Iterable<SCMRevision> revisions = telescope.getRevisions(remote, (StandardCredentials)credentials, referenceTypes);
                        if (context.wantBranches()) {
                            listener.getLogger().println("Checking branches...");
                            count = 0;
                            for (final SCMRevision revision : revisions) {
                                if (!(revision instanceof SCMRevisionImpl) || revision instanceof GitTagSCMRevision) continue;
                                ++count;
                                if (!request.process(revision.getHead(), (SCMSourceRequest.RevisionLambda)new SCMSourceRequest.RevisionLambda<SCMHead, SCMRevisionImpl>(){

                                    @NonNull
                                    public SCMRevisionImpl create(@NonNull SCMHead head) throws IOException, InterruptedException {
                                        listener.getLogger().println("  Checking branch " + revision.getHead().getName());
                                        return (SCMRevisionImpl)revision;
                                    }
                                }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<SCMHead, SCMRevisionImpl>(){

                                    @NonNull
                                    public SCMSourceCriteria.Probe create(@NonNull SCMHead head, @NonNull SCMRevisionImpl revision) throws IOException, InterruptedException {
                                        return new TelescopingSCMProbe(telescope, remote, (StandardCredentials)credentials, revision);
                                    }
                                }, new SCMSourceRequest.Witness[]{new SCMSourceRequest.Witness(){

                                    public void record(@NonNull SCMHead head, SCMRevision revision, boolean isMatch) {
                                        if (isMatch) {
                                            listener.getLogger().println("    Met criteria");
                                        } else {
                                            listener.getLogger().println("    Does not meet criteria");
                                        }
                                    }
                                }})) continue;
                                listener.getLogger().format("Processed %d branches (query complete)%n", count);
                                return;
                            }
                            listener.getLogger().format("Processed %d branches%n", count);
                        }
                        if (!context.wantTags()) break block15;
                        listener.getLogger().println("Checking tags...");
                        count = 0;
                        for (final SCMRevision revision : revisions) {
                            if (!(revision instanceof GitTagSCMRevision)) continue;
                            ++count;
                            SCMHead scmHead = revision.getHead();
                            if (!(scmHead instanceof GitTagSCMHead)) continue;
                            GitTagSCMHead gitTagHead = (GitTagSCMHead)scmHead;
                            if (!request.process((SCMHead)gitTagHead, (SCMSourceRequest.RevisionLambda)new SCMSourceRequest.RevisionLambda<GitTagSCMHead, GitTagSCMRevision>(){

                                @NonNull
                                public GitTagSCMRevision create(@NonNull GitTagSCMHead head) throws IOException, InterruptedException {
                                    listener.getLogger().println("  Checking tag " + revision.getHead().getName());
                                    return (GitTagSCMRevision)revision;
                                }
                            }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<GitTagSCMHead, GitTagSCMRevision>(){

                                @NonNull
                                public SCMSourceCriteria.Probe create(@NonNull GitTagSCMHead head, @NonNull GitTagSCMRevision revision) throws IOException, InterruptedException {
                                    return new TelescopingSCMProbe(telescope, remote, (StandardCredentials)credentials, revision);
                                }
                            }, new SCMSourceRequest.Witness[]{new SCMSourceRequest.Witness(){

                                public void record(@NonNull SCMHead head, SCMRevision revision, boolean isMatch) {
                                    if (isMatch) {
                                        listener.getLogger().println("    Met criteria");
                                    } else {
                                        listener.getLogger().println("    Does not meet criteria");
                                    }
                                }
                            }})) continue;
                            listener.getLogger().format("Processed %d tags (query complete)%n", count);
                            return;
                        }
                        listener.getLogger().format("Processed %d tags%n", count);
                    }
                }
                return;
            }
        }
        this.doRetrieve(new Retriever2<Void>(){

            @Override
            public Void run(GitClient client, String remoteName, FetchCommand fetch) throws IOException, InterruptedException {
                Map remoteReferences;
                if (context.wantBranches() || context.wantTags() || context.wantOtherRefs()) {
                    listener.getLogger().println("Listing remote references...");
                    boolean headsOnly = !context.wantOtherRefs() && context.wantBranches();
                    boolean tagsOnly = !context.wantOtherRefs() && context.wantTags();
                    remoteReferences = client.getRemoteReferences(client.getRemoteUrl(remoteName), null, headsOnly, tagsOnly);
                } else {
                    remoteReferences = Collections.emptyMap();
                }
                fetch.execute();
                try (Repository repository = client.getRepository();
                     RevWalk walk = new RevWalk(repository);
                     SCMSourceRequest request = context.newRequest(AbstractGitSCMSource.this, listener);){
                    if (context.wantBranches()) {
                        this.discoverBranches(repository, walk, (GitSCMSourceRequest)request, remoteReferences);
                    }
                    if (context.wantTags()) {
                        this.discoverTags(repository, walk, (GitSCMSourceRequest)request, remoteReferences);
                    }
                    if (context.wantOtherRefs()) {
                        this.discoverOtherRefs(repository, walk, (GitSCMSourceRequest)request, remoteReferences, context.getRefNameMappings());
                    }
                }
                return null;
            }

            private void discoverOtherRefs(final Repository repository, final RevWalk walk, GitSCMSourceRequest request, Map<String, ObjectId> remoteReferences, Collection<GitSCMSourceContext.RefNameMapping> wantedRefs) throws IOException, InterruptedException {
                listener.getLogger().println("Checking other refs...");
                walk.setRetainBody(false);
                int count = 0;
                block0: for (final Map.Entry<String, ObjectId> ref : remoteReferences.entrySet()) {
                    if (ref.getKey().startsWith("refs/heads/") || ref.getKey().startsWith("refs/tags/")) continue;
                    for (GitSCMSourceContext.RefNameMapping otherRef : wantedRefs) {
                        if (!otherRef.matches(ref.getKey())) continue;
                        final String refName = otherRef.getName(ref.getKey());
                        if (refName == null) {
                            listener.getLogger().println("  Possible badly configured name mapping (" + otherRef.getName() + ") (for " + ref.getKey() + ") ignoring.");
                            continue;
                        }
                        ++count;
                        if (!request.process(new GitRefSCMHead(refName, ref.getKey()), (SCMSourceRequest.IntermediateLambda)new SCMSourceRequest.IntermediateLambda<ObjectId>(){

                            @Nullable
                            public ObjectId create() throws IOException, InterruptedException {
                                listener.getLogger().println("  Checking ref " + refName + " (" + (String)ref.getKey() + ")");
                                return (ObjectId)ref.getValue();
                            }
                        }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<GitRefSCMHead, ObjectId>(){

                            @NonNull
                            public SCMSourceCriteria.Probe create(@NonNull GitRefSCMHead head, @Nullable ObjectId revisionInfo) throws IOException, InterruptedException {
                                RevCommit commit = walk.parseCommit((AnyObjectId)revisionInfo);
                                long lastModified = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                                RevTree tree = commit.getTree();
                                return new TreeWalkingSCMProbe(refName, lastModified, repository, tree);
                            }
                        }, (SCMSourceRequest.LazyRevisionLambda)new SCMSourceRequest.LazyRevisionLambda<GitRefSCMHead, SCMRevision, ObjectId>(){

                            @NonNull
                            public SCMRevision create(@NonNull GitRefSCMHead head, @Nullable ObjectId intermediate) throws IOException, InterruptedException {
                                return new GitRefSCMRevision(head, ((ObjectId)ref.getValue()).name());
                            }
                        }, new SCMSourceRequest.Witness[]{new SCMSourceRequest.Witness(){

                            public void record(@NonNull SCMHead head, SCMRevision revision, boolean isMatch) {
                                if (isMatch) {
                                    listener.getLogger().println("    Met criteria");
                                } else {
                                    listener.getLogger().println("    Does not meet criteria");
                                }
                            }
                        }})) continue block0;
                        listener.getLogger().format("Processed %d refs (query complete)%n", count);
                        return;
                    }
                }
                listener.getLogger().format("Processed %d refs%n", count);
            }

            private void discoverBranches(final Repository repository, final RevWalk walk, GitSCMSourceRequest request, Map<String, ObjectId> remoteReferences) throws IOException, InterruptedException {
                listener.getLogger().println("Checking branches...");
                walk.setRetainBody(false);
                int count = 0;
                for (final Map.Entry<String, ObjectId> ref : remoteReferences.entrySet()) {
                    if (!ref.getKey().startsWith("refs/heads/")) continue;
                    ++count;
                    final String branchName = StringUtils.removeStart((String)ref.getKey(), (String)"refs/heads/");
                    if (!request.process(new GitBranchSCMHead(branchName), (SCMSourceRequest.IntermediateLambda)new SCMSourceRequest.IntermediateLambda<ObjectId>(){

                        @Nullable
                        public ObjectId create() throws IOException, InterruptedException {
                            listener.getLogger().println("  Checking branch " + branchName);
                            return (ObjectId)ref.getValue();
                        }
                    }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<GitBranchSCMHead, ObjectId>(){

                        @NonNull
                        public SCMSourceCriteria.Probe create(@NonNull GitBranchSCMHead head, @Nullable ObjectId revisionInfo) throws IOException, InterruptedException {
                            RevCommit commit = walk.parseCommit((AnyObjectId)revisionInfo);
                            long lastModified = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                            RevTree tree = commit.getTree();
                            return new TreeWalkingSCMProbe(branchName, lastModified, repository, tree);
                        }
                    }, (SCMSourceRequest.LazyRevisionLambda)new SCMSourceRequest.LazyRevisionLambda<GitBranchSCMHead, SCMRevision, ObjectId>(){

                        @NonNull
                        public SCMRevision create(@NonNull GitBranchSCMHead head, @Nullable ObjectId intermediate) throws IOException, InterruptedException {
                            return new GitBranchSCMRevision(head, ((ObjectId)ref.getValue()).name());
                        }
                    }, new SCMSourceRequest.Witness[]{new SCMSourceRequest.Witness(){

                        public void record(@NonNull SCMHead head, SCMRevision revision, boolean isMatch) {
                            if (isMatch) {
                                listener.getLogger().println("    Met criteria");
                            } else {
                                listener.getLogger().println("    Does not meet criteria");
                            }
                        }
                    }})) continue;
                    listener.getLogger().format("Processed %d branches (query complete)%n", count);
                    return;
                }
                listener.getLogger().format("Processed %d branches%n", count);
            }

            private void discoverTags(final Repository repository, final RevWalk walk, GitSCMSourceRequest request, Map<String, ObjectId> remoteReferences) throws IOException, InterruptedException {
                listener.getLogger().println("Checking tags...");
                walk.setRetainBody(false);
                int count = 0;
                for (final Map.Entry<String, ObjectId> ref : remoteReferences.entrySet()) {
                    if (!ref.getKey().startsWith("refs/tags/")) continue;
                    ++count;
                    final String tagName = StringUtils.removeStart((String)ref.getKey(), (String)"refs/tags/");
                    RevCommit commit = walk.parseCommit((AnyObjectId)ref.getValue());
                    long lastModified = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                    if (!request.process(new GitTagSCMHead(tagName, lastModified), (SCMSourceRequest.IntermediateLambda)new SCMSourceRequest.IntermediateLambda<ObjectId>(){

                        @Nullable
                        public ObjectId create() throws IOException, InterruptedException {
                            listener.getLogger().println("  Checking tag " + tagName);
                            return (ObjectId)ref.getValue();
                        }
                    }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<GitTagSCMHead, ObjectId>(){

                        @NonNull
                        public SCMSourceCriteria.Probe create(@NonNull GitTagSCMHead head, @Nullable ObjectId revisionInfo) throws IOException, InterruptedException {
                            RevCommit commit = walk.parseCommit((AnyObjectId)revisionInfo);
                            long lastModified = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                            RevTree tree = commit.getTree();
                            return new TreeWalkingSCMProbe(tagName, lastModified, repository, tree);
                        }
                    }, (SCMSourceRequest.LazyRevisionLambda)new SCMSourceRequest.LazyRevisionLambda<GitTagSCMHead, GitTagSCMRevision, ObjectId>(){

                        @NonNull
                        public GitTagSCMRevision create(@NonNull GitTagSCMHead head, @Nullable ObjectId intermediate) throws IOException, InterruptedException {
                            return new GitTagSCMRevision(head, ((ObjectId)ref.getValue()).name());
                        }
                    }, new SCMSourceRequest.Witness[]{new SCMSourceRequest.Witness(){

                        public void record(@NonNull SCMHead head, SCMRevision revision, boolean isMatch) {
                            if (isMatch) {
                                listener.getLogger().println("    Met criteria");
                            } else {
                                listener.getLogger().println("    Does not meet criteria");
                            }
                        }
                    }})) continue;
                    listener.getLogger().format("Processed %d tags (query complete)%n", count);
                    return;
                }
                listener.getLogger().format("Processed %d tags%n", count);
            }
        }, context, listener, true, true);
    }

    @CheckForNull
    protected SCMRevision retrieve(final @NonNull String revision, final @NonNull TaskListener listener, @CheckForNull Item retrieveContext) throws IOException, InterruptedException {
        final GitSCMSourceContext context = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits());
        GitSCMTelescope telescope = GitSCMTelescope.of(this);
        if (telescope != null) {
            String remote = this.getRemote();
            StandardUsernameCredentials credentials = this.getCredentials(retrieveContext);
            telescope.validate(remote, (StandardCredentials)credentials);
            SCMRevision result = telescope.getRevision(remote, (StandardCredentials)credentials, revision);
            if (result != null) {
                return result;
            }
            result = telescope.getRevision(remote, (StandardCredentials)credentials, "refs/heads/" + revision);
            if (result != null) {
                return result;
            }
            result = telescope.getRevision(remote, (StandardCredentials)credentials, "refs/tags/" + revision);
            if (result != null) {
                return result;
            }
            return null;
        }
        Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars));
        GitTool tool = this.resolveGitTool(context.gitTool(), listener);
        if (tool != null) {
            git.using(tool.getGitExe());
        }
        GitClient client = git.getClient();
        client.addDefaultCredentials((StandardCredentials)this.getCredentials(retrieveContext));
        listener.getLogger().printf("Attempting to resolve %s from remote references...%n", revision);
        boolean headsOnly = !context.wantOtherRefs() && context.wantBranches();
        boolean tagsOnly = !context.wantOtherRefs() && context.wantTags();
        Map remoteReferences = client.getRemoteReferences(this.getRemote(), null, headsOnly, tagsOnly);
        String tagName = null;
        TreeSet<String> shortNameMatches = new TreeSet<String>();
        String shortHashMatch = null;
        TreeSet<String> fullTagMatches = new TreeSet<String>();
        TreeSet<String> fullHashMatches = new TreeSet<String>();
        String fullHashMatch = null;
        GitRefSCMRevision candidateOtherRef = null;
        for (Map.Entry entry : remoteReferences.entrySet()) {
            String name = (String)entry.getKey();
            String rev = ((ObjectId)entry.getValue()).name();
            if ("HEAD".equals(name)) continue;
            if (name.equals("refs/heads/" + revision)) {
                listener.getLogger().printf("Found match: %s revision %s%n", name, rev);
                return new GitBranchSCMRevision(new GitBranchSCMHead(revision), rev);
            }
            if (name.equals("refs/tags/" + revision)) {
                listener.getLogger().printf("Found match: %s revision %s%n", name, rev);
                tagName = revision;
                context.wantBranches(false);
                context.wantTags(true);
                context.withoutRefSpecs();
                break;
            }
            if (name.startsWith("refs/heads/") && revision.equalsIgnoreCase(rev)) {
                listener.getLogger().printf("Found match: %s revision %s%n", name, rev);
                return new GitBranchSCMRevision(new GitBranchSCMHead(StringUtils.removeStart((String)name, (String)"refs/heads/")), rev);
            }
            if (name.startsWith("refs/tags/") && revision.equalsIgnoreCase(rev)) {
                listener.getLogger().printf("Candidate match: %s revision %s%n", name, rev);
                fullTagMatches.add(name);
                continue;
            }
            if (("refs/" + revision.toLowerCase(Locale.ENGLISH)).equals(name.toLowerCase(Locale.ENGLISH))) {
                fullHashMatches.add(name);
                if (fullHashMatch != null) continue;
                fullHashMatch = rev;
                continue;
            }
            if (rev.toLowerCase(Locale.ENGLISH).equals(revision.toLowerCase(Locale.ENGLISH))) {
                fullHashMatches.add(name);
                if (fullHashMatch != null) continue;
                fullHashMatch = rev;
                continue;
            }
            for (GitSCMSourceContext.RefNameMapping o : context.getRefNameMappings()) {
                if (!o.matches(revision, name, rev)) continue;
                candidateOtherRef = new GitRefSCMRevision(new GitRefSCMHead(revision, name), rev);
                break;
            }
            if (!rev.toLowerCase(Locale.ENGLISH).startsWith(revision.toLowerCase(Locale.ENGLISH))) continue;
            shortNameMatches.add(name);
            if (shortHashMatch == null) {
                listener.getLogger().printf("Candidate partial match: %s revision %s%n", name, rev);
                shortHashMatch = rev;
                continue;
            }
            listener.getLogger().printf("Candidate partial match: %s revision %s%n", name, rev);
            listener.getLogger().printf("Cannot resolve ambiguous short revision %s%n", revision);
            return null;
        }
        if (!fullTagMatches.isEmpty()) {
            String name = StringUtils.removeStart((String)((String)fullTagMatches.iterator().next()), (String)"refs/tags/");
            listener.getLogger().printf("Selected match: %s revision %s%n", name, shortHashMatch);
            tagName = name;
            context.wantBranches(false);
            context.wantTags(true);
            context.withoutRefSpecs();
        }
        if (fullHashMatch != null) {
            return new GitRefSCMRevision(new GitRefSCMHead(fullHashMatch, (String)fullHashMatches.iterator().next()), fullHashMatch);
        }
        if (shortHashMatch != null) {
            for (String name : shortNameMatches) {
                if (name.startsWith("refs/heads/")) {
                    listener.getLogger().printf("Selected match: %s revision %s%n", name, shortHashMatch);
                    return new GitBranchSCMRevision(new GitBranchSCMHead(StringUtils.removeStart((String)name, (String)"refs/heads/")), shortHashMatch);
                }
                if (!name.startsWith("refs/tags/")) continue;
                tagName = StringUtils.removeStart((String)name, (String)"refs/tags/");
                context.wantBranches(false);
                context.wantTags(true);
                context.withoutRefSpecs();
            }
            if (tagName != null) {
                listener.getLogger().printf("Selected match: %s revision %s%n", tagName, shortHashMatch);
            } else {
                return new GitRefSCMRevision(new GitRefSCMHead(shortHashMatch, (String)shortNameMatches.iterator().next()), shortHashMatch);
            }
        }
        if (candidateOtherRef != null) {
            return candidateOtherRef;
        }
        boolean pruneRefs = context.pruneRefs();
        if (tagName != null) {
            listener.getLogger().println("Resolving tag commit... (remote references may be a lightweight tag or an annotated tag)");
            final String tagRef = "refs/tags/" + tagName;
            return this.doRetrieve(new Retriever<SCMRevision>(){

                @Override
                public SCMRevision run(GitClient client, String remoteName) throws IOException, InterruptedException {
                    try (Repository repository = client.getRepository();){
                        GitTagSCMRevision gitTagSCMRevision;
                        try (RevWalk walk = new RevWalk(repository);){
                            ObjectId ref = client.revParse(tagRef);
                            RevCommit commit = walk.parseCommit((AnyObjectId)ref);
                            long lastModified = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                            listener.getLogger().printf("Resolved tag %s revision %s%n", revision, ref.getName());
                            gitTagSCMRevision = new GitTagSCMRevision(new GitTagSCMHead(revision, lastModified), ref.name());
                        }
                        return gitTagSCMRevision;
                    }
                }
            }, context, listener, pruneRefs, retrieveContext);
        }
        listener.getLogger().printf("Could not find %s in remote references. Pulling heads to local for deep search...%n", revision);
        context.wantTags(true);
        context.wantBranches(true);
        return this.doRetrieve(new Retriever<SCMRevision>(){

            @Override
            public SCMRevision run(GitClient client, String remoteName) throws IOException, InterruptedException {
                try {
                    ObjectId objectId = client.revParse(revision);
                    if (objectId == null) {
                        listener.error("Could not resolve %s", new Object[]{revision});
                        return null;
                    }
                    String hash = objectId.name();
                    String candidatePrefix = "refs/remotes/".substring("refs/".length()) + context.remoteName() + "/";
                    String name = null;
                    for (Branch b : client.getBranchesContaining(hash, true)) {
                        if (!b.getName().startsWith(candidatePrefix)) continue;
                        name = b.getName().substring(candidatePrefix.length());
                        break;
                    }
                    if (name == null) {
                        listener.getLogger().printf("Could not find a branch containing commit %s%n", hash);
                        return null;
                    }
                    listener.getLogger().printf("Selected match: %s revision %s%n", name, hash);
                    return new GitBranchSCMRevision(new GitBranchSCMHead(name), hash);
                }
                catch (GitException x) {
                    x.printStackTrace(listener.error("Could not resolve %s", new Object[]{revision}));
                    return null;
                }
            }
        }, context, listener, pruneRefs, retrieveContext);
    }

    @NonNull
    protected Set<String> retrieveRevisions(@NonNull TaskListener listener, @CheckForNull Item retrieveContext) throws IOException, InterruptedException {
        GitSCMSourceContext context = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits());
        GitSCMTelescope telescope = GitSCMTelescope.of(this);
        if (telescope != null) {
            String remote = this.getRemote();
            StandardUsernameCredentials credentials = this.getCredentials(retrieveContext);
            telescope.validate(remote, (StandardCredentials)credentials);
            HashSet<GitSCMTelescope.ReferenceType> referenceTypes = new HashSet<GitSCMTelescope.ReferenceType>();
            if (context.wantBranches()) {
                referenceTypes.add(GitSCMTelescope.ReferenceType.HEAD);
            }
            if (context.wantTags()) {
                referenceTypes.add(GitSCMTelescope.ReferenceType.TAG);
            }
            HashSet<String> result = new HashSet<String>();
            for (SCMRevision r : telescope.getRevisions(remote, (StandardCredentials)credentials, referenceTypes)) {
                if (r instanceof GitTagSCMRevision && context.wantTags()) {
                    result.add(r.getHead().getName());
                    continue;
                }
                if (r instanceof GitTagSCMRevision || !context.wantBranches()) continue;
                result.add(r.getHead().getName());
            }
            return result;
        }
        Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars));
        GitTool tool = this.resolveGitTool(context.gitTool(), listener);
        if (tool != null) {
            git.using(tool.getGitExe());
        }
        GitClient client = git.getClient();
        client.addDefaultCredentials((StandardCredentials)this.getCredentials(retrieveContext));
        HashSet<String> revisions = new HashSet<String>();
        if (context.wantBranches() || context.wantTags() || context.wantOtherRefs()) {
            listener.getLogger().println("Listing remote references...");
            boolean headsOnly = !context.wantOtherRefs() && context.wantBranches();
            boolean tagsOnly = !context.wantOtherRefs() && context.wantTags();
            Map remoteReferences = client.getRemoteReferences(this.getRemote(), null, headsOnly, tagsOnly);
            block1: for (String name : remoteReferences.keySet()) {
                if (context.wantBranches() && name.startsWith("refs/heads/")) {
                    revisions.add(StringUtils.removeStart((String)name, (String)"refs/heads/"));
                }
                if (context.wantTags() && name.startsWith("refs/tags/")) {
                    revisions.add(StringUtils.removeStart((String)name, (String)"refs/tags/"));
                }
                if (!context.wantOtherRefs() || name.startsWith("refs/heads/") && name.startsWith("refs/tags/")) continue;
                for (GitSCMSourceContext.RefNameMapping o : context.getRefNameMappings()) {
                    String revName;
                    if (!o.matches(name) || (revName = o.getName(name)) == null) continue;
                    revisions.add(revName);
                    continue block1;
                }
            }
        }
        return revisions;
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        GitSCMTelescope telescope = GitSCMTelescope.of(this);
        if (telescope != null) {
            String remote = this.getRemote();
            StandardUsernameCredentials credentials = this.getCredentials();
            telescope.validate(remote, (StandardCredentials)credentials);
            String target = telescope.getDefaultTarget(remote, (StandardCredentials)credentials);
            if (target.startsWith("refs/heads/")) {
                target = target.substring("refs/heads/".length());
            }
            ArrayList<Action> result = new ArrayList<Action>();
            if (target != null && !target.isBlank()) {
                result.add((Action)new GitRemoteHeadRefAction(this.getRemote(), target));
            }
            return result;
        }
        GitSCMSourceContext context = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits());
        Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars));
        GitTool tool = this.resolveGitTool(context.gitTool(), listener);
        if (tool != null) {
            git.using(tool.getGitExe());
        }
        GitClient client = git.getClient();
        client.addDefaultCredentials((StandardCredentials)this.getCredentials());
        Map symrefs = client.getRemoteSymbolicReferences(this.getRemote(), null);
        if (symrefs.containsKey("HEAD")) {
            String target = (String)symrefs.get("HEAD");
            if (target.startsWith("refs/heads/")) {
                target = target.substring("refs/heads/".length());
            }
            ArrayList<Action> result = new ArrayList<Action>();
            if (target != null && !target.isBlank()) {
                result.add((Action)new GitRemoteHeadRefAction(this.getRemote(), target));
            }
            return result;
        }
        Map remoteReferences = client.getRemoteReferences(this.getRemote(), null, false, false);
        if (remoteReferences.containsKey("HEAD")) {
            ObjectId head = (ObjectId)remoteReferences.get("HEAD");
            TreeSet<String> names = new TreeSet<String>();
            for (Map.Entry entry : remoteReferences.entrySet()) {
                if (((String)entry.getKey()).equals("HEAD") || !head.equals((AnyObjectId)entry.getValue())) continue;
                names.add((String)entry.getKey());
            }
            if (names.size() == 1) {
                String target = (String)names.iterator().next();
                if (target.startsWith("refs/heads/")) {
                    target = target.substring("refs/heads/".length());
                }
                ArrayList<Action> result = new ArrayList<Action>();
                if (target != null && !target.isBlank()) {
                    result.add((Action)new GitRemoteHeadRefAction(this.getRemote(), target));
                }
                return result;
            }
            if (names.contains("refs/heads/master")) {
                ArrayList<Action> result = new ArrayList<Action>();
                result.add((Action)new GitRemoteHeadRefAction(this.getRemote(), "master"));
                return result;
            }
        }
        return new ArrayList<Action>();
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        SCMSourceOwner owner = this.getOwner();
        if (owner instanceof Actionable) {
            for (GitRemoteHeadRefAction a : ((Actionable)owner).getActions(GitRemoteHeadRefAction.class)) {
                if (!this.getRemote().equals(a.getRemote()) || !head.getName().equals(a.getName())) continue;
                return Collections.singletonList(new PrimaryInstanceMetadataAction());
            }
        }
        return Collections.emptyList();
    }

    protected boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        if (super.isCategoryEnabled(category)) {
            for (SCMSourceTrait trait : this.getTraits()) {
                if (!trait.isCategoryEnabled(category)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getCacheEntry() {
        return AbstractGitSCMSource.getCacheEntry(this.getRemote());
    }

    protected static File getCacheDir(String cacheEntry) {
        return AbstractGitSCMSource.getCacheDir(cacheEntry, true);
    }

    protected static File getCacheDir(String cacheEntry, boolean createDirectory) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return null;
        }
        File cacheDir = new File(new File(jenkins.getRootDir(), "caches"), cacheEntry);
        if (!cacheDir.isDirectory()) {
            if (createDirectory) {
                boolean ok = cacheDir.mkdirs();
                if (!ok) {
                    LOGGER.log(Level.WARNING, "Failed mkdirs of {0}", cacheDir);
                }
            } else {
                cacheDir = null;
            }
        }
        return cacheDir;
    }

    protected static Lock getCacheLock(String cacheEntry) {
        Lock cacheLock;
        while (null == (cacheLock = (Lock)cacheLocks.get(cacheEntry))) {
            cacheLocks.putIfAbsent(cacheEntry, new ReentrantLock());
        }
        return cacheLock;
    }

    @CheckForNull
    protected StandardUsernameCredentials getCredentials() {
        return this.getCredentials((Item)this.getOwner());
    }

    @CheckForNull
    private StandardUsernameCredentials getCredentials(@CheckForNull Item context) {
        String credentialsId = this.getCredentialsId();
        if (credentialsId == null) {
            return null;
        }
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.getRemote()).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), GitClient.CREDENTIALS_MATCHER}));
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    protected List<RefSpec> getRefSpecs() {
        return Collections.emptyList();
    }

    protected GitSCMBuilder<?> newBuilder(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        return new GitSCMBuilder(head, revision, this.getRemote(), this.getCredentialsId());
    }

    protected void decorate(GitSCMBuilder<?> builder) {
    }

    @NonNull
    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        GitSCMBuilder<?> builder = this.newBuilder(head, revision);
        if (Util.isOverridden(AbstractGitSCMSource.class, ((Object)((Object)this)).getClass(), (String)"getExtensions", (Class[])new Class[0])) {
            builder.withExtensions(this.getExtensions());
        }
        if (Util.isOverridden(AbstractGitSCMSource.class, ((Object)((Object)this)).getClass(), (String)"getBrowser", (Class[])new Class[0])) {
            builder.withBrowser(this.getBrowser());
        }
        if (Util.isOverridden(AbstractGitSCMSource.class, ((Object)((Object)this)).getClass(), (String)"getGitTool", (Class[])new Class[0])) {
            builder.withGitTool(this.getGitTool());
        }
        if (Util.isOverridden(AbstractGitSCMSource.class, ((Object)((Object)this)).getClass(), (String)"getRefSpecs", (Class[])new Class[0])) {
            ArrayList<String> specs = new ArrayList<String>();
            for (RefSpec spec : this.getRefSpecs()) {
                specs.add(spec.toString());
            }
            ((GitSCMBuilder)((Object)builder.withoutRefSpecs())).withRefSpecs(specs);
        }
        builder.withTraits(this.getTraits());
        this.decorate(builder);
        return builder.build();
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    protected List<UserRemoteConfig> getRemoteConfigs() {
        List<RefSpec> refSpecs = this.getRefSpecs();
        ArrayList<UserRemoteConfig> result = new ArrayList<UserRemoteConfig>(refSpecs.size());
        String remote = this.getRemote();
        for (RefSpec refSpec : refSpecs) {
            result.add(new UserRemoteConfig(remote, this.getRemoteName(), refSpec.toString(), this.getCredentialsId()));
        }
        return result;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    protected boolean isExcluded(String branchName) {
        return !Pattern.matches(this.getPattern(this.getIncludes()), branchName) || Pattern.matches(this.getPattern(this.getExcludes()), branchName);
    }

    private String getPattern(String branches) {
        StringBuilder quotedBranches = new StringBuilder();
        for (String wildcard : branches.split(" ")) {
            StringBuilder quotedBranch = new StringBuilder();
            for (String branch : wildcard.split("(?=[*])|(?<=[*])")) {
                if (branch.equals("*")) {
                    quotedBranch.append(".*");
                    continue;
                }
                if (branch.isEmpty()) continue;
                quotedBranch.append(Pattern.quote(branch));
            }
            if (quotedBranches.length() > 0) {
                quotedBranches.append("|");
            }
            quotedBranches.append((CharSequence)quotedBranch);
        }
        return quotedBranches.toString();
    }

    static String getCacheEntry(String remote) {
        return "git-" + Util.getDigestOf((String)remote);
    }

    private static class TelescopingSCMProbe
    extends SCMProbe {
        @NonNull
        private final GitSCMTelescope telescope;
        @NonNull
        private final String remote;
        @CheckForNull
        private final StandardCredentials credentials;
        @NonNull
        private final SCMRevision revision;
        @GuardedBy(value="this")
        @CheckForNull
        private SCMFileSystem fileSystem;
        @GuardedBy(value="this")
        @CheckForNull
        private Long lastModified;

        public TelescopingSCMProbe(GitSCMTelescope telescope, String remote, StandardCredentials credentials, SCMRevision revision) {
            this.telescope = telescope;
            this.remote = remote;
            this.credentials = credentials;
            this.revision = revision;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public SCMProbeStat stat(@NonNull String path) throws IOException {
            try {
                SCMFileSystem fileSystemForStat;
                TelescopingSCMProbe telescopingSCMProbe = this;
                synchronized (telescopingSCMProbe) {
                    if (this.fileSystem == null) {
                        this.fileSystem = this.telescope.build(this.remote, this.credentials, this.revision.getHead(), this.revision);
                    }
                    fileSystemForStat = this.fileSystem;
                }
                if (fileSystemForStat == null) {
                    throw new IOException("Cannot connect to " + this.remote + " as " + (this.credentials == null ? "anonymous" : CredentialsNameProvider.name((Credentials)this.credentials)));
                }
                return SCMProbeStat.fromType((SCMFile.Type)fileSystemForStat.child(path).getType());
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public synchronized void close() throws IOException {
            if (this.fileSystem != null) {
                this.fileSystem.close();
            }
            this.fileSystem = null;
        }

        public String name() {
            return this.revision.getHead().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long lastModified() {
            long lastModifiedTimeStamp;
            TelescopingSCMProbe telescopingSCMProbe = this;
            synchronized (telescopingSCMProbe) {
                if (this.lastModified != null) {
                    return this.lastModified;
                }
            }
            try {
                lastModifiedTimeStamp = this.telescope.getTimestamp(this.remote, this.credentials, this.revision.getHead());
            }
            catch (IOException | InterruptedException e) {
                return -1L;
            }
            TelescopingSCMProbe telescopingSCMProbe2 = this;
            synchronized (telescopingSCMProbe2) {
                this.lastModified = lastModifiedTimeStamp;
            }
            return lastModifiedTimeStamp;
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="Java 11 generated code causes redundant nullcheck")
    private static class TreeWalkingSCMProbe
    extends SCMProbe {
        private final String name;
        private final long lastModified;
        private final Repository repository;
        private final RevTree tree;

        public TreeWalkingSCMProbe(String name, long lastModified, Repository repository, RevTree tree) {
            this.name = name;
            this.lastModified = lastModified;
            this.repository = repository;
            this.tree = tree;
        }

        public void close() throws IOException {
        }

        public String name() {
            return this.name;
        }

        public long lastModified() {
            return this.lastModified;
        }

        @NonNull
        public SCMProbeStat stat(@NonNull String path) throws IOException {
            try (TreeWalk tw = TreeWalk.forPath((Repository)this.repository, (String)path, (RevTree)this.tree);){
                if (tw == null) {
                    SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                    return sCMProbeStat;
                }
                FileMode fileMode = tw.getFileMode(0);
                if (fileMode == FileMode.MISSING) {
                    SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                    return sCMProbeStat;
                }
                if (fileMode == FileMode.EXECUTABLE_FILE) {
                    SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                    return sCMProbeStat;
                }
                if (fileMode == FileMode.REGULAR_FILE) {
                    SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                    return sCMProbeStat;
                }
                if (fileMode == FileMode.SYMLINK) {
                    SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.LINK);
                    return sCMProbeStat;
                }
                if (fileMode == FileMode.TREE) {
                    SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.DIRECTORY);
                    return sCMProbeStat;
                }
                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.OTHER);
                return sCMProbeStat;
            }
        }
    }

    public static class SpecificRevisionBuildChooser
    extends BuildChooser {
        private final Revision revision;

        public SpecificRevisionBuildChooser(SCMRevisionImpl revision) {
            ObjectId sha1 = ObjectId.fromString((String)revision.getHash());
            String name = revision.getHead().getName();
            this.revision = new Revision(sha1, Collections.singleton(new Branch(name, sha1)));
        }

        @Override
        public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, GitClient git, TaskListener listener, BuildData buildData, BuildChooserContext context) throws GitException, IOException, InterruptedException {
            return Collections.singleton(this.revision);
        }

        @Override
        public Build prevBuildForChangelog(String branch, @Nullable BuildData data, GitClient git, BuildChooserContext context) throws IOException, InterruptedException {
            return data == null ? null : data.lastBuild;
        }
    }

    public static class SCMRevisionImpl
    extends SCMRevision {
        private final String hash;

        public SCMRevisionImpl(SCMHead head, String hash) {
            super(head);
            this.hash = hash;
        }

        @Exported
        public String getHash() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            SCMRevisionImpl that = (SCMRevisionImpl)((Object)o);
            return Objects.equals(this.hash, that.hash) && Objects.equals(this.getHead(), that.getHead());
        }

        public int hashCode() {
            return Objects.hash(this.hash, this.getHead());
        }

        public String toString() {
            return this.hash;
        }
    }

    private static interface Retriever2<T>
    extends Retriever<T> {
        public T run(GitClient var1, String var2, FetchCommand var3) throws IOException, InterruptedException;
    }

    private static interface Retriever<T> {
        default public T run(GitClient client, String remoteName) throws IOException, InterruptedException {
            throw new AbstractMethodError("Not implemented");
        }
    }
}

