/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class KilnGit
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public KilnGit(String repoUrl) {
        super(repoUrl);
    }

    private QueryBuilder param(URL url) {
        return new QueryBuilder(url.getQuery());
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return KilnGit.encodeURL(new URL(url, url.getPath() + "History/" + changeSet.getId() + this.param(url)));
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        return this.getDiffLinkRegardlessOfEditType(path);
    }

    private URL getDiffLinkRegardlessOfEditType(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        int i = this.getIndexOfPath(path);
        if (i >= 0) {
            URL url = this.getUrl();
            return new URL(this.getChangeSetLink(changeSet), this.param(url) + "#diff-" + (i + 1));
        }
        return this.getChangeSetLink(changeSet);
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLinkRegardlessOfEditType(path);
        }
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        return KilnGit.encodeURL(new URL(url, url.getPath() + "FileHistory/" + path.getPath() + this.param(url).add("rev=" + changeSet.getId())));
    }

    @Extension
    @Symbol(value={"kiln"})
    public static class KilnGitDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "Kiln";
        }

        public KilnGit newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (KilnGit)((Object)req.bindJSON(KilnGit.class, jsonObject));
        }
    }
}

