/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.scm.api.SCMFile;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE", "NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="Java 11 generated code causes redundant nullcheck")
public class GitSCMFile
extends SCMFile {
    private final GitSCMFileSystem fs;

    public GitSCMFile(GitSCMFileSystem fs) {
        this.fs = fs;
    }

    public GitSCMFile(GitSCMFileSystem fs, @NonNull GitSCMFile parent, String name) {
        super((SCMFile)parent, name);
        this.fs = fs;
    }

    @NonNull
    protected SCMFile newChild(String name, boolean assumeIsDirectory) {
        return new GitSCMFile(this.fs, this, name);
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        return this.fs.invoke(repository -> {
            ArrayList<GitSCMFile> arrayList;
            RevWalk walk;
            block23: {
                walk = new RevWalk(repository);
                RevCommit commit = walk.parseCommit((AnyObjectId)this.fs.getCommitId());
                RevTree tree = commit.getTree();
                if (this.isRoot()) {
                    try (TreeWalk tw = new TreeWalk(repository);){
                        tw.addTree((AnyObjectId)tree);
                        tw.setRecursive(false);
                        ArrayList<GitSCMFile> result = new ArrayList<GitSCMFile>();
                        while (tw.next()) {
                            result.add(new GitSCMFile(this.fs, this, tw.getNameString()));
                        }
                        ArrayList<GitSCMFile> arrayList2 = result;
                        return arrayList2;
                    }
                }
                TreeWalk tw = TreeWalk.forPath((Repository)repository, (String)this.getPath(), (RevTree)tree);
                try {
                    if (tw == null) {
                        throw new FileNotFoundException();
                    }
                    FileMode fileMode = tw.getFileMode(0);
                    if (fileMode == FileMode.MISSING) {
                        throw new FileNotFoundException();
                    }
                    if (fileMode != FileMode.TREE) {
                        throw new IOException("Not a directory");
                    }
                    tw.enterSubtree();
                    ArrayList<GitSCMFile> result = new ArrayList<GitSCMFile>();
                    while (tw.next()) {
                        result.add(new GitSCMFile(this.fs, this, tw.getNameString()));
                    }
                    arrayList = result;
                    if (tw == null) break block23;
                }
                catch (Throwable throwable) {
                    if (tw != null) {
                        try {
                            tw.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tw.close();
            }
            return arrayList;
            finally {
                walk.close();
            }
        });
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.fs.lastModified();
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        return this.fs.invoke(repository -> {
            try (RevWalk walk = new RevWalk(repository);){
                SCMFile.Type type;
                block35: {
                    TreeWalk tw;
                    block33: {
                        SCMFile.Type type2;
                        block34: {
                            FileMode fileMode;
                            block31: {
                                SCMFile.Type type3;
                                block32: {
                                    block29: {
                                        SCMFile.Type type4;
                                        block30: {
                                            block27: {
                                                SCMFile.Type type5;
                                                block28: {
                                                    block25: {
                                                        SCMFile.Type type6;
                                                        block26: {
                                                            block23: {
                                                                SCMFile.Type type7;
                                                                block24: {
                                                                    RevCommit commit = walk.parseCommit((AnyObjectId)this.fs.getCommitId());
                                                                    RevTree tree = commit.getTree();
                                                                    tw = TreeWalk.forPath((Repository)repository, (String)this.getPath(), (RevTree)tree);
                                                                    try {
                                                                        if (tw != null) break block23;
                                                                        type7 = SCMFile.Type.NONEXISTENT;
                                                                        if (tw == null) break block24;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        if (tw != null) {
                                                                            try {
                                                                                tw.close();
                                                                            }
                                                                            catch (Throwable throwable2) {
                                                                                throwable.addSuppressed(throwable2);
                                                                            }
                                                                        }
                                                                        throw throwable;
                                                                    }
                                                                    tw.close();
                                                                }
                                                                return type7;
                                                            }
                                                            fileMode = tw.getFileMode(0);
                                                            if (fileMode != FileMode.MISSING) break block25;
                                                            type6 = SCMFile.Type.NONEXISTENT;
                                                            if (tw == null) break block26;
                                                            tw.close();
                                                        }
                                                        return type6;
                                                    }
                                                    if (fileMode != FileMode.EXECUTABLE_FILE) break block27;
                                                    type5 = SCMFile.Type.REGULAR_FILE;
                                                    if (tw == null) break block28;
                                                    tw.close();
                                                }
                                                return type5;
                                            }
                                            if (fileMode != FileMode.REGULAR_FILE) break block29;
                                            type4 = SCMFile.Type.REGULAR_FILE;
                                            if (tw == null) break block30;
                                            tw.close();
                                        }
                                        return type4;
                                    }
                                    if (fileMode != FileMode.SYMLINK) break block31;
                                    type3 = SCMFile.Type.LINK;
                                    if (tw == null) break block32;
                                    tw.close();
                                }
                                return type3;
                            }
                            if (fileMode != FileMode.TREE) break block33;
                            type2 = SCMFile.Type.DIRECTORY;
                            if (tw == null) break block34;
                            tw.close();
                        }
                        return type2;
                    }
                    type = SCMFile.Type.OTHER;
                    if (tw == null) break block35;
                    tw.close();
                }
                return type;
            }
        });
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        return (InputStream)this.fs.invoke(repository -> {
            try (RevWalk walk = new RevWalk(repository);){
                ObjectStream objectStream;
                block14: {
                    RevCommit commit = walk.parseCommit((AnyObjectId)this.fs.getCommitId());
                    RevTree tree = commit.getTree();
                    TreeWalk tw = TreeWalk.forPath((Repository)repository, (String)this.getPath(), (RevTree)tree);
                    try {
                        if (tw == null) {
                            throw new FileNotFoundException();
                        }
                        FileMode fileMode = tw.getFileMode(0);
                        if (fileMode == FileMode.MISSING) {
                            throw new FileNotFoundException();
                        }
                        if (fileMode == FileMode.TREE) {
                            throw new IOException("Directory");
                        }
                        ObjectId objectId = tw.getObjectId(0);
                        ObjectLoader loader = repository.open((AnyObjectId)objectId);
                        objectStream = loader.openStream();
                        if (tw == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (tw != null) {
                            try {
                                tw.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    tw.close();
                }
                return objectStream;
            }
        });
    }
}

