/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.EnvVars;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.IDN;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class GitRepositoryBrowser
extends RepositoryBrowser<GitChangeSet> {
    private String url;
    private static final Logger LOGGER = Logger.getLogger(GitRepositoryBrowser.class.getName());
    private static final Pattern SUFFIXES = Pattern.compile(".*[.](corp|home|local|localnet)$");
    private static final long serialVersionUID = 1L;

    @Deprecated
    protected GitRepositoryBrowser() {
    }

    protected GitRepositoryBrowser(String repourl) {
        this.url = repourl;
    }

    public final String getRepoUrl() {
        return this.url;
    }

    public final URL getUrl() throws IOException {
        Job job;
        String u = this.url;
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && (job = (Job)req.findAncestorObject(Job.class)) != null) {
            EnvVars env;
            try {
                env = job.getEnvironment(null, TaskListener.NULL);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to retrieve job environment", e);
            }
            u = env.expand(this.url);
        }
        if (this.getNormalizeUrl()) {
            return GitRepositoryBrowser.normalizeToEndWithSlash((URL)new URL(u));
        }
        return new URL(u);
    }

    public abstract URL getDiffLink(GitChangeSet.Path var1) throws IOException;

    public abstract URL getFileLink(GitChangeSet.Path var1) throws IOException, URISyntaxException;

    protected boolean getNormalizeUrl() {
        return true;
    }

    protected int getIndexOfPath(GitChangeSet.Path path) throws IOException {
        String pathAsString = path.getPath();
        GitChangeSet changeSet = path.getChangeSet();
        int i = 0;
        for (String affected : changeSet.getAffectedPaths()) {
            if (affected.compareTo(pathAsString) >= 0) continue;
            ++i;
        }
        return i;
    }

    public static URL encodeURL(URL url) throws IOException {
        try {
            return new URI(url.getProtocol(), url.getUserInfo(), IDN.toASCII(url.getHost()), url.getPort(), url.getPath(), url.getQuery(), url.getRef()).toURL();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected static boolean initialChecksAndReturnOk(Item project, String cleanUrl) {
        if (cleanUrl == null) {
            return true;
        }
        if (project == null || !project.hasPermission(Item.CONFIGURE)) {
            return true;
        }
        return cleanUrl.contains("$");
    }

    protected static boolean validateUrl(String url) throws URISyntaxException {
        try {
            URL urlToValidate = new URL(url);
            String hostname = urlToValidate.getHost();
            if (hostname == null) {
                LOGGER.log(Level.FINE, "Invalid hostname validating URL {0}", url);
                return false;
            }
            if (SUFFIXES.matcher(hostname).matches()) {
                return true;
            }
            if (InetAddress.getByName(hostname) == null) {
                LOGGER.log(Level.FINE, "Host unknown validating URL {0}", url);
                return false;
            }
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.FINE, "Malformed URL exception validating URL " + url, ex);
            return false;
        }
        catch (UnknownHostException ex) {
            LOGGER.log(Level.FINE, "Unknown host exception validating URL " + url, ex);
            return false;
        }
        return true;
    }
}

