/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.EnvVars;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.CliGitCommand;
import jenkins.plugins.git.GitBranchSCMHead;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitSCMFileSystemTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    private static final String GIT_2_6_0_TAG = "git-2.6.0";
    private static final String GIT_2_6_1_TAG = "git-2.6.1";

    @BeforeClass
    public static void confirmTagsAvailable() throws Exception {
        String[] tags;
        File gitDir = new File(".");
        GitClient client = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(gitDir).using("jgit").getClient();
        for (String tag : tags = new String[]{GIT_2_6_0_TAG, GIT_2_6_1_TAG}) {
            try {
                ObjectId tagId = client.revParse(tag);
            }
            catch (GitException ge) {
                CliGitCommand gitCmd = new CliGitCommand(null, new String[0]);
                gitCmd.run("fetch", "--tags", "https://github.com/jenkinsci/git-plugin");
                ObjectId objectId = client.revParse(tag);
            }
        }
    }

    @Test
    @Deprecated
    public void ofSource_Smokes() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new GitBranchSCMHead("dev"));
        MatcherAssert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        SCMFile root = fs.getRoot();
        MatcherAssert.assertThat((Object)root, (Matcher)Matchers.notNullValue());
        Assert.assertTrue((boolean)root.isRoot());
        Iterable children = root.children();
        Iterator iterator = children.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile file = (SCMFile)iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"file"));
        MatcherAssert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)"modified"));
    }

    @Test
    @Deprecated
    public void ofSourceRevision() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMRevision revision = source.fetch(new SCMHead("dev"), null);
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new SCMHead("dev"), (SCMRevision)revision);
        MatcherAssert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)fs.getRoot(), (Matcher)Matchers.notNullValue());
        Iterable children = fs.getRoot().children();
        Iterator iterator = children.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile file = (SCMFile)iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"file"));
        MatcherAssert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    @Deprecated
    public void ofSourceRevision_GitBranchSCMHead() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMRevision revision = source.fetch((SCMHead)new GitBranchSCMHead("dev"), null);
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new GitBranchSCMHead("dev"), (SCMRevision)revision);
        MatcherAssert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)fs.getRoot(), (Matcher)Matchers.notNullValue());
        Iterable children = fs.getRoot().children();
        Iterator iterator = children.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile file = (SCMFile)iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"file"));
        MatcherAssert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void slashyBranches() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "bug/JENKINS-42817");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        SCMFileSystem fs = SCMFileSystem.of((Item)r.createFreeStyleProject(), (SCM)new GitSCM(GitSCM.createRepoList((String)this.sampleRepo.toString(), null), Collections.singletonList(new BranchSpec("*/bug/JENKINS-42817")), null, null, Collections.emptyList()));
        MatcherAssert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        SCMFile root = fs.getRoot();
        MatcherAssert.assertThat((Object)root, (Matcher)Matchers.notNullValue());
        Assert.assertTrue((boolean)root.isRoot());
        Iterable children = root.children();
        Iterator iterator = children.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile file = (SCMFile)iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"file"));
        MatcherAssert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)"modified"));
    }

    @Test
    public void wildcardBranchNameCausesNPE() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "contents-for-npe-when-branch-name-is-asterisk");
        this.sampleRepo.git("commit", "--all", "--message=npe-when-branch-name-is-asterisk");
        SCMFileSystem fs = SCMFileSystem.of((Item)r.createFreeStyleProject(), (SCM)new GitSCM(GitSCM.createRepoList((String)this.sampleRepo.toString(), null), Collections.singletonList(new BranchSpec("*")), null, null, Collections.emptyList()));
        MatcherAssert.assertThat((String)"Wildcard branch name '*' resolved to a specific checkout unexpectedly", (Object)fs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    @Deprecated
    public void lastModified_Smokes() throws Exception {
        if (this.isWindows()) {
            return;
        }
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMRevision revision = source.fetch((SCMHead)new GitBranchSCMHead("dev"), null);
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        long fileSystemAllowedOffset = 1500L;
        if ("OpenBSD".equals(System.getProperty("os.name"))) {
            fileSystemAllowedOffset = 2L * fileSystemAllowedOffset;
        }
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new SCMHead("dev"), (SCMRevision)revision);
        long currentTime = System.currentTimeMillis();
        long lastModified = fs.lastModified();
        MatcherAssert.assertThat((Object)lastModified, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(currentTime - fileSystemAllowedOffset)));
        MatcherAssert.assertThat((Object)lastModified, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(currentTime + fileSystemAllowedOffset)));
        SCMFile file = fs.getRoot().child("file");
        currentTime = System.currentTimeMillis();
        lastModified = file.lastModified();
        MatcherAssert.assertThat((Object)lastModified, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(currentTime - fileSystemAllowedOffset)));
        MatcherAssert.assertThat((Object)lastModified, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(currentTime + fileSystemAllowedOffset)));
    }

    @Test
    @Deprecated
    public void directoryTraversal() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.mkdirs("dir/subdir");
        this.sampleRepo.git("mv", "file", "dir/subdir/file");
        this.sampleRepo.write("dir/subdir/file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new SCMHead("dev"));
        MatcherAssert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)fs.getRoot(), (Matcher)Matchers.notNullValue());
        Iterable children = fs.getRoot().children();
        Iterator iterator = children.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile dir = (SCMFile)iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)dir.getName(), (Matcher)Matchers.is((Object)"dir"));
        MatcherAssert.assertThat((Object)dir.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.DIRECTORY));
        children = dir.children();
        iterator = children.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile subdir = (SCMFile)iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)subdir.getName(), (Matcher)Matchers.is((Object)"subdir"));
        MatcherAssert.assertThat((Object)subdir.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.DIRECTORY));
        children = subdir.children();
        iterator = children.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile file = (SCMFile)iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"file"));
        MatcherAssert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)"modified"));
    }

    @Test
    @Deprecated
    public void mixedContent() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.write("file2", "new");
        this.sampleRepo.git("add", "file2");
        this.sampleRepo.write("dir/file3", "modified");
        this.sampleRepo.git("add", "file", "dir/file3");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new SCMHead("dev"));
        MatcherAssert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)fs.getRoot(), (Matcher)Matchers.notNullValue());
        Iterable children = fs.getRoot().children();
        TreeSet<String> names = new TreeSet<String>();
        SCMFile file = null;
        SCMFile file2 = null;
        SCMFile dir = null;
        for (SCMFile f : children) {
            names.add(f.getName());
            switch (f.getName()) {
                case "file": {
                    file = f;
                    break;
                }
                case "file2": {
                    file2 = f;
                    break;
                }
                case "dir": {
                    dir = f;
                    break;
                }
            }
        }
        MatcherAssert.assertThat(names, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.is((Object)"file"), Matchers.is((Object)"file2"), Matchers.is((Object)"dir")}));
        MatcherAssert.assertThat((Object)file.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.REGULAR_FILE));
        MatcherAssert.assertThat((Object)file2.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.REGULAR_FILE));
        MatcherAssert.assertThat((Object)dir.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.DIRECTORY));
        MatcherAssert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)"modified"));
        MatcherAssert.assertThat((Object)file2.contentAsString(), (Matcher)Matchers.is((Object)"new"));
    }

    @Test
    public void given_filesystem_when_askingChangesSinceSameRevision_then_changesAreEmpty() throws Exception {
        File gitDir = new File(".");
        GitClient client = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(gitDir).using("git").getClient();
        ObjectId git261 = client.revParse(GIT_2_6_1_TAG);
        AbstractGitSCMSource.SCMRevisionImpl rev261 = new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("origin"), git261.getName());
        GitSCMFileSystem gitPlugin261FS = new GitSCMFileSystem(client, "origin", git261.getName(), rev261);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Assert.assertFalse((boolean)gitPlugin261FS.changesSince((SCMRevision)rev261, (OutputStream)out));
        MatcherAssert.assertThat((Object)out.toString(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void given_filesystem_when_askingChangesSinceOldRevision_then_changesArePopulated() throws Exception {
        File gitDir = new File(".");
        GitClient client = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(gitDir).using("git").getClient();
        ObjectId git261 = client.revParse(GIT_2_6_1_TAG);
        AbstractGitSCMSource.SCMRevisionImpl rev261 = new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("origin"), git261.getName());
        GitSCMFileSystem gitPlugin261FS = new GitSCMFileSystem(client, "origin", git261.getName(), rev261);
        ObjectId git260 = client.revParse(GIT_2_6_0_TAG);
        AbstractGitSCMSource.SCMRevisionImpl rev260 = new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("origin"), git260.getName());
        MatcherAssert.assertThat((Object)git260, (Matcher)Matchers.not((Matcher)Matchers.is((Object)git261)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Assert.assertTrue((boolean)gitPlugin261FS.changesSince((SCMRevision)rev260, (OutputStream)out));
        MatcherAssert.assertThat((Object)out.toString(), (Matcher)Matchers.containsString((String)"prepare release git-2.6.1"));
    }

    @Test
    public void given_filesystem_when_askingChangesSinceNewRevision_then_changesArePopulatedButEmpty() throws Exception {
        File gitDir = new File(".");
        GitClient client = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(gitDir).using("git").getClient();
        ObjectId git260 = client.revParse(GIT_2_6_0_TAG);
        AbstractGitSCMSource.SCMRevisionImpl rev260 = new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("origin"), git260.getName());
        GitSCMFileSystem gitPlugin260FS = new GitSCMFileSystem(client, "origin", git260.getName(), rev260);
        ObjectId git261 = client.revParse(GIT_2_6_1_TAG);
        AbstractGitSCMSource.SCMRevisionImpl rev261 = new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("origin"), git261.getName());
        GitSCMFileSystem gitPlugin261FS = new GitSCMFileSystem(client, "origin", git261.getName(), rev261);
        Assert.assertEquals((Object)git261.getName(), (Object)gitPlugin261FS.getRevision().getHash());
        MatcherAssert.assertThat((Object)git261, (Matcher)Matchers.not((Matcher)Matchers.is((Object)git260)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Assert.assertTrue((boolean)gitPlugin260FS.changesSince((SCMRevision)rev261, (OutputStream)out));
        MatcherAssert.assertThat((Object)out.toString(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void create_SCMFileSystem_from_tag() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.mkdirs("dir/subdir");
        this.sampleRepo.git("mv", "file", "dir/subdir/file");
        this.sampleRepo.write("dir/subdir/file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "v1.0");
        SCMFileSystem fs = SCMFileSystem.of((Item)r.createFreeStyleProject(), (SCM)new GitSCM(GitSCM.createRepoList((String)this.sampleRepo.toString(), null), Collections.singletonList(new BranchSpec("refs/tags/v1.0")), null, null, Collections.emptyList()));
        MatcherAssert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)fs.getRoot(), (Matcher)Matchers.notNullValue());
        Iterable children = fs.getRoot().children();
        Iterator iterator = children.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile dir = (SCMFile)iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)dir.getName(), (Matcher)Matchers.is((Object)"dir"));
        MatcherAssert.assertThat((Object)dir.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.DIRECTORY));
        children = dir.children();
        iterator = children.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile subdir = (SCMFile)iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)subdir.getName(), (Matcher)Matchers.is((Object)"subdir"));
        MatcherAssert.assertThat((Object)subdir.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.DIRECTORY));
        children = subdir.children();
        iterator = children.iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile file = (SCMFile)iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"file"));
        MatcherAssert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)"modified"));
    }

    @Test
    public void filesystem_supports_descriptor() throws Exception {
        SCMSourceDescriptor descriptor = (SCMSourceDescriptor)GitSCMFileSystemTest.r.jenkins.getDescriptorByType(GitSCMSource.DescriptorImpl.class);
        Assert.assertTrue((boolean)SCMFileSystem.supports((SCMSourceDescriptor)descriptor));
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

