/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.plugins.git.browser.AssemblaWeb;
import hudson.util.FormValidation;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class AssemblaWebDoCheckURLTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();
    private static int counter = 0;
    private FreeStyleProject project;
    private AssemblaWeb.AssemblaWebDescriptor assemblaWebDescriptor;

    @Before
    public void setProject() throws Exception {
        this.project = r.createFreeStyleProject("assembla-project-" + counter++);
        this.assemblaWebDescriptor = new AssemblaWeb.AssemblaWebDescriptor();
    }

    @Test
    public void testInitialChecksOnRepoUrl() throws Exception {
        String url = "https://app.assembla.com/spaces/git-plugin/git/source";
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url), (Matcher)Matchers.is((Object)FormValidation.ok()));
    }

    @Test
    public void testInitialChecksOnRepoUrlEmpty() throws Exception {
        String url = "";
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url), (Matcher)Matchers.is((Object)FormValidation.ok()));
    }

    @Test
    public void testInitialChecksOnRepoUrlWithVariable() throws Exception {
        String url = "https://www.assembla.com/spaces/$";
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url), (Matcher)Matchers.is((Object)FormValidation.ok()));
    }

    @Test
    public void testDomainLevelChecksOnRepoUrl() throws Exception {
        String url = "https:/assembla.com";
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url).getLocalizedMessage(), (Matcher)Matchers.is((Object)"Invalid URL"));
    }

    @Test
    public void testDomainLevelChecksOnRepoUrlInvalidURL() throws Exception {
        String url = "http//assmebla";
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url).getLocalizedMessage(), (Matcher)Matchers.is((Object)"Invalid URL"));
    }

    @Test
    public void testPathLevelChecksOnRepoUrlInvalidPathSyntax() throws Exception {
        String hostname = "assembla.comspaces";
        String url = "https://" + hostname + "/git-plugin/git/source";
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url).getLocalizedMessage(), (Matcher)Matchers.is((Object)"Invalid URL"));
    }

    @Test
    public void testPathLevelChecksOnRepoUrlValidURLNullProject() throws Exception {
        String url = "https://app.assembla.com/space/git-plugin/git/source";
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl(null, url), (Matcher)Matchers.is((Object)FormValidation.ok()));
    }

    @Test
    public void testPathLevelChecksOnRepoUrlUnableToConnect() throws Exception {
        String url = "https://app.assembla.com/space/git-plugin/git/source/";
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url).getLocalizedMessage(), (Matcher)Matchers.is((Object)("Exception reading from Assembla URL " + url + " : ERROR: Unable to connect " + url)));
    }

    @Test
    public void testPathLevelChecksOnRepoUrl() throws Exception {
        String url = "https://app.assembla.com/spaces/";
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url), (Matcher)Matchers.is((Object)FormValidation.ok()));
    }

    @Test
    public void testPathLevelChecksOnRepoUrlSupersetOfAssembla() throws Exception {
        Random random = new Random();
        String[] urls = new String[]{"http://assemblage.com/", "http://assemblage.net/", "http://assemblage.org/", "http://assemblages.com/", "http://assemblages.net/", "http://assemblages.org/", "http://assemblagist.com/"};
        String url = urls[random.nextInt(urls.length)];
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url).getLocalizedMessage(), (Matcher)Matchers.is((Object)"Invalid URL"));
    }

    @Test
    public void testInitialChecksOnRepoUrlWithEmptyPath() throws Exception {
        String url = "https://www.assembla.com";
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url), (Matcher)Matchers.is((Object)FormValidation.ok()));
    }

    @Test
    public void testDomainLevelChecksOnRepoUrlAllowDNSLocalHostnamesLocalNet() throws Exception {
        String hostname = "assembla.example.localnet";
        String url = "https://" + hostname + "/space/git-plugin/git/source";
        FormValidation validation = this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url);
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url).getLocalizedMessage(), (Matcher)Matchers.is((Object)("Exception reading from Assembla URL " + url + " : ERROR: " + hostname)));
    }

    @Test
    public void testDomainLevelChecksOnRepoUrlAllowDNSLocalHostnamesHome() throws Exception {
        String hostname = "assembla.example.home";
        String url = "https://" + hostname + "/space/git-plugin/git/source";
        FormValidation validation = this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url);
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url).getLocalizedMessage(), (Matcher)Matchers.is((Object)("Exception reading from Assembla URL " + url + " : ERROR: " + hostname)));
    }

    @Test
    public void testDomainLevelChecksOnRepoUrlCorpDomainMustBeValid() throws Exception {
        String hostname = "assembla.myorg.corp";
        String url = "https://" + hostname + "/space/git-plugin/git/source";
        FormValidation validation = this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url);
        MatcherAssert.assertThat((Object)this.assemblaWebDescriptor.doCheckRepoUrl((Item)this.project, url).getLocalizedMessage(), (Matcher)Matchers.is((Object)("Exception reading from Assembla URL " + url + " : ERROR: " + hostname)));
    }
}

