/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.plugins.git.GitSampleRepoRule;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GitChangeSetPluginHistoryTest {
    private static final long FIRST_COMMIT_TIMESTAMP = 1198029565000L;
    private static final long NOW = System.currentTimeMillis();
    private final ObjectId sha1;
    private final GitChangeSet changeSet;
    @ClassRule
    public static GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    private static final String[] git171exceptions = new String[]{"6e467b23", "750b6806", "7eeb070b", "87988f4d", "94d982c2", "a571899e", "b9e497b0", "bc71cd2d", "bca98ea9", "c73b4ff3", "dcd329f4", "edf066f3"};

    public GitChangeSetPluginHistoryTest(GitClient git, boolean authorOrCommitter, String sha1String) throws IOException, InterruptedException {
        this.sha1 = ObjectId.fromString((String)sha1String);
        StringWriter stringWriter = new StringWriter();
        git.changelog().includes(this.sha1).max(1).to((Writer)stringWriter).execute();
        ArrayList<String> changeLogStrings = new ArrayList<String>(Arrays.asList(stringWriter.toString().split("\n")));
        this.changeSet = new GitChangeSet(changeLogStrings, authorOrCommitter);
    }

    private static List<ObjectId> getNonMergeChanges(boolean honorExclusions) throws IOException {
        ArrayList<ObjectId> nonMergeChanges = new ArrayList<ObjectId>();
        Process process = new ProcessBuilder("git", "rev-list", "--no-merges", "HEAD").start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (honorExclusions) {
                    boolean ignore = false;
                    for (String exclusion : git171exceptions) {
                        if (!line.startsWith(exclusion)) continue;
                        ignore = true;
                        break;
                    }
                    if (ignore) continue;
                    nonMergeChanges.add(ObjectId.fromString((String)line));
                    continue;
                }
                nonMergeChanges.add(ObjectId.fromString((String)line));
            }
        }
        process.destroy();
        Collections.shuffle(nonMergeChanges);
        return nonMergeChanges;
    }

    @Parameterized.Parameters(name="{2}-{1}")
    public static Collection<Object[]> generateData() throws IOException, InterruptedException {
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        String[] implementations = new String[]{"git", "jgit"};
        boolean[] choices = new boolean[]{true, false};
        for (String implementation : implementations) {
            EnvVars envVars = new EnvVars();
            StreamTaskListener listener = StreamTaskListener.fromStdout();
            GitClient git = Git.with((TaskListener)listener, (EnvVars)envVars).in(new FilePath(new File("."))).using(implementation).getClient();
            boolean honorExclusions = implementation.equals("git") && !sampleRepo.gitVersionAtLeast(1, 7, 10);
            List<ObjectId> allNonMergeChanges = GitChangeSetPluginHistoryTest.getNonMergeChanges(honorExclusions);
            int count = allNonMergeChanges.size() / 10;
            for (boolean authorOrCommitter : choices) {
                for (int index = 0; index < count; ++index) {
                    ObjectId sha1 = allNonMergeChanges.get(index);
                    Object[] argList = new Object[]{git, authorOrCommitter, sha1.getName()};
                    args.add(argList);
                }
            }
        }
        return args;
    }

    @Test
    public void timestampInRange() {
        long timestamp = this.changeSet.getTimestamp();
        MatcherAssert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1198029565000L))));
        MatcherAssert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(NOW))));
    }
}

