/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitCredentialBindings;
import jenkins.plugins.git.Messages;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.AbstractOnDiskBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.UnbindableDir;
import org.jenkinsci.plugins.gitclient.CliGitAPIImpl;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitUsernamePasswordBinding
extends MultiBinding<StandardUsernamePasswordCredentials>
implements GitCredentialBindings {
    private static final String GIT_USERNAME_KEY = "GIT_USERNAME";
    private static final String GIT_PASSWORD_KEY = "GIT_PASSWORD";
    private final String gitToolName;
    private transient boolean unixNodeType;

    @DataBoundConstructor
    public GitUsernamePasswordBinding(String gitToolName, String credentialsId) {
        super(credentialsId);
        this.gitToolName = gitToolName;
    }

    public String getGitToolName() {
        return this.gitToolName;
    }

    private void setUnixNodeType(boolean value) {
        this.unixNodeType = value;
    }

    protected Class<StandardUsernamePasswordCredentials> type() {
        return StandardUsernamePasswordCredentials.class;
    }

    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> run, FilePath filePath, Launcher launcher, @NonNull TaskListener taskListener) throws IOException, InterruptedException {
        LinkedHashMap<String, String> secretValues = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> publicValues = new LinkedHashMap<String, String>();
        StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)this.getCredentials(run);
        this.setCredentialPairBindings((StandardCredentials)credentials, secretValues, publicValues);
        GitTool cliGitTool = this.getCliGitTool(run, this.gitToolName, taskListener);
        if (cliGitTool != null && filePath != null) {
            UnbindableDir unbindTempDir = UnbindableDir.create((FilePath)filePath);
            this.setUnixNodeType(this.isCurrentNodeOSUnix(launcher));
            this.setGitEnvironmentVariables(this.getGitClientInstance(cliGitTool.getGitExe(), unbindTempDir.getDirPath(), new EnvVars(), taskListener), publicValues);
            GenerateGitScript gitScript = new GenerateGitScript(credentials.getUsername(), credentials.getPassword().getPlainText(), credentials.getId(), this.unixNodeType);
            FilePath gitTempFile = gitScript.write(credentials, unbindTempDir.getDirPath());
            secretValues.put("GIT_ASKPASS", gitTempFile.getRemote());
            return new MultiBinding.MultiEnvironment(secretValues, publicValues, unbindTempDir.getUnbinder());
        }
        taskListener.getLogger().println("JGit and JGitApache type Git tools are not supported by this binding");
        return new MultiBinding.MultiEnvironment(secretValues, publicValues);
    }

    public Set<String> variables(@Nonnull Run<?, ?> build) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        keys.add(GIT_USERNAME_KEY);
        keys.add(GIT_PASSWORD_KEY);
        return keys;
    }

    @Override
    public void setCredentialPairBindings(@NonNull StandardCredentials credentials, Map<String, String> publicValues, Map<String, String> secretValues) {
        StandardUsernamePasswordCredentials usernamePasswordCredentials = (StandardUsernamePasswordCredentials)credentials;
        if (usernamePasswordCredentials.isUsernameSecret()) {
            secretValues.put(GIT_USERNAME_KEY, usernamePasswordCredentials.getUsername());
        } else {
            publicValues.put(GIT_USERNAME_KEY, usernamePasswordCredentials.getUsername());
        }
        secretValues.put(GIT_PASSWORD_KEY, usernamePasswordCredentials.getPassword().getPlainText());
    }

    void setGitEnvironmentVariables(@NonNull GitClient git, Map<String, String> publicValues) throws IOException, InterruptedException {
        this.setGitEnvironmentVariables(git, null, publicValues);
    }

    @Override
    public void setGitEnvironmentVariables(@NonNull GitClient git, Map<String, String> secretValues, Map<String, String> publicValues) throws IOException, InterruptedException {
        if (this.unixNodeType && ((CliGitAPIImpl)git).isCliGitVerAtLeast(2, 3, 0, 0)) {
            publicValues.put("GIT_TERMINAL_PROMPT", "false");
        } else {
            publicValues.put("GCM_INTERACTIVE", "false");
        }
    }

    @Override
    public GitClient getGitClientInstance(String gitToolExe, FilePath repository, EnvVars env, TaskListener listener) throws IOException, InterruptedException {
        Git gitInstance = Git.with((TaskListener)listener, (EnvVars)env).using(gitToolExe);
        return gitInstance.getClient();
    }

    @Symbol(value={"gitUsernamePassword", "GitUsernamePassword"})
    @Extension
    public static final class DescriptorImpl
    extends BindingDescriptor<StandardUsernamePasswordCredentials> {
        @NonNull
        public String getDisplayName() {
            return Messages.GitUsernamePasswordBinding_DisplayName();
        }

        public ListBoxModel doFillGitToolNameItems() {
            ListBoxModel items = new ListBoxModel();
            List<GitTool> toolList = ((GitSCM.DescriptorImpl)Jenkins.get().getDescriptorByType(GitSCM.DescriptorImpl.class)).getGitTools();
            for (GitTool t : toolList) {
                if (!t.getClass().equals(GitTool.class)) continue;
                items.add(t.getName());
            }
            return items;
        }

        protected Class<StandardUsernamePasswordCredentials> type() {
            return StandardUsernamePasswordCredentials.class;
        }

        public boolean requiresWorkspace() {
            return true;
        }
    }

    protected static final class GenerateGitScript
    extends AbstractOnDiskBinding<StandardUsernamePasswordCredentials> {
        private final String userVariable;
        private final String passVariable;
        private final boolean unixNodeType;

        protected GenerateGitScript(String gitUsername, String gitPassword, String credentialId, boolean unixNodeType) {
            super(gitUsername + ":" + gitPassword, credentialId);
            this.userVariable = gitUsername;
            this.passVariable = gitPassword;
            this.unixNodeType = unixNodeType;
        }

        protected FilePath write(StandardUsernamePasswordCredentials credentials, FilePath workspace) throws IOException, InterruptedException {
            FilePath gitEcho;
            if (this.unixNodeType) {
                gitEcho = workspace.createTempFile("auth", ".sh");
                gitEcho.write("case $1 in\n        Username*) echo " + this.userVariable + "                ;;\n        Password*) echo " + this.passVariable + "                ;;\n        esac\n", null);
                gitEcho.chmod(320);
            } else {
                gitEcho = workspace.createTempFile("auth", ".bat");
                gitEcho.write("@ECHO OFF\r\nSET ARG=%~1\r\nIF %ARG:~0,8%==Username (ECHO " + this.userVariable + ")\r\nIF %ARG:~0,8%==Password (ECHO " + this.passVariable + ")", null);
            }
            return gitEcho;
        }

        protected Class<StandardUsernamePasswordCredentials> type() {
            return StandardUsernamePasswordCredentials.class;
        }
    }
}

