/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.google.common.base.Joiner;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.DataBoundConstructor;

public class SubmoduleConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    String submoduleName;
    String[] branches;

    public SubmoduleConfig() {
        this(null, Collections.emptySet());
    }

    public SubmoduleConfig(String submoduleName, String[] branches) {
        this(submoduleName, branches != null ? Arrays.asList(branches) : Collections.emptySet());
    }

    @DataBoundConstructor
    public SubmoduleConfig(String submoduleName, Collection<String> branches) {
        this.submoduleName = submoduleName;
        if (CollectionUtils.isNotEmpty(branches)) {
            this.branches = branches.toArray(new String[0]);
        }
    }

    @Whitelisted
    public String getSubmoduleName() {
        return this.submoduleName;
    }

    public void setSubmoduleName(String submoduleName) {
        this.submoduleName = submoduleName;
    }

    public String[] getBranches() {
        return Arrays.copyOf(this.branches, this.branches.length);
    }

    public void setBranches(String[] branches) {
        this.branches = Arrays.copyOf(branches, branches.length);
    }

    public boolean revisionMatchesInterest(Revision r) {
        for (Branch br : r.getBranches()) {
            if (!this.branchMatchesInterest(br)) continue;
            return true;
        }
        return false;
    }

    public boolean branchMatchesInterest(Branch br) {
        for (String regex : this.branches) {
            if (Pattern.matches(regex, br.getName())) continue;
            return false;
        }
        return true;
    }

    public String getBranchesString() {
        return Joiner.on((char)',').join((Object[])this.branches);
    }
}

