/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git.traits;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.SCM;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.traits.GitSCMExtensionTrait;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.jvnet.tiger_types.Types;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class GitSCMExtensionTraitDescriptor
extends SCMSourceTraitDescriptor {
    @NonNull
    private final Class<? extends GitSCMExtension> extension;
    @CheckForNull
    private final Constructor<? extends SCMSourceTrait> constructor;
    private final boolean noArgConstructor;

    protected GitSCMExtensionTraitDescriptor(Class<? extends SCMSourceTrait> clazz, Class<? extends GitSCMExtension> extension) {
        super(clazz);
        this.extension = extension;
        if (!Util.isOverridden(GitSCMExtensionTraitDescriptor.class, ((Object)((Object)this)).getClass(), (String)"convertToTrait", (Class[])new Class[]{GitSCMExtension.class})) {
            try {
                this.constructor = clazz.getConstructor(extension);
                this.noArgConstructor = this.constructor.getParameterTypes().length == 0;
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError("Could not infer how to convert a " + extension + " to a " + clazz + " as there is no obvious constructor. Either provide a simple constructor or override convertToTrait(GitSCMExtension)", e);
            }
        } else {
            this.constructor = null;
            this.noArgConstructor = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected GitSCMExtensionTraitDescriptor() {
        Type bt = Types.getBaseClass((Type)this.clazz, GitSCMExtensionTrait.class);
        if (!(bt instanceof ParameterizedType)) throw new AssertionError((Object)"Could not infer GitSCMExtension type. Consider using the explicit class constructor)");
        ParameterizedType pt = (ParameterizedType)bt;
        this.extension = Types.erasure((Type)pt.getActualTypeArguments()[0]);
        if (!GitSCMExtension.class.isAssignableFrom(this.extension) || GitSCMExtension.class == this.extension) {
            throw new AssertionError((Object)("Could not infer GitSCMExtension type for outer class " + this.clazz + " of " + ((Object)((Object)this)).getClass() + ". Perhaps wrong outer class? (or consider using the explicit class constructor)"));
        }
        if (!Util.isOverridden(GitSCMExtensionTraitDescriptor.class, ((Object)((Object)this)).getClass(), (String)"convertToTrait", (Class[])new Class[]{GitSCMExtension.class})) {
            Constructor<?> constructor = null;
            for (Constructor<?> c : this.clazz.getConstructors()) {
                if (c.getAnnotation(DataBoundConstructor.class) == null) continue;
                constructor = c;
                break;
            }
            if (constructor == null) throw new AssertionError((Object)("Could not infer how to convert a " + this.extension + " to a " + this.clazz + " as there is no @DataBoundConstructor (which is going to cause other problems)"));
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length == 0) {
                this.constructor = constructor;
                this.noArgConstructor = true;
                return;
            } else {
                if (parameterTypes.length != 1 || !this.extension.equals(parameterTypes[0])) throw new AssertionError((Object)("Could not infer how to convert a " + this.extension + " to a " + this.clazz + " as the @DataBoundConstructor is neither zero arg nor single arg of type " + this.extension + ". Either provide a simple constructor or override convertToTrait(GitSCMExtension)"));
                this.constructor = constructor;
                this.noArgConstructor = false;
            }
            return;
        } else {
            this.constructor = null;
            this.noArgConstructor = false;
        }
    }

    public Class<? extends SCMBuilder> getBuilderClass() {
        return GitSCMBuilder.class;
    }

    public Class<? extends SCM> getScmClass() {
        return GitSCM.class;
    }

    @Restricted(value={NoExternalUse.class})
    public GitSCMExtensionDescriptor getExtensionDescriptor() {
        return (GitSCMExtensionDescriptor)Jenkins.get().getDescriptor(this.extension);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Low risk")
    public Class<? extends GitSCMExtension> getExtensionClass() {
        return this.extension;
    }

    @CheckForNull
    public SCMSourceTrait convertToTrait(@NonNull GitSCMExtension extension) {
        if (!this.extension.isInstance((Object)extension)) {
            throw new IllegalArgumentException("Expected a " + this.extension.getName() + " but got a " + ((Object)((Object)extension)).getClass().getName());
        }
        if (this.constructor == null) {
            if (!Util.isOverridden(GitSCMExtensionTraitDescriptor.class, ((Object)((Object)this)).getClass(), (String)"convertToTrait", (Class[])new Class[]{GitSCMExtension.class})) {
                throw new IllegalStateException("Should not be able to instantiate a " + ((Object)((Object)this)).getClass().getName() + " without an inferred constructor for " + this.extension.getName());
            }
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " should not delegate convertToTrait() to " + GitSCMExtension.class.getName());
        }
        try {
            return this.noArgConstructor ? this.constructor.newInstance(new Object[0]) : this.constructor.newInstance(new Object[]{this.extension.cast((Object)extension)});
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public String getHelpFile() {
        String primary = super.getHelpFile();
        return primary == null ? this.getExtensionDescriptor().getHelpFile() : primary;
    }
}

