/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.scm.AbstractScmTagAction;
import hudson.security.Permission;
import hudson.util.CopyOnWriteMap;
import hudson.util.MultipartFormDataParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class GitTagAction
extends AbstractScmTagAction
implements Describable<GitTagAction> {
    private final Map<String, List<String>> tags = new CopyOnWriteMap.Tree();
    private final String ws;
    private String lastTagName = null;
    private GitException lastTagException = null;

    protected GitTagAction(Run build, FilePath workspace, Revision revision) {
        super(build);
        this.ws = workspace.getRemote();
        for (Branch b : revision.getBranches()) {
            this.tags.put(b.getName(), new ArrayList());
        }
    }

    public Descriptor<GitTagAction> getDescriptor() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public boolean isTagged() {
        for (List<String> t : this.tags.values()) {
            if (t.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getIconFileName() {
        if (!this.isTagged() && !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        int nonNullTag = 0;
        for (List<String> v : this.tags.values()) {
            if (!v.isEmpty() && (nonNullTag += v.size()) > 1) break;
        }
        if (nonNullTag == 0) {
            return "No Tags";
        }
        if (nonNullTag == 1) {
            return "One tag";
        }
        return "Multiple tags";
    }

    public Map<String, List<String>> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Exported(name="tags")
    public List<TagInfo> getTagInfo() {
        ArrayList<TagInfo> data = new ArrayList<TagInfo>();
        for (Map.Entry<String, List<String>> e : this.tags.entrySet()) {
            String module = e.getKey();
            for (String tag : e.getValue()) {
                data.add(new TagInfo(module, tag));
            }
        }
        return data;
    }

    public String getTooltip() {
        String tag = null;
        for (List<String> v : this.tags.values()) {
            for (String s : v) {
                if (tag != null) {
                    return "Tagged";
                }
                tag = s;
            }
        }
        if (tag != null) {
            return "Tag: " + tag;
        }
        return null;
    }

    @RequirePOST
    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        try (MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);){
            HashMap<String, String> newTags = new HashMap<String, String>();
            int i = -1;
            for (String e : this.tags.keySet()) {
                if (this.tags.size() > 1 && parser.get("tag" + ++i) == null) continue;
                newTags.put(e, parser.get("name" + i));
            }
            this.scheduleTagCreation(newTags, parser.get("comment"));
            rsp.sendRedirect(".");
        }
    }

    void scheduleTagCreation(Map<String, String> newTags, String comment) throws IOException, ServletException {
        new TagWorkerThread(newTags, comment).start();
    }

    public Permission getPermission() {
        return GitSCM.TAG;
    }

    String getLastTagName() {
        return this.lastTagName;
    }

    GitException getLastTagException() {
        return this.lastTagException;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GitTagAction> {
        public String getDisplayName() {
            return "Tag";
        }
    }

    public final class TagWorkerThread
    extends TaskThread {
        private final Map<String, String> tagSet;
        private final String comment;

        public TagWorkerThread(Map<String, String> tagSet, String comment) {
            super((TaskAction)GitTagAction.this, TaskThread.ListenerAndText.forMemory(null));
            this.tagSet = tagSet;
            this.comment = comment;
        }

        protected void perform(TaskListener listener) throws Exception {
            EnvVars environment = GitTagAction.this.getRun().getEnvironment(listener);
            FilePath workspace = new FilePath(new File(GitTagAction.this.ws));
            GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).in(workspace).getClient();
            for (Map.Entry<String, String> entry : this.tagSet.entrySet()) {
                try {
                    String buildNum = "jenkins-" + GitTagAction.this.getRun().getParent().getName().replace(" ", "_") + "-" + entry.getValue();
                    git.tag(entry.getValue(), "Jenkins Build #" + buildNum);
                    GitTagAction.this.lastTagName = entry.getValue();
                    for (Map.Entry<String, String> e : this.tagSet.entrySet()) {
                        ((List)GitTagAction.this.tags.get(e.getKey())).add(e.getValue());
                    }
                    GitTagAction.this.getRun().save();
                    GitTagAction.this.workerThread = null;
                }
                catch (GitException ex) {
                    GitTagAction.this.lastTagException = ex;
                    ex.printStackTrace(listener.error("Error tagging repo '%s' : %s", new Object[]{entry.getKey(), ex.getMessage()}));
                    listener.getLogger().println("Trying next branch");
                }
            }
        }
    }

    @ExportedBean
    public static class TagInfo {
        private final String module;
        private final String url;

        private TagInfo(String branch, String tag) {
            this.module = branch;
            this.url = tag;
        }

        @Exported
        public String getBranch() {
            return this.module;
        }

        @Exported
        public String getTag() {
            return this.url;
        }
    }
}

