/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import com.google.common.base.Function;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class SparseCheckoutPath
extends AbstractDescribableImpl<SparseCheckoutPath>
implements Serializable {
    private static final long serialVersionUID = -6177158367915899356L;
    public static final transient SparseCheckoutPathToPath SPARSE_CHECKOUT_PATH_TO_PATH = new SparseCheckoutPathToPath();
    private final String path;

    @DataBoundConstructor
    public SparseCheckoutPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseCheckoutPath that = (SparseCheckoutPath)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }

    public String toString() {
        return this.path;
    }

    public Descriptor<SparseCheckoutPath> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SparseCheckoutPath> {
        public String getDisplayName() {
            return "Path";
        }
    }

    private static class SparseCheckoutPathToPath
    implements Function<SparseCheckoutPath, String>,
    Serializable {
        private SparseCheckoutPathToPath() {
        }

        public String apply(SparseCheckoutPath sparseCheckoutPath) {
            return sparseCheckoutPath.getPath();
        }
    }
}

