/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git.traits;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.plugins.git.traits.Messages;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.SCMHeadMixin;
import jenkins.scm.api.mixin.TagSCMHead;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMHeadAuthorityDescriptor;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.kohsuke.stapler.DataBoundConstructor;

public class BranchDiscoveryTrait
extends SCMSourceTrait {
    @DataBoundConstructor
    public BranchDiscoveryTrait() {
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GitSCMSourceContext ctx = (GitSCMSourceContext)context;
        ctx.wantBranches(true);
        ctx.withAuthority(new BranchSCMHeadAuthority());
    }

    public boolean includeCategory(@NonNull SCMHeadCategory category) {
        return category.isUncategorized();
    }

    public static class BranchSCMHeadAuthority
    extends SCMHeadAuthority<SCMSourceRequest, SCMHead, SCMRevision> {
        protected boolean checkTrusted(@NonNull SCMSourceRequest request, @NonNull SCMHead head) {
            return true;
        }

        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public String getDisplayName() {
                return Messages.BranchDiscoveryTrait_authorityDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Default.class.isAssignableFrom(originClass);
            }

            public boolean isApplicableToHead(@NonNull Class<? extends SCMHeadMixin> headClass) {
                return super.isApplicableToHead(headClass) && !TagSCMHead.class.isAssignableFrom(headClass);
            }
        }
    }

    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.BranchDiscoveryTrait_displayName();
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitSCMSource.class;
        }
    }
}

