/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.structs.describable.CustomDescribableModel;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class UserMergeOptions
extends AbstractDescribableImpl<UserMergeOptions>
implements Serializable {
    private String mergeRemote;
    private final String mergeTarget;
    private String mergeStrategy;
    private MergeCommand.GitPluginFastForwardMode fastForwardMode;

    @Deprecated
    public UserMergeOptions(String mergeRemote, String mergeTarget, String mergeStrategy) {
        this(mergeRemote, mergeTarget, mergeStrategy, MergeCommand.GitPluginFastForwardMode.FF);
    }

    public UserMergeOptions(String mergeRemote, String mergeTarget, String mergeStrategy, MergeCommand.GitPluginFastForwardMode fastForwardMode) {
        this.mergeRemote = mergeRemote;
        this.mergeTarget = mergeTarget;
        this.mergeStrategy = mergeStrategy;
        this.fastForwardMode = fastForwardMode;
    }

    @DataBoundConstructor
    public UserMergeOptions(String mergeTarget) {
        this.mergeTarget = mergeTarget;
    }

    public UserMergeOptions(PreBuildMergeOptions pbm) {
        this(pbm.getRemoteBranchName(), pbm.getMergeTarget(), pbm.getMergeStrategy().toString(), pbm.getFastForwardMode());
    }

    public String getMergeRemote() {
        return this.mergeRemote;
    }

    @DataBoundSetter
    public void setMergeRemote(String mergeRemote) {
        this.mergeRemote = Util.fixEmptyAndTrim((String)mergeRemote);
    }

    public String getMergeTarget() {
        return this.mergeTarget;
    }

    public String getRef() {
        return this.mergeRemote + "/" + this.mergeTarget;
    }

    public MergeCommand.Strategy getMergeStrategy() {
        for (MergeCommand.Strategy strategy : MergeCommand.Strategy.values()) {
            if (!strategy.toString().equals(this.mergeStrategy)) continue;
            return strategy;
        }
        return MergeCommand.Strategy.DEFAULT;
    }

    @DataBoundSetter
    public void setMergeStrategy(MergeCommand.Strategy mergeStrategy) {
        this.mergeStrategy = mergeStrategy.toString();
    }

    public MergeCommand.GitPluginFastForwardMode getFastForwardMode() {
        for (MergeCommand.GitPluginFastForwardMode ffMode : MergeCommand.GitPluginFastForwardMode.values()) {
            if (!ffMode.equals((Object)this.fastForwardMode)) continue;
            return ffMode;
        }
        return MergeCommand.GitPluginFastForwardMode.FF;
    }

    @DataBoundSetter
    public void setFastForwardMode(MergeCommand.GitPluginFastForwardMode fastForwardMode) {
        this.fastForwardMode = fastForwardMode;
    }

    public String toString() {
        return "UserMergeOptions{mergeRemote='" + this.mergeRemote + '\'' + ", mergeTarget='" + this.mergeTarget + '\'' + ", mergeStrategy='" + this.getMergeStrategy().name() + '\'' + ", fastForwardMode='" + this.getFastForwardMode().name() + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserMergeOptions that = (UserMergeOptions)o;
        return Objects.equals(this.mergeRemote, that.mergeRemote) && Objects.equals(this.mergeTarget, that.mergeTarget) && Objects.equals(this.mergeStrategy, that.mergeStrategy) && Objects.equals(this.fastForwardMode, that.fastForwardMode);
    }

    public int hashCode() {
        return Objects.hash(this.mergeRemote, this.mergeTarget, this.mergeStrategy, this.fastForwardMode);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<UserMergeOptions>
    implements CustomDescribableModel {
        public String getDisplayName() {
            return "";
        }

        public Map<String, Object> customInstantiate(Map<String, Object> arguments) {
            HashMap<String, Object> r = new HashMap<String, Object>(arguments);
            Object mergeStrategy = r.get("mergeStrategy");
            if (mergeStrategy instanceof String) {
                r.put("mergeStrategy", ((String)mergeStrategy).toUpperCase(Locale.ROOT));
            }
            return r;
        }
    }
}

