/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GitLab
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final double version;
    static final double DEFAULT_VERSION = 8.7;

    private static double valueOfVersion(String version) throws NumberFormatException {
        double tmpVersion = Double.valueOf(version);
        if (Double.isNaN(tmpVersion)) {
            throw new NumberFormatException("Version cannot be NaN (not a number)");
        }
        if (Double.isInfinite(tmpVersion)) {
            throw new NumberFormatException("Version cannot be infinite");
        }
        return tmpVersion;
    }

    @DataBoundConstructor
    public GitLab(String repoUrl, String version) {
        super(repoUrl);
        double tmpVersion;
        try {
            tmpVersion = GitLab.valueOfVersion(version);
        }
        catch (NumberFormatException nfe) {
            tmpVersion = 8.7;
        }
        this.version = tmpVersion;
    }

    public double getVersion() {
        return this.version;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.getUrl(), this.calculatePrefix() + changeSet.getId());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        String filelink = null;
        filelink = this.getVersion() < 8.0 ? "#" + path.getPath() : "#diff-" + String.valueOf(this.getIndexOfPath(path));
        return new URL(this.getUrl(), this.calculatePrefix() + changeSet.getId() + filelink);
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLink(path);
        }
        if (this.getVersion() <= 4.2) {
            return new URL(this.getUrl(), "tree/" + path.getChangeSet().getId() + "/" + path.getPath());
        }
        if (this.getVersion() < 5.1) {
            return new URL(this.getUrl(), path.getChangeSet().getId() + "/tree/" + path.getPath());
        }
        return new URL(this.getUrl(), "blob/" + path.getChangeSet().getId() + "/" + path.getPath());
    }

    private String calculatePrefix() {
        if (this.getVersion() < 3.0) {
            return "commits/";
        }
        return "commit/";
    }

    @Extension
    public static class GitLabDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @Nonnull
        public String getDisplayName() {
            return "gitlab";
        }

        public GitLab newInstance(StaplerRequest req, @Nonnull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (GitLab)((Object)req.bindJSON(GitLab.class, jsonObject));
        }

        public FormValidation doCheckVersion(@QueryParameter(fixEmpty=true) String version) throws IOException, ServletException {
            if (version == null) {
                return FormValidation.error((String)"Version is required");
            }
            try {
                GitLab.valueOfVersion(version);
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)("Can't convert '" + version + "' to a number: " + nfe.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

