/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.converters.Converter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitLockFailedException;
import hudson.plugins.git.GitSCMBackwardCompatibility;
import hudson.plugins.git.GitTagAction;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.ObjectIdConverter;
import hudson.plugins.git.RemoteConfigConverter;
import hudson.plugins.git.Revision;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.extensions.GitClientConflictException;
import hudson.plugins.git.extensions.GitClientType;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.extensions.impl.AuthorInChangelog;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.extensions.impl.ChangelogToBranch;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.plugins.git.extensions.impl.PathRestriction;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.plugins.git.util.GitUtils;
import hudson.plugins.git.util.RevCommitRepositoryCallback;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.security.ACL;
import hudson.triggers.SCMTrigger;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.LogTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class GitSCM
extends GitSCMBackwardCompatibility {
    private Long configVersion;
    private List<UserRemoteConfig> userRemoteConfigs;
    private transient List<RemoteConfig> remoteRepositories;
    private List<BranchSpec> branches;
    private boolean doGenerateSubmoduleConfigurations;
    @CheckForNull
    public String gitTool = null;
    @CheckForNull
    private GitRepositoryBrowser browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_LOCAL_BRANCH = "GIT_LOCAL_BRANCH";
    public static final String GIT_COMMIT = "GIT_COMMIT";
    public static final String GIT_PREVIOUS_COMMIT = "GIT_PREVIOUS_COMMIT";
    public static final String GIT_PREVIOUS_SUCCESSFUL_COMMIT = "GIT_PREVIOUS_SUCCESSFUL_COMMIT";
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Known non-serializable field")
    private DescribableList<GitSCMExtension, GitSCMExtensionDescriptor> extensions;
    private static final Pattern[] URL_PATTERNS = new Pattern[]{Pattern.compile("https://github[.]com/([^/]+/[^/]+?)([.]git)*/*"), Pattern.compile("(?:git@)?github[.]com:([^/]+/[^/]+?)([.]git)*/*"), Pattern.compile("ssh://(?:git@)?github[.]com/([^/]+/[^/]+?)([.]git)*/*")};
    public static final Pattern GIT_REF = Pattern.compile("(refs/[^/]+)/.*");
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(GitSCM.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Not final so users can adjust log verbosity")
    public static boolean VERBOSE = Boolean.getBoolean(GitSCM.class.getName() + ".verbose");
    public static final int MAX_CHANGELOG = Integer.getInteger(GitSCM.class.getName() + ".maxChangelog", 1024);

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    public static List<UserRemoteConfig> createRepoList(String url, String credentialsId) {
        ArrayList<UserRemoteConfig> repoList = new ArrayList<UserRemoteConfig>();
        repoList.add(new UserRemoteConfig(url, null, null, credentialsId));
        return repoList;
    }

    public GitSCM(String repositoryUrl) {
        this(GitSCM.createRepoList(repositoryUrl, null), Collections.singletonList(new BranchSpec("")), false, Collections.emptyList(), null, null, Collections.emptyList());
    }

    @DataBoundConstructor
    public GitSCM(List<UserRemoteConfig> userRemoteConfigs, List<BranchSpec> branches, Boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, @CheckForNull GitRepositoryBrowser browser, @CheckForNull String gitTool, List<GitSCMExtension> extensions) {
        this.branches = CollectionUtils.isEmpty(branches) ? Lists.newArrayList((Object[])new BranchSpec[]{new BranchSpec("*/master")}) : branches;
        this.userRemoteConfigs = userRemoteConfigs;
        this.updateFromUserData();
        this.browser = browser;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations != null ? doGenerateSubmoduleConfigurations : false;
        if (submoduleCfg == null) {
            submoduleCfg = new ArrayList<SubmoduleConfig>();
        }
        this.submoduleCfg = submoduleCfg;
        this.configVersion = 2L;
        this.gitTool = gitTool;
        this.extensions = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(extensions));
        this.getBuildChooser();
    }

    @Override
    public DescribableList<GitSCMExtension, GitSCMExtensionDescriptor> getExtensions() {
        return this.extensions;
    }

    private void updateFromUserData() throws GitException {
        if (this.userRemoteConfigs == null) {
            return;
        }
        try {
            String[] pUrls = new String[this.userRemoteConfigs.size()];
            String[] repoNames = new String[this.userRemoteConfigs.size()];
            String[] refSpecs = new String[this.userRemoteConfigs.size()];
            for (int i = 0; i < this.userRemoteConfigs.size(); ++i) {
                pUrls[i] = this.userRemoteConfigs.get(i).getUrl();
                repoNames[i] = this.userRemoteConfigs.get(i).getName();
                refSpecs[i] = this.userRemoteConfigs.get(i).getRefspec();
            }
            this.remoteRepositories = DescriptorImpl.createRepositoryConfigurations(pUrls, repoNames, refSpecs);
        }
        catch (IOException e1) {
            throw new GitException("Error creating repositories", (Throwable)e1);
        }
    }

    public Object readResolve() throws IOException {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.source != null) {
            this.remoteRepositories = new ArrayList<RemoteConfig>();
            this.branches = new ArrayList<BranchSpec>();
            this.doGenerateSubmoduleConfigurations = false;
            Iterator<RemoteConfig> rs = new ArrayList();
            rs.add((RemoteConfig)new RefSpec("+refs/heads/*:refs/remotes/origin/*"));
            this.remoteRepositories.add(this.newRemoteConfig("origin", this.source, rs.toArray((RefSpec[])new RefSpec[rs.size()])));
            if (this.branch != null) {
                this.branches.add(new BranchSpec(this.branch));
            } else {
                this.branches.add(new BranchSpec("*/master"));
            }
        }
        if (this.configVersion < 1L && this.branches != null) {
            for (BranchSpec branchSpec : this.branches) {
                String name = branchSpec.getName();
                name = name.replace("*", "**");
                branchSpec.setName(name);
            }
        }
        if (this.remoteRepositories != null && this.userRemoteConfigs == null) {
            this.userRemoteConfigs = new ArrayList<UserRemoteConfig>();
            for (RemoteConfig cfg : this.remoteRepositories) {
                String url = "";
                if (cfg.getURIs().size() > 0 && cfg.getURIs().get(0) != null) {
                    url = ((URIish)cfg.getURIs().get(0)).toPrivateString();
                }
                String refspec = "";
                if (cfg.getFetchRefSpecs().size() > 0 && cfg.getFetchRefSpecs().get(0) != null) {
                    refspec = ((RefSpec)cfg.getFetchRefSpecs().get(0)).toString();
                }
                this.userRemoteConfigs.add(new UserRemoteConfig(url, cfg.getName(), refspec, null));
            }
        }
        if (this.remoteRepositories == null) {
            try {
                this.updateFromUserData();
            }
            catch (GitException e) {
                LOGGER.log(Level.WARNING, "Failed to load SCM data", e);
            }
        }
        if (this.extensions == null) {
            this.extensions = new DescribableList(Saveable.NOOP);
        }
        this.readBackExtensionsFromLegacy();
        if (this.choosingStrategy != null && this.getBuildChooser().getClass() == DefaultBuildChooser.class) {
            for (BuildChooserDescriptor d : BuildChooser.all()) {
                if (!this.choosingStrategy.equals(d.getLegacyId())) continue;
                try {
                    this.setBuildChooser((BuildChooser)d.clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
            }
        }
        this.getBuildChooser();
        return this;
    }

    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public void setBrowser(GitRepositoryBrowser browser) {
        this.browser = browser;
    }

    public RepositoryBrowser<?> guessBrowser() {
        HashSet<String> webUrls = new HashSet<String>();
        if (this.remoteRepositories != null) {
            for (RemoteConfig config : this.remoteRepositories) {
                for (URIish uriIsh : config.getURIs()) {
                    String uri = uriIsh.toString();
                    for (Pattern p : URL_PATTERNS) {
                        Matcher m = p.matcher(uri);
                        if (!m.matches()) continue;
                        webUrls.add("https://github.com/" + m.group(1) + "/");
                    }
                }
            }
        }
        if (webUrls.size() == 1) {
            return new GithubWeb((String)webUrls.iterator().next());
        }
        return null;
    }

    public boolean isCreateAccountBasedOnEmail() {
        DescriptorImpl gitDescriptor = this.getDescriptor();
        return gitDescriptor != null && gitDescriptor.isCreateAccountBasedOnEmail();
    }

    public BuildChooser getBuildChooser() {
        BuildChooserSetting bcs = (BuildChooserSetting)this.getExtensions().get(BuildChooserSetting.class);
        BuildChooser bc = bcs != null ? bcs.getBuildChooser() : new DefaultBuildChooser();
        bc.gitSCM = this;
        return bc;
    }

    public void setBuildChooser(BuildChooser buildChooser) throws IOException {
        if (buildChooser.getClass() == DefaultBuildChooser.class) {
            this.getExtensions().remove(BuildChooserSetting.class);
        } else {
            this.getExtensions().replace((Describable)new BuildChooserSetting(buildChooser));
        }
    }

    @Deprecated
    public String getParamLocalBranch(Run<?, ?> build) throws IOException, InterruptedException {
        return this.getParamLocalBranch(build, (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
    }

    public String getParamLocalBranch(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        String branch = this.getLocalBranch();
        return GitSCM.getParameterString(branch != null ? branch : null, build.getEnvironment(listener));
    }

    @Deprecated
    public List<RemoteConfig> getParamExpandedRepos(Run<?, ?> build) throws IOException, InterruptedException {
        return this.getParamExpandedRepos(build, (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
    }

    public List<RemoteConfig> getParamExpandedRepos(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<RemoteConfig> expandedRepos = new ArrayList<RemoteConfig>();
        EnvVars env = build.getEnvironment(listener);
        for (RemoteConfig oldRepo : Util.fixNull(this.remoteRepositories)) {
            expandedRepos.add(this.getParamExpandedRepo(env, oldRepo));
        }
        return expandedRepos;
    }

    public RemoteConfig getParamExpandedRepo(EnvVars env, RemoteConfig remoteRepository) {
        List<RefSpec> refSpecs = this.getRefSpecs(remoteRepository, env);
        return this.newRemoteConfig(GitSCM.getParameterString(remoteRepository.getName(), env), GitSCM.getParameterString(((URIish)remoteRepository.getURIs().get(0)).toPrivateString(), env), refSpecs.toArray(new RefSpec[refSpecs.size()]));
    }

    public RemoteConfig getRepositoryByName(String repoName) {
        for (RemoteConfig r : this.getRepositories()) {
            if (!r.getName().equals(repoName)) continue;
            return r;
        }
        return null;
    }

    @Exported
    public List<UserRemoteConfig> getUserRemoteConfigs() {
        if (this.userRemoteConfigs == null) {
            this.userRemoteConfigs = new ArrayList<UserRemoteConfig>();
        }
        return Collections.unmodifiableList(this.userRemoteConfigs);
    }

    public List<RemoteConfig> getRepositories() {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        return this.remoteRepositories;
    }

    public String deriveLocalBranchName(String remoteBranchName) {
        String remoteName = "origin";
        for (UserRemoteConfig remote : this.getUserRemoteConfigs()) {
            remoteName = remote.getName();
            if (remoteName == null || remoteName.isEmpty()) {
                remoteName = "origin";
            }
            if (!remoteBranchName.startsWith(remoteName + "/")) continue;
            break;
        }
        String localBranchName = remoteBranchName.replaceFirst("^" + remoteName + "/", "");
        return localBranchName;
    }

    @CheckForNull
    public String getGitTool() {
        return this.gitTool;
    }

    @NonNull
    public static String getParameterString(@CheckForNull String original, @NonNull EnvVars env) {
        return env.expand(original);
    }

    private List<RefSpec> getRefSpecs(RemoteConfig repo, EnvVars env) {
        ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>();
        for (RefSpec refSpec : repo.getFetchRefSpecs()) {
            refSpecs.add(new RefSpec(GitSCM.getParameterString(refSpec.toString(), env)));
        }
        return refSpecs;
    }

    @CheckForNull
    private String getSingleBranch(EnvVars env) {
        if (this.getBranches().size() != 1) {
            return null;
        }
        String branch = this.getBranches().get(0).getName();
        String repository = null;
        if (this.getRepositories().size() != 1) {
            for (RemoteConfig repo : this.getRepositories()) {
                if (!branch.startsWith(repo.getName() + "/")) continue;
                repository = repo.getName();
                break;
            }
        } else {
            repository = this.getRepositories().get(0).getName();
        }
        if (branch.startsWith("*/") && repository != null) {
            branch = repository + branch.substring(1);
        }
        if (branch.contains("*")) {
            return null;
        }
        if ((branch = GitSCM.getParameterString(branch, env)).equals("")) {
            branch = "**";
        }
        return branch;
    }

    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> abstractBuild, FilePath workspace, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    public boolean requiresWorkspaceForPolling() {
        return this.requiresWorkspaceForPolling(new EnvVars());
    }

    private boolean requiresWorkspaceForPolling(EnvVars environment) {
        for (GitSCMExtension ext : this.getExtensions()) {
            if (!ext.requiresWorkspaceForPolling()) continue;
            return true;
        }
        return this.getSingleBranch(environment) == null;
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        try {
            return this.compareRemoteRevisionWithImpl(project, launcher, workspace, listener);
        }
        catch (GitException e) {
            throw new IOException(e);
        }
    }

    private PollingResult compareRemoteRevisionWithImpl(Job<?, ?> project, Launcher launcher, FilePath workspace, @NonNull TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Using strategy: " + this.getBuildChooser().getDisplayName());
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("[poll] No previous build, so forcing an initial build.");
            return PollingResult.BUILD_NOW;
        }
        BuildData buildData = this.fixNull(this.getBuildData(lastBuild));
        if (buildData.lastBuild != null) {
            listener.getLogger().println("[poll] Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars pollEnv = project instanceof AbstractProject ? GitUtils.getPollEnvironment((AbstractProject)project, workspace, launcher, listener, false) : lastBuild.getEnvironment(listener);
        String singleBranch = this.getSingleBranch(pollEnv);
        if (!this.requiresWorkspaceForPolling(pollEnv)) {
            EnvVars environment = project instanceof AbstractProject ? GitUtils.getPollEnvironment((AbstractProject)project, workspace, launcher, listener, false) : new EnvVars();
            GitClient git = this.createClient(listener, environment, project, (Node)Jenkins.getInstance(), null);
            for (RemoteConfig remoteConfig : this.getParamExpandedRepos(lastBuild, listener)) {
                String remote = remoteConfig.getName();
                List<RefSpec> refSpecs = this.getRefSpecs(remoteConfig, environment);
                for (URIish urIish : remoteConfig.getURIs()) {
                    String gitRepo = urIish.toString();
                    Map heads = git.getHeadRev(gitRepo);
                    if (heads == null || heads.isEmpty()) {
                        listener.getLogger().println("[poll] Couldn't get remote head revision");
                        return PollingResult.BUILD_NOW;
                    }
                    listener.getLogger().println("Found " + heads.size() + " remote heads on " + urIish);
                    Iterator it = heads.entrySet().iterator();
                    while (it.hasNext()) {
                        String head = (String)it.next().getKey();
                        boolean match = false;
                        for (RefSpec refSpec : refSpecs) {
                            if (!refSpec.matchSource(head)) continue;
                            match = true;
                            break;
                        }
                        if (match) continue;
                        listener.getLogger().println("Ignoring " + head + " as it doesn't match any of the configured refspecs");
                        it.remove();
                    }
                    for (BranchSpec branchSpec : this.getBranches()) {
                        for (Map.Entry entry : heads.entrySet()) {
                            ObjectId sha1;
                            Build built;
                            String head = (String)entry.getKey();
                            if (!branchSpec.matches(head, environment)) {
                                String name = head;
                                Matcher matcher = GIT_REF.matcher(head);
                                name = matcher.matches() ? remote + head.substring(matcher.group(1).length()) : remote + "/" + head;
                                if (!branchSpec.matches(name, environment)) continue;
                            }
                            if ((built = buildData.getLastBuild(sha1 = (ObjectId)entry.getValue())) != null) {
                                listener.getLogger().println("[poll] Latest remote head revision on " + head + " is: " + sha1.getName() + " - already built by " + built.getBuildNumber());
                                continue;
                            }
                            listener.getLogger().println("[poll] Latest remote head revision on " + head + " is: " + sha1.getName());
                            return PollingResult.BUILD_NOW;
                        }
                    }
                }
            }
            return PollingResult.NO_CHANGES;
        }
        Node node = GitUtils.workspaceToNode(workspace);
        EnvVars environment = project instanceof AbstractProject ? GitUtils.getPollEnvironment((AbstractProject)project, workspace, launcher, listener) : project.getEnvironment(node, listener);
        FilePath workingDirectory = this.workingDirectory(project, workspace, environment, listener);
        if (workingDirectory == null || !workingDirectory.exists()) {
            return PollingResult.BUILD_NOW;
        }
        GitClient git = this.createClient(listener, environment, project, node, workingDirectory);
        if (git.hasGitRepo()) {
            listener.getLogger().println("Fetching changes from the remote Git repositories");
            for (RemoteConfig remoteRepository : this.getParamExpandedRepos(lastBuild, listener)) {
                this.fetchFrom(git, listener, remoteRepository);
            }
            listener.getLogger().println("Polling for changes in");
            Collection<Revision> candidates = this.getBuildChooser().getCandidateRevisions(true, singleBranch, git, listener, buildData, (BuildChooserContext)new BuildChooserContextImpl(project, null, environment));
            for (Revision c : candidates) {
                if (this.isRevExcluded(git, c, listener, buildData)) continue;
                return PollingResult.SIGNIFICANT;
            }
            return PollingResult.NO_CHANGES;
        }
        listener.getLogger().println("No Git repository yet, an initial checkout is required");
        return PollingResult.SIGNIFICANT;
    }

    @NonNull
    public GitClient createClient(TaskListener listener, EnvVars environment, Run<?, ?> build, FilePath workspace) throws IOException, InterruptedException {
        FilePath ws = this.workingDirectory(build.getParent(), workspace, environment, listener);
        if (ws != null) {
            ws.mkdirs();
        }
        return this.createClient(listener, environment, build.getParent(), GitUtils.workspaceToNode(workspace), ws);
    }

    @NonNull
    GitClient createClient(TaskListener listener, EnvVars environment, Job project, Node n, FilePath ws) throws IOException, InterruptedException {
        String gitExe = this.getGitExe(n, listener);
        Git git = Git.with((TaskListener)listener, (EnvVars)environment).in(ws).using(gitExe);
        GitClient c = git.getClient();
        for (GitSCMExtension ext : this.extensions) {
            c = ext.decorate(this, c);
        }
        for (UserRemoteConfig uc : this.getUserRemoteConfigs()) {
            CredentialsMatcher ucMatcher;
            CredentialsMatcher idMatcher;
            String url;
            List urlCredentials;
            StandardUsernameCredentials credentials;
            String ucCredentialsId = uc.getCredentialsId();
            if (ucCredentialsId == null || (credentials = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)(urlCredentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)(url = GitSCM.getParameterString(uc.getUrl(), environment))).build())), (CredentialsMatcher)(idMatcher = CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{ucMatcher = CredentialsMatchers.withId((String)ucCredentialsId), GitClient.CREDENTIALS_MATCHER})))) == null) continue;
            c.addCredentials(url, (StandardCredentials)credentials);
            if (project == null || project.getLastBuild() == null) continue;
            CredentialsProvider.track((Run)project.getLastBuild(), (Credentials)credentials);
        }
        return c;
    }

    @NonNull
    private BuildData fixNull(BuildData bd) {
        return bd != null ? bd : new BuildData(this.getScmName(), this.getUserRemoteConfigs());
    }

    private void fetchFrom(GitClient git, TaskListener listener, RemoteConfig remoteRepository) throws InterruptedException, IOException {
        boolean first = true;
        for (URIish url : remoteRepository.getURIs()) {
            try {
                if (first) {
                    git.setRemoteUrl(remoteRepository.getName(), url.toPrivateASCIIString());
                    first = false;
                } else {
                    git.addRemoteUrl(remoteRepository.getName(), url.toPrivateASCIIString());
                }
                FetchCommand fetch = git.fetch_().from(url, remoteRepository.getFetchRefSpecs());
                for (GitSCMExtension extension : this.extensions) {
                    extension.decorateFetchCommand(this, git, listener, fetch);
                }
                fetch.execute();
            }
            catch (GitException ex) {
                throw new GitException("Failed to fetch from " + url.toString(), (Throwable)ex);
            }
        }
    }

    private RemoteConfig newRemoteConfig(String name, String refUrl, RefSpec ... refSpec) {
        try {
            Config repoConfig = new Config();
            repoConfig.setString("remote", name, "url", refUrl);
            ArrayList<String> str = new ArrayList<String>();
            if (refSpec != null && refSpec.length > 0) {
                for (RefSpec rs : refSpec) {
                    str.add(rs.toString());
                }
            }
            repoConfig.setStringList("remote", name, "fetch", str);
            return (RemoteConfig)RemoteConfig.getAllRemoteConfigs((Config)repoConfig).get(0);
        }
        catch (Exception ex) {
            throw new GitException("Error trying to create JGit configuration", (Throwable)ex);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Jenkins.getInstance() is not null")
    public GitTool resolveGitTool(TaskListener listener) {
        if (this.gitTool == null) {
            return GitTool.getDefaultInstallation();
        }
        GitTool git = ((GitTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallation(this.gitTool);
        if (git == null) {
            listener.getLogger().println("Selected Git installation does not exist. Using Default");
            git = GitTool.getDefaultInstallation();
        }
        return git;
    }

    public String getGitExe(Node builtOn, TaskListener listener) {
        return this.getGitExe(builtOn, null, listener);
    }

    public String getGitExe(Node builtOn, EnvVars env, TaskListener listener) {
        GitClientType client = GitClientType.ANY;
        for (GitSCMExtension ext : this.extensions) {
            try {
                client = client.combine(ext.getRequiredClient());
            }
            catch (GitClientConflictException e) {
                throw new RuntimeException(ext.getDescriptor().getDisplayName() + " extended Git behavior is incompatible with other behaviors");
            }
        }
        if (client == GitClientType.JGIT) {
            return "jgit";
        }
        GitTool tool = this.resolveGitTool(listener);
        if (builtOn != null) {
            try {
                tool = tool.forNode(builtOn, listener);
            }
            catch (IOException | InterruptedException e) {
                listener.getLogger().println("Failed to get git executable");
            }
        }
        if (env != null) {
            tool = tool.forEnvironment(env);
        }
        return tool.getGitExe();
    }

    public AbstractBuild<?, ?> getBySHA1(String sha1) {
        AbstractProject p = (AbstractProject)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
        for (AbstractBuild b : p.getBuilds()) {
            Build lb;
            BuildData d = (BuildData)b.getAction(BuildData.class);
            if (d == null || d.lastBuild == null || !(lb = d.lastBuild).isFor(sha1)) continue;
            return b;
        }
        return null;
    }

    @NonNull
    private Build determineRevisionToBuild(Run build, @NonNull BuildData buildData, EnvVars environment, @NonNull GitClient git, @NonNull TaskListener listener) throws IOException, InterruptedException {
        Revision marked;
        RevisionParameterAction rpa;
        Object lastBuild;
        BuildData parentBuildData;
        MatrixBuild parentBuild;
        PrintStream log = listener.getLogger();
        Collection<Object> candidates = Collections.EMPTY_LIST;
        BuildChooserContextImpl context = new BuildChooserContextImpl(build.getParent(), build, environment);
        this.getBuildChooser().prepareWorkingTree(git, listener, context);
        if (build instanceof MatrixRun && (parentBuild = ((MatrixRun)build).getParentBuild()) != null && (parentBuildData = this.getBuildData((Run)parentBuild)) != null && (lastBuild = parentBuildData.lastBuild) != null) {
            candidates = Collections.singleton(((Build)lastBuild).getMarked());
        }
        if (candidates.isEmpty() && (rpa = (RevisionParameterAction)build.getAction(RevisionParameterAction.class)) != null) {
            if (rpa.canOriginateFrom(this.getRepositories())) {
                candidates = Collections.singleton(rpa.toRevision(git));
            } else {
                log.println("skipping resolution of commit " + rpa.commit + ", since it originates from another repository");
            }
        }
        if (candidates.isEmpty()) {
            String singleBranch = environment.expand(this.getSingleBranch(environment));
            candidates = this.getBuildChooser().getCandidateRevisions(false, singleBranch, git, listener, buildData, (BuildChooserContext)context);
        }
        if (candidates.isEmpty()) {
            throw new AbortException("Couldn't find any revision to build. Verify the repository and branch configuration for this job.");
        }
        Revision rev = marked = (Revision)candidates.iterator().next();
        for (GitSCMExtension ext : this.extensions) {
            rev = ext.decorateRevisionToBuild(this, build, git, listener, marked, rev);
        }
        Build revToBuild = new Build(marked, rev, build.getNumber(), null);
        buildData.saveBuild(revToBuild);
        if (buildData.getBuildsByBranchName().size() >= 100) {
            log.println("JENKINS-19022: warning: possible memory leak due to Git plugin usage; see: https://wiki.jenkins-ci.org/display/JENKINS/Remove+Git+Plugin+BuildsByBranch+BuildData");
        }
        if (candidates.size() > 1) {
            AbstractProject project;
            log.println("Multiple candidate revisions");
            Job job = build.getParent();
            if (job instanceof AbstractProject && !(project = (AbstractProject)job).isDisabled()) {
                log.println("Scheduling another build to catch up with " + project.getFullDisplayName());
                if (!project.scheduleBuild(0, (Cause)new SCMTrigger.SCMTriggerCause("This build was triggered by build " + build.getNumber() + " because more than one build candidate was found."))) {
                    log.println("WARNING: multiple candidate revisions, but unable to schedule build of " + project.getFullDisplayName());
                }
            }
        }
        return revToBuild;
    }

    private void retrieveChanges(Run build, GitClient git, TaskListener listener) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        List<RemoteConfig> repos = this.getParamExpandedRepos(build, listener);
        if (repos.isEmpty()) {
            return;
        }
        if (git.hasGitRepo()) {
            if (repos.size() == 1) {
                log.println("Fetching changes from the remote Git repository");
            } else {
                log.println(MessageFormat.format("Fetching changes from {0} remote Git repositories", repos.size()));
            }
        } else {
            log.println("Cloning the remote Git repository");
            RemoteConfig rc = repos.get(0);
            try {
                CloneCommand cmd = git.clone_().url(((URIish)rc.getURIs().get(0)).toPrivateString()).repositoryName(rc.getName());
                for (GitSCMExtension ext : this.extensions) {
                    ext.decorateCloneCommand(this, build, git, listener, cmd);
                }
                cmd.execute();
            }
            catch (GitException ex) {
                ex.printStackTrace(listener.error("Error cloning remote repo '" + rc.getName() + "'"));
                throw new AbortException("Error cloning remote repo '" + rc.getName() + "'");
            }
        }
        for (RemoteConfig remoteRepository : repos) {
            try {
                this.fetchFrom(git, listener, remoteRepository);
            }
            catch (GitException ex) {
                ex.printStackTrace(listener.error("Error fetching remote repo '" + remoteRepository.getName() + "'"));
                throw new AbortException("Error fetching remote repo '" + remoteRepository.getName() + "'");
            }
        }
    }

    public void checkout(Run<?, ?> build, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        if (VERBOSE) {
            listener.getLogger().println("Using checkout strategy: " + this.getBuildChooser().getDisplayName());
        }
        BuildData previousBuildData = this.getBuildData(build.getPreviousBuild());
        BuildData buildData = this.copyBuildData(build.getPreviousBuild());
        if (VERBOSE && buildData.lastBuild != null) {
            listener.getLogger().println("Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars environment = build.getEnvironment(listener);
        GitClient git = this.createClient(listener, environment, build, workspace);
        for (GitSCMExtension ext : this.extensions) {
            ext.beforeCheckout(this, build, git, listener);
        }
        this.retrieveChanges(build, git, listener);
        Build revToBuild = this.determineRevisionToBuild(build, buildData, environment, git, listener);
        boolean buildDataAlreadyPresent = false;
        List actions = build.getActions(BuildData.class);
        for (BuildData d : actions) {
            if (!d.similarTo(buildData)) continue;
            buildDataAlreadyPresent = true;
            break;
        }
        if (!actions.isEmpty()) {
            buildData.setIndex(actions.size() + 1);
        }
        if (!buildDataAlreadyPresent) {
            build.addAction((Action)buildData);
        }
        environment.put(GIT_COMMIT, revToBuild.revision.getSha1String());
        Branch localBranch = (Branch)Iterables.getFirst((Iterable)revToBuild.revision.getBranches(), null);
        String localBranchName = this.getParamLocalBranch(build, listener);
        if (localBranch != null && localBranch.getName() != null) {
            String remoteBranchName = this.getBranchName(localBranch);
            environment.put(GIT_BRANCH, remoteBranchName);
            LocalBranch lb = (LocalBranch)this.getExtensions().get(LocalBranch.class);
            if (lb != null) {
                String lbn = lb.getLocalBranch();
                if (lbn == null || lbn.equals("**")) {
                    localBranchName = this.deriveLocalBranchName(remoteBranchName);
                }
                environment.put(GIT_LOCAL_BRANCH, localBranchName);
            }
        }
        listener.getLogger().println("Checking out " + revToBuild.revision);
        CheckoutCommand checkoutCommand = git.checkout().branch(localBranchName).ref(revToBuild.revision.getSha1String()).deleteBranchIfExist(true);
        for (GitSCMExtension ext : this.getExtensions()) {
            ext.decorateCheckoutCommand(this, build, git, listener, checkoutCommand);
        }
        try {
            checkoutCommand.execute();
        }
        catch (GitLockFailedException e) {
            throw new IOException("Could not checkout " + revToBuild.revision.getSha1String(), e);
        }
        try {
            this.printCommitMessageToLog(listener, git, revToBuild);
        }
        catch (GitException ge) {
            listener.getLogger().println("Exception logging commit message for " + revToBuild + ": " + ge.getMessage());
        }
        if (!buildDataAlreadyPresent) {
            if (build.getActions(AbstractScmTagAction.class).isEmpty()) {
                build.addAction((Action)new GitTagAction(build, workspace, revToBuild.revision));
            }
            if (changelogFile != null) {
                this.computeChangeLog(git, revToBuild.revision, listener, previousBuildData, new FilePath(changelogFile), new BuildChooserContextImpl(build.getParent(), build, environment));
            }
        }
        for (GitSCMExtension ext : this.extensions) {
            ext.onCheckoutCompleted(this, build, git, listener);
        }
    }

    private void printCommitMessageToLog(TaskListener listener, GitClient git, Build revToBuild) throws IOException {
        try {
            RevCommit commit = (RevCommit)git.withRepository((RepositoryCallback)new RevCommitRepositoryCallback(revToBuild));
            listener.getLogger().println("Commit message: \"" + commit.getShortMessage() + "\"");
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.error("Unable to retrieve commit message"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeChangeLog(GitClient git, Revision revToBuild, TaskListener listener, BuildData previousBuildData, FilePath changelogFile, BuildChooserContext context) throws IOException, InterruptedException {
        boolean executed = false;
        ChangelogCommand changelog = git.changelog();
        changelog.includes(revToBuild.getSha1());
        try (OutputStreamWriter out = new OutputStreamWriter(changelogFile.write(), "UTF-8");){
            boolean exclusion = false;
            ChangelogToBranch changelogToBranch = (ChangelogToBranch)this.getExtensions().get(ChangelogToBranch.class);
            if (changelogToBranch != null) {
                listener.getLogger().println("Using 'Changelog to branch' strategy.");
                changelog.excludes(changelogToBranch.getOptions().getRef());
                exclusion = true;
            } else {
                for (Branch b : revToBuild.getBranches()) {
                    Build lastRevWas = this.getBuildChooser().prevBuildForChangelog(b.getName(), previousBuildData, git, context);
                    if (lastRevWas == null || lastRevWas.revision == null || !git.isCommitInRepo(lastRevWas.getSHA1())) continue;
                    changelog.excludes(lastRevWas.getSHA1());
                    exclusion = true;
                }
            }
            if (!exclusion) {
                listener.getLogger().println("First time build. Skipping changelog.");
            } else {
                changelog.to((Writer)out).max(MAX_CHANGELOG).execute();
                executed = true;
            }
        }
        catch (GitException ge) {
            ge.printStackTrace(listener.error("Unable to retrieve changeset"));
        }
        finally {
            if (!executed) {
                changelog.abort();
            }
        }
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        this.buildEnvironment((Run<?, ?>)build, env);
    }

    public void buildEnvironment(Run<?, ?> build, Map<String, String> env) {
        Revision rev = this.fixNull(this.getBuildData(build)).getLastBuiltRevision();
        if (rev != null) {
            Object sha1;
            Branch branch = (Branch)Iterables.getFirst((Iterable)rev.getBranches(), null);
            if (branch != null && branch.getName() != null) {
                String prevSuccessfulCommit;
                String prevCommit;
                String remoteBranchName = this.getBranchName(branch);
                env.put(GIT_BRANCH, remoteBranchName);
                LocalBranch lb = (LocalBranch)this.getExtensions().get(LocalBranch.class);
                if (lb != null) {
                    String localBranchName = lb.getLocalBranch();
                    if (localBranchName == null || localBranchName.equals("**")) {
                        localBranchName = this.deriveLocalBranchName(remoteBranchName);
                    }
                    env.put(GIT_LOCAL_BRANCH, localBranchName);
                }
                if ((prevCommit = this.getLastBuiltCommitOfBranch(build, branch)) != null) {
                    env.put(GIT_PREVIOUS_COMMIT, prevCommit);
                }
                if ((prevSuccessfulCommit = this.getLastSuccessfulBuiltCommitOfBranch(build, branch)) != null) {
                    env.put(GIT_PREVIOUS_SUCCESSFUL_COMMIT, prevSuccessfulCommit);
                }
            }
            if ((sha1 = Util.fixEmpty((String)rev.getSha1String())) != null && !((String)sha1).isEmpty()) {
                env.put(GIT_COMMIT, (String)sha1);
            }
        }
        if (this.userRemoteConfigs.size() == 1) {
            env.put("GIT_URL", this.userRemoteConfigs.get(0).getUrl());
        } else {
            int count = 1;
            for (UserRemoteConfig config : this.userRemoteConfigs) {
                env.put("GIT_URL_" + count, config.getUrl());
                ++count;
            }
        }
        this.getDescriptor().populateEnvironmentVariables(env);
        for (GitSCMExtension ext : this.extensions) {
            ext.populateEnvironmentVariables(this, env);
        }
    }

    private String getBranchName(Branch branch) {
        String name = branch.getName();
        if (name.startsWith("refs/remotes/")) {
            name = name.substring("refs/remotes/".length());
        }
        return name;
    }

    private String getLastBuiltCommitOfBranch(Run<?, ?> build, Branch branch) {
        Revision previousRev;
        Build lastBuildOfBranch;
        String prevCommit = null;
        if (build.getPreviousBuiltBuild() != null && (lastBuildOfBranch = this.fixNull(this.getBuildData(build.getPreviousBuiltBuild())).getLastBuildOfBranch(branch.getName())) != null && (previousRev = lastBuildOfBranch.getRevision()) != null) {
            prevCommit = previousRev.getSha1String();
        }
        return prevCommit;
    }

    private String getLastSuccessfulBuiltCommitOfBranch(Run<?, ?> build, Branch branch) {
        Revision previousRev;
        Build lastSuccessfulBuildOfBranch;
        String prevCommit = null;
        if (build.getPreviousSuccessfulBuild() != null && (lastSuccessfulBuildOfBranch = this.fixNull(this.getBuildData(build.getPreviousSuccessfulBuild())).getLastBuildOfBranch(branch.getName())) != null && (previousRev = lastSuccessfulBuildOfBranch.getRevision()) != null) {
            prevCommit = previousRev.getSha1String();
        }
        return prevCommit;
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser(this.getExtensions().get(AuthorInChangelog.class) != null);
    }

    public boolean isDoGenerateSubmoduleConfigurations() {
        return this.doGenerateSubmoduleConfigurations;
    }

    @Exported
    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    public String getKey() {
        String name = this.getScmName();
        if (name != null) {
            return name;
        }
        StringBuilder b = new StringBuilder("git");
        for (RemoteConfig cfg : this.getRepositories()) {
            for (URIish uri : cfg.getURIs()) {
                b.append(' ').append(uri.toString());
            }
        }
        return b.toString();
    }

    @Exported
    @Deprecated
    public PreBuildMergeOptions getMergeOptions() throws Descriptor.FormException {
        return DescriptorImpl.createMergeOptions(this.getUserMergeOptions(), this.remoteRepositories);
    }

    private boolean isRelevantBuildData(BuildData bd) {
        for (UserRemoteConfig c : this.getUserRemoteConfigs()) {
            if (!bd.hasBeenReferenced(c.getUrl())) continue;
            return true;
        }
        return false;
    }

    public BuildData getBuildData(Run build, boolean clone) {
        return clone ? this.copyBuildData(build) : this.getBuildData(build);
    }

    public BuildData copyBuildData(Run build) {
        BuildData base = this.getBuildData(build);
        if (base == null) {
            return new BuildData(this.getScmName(), this.getUserRemoteConfigs());
        }
        BuildData buildData = base.clone();
        buildData.setScmName(this.getScmName());
        return buildData;
    }

    @CheckForNull
    public BuildData getBuildData(Run build) {
        BuildData buildData = null;
        while (build != null) {
            List buildDataList = build.getActions(BuildData.class);
            for (BuildData bd : buildDataList) {
                if (bd == null || !this.isRelevantBuildData(bd)) continue;
                buildData = bd;
                break;
            }
            if (buildData != null) break;
            build = build.getPreviousBuild();
        }
        return buildData;
    }

    protected FilePath workingDirectory(Job<?, ?> context, FilePath workspace, EnvVars environment, TaskListener listener) throws IOException, InterruptedException {
        if (workspace == null) {
            return null;
        }
        for (GitSCMExtension ext : this.extensions) {
            FilePath r = ext.getWorkingDirectory(this, context, workspace, environment, listener);
            if (r == null) continue;
            return r;
        }
        return workspace;
    }

    private boolean isRevExcluded(GitClient git, Revision r, TaskListener listener, BuildData buildData) throws IOException, InterruptedException {
        try {
            List revShow = buildData != null && buildData.lastBuild != null ? (this.getExtensions().get(PathRestriction.class) != null ? git.showRevision(buildData.lastBuild.revision.getSha1(), r.getSha1()) : git.showRevision(buildData.lastBuild.revision.getSha1(), r.getSha1(), Boolean.valueOf(false))) : git.showRevision(r.getSha1());
            revShow.add("commit ");
            int start = 0;
            int idx = 0;
            for (String line : revShow) {
                if (line.startsWith("commit ") && idx != 0) {
                    GitSCMExtension ext;
                    GitChangeSet change = new GitChangeSet(revShow.subList(start, idx), this.getExtensions().get(AuthorInChangelog.class) != null);
                    Boolean excludeThisCommit = null;
                    Iterator iterator = this.extensions.iterator();
                    while (iterator.hasNext() && (excludeThisCommit = (ext = (GitSCMExtension)((Object)iterator.next())).isRevExcluded(this, git, change, listener, buildData)) == null) {
                    }
                    if (excludeThisCommit == null || !excludeThisCommit.booleanValue()) {
                        return false;
                    }
                    start = idx;
                }
                ++idx;
            }
            assert (start == revShow.size() - 1);
            return true;
        }
        catch (GitException e) {
            e.printStackTrace(listener.error("Failed to determine if we want to exclude " + r.getSha1String()));
            return false;
        }
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void onLoaded() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            LOGGER.severe("Jenkins.getInstance is null in GitSCM.onLoaded");
            return;
        }
        DescriptorImpl desc = (DescriptorImpl)jenkins.getDescriptorByType(DescriptorImpl.class);
        if (desc.getOldGitExe() != null) {
            String defaultGit;
            String exe = desc.getOldGitExe();
            if (exe.equals(defaultGit = GitTool.getDefaultInstallation().getGitExe())) {
                return;
            }
            System.err.println("[WARNING] you're using deprecated gitexe attribute to configure git plugin. Use Git installations");
        }
    }

    @Initializer(before=InitMilestone.JOB_LOADED)
    public static void configureXtream() {
        Run.XSTREAM.registerConverter((Converter)new ObjectIdConverter());
        Items.XSTREAM.registerConverter((Converter)new RemoteConfigConverter(Items.XSTREAM));
        Items.XSTREAM.alias("org.spearce.jgit.transport.RemoteConfig", RemoteConfig.class);
    }

    @Extension
    public static final class DescriptorImpl
    extends SCMDescriptor<GitSCM> {
        private String gitExe;
        private String globalConfigName;
        private String globalConfigEmail;
        private boolean createAccountBasedOnEmail;

        public DescriptorImpl() {
            super(GitSCM.class, GitRepositoryBrowser.class);
            this.load();
        }

        public String getDisplayName() {
            return "Git";
        }

        public boolean isApplicable(Job project) {
            return true;
        }

        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return GitSCMExtensionDescriptor.all();
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Jenkins.getInstance() is not null")
        public boolean showGitToolOptions() {
            return ((GitTool[])((GitTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations()).length > 1;
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Jenkins.getInstance() is not null")
        public List<GitTool> getGitTools() {
            GitTool[] gitToolInstallations = (GitTool[])((GitTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(gitToolInstallations);
        }

        public ListBoxModel doFillGitToolItems() {
            ListBoxModel r = new ListBoxModel();
            for (GitTool git : this.getGitTools()) {
                r.add(git.getName());
            }
            return r;
        }

        @Deprecated
        public String getGitExe() {
            return this.gitExe;
        }

        public String getGlobalConfigName() {
            return Util.fixEmptyAndTrim((String)this.globalConfigName);
        }

        public void setGlobalConfigName(String globalConfigName) {
            this.globalConfigName = globalConfigName;
        }

        public String getGlobalConfigEmail() {
            return Util.fixEmptyAndTrim((String)this.globalConfigEmail);
        }

        public void setGlobalConfigEmail(String globalConfigEmail) {
            this.globalConfigEmail = globalConfigEmail;
        }

        public boolean isCreateAccountBasedOnEmail() {
            return this.createAccountBasedOnEmail;
        }

        public void setCreateAccountBasedOnEmail(boolean createAccountBasedOnEmail) {
            this.createAccountBasedOnEmail = createAccountBasedOnEmail;
        }

        public String getOldGitExe() {
            return this.gitExe;
        }

        private GitRepositoryBrowser getBrowserFromRequest(StaplerRequest req, JSONObject scmData) {
            if (scmData.containsKey((Object)"browser")) {
                return (GitRepositoryBrowser)((Object)req.bindJSON(GitRepositoryBrowser.class, scmData.getJSONObject("browser")));
            }
            return null;
        }

        public static List<RemoteConfig> createRepositoryConfigurations(String[] urls, String[] repoNames, String[] refs) throws IOException {
            List remoteRepositories;
            Config repoConfig = new Config();
            String[] names = repoNames;
            names = GitUtils.fixupNames(names, urls);
            for (int i = 0; i < names.length; ++i) {
                String url = urls[i];
                if (url == null) continue;
                String name = names[i];
                name = name.replace(' ', '_');
                if (StringUtils.isBlank((String)refs[i])) {
                    refs[i] = "+refs/heads/*:refs/remotes/" + name + "/*";
                }
                repoConfig.setString("remote", name, "url", url);
                repoConfig.setStringList("remote", name, "fetch", new ArrayList<String>(Arrays.asList(refs[i].split("\\s+"))));
            }
            try {
                remoteRepositories = RemoteConfig.getAllRemoteConfigs((Config)repoConfig);
            }
            catch (Exception e) {
                throw new GitException("Error creating repositories", (Throwable)e);
            }
            return remoteRepositories;
        }

        public static PreBuildMergeOptions createMergeOptions(UserMergeOptions mergeOptionsBean, List<RemoteConfig> remoteRepositories) throws Descriptor.FormException {
            PreBuildMergeOptions mergeOptions = new PreBuildMergeOptions();
            if (mergeOptionsBean != null) {
                RemoteConfig mergeRemote = null;
                String mergeRemoteName = mergeOptionsBean.getMergeRemote().trim();
                if (mergeRemoteName.length() == 0) {
                    mergeRemote = remoteRepositories.get(0);
                } else {
                    for (RemoteConfig remote : remoteRepositories) {
                        if (!remote.getName().equals(mergeRemoteName)) continue;
                        mergeRemote = remote;
                        break;
                    }
                }
                if (mergeRemote == null) {
                    throw new Descriptor.FormException("No remote repository configured with name '" + mergeRemoteName + "'", "git.mergeRemote");
                }
                mergeOptions.setMergeRemote(mergeRemote);
                mergeOptions.setMergeTarget(mergeOptionsBean.getMergeTarget());
                mergeOptions.setMergeStrategy(mergeOptionsBean.getMergeStrategy());
                mergeOptions.setFastForwardMode(mergeOptionsBean.getFastForwardMode());
            }
            return mergeOptions;
        }

        public FormValidation doGitRemoteNameCheck(StaplerRequest req) throws IOException, ServletException {
            boolean isMerge;
            String mergeRemoteName = req.getParameter("value");
            boolean bl = isMerge = req.getParameter("isMerge") != null;
            if (mergeRemoteName.length() == 0 && isMerge) {
                return FormValidation.ok();
            }
            String[] urls = req.getParameterValues("repo.url");
            String[] names = req.getParameterValues("repo.name");
            if (urls != null && names != null) {
                for (String name : GitUtils.fixupNames(names, urls)) {
                    if (!name.equals(mergeRemoteName)) continue;
                    return FormValidation.ok();
                }
            }
            return FormValidation.error((String)("No remote repository configured with name '" + mergeRemoteName + "'"));
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        public void populateEnvironmentVariables(Map<String, String> env) {
            String email;
            String name = this.getGlobalConfigName();
            if (name != null) {
                env.put("GIT_COMMITTER_NAME", name);
                env.put("GIT_AUTHOR_NAME", name);
            }
            if ((email = this.getGlobalConfigEmail()) != null) {
                env.put("GIT_COMMITTER_EMAIL", email);
                env.put("GIT_AUTHOR_EMAIL", email);
            }
        }
    }

    static class BuildChooserContextImpl
    implements BuildChooserContext,
    Serializable {
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="known non-serializable field")
        final Job project;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="known non-serializable field")
        final Run build;
        final EnvVars environment;

        BuildChooserContextImpl(Job project, Run build, EnvVars environment) {
            this.project = project;
            this.build = build;
            this.environment = environment;
        }

        @Override
        public <T> T actOnBuild(BuildChooserContext.ContextCallable<Run<?, ?>, T> callable) throws IOException, InterruptedException {
            return callable.invoke(this.build, (VirtualChannel)Hudson.MasterComputer.localChannel);
        }

        @Override
        public <T> T actOnProject(BuildChooserContext.ContextCallable<Job<?, ?>, T> callable) throws IOException, InterruptedException {
            return callable.invoke(this.project, (VirtualChannel)Hudson.MasterComputer.localChannel);
        }

        @Override
        public Run<?, ?> getBuild() {
            return this.build;
        }

        @Override
        public EnvVars getEnvironment() {
            return this.environment;
        }

        private Object writeReplace() {
            return Channel.current().export(BuildChooserContext.class, (Object)new BuildChooserContext(){

                @Override
                public <T> T actOnBuild(BuildChooserContext.ContextCallable<Run<?, ?>, T> callable) throws IOException, InterruptedException {
                    return callable.invoke(BuildChooserContextImpl.this.build, (VirtualChannel)Channel.current());
                }

                @Override
                public <T> T actOnProject(BuildChooserContext.ContextCallable<Job<?, ?>, T> callable) throws IOException, InterruptedException {
                    return callable.invoke(BuildChooserContextImpl.this.project, (VirtualChannel)Channel.current());
                }

                @Override
                public Run<?, ?> getBuild() {
                    return BuildChooserContextImpl.this.build;
                }

                @Override
                public EnvVars getEnvironment() {
                    return BuildChooserContextImpl.this.environment;
                }
            });
        }
    }
}

