/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.plugins.git.Messages;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.plugins.git.traits.GitSCMExtensionTrait;
import jenkins.plugins.git.traits.GitSCMExtensionTraitDescriptor;
import jenkins.plugins.git.traits.GitToolSCMSourceTrait;
import jenkins.plugins.git.traits.IgnoreOnPushNotificationTrait;
import jenkins.plugins.git.traits.RefSpecsSCMSourceTrait;
import jenkins.plugins.git.traits.RemoteNameSCMSourceTrait;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class GitSCMSource
extends AbstractGitSCMSource {
    private static final String DEFAULT_INCLUDES = "*";
    private static final String DEFAULT_EXCLUDES = "";
    public static final Logger LOGGER = Logger.getLogger(GitSCMSource.class.getName());
    private final String remote;
    @CheckForNull
    private transient String credentialsId;
    @Deprecated
    private transient String remoteName;
    @Deprecated
    private transient String rawRefSpecs;
    @Deprecated
    private transient String includes;
    @Deprecated
    private transient String excludes;
    @Deprecated
    private transient boolean ignoreOnPushNotifications;
    @Deprecated
    private transient GitRepositoryBrowser browser;
    @Deprecated
    private transient String gitTool;
    @Deprecated
    private transient List<GitSCMExtension> extensions;
    private List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();

    @DataBoundConstructor
    public GitSCMSource(String remote) {
        this.remote = remote;
    }

    @Deprecated
    public GitSCMSource(String id, String remote) {
        this(remote);
        this.setId(id);
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setTraits(List<SCMSourceTrait> traits) {
        this.traits = traits == null ? new ArrayList<SCMSourceTrait>() : new ArrayList<SCMSourceTrait>(traits);
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public GitSCMSource(String id, String remote, String credentialsId, String remoteName, String rawRefSpecs, String includes, String excludes, boolean ignoreOnPushNotifications) {
        super(id);
        RefSpecsSCMSourceTrait trait;
        this.remote = remote;
        this.credentialsId = credentialsId;
        this.traits = new ArrayList<SCMSourceTrait>();
        if (!DEFAULT_INCLUDES.equals(includes) || !DEFAULT_EXCLUDES.equals(excludes)) {
            this.traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait(includes, excludes));
        }
        if (!"origin".equals(remoteName) && StringUtils.isNotBlank((String)remoteName)) {
            this.traits.add(new RemoteNameSCMSourceTrait(remoteName));
        }
        if (ignoreOnPushNotifications) {
            this.traits.add(new IgnoreOnPushNotificationTrait());
        }
        if ((trait = this.asRefSpecsSCMSourceTrait(rawRefSpecs, remoteName)) != null) {
            this.traits.add(trait);
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public GitSCMSource(String id, String remote, String credentialsId, String includes, String excludes, boolean ignoreOnPushNotifications) {
        this(id, remote, credentialsId, null, null, includes, excludes, ignoreOnPushNotifications);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.traits == null) {
            RefSpecsSCMSourceTrait trait;
            this.traits = new ArrayList<SCMSourceTrait>();
            if (this.includes != null && !DEFAULT_INCLUDES.equals(this.includes) || this.excludes != null && !DEFAULT_EXCLUDES.equals(this.excludes)) {
                this.traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait(this.includes, this.excludes));
            }
            if (this.extensions != null) {
                block2: for (GitSCMExtension extension : this.extensions) {
                    for (SCMSourceTraitDescriptor d : SCMSourceTrait.all()) {
                        GitSCMExtensionTraitDescriptor descriptor;
                        if (d instanceof GitSCMExtensionTraitDescriptor && (descriptor = (GitSCMExtensionTraitDescriptor)d).getExtensionClass().isInstance((Object)extension)) {
                            try {
                                SCMSourceTrait trait2 = descriptor.convertToTrait(extension);
                                if (trait2 != null) {
                                    this.traits.add(trait2);
                                    continue block2;
                                }
                            }
                            catch (UnsupportedOperationException e) {
                                LOGGER.log(Level.WARNING, "Could not convert " + ((Object)((Object)extension)).getClass().getName() + " to a trait", e);
                            }
                        }
                        LOGGER.log(Level.FINE, "Could not convert {0} to a trait (likely because this option does not make sense for a GitSCMSource)", ((Object)((Object)this)).getClass().getName());
                    }
                }
            }
            if (this.remoteName != null && !"origin".equals(this.remoteName) && StringUtils.isNotBlank((String)this.remoteName)) {
                this.traits.add(new RemoteNameSCMSourceTrait(this.remoteName));
            }
            if (StringUtils.isNotBlank((String)this.gitTool)) {
                this.traits.add(new GitToolSCMSourceTrait(this.gitTool));
            }
            if (this.browser != null) {
                this.traits.add(new GitBrowserSCMSourceTrait(this.browser));
            }
            if ((trait = this.asRefSpecsSCMSourceTrait(this.rawRefSpecs, this.remoteName)) != null) {
                this.traits.add(trait);
            }
        }
        return this;
    }

    private RefSpecsSCMSourceTrait asRefSpecsSCMSourceTrait(String rawRefSpecs, String remoteName) {
        if (rawRefSpecs != null) {
            HashSet<String> defaults = new HashSet<String>();
            defaults.add("+refs/heads/*:refs/remotes/origin/*");
            if (remoteName != null) {
                defaults.add("+refs/heads/*:refs/remotes/" + remoteName + "/*");
            }
            if (!defaults.contains(rawRefSpecs.trim())) {
                ArrayList<String> templates = new ArrayList<String>();
                for (String rawRefSpec : rawRefSpecs.split(" ")) {
                    if (StringUtils.isBlank((String)rawRefSpec)) continue;
                    if (defaults.contains(rawRefSpec)) {
                        templates.add("+refs/heads/*:refs/remotes/@{remote}/*");
                        continue;
                    }
                    templates.add(rawRefSpec);
                }
                if (!templates.isEmpty()) {
                    return new RefSpecsSCMSourceTrait(templates.toArray(new String[templates.size()]));
                }
            }
        }
        return null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    public boolean isIgnoreOnPushNotifications() {
        for (SCMSourceTrait trait : this.traits) {
            if (!(trait instanceof IgnoreOnPushNotificationTrait)) continue;
            return true;
        }
        return false;
    }

    @DataBoundSetter
    @Restricted(value={DoNotUse.class})
    public void setBrowser(GitRepositoryBrowser browser) {
        Iterator<SCMSourceTrait> iterator = this.traits.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof GitBrowserSCMSourceTrait)) continue;
            iterator.remove();
        }
        if (browser != null) {
            this.traits.add(new GitBrowserSCMSourceTrait(browser));
        }
    }

    @DataBoundSetter
    @Restricted(value={DoNotUse.class})
    public void setGitTool(String gitTool) {
        gitTool = Util.fixEmptyAndTrim((String)gitTool);
        Iterator<SCMSourceTrait> iterator = this.traits.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof GitToolSCMSourceTrait)) continue;
            iterator.remove();
        }
        if (gitTool != null) {
            this.traits.add(new GitToolSCMSourceTrait(gitTool));
        }
    }

    @DataBoundSetter
    @Deprecated
    @Restricted(value={DoNotUse.class})
    public void setExtensions(@CheckForNull List<GitSCMExtension> extensions) {
        Iterator<SCMSourceTrait> iterator = this.traits.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof GitSCMExtensionTrait)) continue;
            iterator.remove();
        }
        block3: for (GitSCMExtension extension : Util.fixNull(extensions)) {
            for (SCMSourceTraitDescriptor d : SCMSourceTrait.all()) {
                GitSCMExtensionTraitDescriptor descriptor;
                if (d instanceof GitSCMExtensionTraitDescriptor && (descriptor = (GitSCMExtensionTraitDescriptor)d).getExtensionClass().isInstance((Object)extension)) {
                    try {
                        SCMSourceTrait trait = descriptor.convertToTrait(extension);
                        if (trait != null) {
                            this.traits.add(trait);
                            continue block3;
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        LOGGER.log(Level.WARNING, "Could not convert " + ((Object)((Object)extension)).getClass().getName() + " to a trait", e);
                    }
                }
                LOGGER.log(Level.FINE, "Could not convert {0} to a trait (likely because this option does not make sense for a GitSCMSource)", ((Object)((Object)extension)).getClass().getName());
            }
        }
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public String getRemote() {
        return this.remote;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    public String getRawRefSpecs() {
        String remoteName = null;
        RefSpecsSCMSourceTrait refSpecs = null;
        for (SCMSourceTrait trait : this.traits) {
            if (trait instanceof RemoteNameSCMSourceTrait) {
                remoteName = ((RemoteNameSCMSourceTrait)trait).getRemoteName();
                if (refSpecs != null) break;
            }
            if (!(trait instanceof RefSpecsSCMSourceTrait)) continue;
            refSpecs = (RefSpecsSCMSourceTrait)trait;
            if (remoteName == null) continue;
            break;
        }
        if (remoteName == null) {
            remoteName = "origin";
        }
        if (refSpecs == null) {
            return "+refs/heads/*:refs/remotes/@{remote}/*".replaceAll(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER, remoteName);
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        Pattern placeholder = Pattern.compile(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER);
        for (String template : refSpecs.asStrings()) {
            if (first) {
                first = false;
            } else {
                result.append(' ');
            }
            result.append(placeholder.matcher(template).replaceAll(remoteName));
        }
        return result.toString();
    }

    @Override
    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    protected List<RefSpec> getRefSpecs() {
        return ((GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits)).asRefSpecs();
    }

    @Override
    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return this.traits;
    }

    @Extension
    public static class ListenerImpl
    extends GitStatus.Listener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<GitStatus.ResponseContributor> onNotifyCommit(String origin, URIish uri, final @Nullable String sha1, List<ParameterValue> buildParameters, String ... branches) {
            boolean[] notified;
            ArrayList<GitStatus.ResponseContributor> result;
            block11: {
                result = new ArrayList<GitStatus.ResponseContributor>();
                notified = new boolean[]{false};
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins == null) {
                    LOGGER.severe("Jenkins instance is null in GitSCMSource.onNotifyCommit");
                    return result;
                }
                jenkins.getACL();
                SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
                try {
                    if (branches.length > 0) {
                        final URIish u = uri;
                        for (final String branch : branches) {
                            SCMHeadEvent.fireNow((SCMHeadEvent)new SCMHeadEvent<String>(SCMEvent.Type.UPDATED, branch, origin){

                                public boolean isMatch(@NonNull SCMNavigator navigator) {
                                    return false;
                                }

                                @NonNull
                                public String getSourceName() {
                                    return u.getHumanishName();
                                }

                                public boolean isMatch(SCMSource source) {
                                    if (source instanceof GitSCMSource) {
                                        URIish remote;
                                        GitSCMSource git = (GitSCMSource)source;
                                        GitSCMSourceContext ctx = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(git.getTraits());
                                        if (ctx.ignoreOnPushNotifications()) {
                                            return false;
                                        }
                                        try {
                                            remote = new URIish(git.getRemote());
                                        }
                                        catch (URISyntaxException e) {
                                            return false;
                                        }
                                        if (GitStatus.looselyMatches(u, remote)) {
                                            notified[0] = true;
                                            return true;
                                        }
                                        return false;
                                    }
                                    return false;
                                }

                                @NonNull
                                public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
                                    if (source instanceof GitSCMSource) {
                                        URIish remote;
                                        GitSCMSource git = (GitSCMSource)source;
                                        GitSCMSourceContext ctx = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(git.getTraits());
                                        if (ctx.ignoreOnPushNotifications()) {
                                            return Collections.emptyMap();
                                        }
                                        try {
                                            remote = new URIish(git.getRemote());
                                        }
                                        catch (URISyntaxException e) {
                                            return Collections.emptyMap();
                                        }
                                        if (GitStatus.looselyMatches(u, remote)) {
                                            SCMHead head = new SCMHead(branch);
                                            for (SCMHeadPrefilter filter : ctx.prefilters()) {
                                                if (!filter.isExcluded((SCMSource)git, head)) continue;
                                                return Collections.emptyMap();
                                            }
                                            return Collections.singletonMap(head, sha1 != null ? new AbstractGitSCMSource.SCMRevisionImpl(head, sha1) : null);
                                        }
                                    }
                                    return Collections.emptyMap();
                                }

                                public boolean isMatch(@NonNull SCM scm) {
                                    return false;
                                }
                            });
                        }
                        break block11;
                    }
                    for (final SCMSourceOwner owner : SCMSourceOwners.all()) {
                        for (SCMSource source : owner.getSCMSources()) {
                            URIish remote;
                            if (!(source instanceof GitSCMSource)) continue;
                            GitSCMSource git = (GitSCMSource)source;
                            GitSCMSourceContext ctx = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(git.getTraits());
                            if (ctx.ignoreOnPushNotifications()) continue;
                            try {
                                remote = new URIish(git.getRemote());
                            }
                            catch (URISyntaxException e) {
                                continue;
                            }
                            if (!GitStatus.looselyMatches(uri, remote)) continue;
                            LOGGER.info("Triggering the indexing of " + owner.getFullDisplayName() + " as a result of event from " + origin);
                            owner.onSCMSourceUpdated(source);
                            result.add(new GitStatus.ResponseContributor(){

                                @Override
                                public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                                    rsp.addHeader("Triggered", owner.getAbsoluteUrl());
                                }

                                @Override
                                public void writeBody(PrintWriter w) {
                                    w.println("Scheduled indexing of " + owner.getFullDisplayName());
                                }
                            });
                            notified[0] = true;
                        }
                    }
                }
                finally {
                    SecurityContextHolder.setContext((SecurityContext)old);
                }
            }
            if (!notified[0]) {
                result.add(new GitStatus.MessageResponseContributor("No Git consumers using SCM API plugin for: " + uri.toString()));
            }
            return result;
        }
    }

    @Symbol(value={"git"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return Messages.GitSCMSource_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String remote, @QueryParameter String credentialsId) {
            if (context == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, (Item)context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)remote).build(), GitClient.CREDENTIALS_MATCHER).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath SCMSourceOwner context, @QueryParameter String url, @QueryParameter String value) {
            if (context == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((url = Util.fixEmptyAndTrim((String)url)) == null) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)url).build(), (CredentialsMatcher)GitClient.CREDENTIALS_MATCHER)) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        @Deprecated
        @Restricted(value={NoExternalUse.class})
        @RestrictedSince(value="3.4.0")
        public GitSCM.DescriptorImpl getSCMDescriptor() {
            return (GitSCM.DescriptorImpl)Jenkins.getActiveInstance().getDescriptor(GitSCM.class);
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="3.4.0")
        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return this.getSCMDescriptor().getExtensionDescriptors();
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="3.4.0")
        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return this.getSCMDescriptor().getBrowserDescriptors();
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="3.4.0")
        public boolean showGitToolOptions() {
            return this.getSCMDescriptor().showGitToolOptions();
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="3.4.0")
        public ListBoxModel doFillGitToolItems() {
            return this.getSCMDescriptor().doFillGitToolItems();
        }

        public List<NamedArrayList<? extends SCMSourceTraitDescriptor>> getTraitsDescriptorLists() {
            ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>> result = new ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>>();
            List descriptors = SCMSourceTrait._for((SCMSourceDescriptor)this, GitSCMSourceContext.class, GitSCMBuilder.class);
            NamedArrayList.select((List)descriptors, (String)"Within Repository", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Selection.class), NamedArrayList.withAnnotation(Discovery.class)}), (boolean)true, result);
            NamedArrayList.select((List)descriptors, (String)"Additional", null, (boolean)true, result);
            return result;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Collections.emptyList();
        }
    }
}

