/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.transport.RemoteConfig;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitLFSPull
extends GitSCMExtension {
    @DataBoundConstructor
    public GitLFSPull() {
    }

    @Override
    public void decorateCheckoutCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, CheckoutCommand cmd) throws IOException, InterruptedException, GitException {
        listener.getLogger().println("Enabling Git LFS pull");
        List<RemoteConfig> repos = scm.getParamExpandedRepos(build, listener);
        if (!repos.isEmpty()) {
            cmd.lfsRemote(repos.get(0).getName());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Git LFS pull after checkout";
        }
    }
}

