/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Action;
import hudson.model.Label;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTagAction;
import hudson.plugins.git.util.BuildData;
import hudson.scm.ChangeLogSet;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import jenkins.plugins.git.CliGitCommand;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitStep;
import jenkins.util.VirtualFile;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepConfigTester;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitStepTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    @Rule
    public GitSampleRepoRule otherRepo = new GitSampleRepoRule();

    @BeforeClass
    public static void setGitDefaults() throws Exception {
        CliGitCommand gitCmd = new CliGitCommand(null, new String[0]);
        gitCmd.setDefaults();
    }

    @Test
    public void roundtrip() throws Exception {
        GitStep step = new GitStep("git@github.com:jenkinsci/workflow-plugin.git");
        Step roundtrip = new StepConfigTester(this.r).configRoundTrip((Step)step);
        this.r.assertEqualDataBoundBeans((Object)step, (Object)roundtrip);
    }

    @Test
    public void roundtrip_withcredentials() throws Exception {
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, null, "user", "pass");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.r.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        GitStep step = new GitStep("git@github.com:jenkinsci/workflow-plugin.git");
        step.setCredentialsId(c.getId());
        Step roundtrip = new StepConfigTester(this.r).configRoundTrip((Step)step);
        this.r.assertEqualDataBoundBeans((Object)step, (Object)roundtrip);
    }

    @Test
    public void basicCloneAndUpdate() throws Exception {
        this.sampleRepo.init();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "demo");
        this.r.createOnlineSlave(Label.get((String)"remote"));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node('remote') {\n    ws {\n        git(url: $/" + (Object)((Object)this.sampleRepo) + "/$, poll: false, changelog: false)\n        archive '**'\n    }\n}"));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("Cloning the remote Git repository", (Run)b);
        Assert.assertTrue((boolean)b.getArtifactManager().root().child("file").isFile());
        this.sampleRepo.write("nextfile", "");
        this.sampleRepo.git("add", "nextfile");
        this.sampleRepo.git("commit", "--message=next");
        b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("Fetching changes from the remote Git repository", (Run)b);
        Assert.assertTrue((boolean)b.getArtifactManager().root().child("nextfile").isFile());
    }

    @Test
    public void changelogAndPolling() throws Exception {
        this.sampleRepo.init();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "demo");
        p.addTrigger((Trigger)new SCMTrigger(""));
        this.r.createOnlineSlave(Label.get((String)"remote"));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node('remote') {\n    ws {\n        git($/" + (Object)((Object)this.sampleRepo) + "/$)\n    }\n}"));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("Cloning the remote Git repository", (Run)b);
        this.sampleRepo.write("nextfile", "");
        this.sampleRepo.git("add", "nextfile");
        this.sampleRepo.git("commit", "--message=next");
        this.sampleRepo.notifyCommit(this.r);
        b = p.getLastBuild();
        Assert.assertEquals((long)2L, (long)b.number);
        this.r.assertLogContains("Fetching changes from the remote Git repository", (Run)b);
        List changeSets = b.getChangeSets();
        Assert.assertEquals((long)1L, (long)changeSets.size());
        ChangeLogSet changeSet = (ChangeLogSet)changeSets.get(0);
        Assert.assertEquals((Object)b, (Object)changeSet.getRun());
        Assert.assertEquals((Object)"git", (Object)changeSet.getKind());
        Iterator iterator = changeSet.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)iterator.next();
        Assert.assertEquals((Object)"[nextfile]", (Object)entry.getAffectedPaths().toString());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void multipleSCMs() throws Exception {
        this.sampleRepo.init();
        this.otherRepo.init();
        this.otherRepo.write("otherfile", "");
        this.otherRepo.git("add", "otherfile");
        this.otherRepo.git("commit", "--message=init");
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "demo");
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.setQuietPeriod(Integer.valueOf(3));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n    ws {\n        dir('main') {\n            git($/" + (Object)((Object)this.sampleRepo) + "/$)\n        }\n        dir('other') {\n            git($/" + (Object)((Object)this.otherRepo) + "/$)\n        }\n        archive '**'\n    }\n}"));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        VirtualFile artifacts = b.getArtifactManager().root();
        Assert.assertTrue((boolean)artifacts.child("main/file").isFile());
        Assert.assertTrue((boolean)artifacts.child("other/otherfile").isFile());
        this.sampleRepo.write("file2", "");
        this.sampleRepo.git("add", "file2");
        this.sampleRepo.git("commit", "--message=file2");
        this.otherRepo.write("otherfile2", "");
        this.otherRepo.git("add", "otherfile2");
        this.otherRepo.git("commit", "--message=otherfile2");
        this.sampleRepo.notifyCommit(this.r);
        this.otherRepo.notifyCommit(this.r);
        b = p.getLastBuild();
        Assert.assertEquals((long)2L, (long)b.number);
        artifacts = b.getArtifactManager().root();
        Assert.assertTrue((boolean)artifacts.child("main/file2").isFile());
        Assert.assertTrue((boolean)artifacts.child("other/otherfile2").isFile());
        Iterator scms = p.getSCMs().iterator();
        Assert.assertTrue((boolean)scms.hasNext());
        Assert.assertEquals((Object)this.sampleRepo.toString(), (Object)((URIish)((RemoteConfig)((GitSCM)scms.next()).getRepositories().get(0)).getURIs().get(0)).toString());
        Assert.assertTrue((boolean)scms.hasNext());
        Assert.assertEquals((Object)this.otherRepo.toString(), (Object)((URIish)((RemoteConfig)((GitSCM)scms.next()).getRepositories().get(0)).getURIs().get(0)).toString());
        Assert.assertFalse((boolean)scms.hasNext());
        List changeSets = b.getChangeSets();
        Assert.assertEquals((long)2L, (long)changeSets.size());
        ChangeLogSet changeSet = (ChangeLogSet)changeSets.get(0);
        Assert.assertEquals((Object)b, (Object)changeSet.getRun());
        Assert.assertEquals((Object)"git", (Object)changeSet.getKind());
        Iterator iterator = changeSet.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)iterator.next();
        Assert.assertEquals((Object)"[file2]", (Object)entry.getAffectedPaths().toString());
        Assert.assertFalse((boolean)iterator.hasNext());
        changeSet = (ChangeLogSet)changeSets.get(1);
        iterator = changeSet.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        entry = (ChangeLogSet.Entry)iterator.next();
        Assert.assertEquals((Object)"[otherfile2]", (Object)entry.getAffectedPaths().toString());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void identicalGitSCMs() throws Exception {
        this.sampleRepo.init();
        this.otherRepo.init();
        this.otherRepo.write("firstfile", "");
        this.otherRepo.git("add", "firstfile");
        this.otherRepo.git("commit", "--message=init");
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "demo");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n    dir('main') {\n        git($/" + (Object)((Object)this.otherRepo) + "/$)\n    }\n    dir('other') {\n        git($/" + (Object)((Object)this.otherRepo) + "/$)\n    }\n}"));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertEquals((long)1L, (long)b.getActions(BuildData.class).size());
        Assert.assertEquals((long)1L, (long)b.getActions(GitTagAction.class).size());
        Assert.assertEquals((long)0L, (long)b.getChangeSets().size());
        Assert.assertEquals((long)1L, (long)p.getSCMs().size());
        this.otherRepo.write("secondfile", "");
        this.otherRepo.git("add", "secondfile");
        this.otherRepo.git("commit", "--message=second");
        WorkflowRun b2 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assert.assertEquals((long)1L, (long)b2.getActions(BuildData.class).size());
        Assert.assertEquals((long)1L, (long)b2.getActions(GitTagAction.class).size());
        Assert.assertEquals((long)1L, (long)b2.getChangeSets().size());
        Assert.assertFalse((boolean)((ChangeLogSet)b2.getChangeSets().get(0)).isEmptySet());
        Assert.assertEquals((long)1L, (long)p.getSCMs().size());
    }

    @Test
    public void commitToWorkspace() throws Exception {
        this.sampleRepo.init();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("def rungit(cmd) {def gitcmd = \"git ${cmd}\"; if (isUnix()) {sh gitcmd} else {bat gitcmd}}\nnode {\n  git url: $/" + (Object)((Object)this.sampleRepo) + "/$\n  writeFile file: 'file', text: 'edited by build'\n  rungit 'commit --all --message=edits'\n  rungit 'show master'\n}"));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("+edited by build", (Run)b);
    }
}

