/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import jenkins.scm.impl.mock.AbstractSampleDVCSRepoRule;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.jvnet.hudson.test.JenkinsRule;

public final class GitSampleRepoRule
extends AbstractSampleDVCSRepoRule {
    public void git(String ... cmds) throws Exception {
        this.run("git", cmds);
    }

    public void init() throws Exception {
        GitSampleRepoRule.run((boolean)true, (File)this.tmp.getRoot(), (String[])new String[]{"git", "version"});
        this.git("init");
        this.write("file", "");
        this.git("add", "file");
        this.git("config", "user.name", "Git SampleRepoRule");
        this.git("config", "user.email", "gits@mplereporule");
        this.git("commit", "--message=init");
    }

    public final boolean mkdirs(String rel) throws IOException {
        return new File(this.sampleRepo, rel).mkdirs();
    }

    public void notifyCommit(JenkinsRule r) throws Exception {
        this.synchronousPolling(r);
        WebResponse webResponse = r.createWebClient().goTo("git/notifyCommit?url=" + this.bareUrl(), "text/plain").getWebResponse();
        System.out.println(webResponse.getContentAsString());
        for (NameValuePair pair : webResponse.getResponseHeaders()) {
            if (!pair.getName().equals("Triggered")) continue;
            System.out.println("Triggered: " + pair.getValue());
        }
        r.waitUntilNoActivity();
    }

    public String head() throws Exception {
        return ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(this.sampleRepo)).build().resolve("HEAD").name();
    }

    public File getRoot() {
        return this.sampleRepo;
    }

    public boolean gitVersionAtLeast(int neededMajor, int neededMinor) {
        return this.gitVersionAtLeast(neededMajor, neededMinor, 0);
    }

    public boolean gitVersionAtLeast(int neededMajor, int neededMinor, int neededPatch) {
        StreamTaskListener procListener = StreamTaskListener.fromStderr();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int returnCode = -1;
        try {
            returnCode = new Launcher.LocalLauncher((TaskListener)procListener).launch().cmds(new String[]{"git", "--version"}).stdout((OutputStream)out).join();
        }
        catch (IOException | InterruptedException ex) {
            System.out.println("Error checking git version " + ex);
        }
        String versionOutput = out.toString().trim();
        String[] fields = versionOutput.split(" ")[2].replaceAll("msysgit.", "").replaceAll("windows.", "").split("\\.");
        int gitMajor = Integer.parseInt(fields[0]);
        int gitMinor = Integer.parseInt(fields[1]);
        int gitPatch = Integer.parseInt(fields[2]);
        if (gitMajor < 1 || gitMajor > 3) {
            System.out.println("WARNING: Unexpected git major version " + gitMajor + " parsed from '" + versionOutput + "', field:'" + fields[0] + "'");
        }
        if (gitMinor < 0 || gitMinor > 20) {
            System.out.println("WARNING: Unexpected git minor version " + gitMinor + " parsed from '" + versionOutput + "', field:'" + fields[1] + "'");
        }
        if (gitPatch < 0 || gitPatch > 20) {
            System.out.println("WARNING: Unexpected git patch version " + gitPatch + " parsed from '" + versionOutput + "', field:'" + fields[2] + "'");
        }
        return gitMajor > neededMajor || gitMajor == neededMajor && gitMinor > neededMinor || gitMajor == neededMajor && gitMinor == neededMinor && gitPatch >= neededPatch;
    }
}

