/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.util.ArgumentListBuilder;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;

public class CliGitCommand {
    private final TaskListener listener;
    private final transient Launcher launcher;
    private final EnvVars env;
    private final File dir;
    private String[] output;
    private ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"git"});

    public CliGitCommand(GitClient client, String ... arguments) {
        this.args.add(arguments);
        this.listener = StreamTaskListener.NULL;
        this.launcher = new Launcher.LocalLauncher(this.listener);
        this.env = new EnvVars();
        this.dir = client != null ? client.getRepository().getWorkTree() : new File(".");
    }

    public String[] run(String ... arguments) throws IOException, InterruptedException {
        this.args = new ArgumentListBuilder(new String[]{"git"});
        this.args.add(arguments);
        return this.run(true);
    }

    public String[] run() throws IOException, InterruptedException {
        return this.run(true);
    }

    private String[] run(boolean assertProcessStatus) throws IOException, InterruptedException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ByteArrayOutputStream bytesErr = new ByteArrayOutputStream();
        Launcher.ProcStarter p = this.launcher.launch().cmds(this.args).envs((Map)this.env).stdout((OutputStream)bytesOut).stderr((OutputStream)bytesErr).pwd(this.dir);
        int status = p.start().joinWithTimeout(1L, TimeUnit.MINUTES, this.listener);
        String result = bytesOut.toString("UTF-8");
        if (bytesErr.size() > 0) {
            result = result + "\nstderr not empty:\n" + bytesErr.toString("UTF-8");
        }
        this.output = result.split("[\\n\\r]");
        if (assertProcessStatus) {
            Assert.assertEquals((String)(this.args.toString() + " command failed and reported '" + Arrays.toString(this.output) + "'"), (long)0L, (long)status);
        }
        return this.output;
    }

    public void assertOutputContains(String ... expectedRegExes) {
        ArrayList<String> notFound = new ArrayList<String>();
        boolean modified = notFound.addAll(Arrays.asList(expectedRegExes));
        Assert.assertTrue((String)"Missing regular expressions in assertion", (boolean)modified);
        for (String line : this.output) {
            Iterator iterator = notFound.iterator();
            while (iterator.hasNext()) {
                String regex = (String)iterator.next();
                if (!line.matches(regex)) continue;
                iterator.remove();
            }
        }
        if (!notFound.isEmpty()) {
            Assert.fail((String)(Arrays.toString(this.output) + " did not match all strings in notFound: " + Arrays.toString(expectedRegExes)));
        }
    }

    private String[] runWithoutAssert(String ... arguments) throws IOException, InterruptedException {
        this.args = new ArgumentListBuilder(new String[]{"git"});
        this.args.add(arguments);
        return this.run(false);
    }

    private void setConfigIfEmpty(String configName, String value) throws Exception {
        String[] cmdOutput = this.runWithoutAssert("config", "--global", configName);
        if (cmdOutput == null || cmdOutput[0].isEmpty() || cmdOutput[0].equals("[]")) {
            cmdOutput = this.run("config", "--global", configName, value);
            Assert.assertThat(Arrays.asList(cmdOutput), (Matcher)Matchers.hasItems((Object[])new String[]{""}));
            cmdOutput = this.run("config", "--global", configName);
            if (cmdOutput == null || cmdOutput[0].isEmpty() || !cmdOutput[0].equals(value)) {
                throw new GitException("ERROR: git config --global " + configName + " reported '" + cmdOutput[0] + "' instead of '" + value + "'");
            }
        }
    }

    public void setDefaults() throws Exception {
        this.setConfigIfEmpty("user.name", "Name From Git-Plugin-Test");
        this.setConfigIfEmpty("user.email", "email.from.git.plugin.test@example.com");
    }
}

