/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetUtil;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GitRepositoryBrowserTest {
    private GitRepositoryBrowser browser;
    private GitChangeSet changeSet;
    private Collection<GitChangeSet.Path> paths;
    private final String baseURL = "https://github.com/jenkinsci/git-plugin/";
    private final boolean useAuthorName;
    private final String gitImplementation;
    private final ObjectId sha1;

    public GitRepositoryBrowserTest(String useAuthorName, String gitImplementation, ObjectId sha1) {
        this.useAuthorName = Boolean.valueOf(useAuthorName);
        this.gitImplementation = gitImplementation;
        this.sha1 = sha1;
    }

    @Parameterized.Parameters(name="{0},{1},{2}")
    public static Collection permuteAuthorNameAndGitImplementationAndObjectId() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        String[] allowed = new String[]{"true", "false"};
        String[] implementations = new String[]{"git", "jgit"};
        ObjectId[] sha1Array = new ObjectId[]{ObjectId.fromString((String)"016407404eeda093385ba2ebe9557068b519b669"), ObjectId.fromString((String)"4289aacbb493cfcb78c8276c52e945802942ffd5"), ObjectId.fromString((String)"daf453dfc43db81ede5cde60d0469fda0b3321ab"), ObjectId.fromString((String)"c685e980a502fa10e3a5fa08e02ab4194950c1df"), ObjectId.fromString((String)"8e4ef541b8f319fd2019932a6cddfc480fc7ca28"), ObjectId.fromString((String)"75ef0cde74e01f16b6da075d67cf88b3503067f5")};
        for (String authorName : allowed) {
            for (String gitImplementation : implementations) {
                for (ObjectId sha1 : sha1Array) {
                    Object[] combination = new Object[]{authorName, gitImplementation, sha1};
                    values.add(combination);
                }
            }
        }
        return values;
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.browser = new GitRepositoryBrowserImpl();
        this.changeSet = GitChangeSetUtil.genChangeSet(this.sha1, this.gitImplementation, this.useAuthorName);
        this.paths = this.changeSet.getPaths();
    }

    @Test
    public void testGetRepoUrl() {
        Assert.assertThat((Object)this.browser.getRepoUrl(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetDiffLink() throws Exception {
        for (GitChangeSet.Path path : this.paths) {
            Assert.assertThat((Object)this.browser.getDiffLink(path), (Matcher)CoreMatchers.is((Object)this.getURL(path, true)));
        }
    }

    @Test
    public void testGetFileLink() throws Exception {
        for (GitChangeSet.Path path : this.paths) {
            Assert.assertThat((Object)this.browser.getFileLink(path), (Matcher)CoreMatchers.is((Object)this.getURL(path, false)));
        }
    }

    @Test
    public void testGetNormalizeUrl() {
        Assert.assertThat((Object)this.browser.getNormalizeUrl(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGetIndexOfPath() throws Exception {
        HashSet<Integer> foundLocations = new HashSet<Integer>(this.paths.size());
        for (GitChangeSet.Path path : this.paths) {
            int location = this.browser.getIndexOfPath(path);
            Assert.assertThat((Object)location, (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(this.paths.size()))));
            Assert.assertThat((Object)location, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(-1))));
            Assert.assertThat(foundLocations, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)location)));
            foundLocations.add(location);
        }
        Assert.assertThat((Object)foundLocations.size(), (Matcher)CoreMatchers.is((Object)this.paths.size()));
    }

    private URL getURL(GitChangeSet.Path path, boolean isDiffLink) throws MalformedURLException {
        return new URL("https://github.com/jenkinsci/git-plugin/" + path.getPath() + (isDiffLink ? "-diff-link" : "-file-link"));
    }

    public class GitRepositoryBrowserImpl
    extends GitRepositoryBrowser {
        public URL getDiffLink(GitChangeSet.Path path) throws IOException {
            return GitRepositoryBrowserTest.this.getURL(path, true);
        }

        public URL getFileLink(GitChangeSet.Path path) throws IOException {
            return GitRepositoryBrowserTest.this.getURL(path, false);
        }

        public URL getChangeSetLink(GitChangeSet e) throws IOException {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

