/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.TaskListener;
import hudson.plugins.git.AbstractGitProject;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.EnforceGitClient;
import hudson.scm.PollingResult;
import hudson.triggers.SCMTrigger;
import hudson.util.IOUtils;
import hudson.util.RunList;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class SCMTriggerTest
extends AbstractGitProject {
    private ZipFile namespaceRepoZip;
    private Properties namespaceRepoCommits;
    private ExecutorService singleThreadExecutor;
    protected boolean expectChanges = false;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.expectChanges = false;
        this.namespaceRepoZip = new ZipFile("src/test/resources/namespaceBranchRepo.zip");
        this.namespaceRepoCommits = this.parseLsRemote(new File("src/test/resources/namespaceBranchRepo.ls-remote"));
        this.singleThreadExecutor = Executors.newSingleThreadExecutor();
    }

    protected abstract EnforceGitClient getGitClient();

    protected abstract boolean isDisableRemotePoll();

    @Test
    public void testNamespaces_with_refsHeadsMaster() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/heads/master", this.namespaceRepoCommits.getProperty("refs/heads/master"), "origin/master");
    }

    public void testNamespaces_with_remotesOriginMaster() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "remotes/origin/master", this.namespaceRepoCommits.getProperty("refs/heads/master"), "origin/master");
    }

    public void testNamespaces_with_refsRemotesOriginMaster() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/remotes/origin/master", this.namespaceRepoCommits.getProperty("refs/heads/master"), "origin/master");
    }

    public void testNamespaces_with_master() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "master", this.namespaceRepoCommits.getProperty("refs/heads/master"), "origin/master");
    }

    public void testNamespaces_with_namespace1Master() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "a_tests/b_namespace1/master", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace1/master"), "origin/a_tests/b_namespace1/master");
    }

    public void testNamespaces_with_refsHeadsNamespace1Master() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/heads/a_tests/b_namespace1/master", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace1/master"), "origin/a_tests/b_namespace1/master");
    }

    public void testNamespaces_with_namespace2Master() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "a_tests/b_namespace2/master", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace2/master"), "origin/a_tests/b_namespace2/master");
    }

    public void testNamespaces_with_refsHeadsNamespace2Master() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/heads/a_tests/b_namespace2/master", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace2/master"), "origin/a_tests/b_namespace2/master");
    }

    public void testNamespaces_with_namespace3_feature3_sha1() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), "detached");
    }

    public void testNamespaces_with_namespace3_feature3_branchName() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "a_tests/b_namespace3/feature3", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), "origin/a_tests/b_namespace3/feature3");
    }

    public void testNamespaces_with_refsHeadsNamespace3_feature3_sha1() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), "detached");
    }

    public void testNamespaces_with_refsHeadsNamespace3_feature3_branchName() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/heads/a_tests/b_namespace3/feature3", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), "origin/a_tests/b_namespace3/feature3");
    }

    public void testTags_with_TagA() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "TagA", this.namespaceRepoCommits.getProperty("refs/tags/TagA"), "TagA");
    }

    public void testTags_with_TagBAnnotated() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "TagBAnnotated", this.namespaceRepoCommits.getProperty("refs/tags/TagBAnnotated^{}"), "TagBAnnotated");
    }

    public void testTags_with_refsTagsTagA() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/tags/TagA", this.namespaceRepoCommits.getProperty("refs/tags/TagA"), "refs/tags/TagA");
    }

    public void testTags_with_refsTagsTagBAnnotated() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/tags/TagBAnnotated", this.namespaceRepoCommits.getProperty("refs/tags/TagBAnnotated^{}"), "refs/tags/TagBAnnotated");
    }

    public void testCommitAsBranchSpec_feature4_sha1() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, this.namespaceRepoCommits.getProperty("refs/heads/b_namespace3/feature4"), this.namespaceRepoCommits.getProperty("refs/heads/b_namespace3/feature4"), "detached");
    }

    public void testCommitAsBranchSpec_feature4_branchName() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/heads/b_namespace3/feature4", this.namespaceRepoCommits.getProperty("refs/heads/b_namespace3/feature4"), "origin/b_namespace3/feature4");
    }

    public void testCommitAsBranchSpec() throws Exception {
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, this.namespaceRepoCommits.getProperty("refs/heads/b_namespace3/master"), this.namespaceRepoCommits.getProperty("refs/heads/b_namespace3/master"), "detached");
    }

    public void testMultipleRefspecs() throws Exception {
        String remote = this.prepareRepo(this.namespaceRepoZip);
        UserRemoteConfig remoteConfig = new UserRemoteConfig(remote, "origin", "+refs/pull/*:refs/remotes/origin/pr/* +refs/heads/*:refs/remotes/origin/*", null);
        String branchSpec = "refs/heads/master";
        FreeStyleProject project = this.setupProject(Arrays.asList(remoteConfig), Arrays.asList(new BranchSpec(branchSpec)), "", this.isDisableRemotePoll(), this.getGitClient());
        this.triggerSCMTrigger((SCMTrigger)project.getTrigger(SCMTrigger.class));
        FreeStyleBuild build1 = this.waitForBuildFinished(project, 1, 60000L);
        Assert.assertNotNull((String)"Job has not been triggered", (Object)build1);
        GitSCM scm = (GitSCM)project.getScm();
        scm.getBranches().set(0, new BranchSpec("b_namespace3/master"));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        PollingResult poll = project.poll((TaskListener)listener);
        Assert.assertEquals((String)"Expected and actual polling results disagree", (Object)true, (Object)poll.hasChanges());
    }

    public void check(ZipFile repoZip, Properties commits, String branchSpec, String expected_GIT_COMMIT, String expected_GIT_BRANCH) throws Exception {
        String remote = this.prepareRepo(repoZip);
        FreeStyleProject project = this.setupProject(Arrays.asList(new UserRemoteConfig(remote, null, null, null)), Arrays.asList(new BranchSpec(branchSpec)), "", this.isDisableRemotePoll(), this.getGitClient());
        this.triggerSCMTrigger((SCMTrigger)project.getTrigger(SCMTrigger.class));
        FreeStyleBuild build1 = this.waitForBuildFinished(project, 1, 60000L);
        Assert.assertNotNull((String)"Job has not been triggered", (Object)build1);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        PollingResult poll = project.poll((TaskListener)listener);
        Assert.assertEquals((String)"Expected and actual polling results disagree", (Object)false, (Object)poll.hasChanges());
        this.triggerSCMTrigger((SCMTrigger)project.getTrigger(SCMTrigger.class)).get(20L, TimeUnit.SECONDS);
        FreeStyleBuild build2 = this.waitForBuildFinished(project, 2, 2000L);
        Assert.assertNull((String)"Found build 2 although no new changes and no multi candidate build", (Object)build2);
        Assert.assertEquals((String)"Unexpected GIT_COMMIT", (Object)expected_GIT_COMMIT, (Object)build1.getEnvironment(null).get((Object)"GIT_COMMIT"));
        Assert.assertEquals((String)"Unexpected GIT_BRANCH", (Object)expected_GIT_BRANCH, (Object)build1.getEnvironment(null).get((Object)"GIT_BRANCH"));
    }

    private String prepareRepo(ZipFile repoZip) throws IOException {
        File tempRemoteDir = this.tempFolder.newFolder();
        this.extract(repoZip, tempRemoteDir);
        return tempRemoteDir.getAbsolutePath();
    }

    private Future<Void> triggerSCMTrigger(final SCMTrigger trigger) {
        if (trigger == null) {
            return null;
        }
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                trigger.run();
                return null;
            }
        };
        return this.singleThreadExecutor.submit(callable);
    }

    private FreeStyleBuild waitForBuildFinished(FreeStyleProject project, int expectedBuildNumber, long timeout) throws Exception {
        long endTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < endTime) {
            RunList builds = project.getBuilds();
            for (FreeStyleBuild build : builds) {
                if (build.getNumber() != expectedBuildNumber) continue;
                if (build.getResult() == null) break;
                return build;
            }
            Thread.sleep(10L);
        }
        return null;
    }

    private Properties parseLsRemote(File file) throws IOException {
        Properties properties = new Properties();
        Pattern pattern = Pattern.compile("([a-f0-9]{40})\\s*(.*)");
        for (Object lineO : FileUtils.readLines((File)file)) {
            String line = ((String)lineO).trim();
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                properties.setProperty(matcher.group(2), matcher.group(1));
                continue;
            }
            System.err.println("ls-remote pattern does not match '" + line + "'");
        }
        return properties;
    }

    private void extract(ZipFile zipFile, File outputDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File entryDestination = new File(outputDir, entry.getName());
            entryDestination.getParentFile().mkdirs();
            if (entry.isDirectory()) {
                entryDestination.mkdirs();
                continue;
            }
            InputStream in = zipFile.getInputStream(entry);
            FileOutputStream out = new FileOutputStream(entryDestination);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

