/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.Cause;
import hudson.model.Describable;
import hudson.model.EnvironmentContributingAction;
import hudson.model.EnvironmentContributor;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.git.AbstractGitTestCase;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitRevisionBuildParameters;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Revision;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.impl.AuthorInChangelog;
import hudson.plugins.git.extensions.impl.CleanBeforeCheckout;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.plugins.git.extensions.impl.DisableRemotePoll;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.plugins.git.extensions.impl.PreBuildMerge;
import hudson.plugins.git.extensions.impl.RelativeTargetDirectory;
import hudson.plugins.git.extensions.impl.ScmName;
import hudson.plugins.git.extensions.impl.SparseCheckoutPath;
import hudson.plugins.git.extensions.impl.SparseCheckoutPaths;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.plugins.git.util.GitUtils;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.slaves.DumbSlave;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.tools.ToolInstallation;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import jenkins.plugins.git.CliGitCommand;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.JGitTool;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.TestExtension;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GitSCMTest
extends AbstractGitTestCase {
    @Rule
    public GitSampleRepoRule secondRepo = new GitSampleRepoRule();

    @BeforeClass
    public static void setGitDefaults() throws Exception {
        CliGitCommand gitCmd = new CliGitCommand(null, new String[0]);
        gitCmd.setDefaults();
    }

    @Test
    public void testBasic() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        Assert.assertEquals((String)"", (Object)this.janeDoe.getName(), (Object)((User)culprits.iterator().next()).getFullName());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicRemotePoll() throws Exception {
        FreeStyleProject project = this.setupProject("master", false, null, null, null, true, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        Assert.assertEquals((String)"", (Object)this.janeDoe.getName(), (Object)((User)culprits.iterator().next()).getFullName());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testBranchSpecWithRemotesMaster() throws Exception {
        FreeStyleProject projectMasterBranch = this.setupProject("remotes/origin/master", false, null, null, null, true, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(projectMasterBranch, Result.SUCCESS, "commitFile1");
    }

    @Test
    public void testSpecificRefspecs() throws Exception {
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", "+refs/heads/foo:refs/remotes/foo", null));
        FreeStyleProject projectWithMaster = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        CloneOption cloneOptionMaster = new CloneOption(false, null, null);
        cloneOptionMaster.setHonorRefspec(true);
        ((GitSCM)projectWithMaster.getScm()).getExtensions().add((Object)cloneOptionMaster);
        FreeStyleProject projectWithFoo = this.setupProject(repos, Collections.singletonList(new BranchSpec("foo")), null, false, null);
        CloneOption cloneOptionFoo = new CloneOption(false, null, null);
        cloneOptionFoo.setHonorRefspec(true);
        ((GitSCM)projectWithMaster.getScm()).getExtensions().add((Object)cloneOptionFoo);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit in master");
        this.git.branch("foo");
        this.git.checkout().branch("foo");
        this.commit("commitFile1", this.johnDoe, "Commit in foo");
        this.build(projectWithMaster, Result.FAILURE, new String[0]);
        this.build(projectWithFoo, Result.SUCCESS, "commitFile1");
    }

    @Test
    public void testSpecificRefspecsWithoutCloneOption() throws Exception {
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", "+refs/heads/foo:refs/remotes/foo", null));
        FreeStyleProject projectWithMaster = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        FreeStyleProject projectWithFoo = this.setupProject(repos, Collections.singletonList(new BranchSpec("foo")), null, false, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit in master");
        this.git.branch("foo");
        this.git.checkout().branch("foo");
        this.commit("commitFile1", this.johnDoe, "Commit in foo");
        this.build(projectWithMaster, Result.SUCCESS, new String[0]);
        this.build(projectWithFoo, Result.SUCCESS, "commitFile1");
    }

    @Test
    public void testBranchSpecWithRemotesHierarchical() throws Exception {
        FreeStyleProject projectMasterBranch = this.setupProject("master", false, null, null, null, true, null);
        FreeStyleProject projectHierarchicalBranch = this.setupProject("remotes/origin/rel-1/xy", false, null, null, null, true, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.git.branch("rel-1/xy");
        this.git.checkout("rel-1/xy");
        this.git.deleteBranch("master");
        this.build(projectMasterBranch, Result.FAILURE, new String[0]);
        this.build(projectHierarchicalBranch, Result.SUCCESS, "commitFile1");
    }

    @Test
    public void testBranchSpecUsingTagWithSlash() throws Exception {
        FreeStyleProject projectMasterBranch = this.setupProject("path/tag", false, null, null, null, true, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1 will be tagged with path/tag");
        this.testRepo.git.tag("path/tag", "tag with a slash in the tag name");
        this.build(projectMasterBranch, Result.SUCCESS, "commitFile1");
    }

    @Test
    public void testBasicIncludedRegion() throws Exception {
        FreeStyleProject project = this.setupProject("master", false, null, null, null, ".*3");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling detected commit2 change, which should not have been included", (boolean)project.poll(this.listener).hasChanges());
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertTrue((String)"scm polling did not detect commit3 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2", "commitFile3");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have two culprit", (long)2L, (long)culprits.size());
        PersonIdent[] expected = new PersonIdent[]{this.johnDoe, this.janeDoe};
        GitSCMTest.assertCulprits("jane doe and john doe should be the culprits", culprits, expected);
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile3").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testIncludedRegionWithDeeperCommits() throws Exception {
        FreeStyleProject project = this.setupProject("master", false, null, null, null, ".*3");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling detected commit2 change, which should not have been included", (boolean)project.poll(this.listener).hasChanges());
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        String commitFile4 = "commitFile4";
        this.commit("commitFile4", this.janeDoe, "Commit number 4");
        Assert.assertTrue((String)"scm polling did not detect commit3 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2", "commitFile3");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have two culprit", (long)2L, (long)culprits.size());
        PersonIdent[] expected = new PersonIdent[]{this.johnDoe, this.janeDoe};
        GitSCMTest.assertCulprits("jane doe and john doe should be the culprits", culprits, expected);
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile3").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicExcludedRegion() throws Exception {
        FreeStyleProject project = this.setupProject("master", false, null, ".*2", null, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling detected commit2 change, which should have been excluded", (boolean)project.poll(this.listener).hasChanges());
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertTrue((String)"scm polling did not detect commit3 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2", "commitFile3");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have two culprit", (long)2L, (long)culprits.size());
        PersonIdent[] expected = new PersonIdent[]{this.johnDoe, this.janeDoe};
        GitSCMTest.assertCulprits("jane doe and john doe should be the culprits", culprits, expected);
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile3").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testCleanBeforeCheckout() throws Exception {
        FreeStyleProject p = this.setupProject("master", false, null, null, "Jane Doe", null);
        ((GitSCM)p.getScm()).getExtensions().add((Object)new CleanBeforeCheckout());
        String commitFile1 = "commitFile1";
        String commitFile2 = "commitFile2";
        this.commit("commitFile1", this.johnDoe, this.janeDoe, "Commit number 1");
        this.commit("commitFile2", this.johnDoe, this.janeDoe, "Commit number 2");
        FreeStyleBuild firstBuild = this.build(p, Result.SUCCESS, "commitFile1");
        String branch1 = "Branch1";
        String branch2 = "Branch2";
        ArrayList<BranchSpec> branches = new ArrayList<BranchSpec>();
        branches.add(new BranchSpec("master"));
        branches.add(new BranchSpec("Branch1"));
        branches.add(new BranchSpec("Branch2"));
        this.git.branch("Branch1");
        this.git.checkout("Branch1");
        p.poll(this.listener).hasChanges();
        Assert.assertTrue((boolean)firstBuild.getLog().contains("Cleaning"));
        Assert.assertTrue((firstBuild.getLog().indexOf("Cleaning") > firstBuild.getLog().indexOf("Cloning") ? 1 : 0) != 0);
        Assert.assertTrue((firstBuild.getLog().indexOf("Cleaning") < firstBuild.getLog().indexOf("Checking out") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)firstBuild.getWorkspace().child("commitFile1").exists());
        this.git.checkout("Branch1");
        FreeStyleBuild secondBuild = this.build(p, Result.SUCCESS, "commitFile2");
        p.poll(this.listener).hasChanges();
        Assert.assertTrue((boolean)secondBuild.getLog().contains("Cleaning"));
        Assert.assertTrue((secondBuild.getLog().indexOf("Cleaning") < secondBuild.getLog().indexOf("Fetching upstream changes") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)secondBuild.getWorkspace().child("commitFile2").exists());
    }

    @Test
    public void testExcludedRegionMultiCommit() throws Exception {
        FreeStyleProject clientProject = this.setupProject("master", false, null, ".*serverFile", null, null);
        FreeStyleProject serverProject = this.setupProject("master", false, null, ".*clientFile", null, null);
        String initialCommitFile = "initialFile";
        this.commit(initialCommitFile, this.johnDoe, "initial commit");
        this.build(clientProject, Result.SUCCESS, initialCommitFile);
        this.build(serverProject, Result.SUCCESS, initialCommitFile);
        Assert.assertFalse((String)"scm polling should not detect any more changes after initial build", (boolean)clientProject.poll(this.listener).hasChanges());
        Assert.assertFalse((String)"scm polling should not detect any more changes after initial build", (boolean)serverProject.poll(this.listener).hasChanges());
        this.commit("myserverFile", this.johnDoe, "commit first server file");
        Assert.assertFalse((String)"scm polling should not detect any changes in client project", (boolean)clientProject.poll(this.listener).hasChanges());
        Assert.assertTrue((String)"scm polling did not detect changes in server project", (boolean)serverProject.poll(this.listener).hasChanges());
        this.commit("myNewserverFile", this.johnDoe, "commit new server file");
        this.commit("myclientFile", this.johnDoe, "commit first clientfile");
        Assert.assertTrue((String)"scm polling did not detect changes in client project", (boolean)clientProject.poll(this.listener).hasChanges());
        Assert.assertTrue((String)"scm polling did not detect changes in server project", (boolean)serverProject.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicExcludedUser() throws Exception {
        FreeStyleProject project = this.setupProject("master", false, null, null, "Jane Doe", null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling detected commit2 change, which should have been excluded", (boolean)project.poll(this.listener).hasChanges());
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertTrue((String)"scm polling did not detect commit3 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2", "commitFile3");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have two culprit", (long)2L, (long)culprits.size());
        PersonIdent[] expected = new PersonIdent[]{this.johnDoe, this.janeDoe};
        GitSCMTest.assertCulprits("jane doe and john doe should be the culprits", culprits, expected);
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile3").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicInSubdir() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        ((GitSCM)project.getScm()).getExtensions().add((Object)new RelativeTargetDirectory("subdir"));
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, "subdir", Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, "subdir", Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        Assert.assertEquals((String)"", (Object)this.janeDoe.getName(), (Object)((User)culprits.iterator().next()).getFullName());
        Assert.assertEquals((String)"The workspace should have a 'subdir' subdirectory, but does not.", (Object)true, (Object)build2.getWorkspace().child("subdir").exists());
        Assert.assertEquals((String)"The 'subdir' subdirectory should contain commitFile2, but does not.", (Object)true, (Object)build2.getWorkspace().child("subdir").child("commitFile2").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicWithSlave() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        project.setAssignedLabel((Label)this.rule.createSlave().getSelfLabel());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        Assert.assertEquals((String)"", (Object)this.janeDoe.getName(), (Object)((User)culprits.iterator().next()).getFullName());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicWithSlaveNoExecutorsOnMaster() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        this.rule.jenkins.setNumExecutors(0);
        project.setAssignedLabel((Label)this.rule.createSlave().getSelfLabel());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        Assert.assertEquals((String)"", (Object)this.janeDoe.getName(), (Object)((User)culprits.iterator().next()).getFullName());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testAuthorOrCommitterFalse() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, this.janeDoe, "Commit number 1");
        FreeStyleBuild firstBuild = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild secondBuild = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        Set secondCulprits = secondBuild.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)secondCulprits.size());
        Assert.assertEquals((String)"Did not get the committer as the change author with authorOrCommiter==false", (Object)this.janeDoe.getName(), (Object)((User)secondCulprits.iterator().next()).getFullName());
    }

    @Test
    public void testAuthorOrCommitterTrue() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        ((GitSCM)project.getScm()).getExtensions().add((Object)new AuthorInChangelog());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, this.janeDoe, "Commit number 1");
        FreeStyleBuild firstBuild = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild secondBuild = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        Set secondCulprits = secondBuild.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)secondCulprits.size());
        Assert.assertEquals((String)"Did not get the author as the change author with authorOrCommiter==true", (Object)this.johnDoe.getName(), (Object)((User)secondCulprits.iterator().next()).getFullName());
    }

    @Test
    public void testNewCommitToUntrackedBranchDoesNotTriggerBuild() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        this.git.checkout("HEAD", "untracked");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling should not detect commit2 change because it is not in the branch we are tracking.", (boolean)project.poll(this.listener).hasChanges());
    }

    private String checkoutString(FreeStyleProject project, String envVar) {
        return "checkout -f " + (String)this.getEnvVars(project).get((Object)envVar);
    }

    @Test
    public void testEnvVarsAvailable() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertEquals((Object)"origin/master", (Object)this.getEnvVars(project).get((Object)"GIT_BRANCH"));
        this.rule.assertLogContains((String)this.getEnvVars(project).get((Object)"GIT_BRANCH"), (Run)build1);
        this.rule.assertLogContains(this.checkoutString(project, "GIT_COMMIT"), (Run)build1);
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        this.rule.assertLogNotContains(this.checkoutString(project, "GIT_PREVIOUS_COMMIT"), (Run)build2);
        this.rule.assertLogContains(this.checkoutString(project, "GIT_PREVIOUS_COMMIT"), (Run)build1);
        this.rule.assertLogNotContains(this.checkoutString(project, "GIT_PREVIOUS_SUCCESSFUL_COMMIT"), (Run)build2);
        this.rule.assertLogContains(this.checkoutString(project, "GIT_PREVIOUS_SUCCESSFUL_COMMIT"), (Run)build1);
    }

    @Test
    public void testNodeEnvVarsAvailable() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        DumbSlave s = this.rule.createSlave();
        this.setVariables((Node)s, new EnvironmentVariablesNodeProperty.Entry("TESTKEY", "slaveValue"));
        project.setAssignedLabel((Label)s.getSelfLabel());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertEquals((Object)"slaveValue", (Object)this.getEnvVars(project).get((Object)"TESTKEY"));
    }

    @Test
    public void testGitSCMCanBuildAgainstTags() throws Exception {
        String mytag = "mytag";
        FreeStyleProject project = this.setupSimpleProject("mytag");
        this.build(project, Result.FAILURE, new String[0]);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.FAILURE, new String[0]);
        String tmpBranch = "tmp";
        this.git.branch("tmp");
        this.git.checkout("tmp");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling should not detect any more changes since mytag is untouched right now", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.FAILURE, new String[0]);
        this.git.tag("mytag", "mytag initial");
        this.git.checkout("master");
        this.git.deleteBranch("tmp");
        Assert.assertTrue((String)"scm polling should detect commit2 change in 'mytag'", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertFalse((String)"scm polling should not detect any more changes after last build", (boolean)project.poll(this.listener).hasChanges());
        this.git.checkout("mytag");
        this.git.branch("tmp");
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertFalse((String)"scm polling should not detect any more changes since mytag is untouched right now", (boolean)project.poll(this.listener).hasChanges());
        this.git.tag("mytag", "mytag moved");
        this.git.checkout("master");
        this.git.deleteBranch("tmp");
        Assert.assertTrue((String)"scm polling should detect commit3 change in 'mytag'", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, "commitFile3");
        Assert.assertFalse((String)"scm polling should not detect any more changes after last build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMultipleBranchBuild() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        String fork = "fork";
        this.git.branch("fork");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertTrue((String)"scm polling should detect changes in 'master' branch", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, "commitFile1", "commitFile2");
        Assert.assertFalse((String)"scm polling should not detect any more changes after last build", (boolean)project.poll(this.listener).hasChanges());
        this.git.checkout("fork");
        String forkFile1 = "forkFile1";
        this.commit("forkFile1", this.johnDoe, "Fork commit number 1");
        String forkFile2 = "forkFile2";
        this.commit("forkFile2", this.johnDoe, "Fork commit number 2");
        Assert.assertTrue((String)"scm polling should detect changes in 'fork' branch", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, "forkFile1", "forkFile2");
        Assert.assertFalse((String)"scm polling should not detect any more changes after last build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMultipleBranchesWithTags() throws Exception {
        List<BranchSpec> branchSpecs = Arrays.asList(new BranchSpec("refs/tags/v*"), new BranchSpec("refs/remotes/origin/non-existent"));
        FreeStyleProject project = this.setupProject(branchSpecs, false, null, null, this.janeDoe.getName(), null, false, null);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        FreeStyleBuild freeStyleBuild = this.build(project, Result.FAILURE, new String[0]);
        String v1 = "v1";
        this.git.tag("v1", "version 1");
        Assert.assertTrue((String)"v1 tag exists", (boolean)this.git.tagExists("v1"));
        freeStyleBuild = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((String)"change set is empty", (boolean)freeStyleBuild.getChangeSet().isEmptySet());
        this.commit("file1", this.johnDoe, "change to file1");
        this.git.tag("none", "latest");
        freeStyleBuild = this.build(project, Result.SUCCESS, new String[0]);
        ObjectId tag = this.git.revParse("refs/tags/v1");
        GitSCM scm = (GitSCM)project.getScm();
        BuildData buildData = scm.getBuildData((Run)freeStyleBuild);
        Assert.assertEquals((String)"last build matches the v1 tag revision", (Object)tag, (Object)buildData.lastBuild.getSHA1());
    }

    @Test
    public void testBlankRepositoryName() throws Exception {
        new GitSCM(null);
    }

    @Test
    public void testSubmoduleFixup() throws Exception {
        File repo = this.secondRepo.getRoot();
        FilePath moduleWs = new FilePath(repo);
        GitClient moduleRepo = Git.with((TaskListener)this.listener, (EnvVars)new EnvVars()).in(repo).getClient();
        moduleRepo.init();
        moduleWs.child("a").touch(0L);
        moduleRepo.add("a");
        moduleRepo.commit("creating a module");
        this.git.addSubmodule(repo.getAbsolutePath(), "module1");
        this.git.commit("creating a super project");
        FreeStyleProject u = this.createFreeStyleProject();
        FreeStyleProject d = this.createFreeStyleProject();
        u.setScm((SCM)new GitSCM(this.workDir.getPath()));
        u.getPublishersList().add((Object)new BuildTrigger(new BuildTriggerConfig[]{new BuildTriggerConfig(d.getName(), ResultCondition.SUCCESS, new AbstractBuildParameters[]{new GitRevisionBuildParameters()})}));
        d.setScm((SCM)new GitSCM(this.workDir.getPath()));
        this.rule.jenkins.rebuildDependencyGraph();
        FreeStyleBuild ub = (FreeStyleBuild)this.rule.assertBuildStatusSuccess((Future)u.scheduleBuild2(0));
        System.out.println(ub.getLog());
        for (int i = 0; (d.getLastBuild() == null || ((FreeStyleBuild)d.getLastBuild()).isBuilding()) && i < 100; ++i) {
            Thread.sleep(100L);
        }
        FreeStyleBuild db = (FreeStyleBuild)d.getLastBuild();
        Assert.assertNotNull((String)"downstream build didn't happen", (Object)db);
        this.rule.assertBuildStatusSuccess((Run)db);
    }

    @Test
    public void testBuildChooserContext() throws Exception {
        final FreeStyleProject p = this.createFreeStyleProject();
        final FreeStyleBuild b = (FreeStyleBuild)this.rule.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        GitSCM.BuildChooserContextImpl c = new GitSCM.BuildChooserContextImpl((Job)p, (Run)b, null);
        c.actOnBuild(new BuildChooserContext.ContextCallable<Run<?, ?>, Object>(){

            public Object invoke(Run param, VirtualChannel channel) throws IOException, InterruptedException {
                Assert.assertSame((Object)param, (Object)b);
                return null;
            }
        });
        c.actOnProject(new BuildChooserContext.ContextCallable<Job<?, ?>, Object>(){

            public Object invoke(Job param, VirtualChannel channel) throws IOException, InterruptedException {
                Assert.assertSame((Object)param, (Object)p);
                return null;
            }
        });
        DumbSlave s = this.rule.createOnlineSlave();
        Assert.assertEquals((Object)p.toString(), (Object)s.getChannel().call((Callable)new BuildChooserContextTestCallable((BuildChooserContext)c)));
    }

    public static void assertCulprits(String assertMsg, Set<User> actual, PersonIdent[] expected) {
        Collection fullNames = Collections2.transform(actual, (Function)new Function<User, String>(){

            public String apply(User u) {
                return u.getFullName();
            }
        });
        for (PersonIdent p : expected) {
            Assert.assertTrue((String)assertMsg, (boolean)fullNames.contains(p.getName()));
        }
    }

    @Test
    public void testEmailCommitter() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM.DescriptorImpl descriptor = (GitSCM.DescriptorImpl)project.getScm().getDescriptor();
        descriptor.setCreateAccountBasedOnEmail(true);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        PersonIdent jeffDoe = new PersonIdent("Jeff Doe", "jeff@doe.com");
        this.commit("commitFile2", jeffDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        User culprit = (User)culprits.iterator().next();
        Assert.assertEquals((String)"", (Object)jeffDoe.getEmailAddress(), (Object)culprit.getId());
        Assert.assertEquals((String)"", (Object)jeffDoe.getName(), (Object)culprit.getFullName());
        this.rule.assertBuildStatusSuccess((Run)build);
    }

    public void testFetchFromMultipleRepositories() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        TestGitRepo secondTestRepo = new TestGitRepo("second", this.secondRepo.getRoot(), this.listener);
        ArrayList<UserRemoteConfig> remotes = new ArrayList<UserRemoteConfig>();
        remotes.addAll(this.testRepo.remoteConfigs());
        remotes.addAll(secondTestRepo.remoteConfigs());
        project.setScm((SCM)new GitSCM(remotes, Collections.singletonList(new BranchSpec("master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList()));
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        SCMRevisionState baseline = project.poll((TaskListener)this.listener).baseline;
        PollingResult.Change change = project.poll((TaskListener)this.listener).change;
        SCMRevisionState remote = project.poll((TaskListener)this.listener).remote;
        String assertionMessage = MessageFormat.format("polling incorrectly detected change after build. Baseline: {0}, Change: {1}, Remote: {2}", baseline, change, remote);
        Assert.assertFalse((String)assertionMessage, (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        secondTestRepo.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    private void branchSpecWithMultipleRepositories(String branchName) throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        TestGitRepo secondTestRepo = new TestGitRepo("second", this.secondRepo.getRoot(), this.listener);
        ArrayList<UserRemoteConfig> remotes = new ArrayList<UserRemoteConfig>();
        remotes.addAll(this.testRepo.remoteConfigs());
        remotes.addAll(secondTestRepo.remoteConfigs());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        project.setScm((SCM)new GitSCM(remotes, Collections.singletonList(new BranchSpec(branchName)), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList()));
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1");
        this.rule.assertBuildStatusSuccess((Run)build);
    }

    public void testBranchSpecAsSHA1WithMultipleRepositories() throws Exception {
        this.branchSpecWithMultipleRepositories(this.testRepo.git.revParse("HEAD").getName());
    }

    public void testBranchSpecAsRemotesOriginMasterWithMultipleRepositories() throws Exception {
        this.branchSpecWithMultipleRepositories("remotes/origin/master");
    }

    @Test
    public void testCommitDetectedOnlyOnceInMultipleRepositories() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        TestGitRepo secondTestRepo = new TestGitRepo("secondRepo", this.secondRepo.getRoot(), this.listener);
        ArrayList<UserRemoteConfig> remotes = new ArrayList<UserRemoteConfig>();
        remotes.addAll(this.testRepo.remoteConfigs());
        remotes.addAll(secondTestRepo.remoteConfigs());
        GitSCM gitSCM = new GitSCM(remotes, Collections.singletonList(new BranchSpec("origin/master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)gitSCM);
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1");
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        this.git = Git.with((TaskListener)this.listener, (EnvVars)new EnvVars()).in(build.getWorkspace()).getClient();
        for (RemoteConfig remoteConfig : gitSCM.getRepositories()) {
            this.git.fetch_().from((URIish)remoteConfig.getURIs().get(0), remoteConfig.getFetchRefSpecs());
        }
        Collection candidateRevisions = ((DefaultBuildChooser)gitSCM.getBuildChooser()).getCandidateRevisions(false, "origin/master", this.git, this.listener, (BuildData)((FreeStyleBuild)project.getLastBuild()).getAction(BuildData.class), null);
        Assert.assertEquals((long)1L, (long)candidateRevisions.size());
    }

    @Test
    public void testMerge() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", "default", MergeCommand.GitPluginFastForwardMode.FF)));
        project.setScm((SCM)scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.testRepo.git.deleteBranch("integration");
        this.testRepo.git.checkout("topic1", "integration");
        this.testRepo.git.checkout("master", "topic2");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeChangelog() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", "default", MergeCommand.GitPluginFastForwardMode.FF)));
        project.setScm((SCM)scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout("master", "topic2");
        String commitFile2 = "commitFile2";
        String commitMessage = "Commit number 2";
        this.commit("commitFile2", this.johnDoe, commitMessage);
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        ChangeLogSet changeLog = build2.getChangeSet();
        Assert.assertEquals((String)"Changelog should contain one item", (long)1L, (long)changeLog.getItems().length);
        GitChangeSet singleChange = (GitChangeSet)changeLog.getItems()[0];
        Assert.assertEquals((String)"Changelog should contain commit number 2", (Object)commitMessage, (Object)singleChange.getComment().trim());
    }

    @Test
    public void testMergeWithSlave() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        project.setAssignedLabel((Label)this.rule.createSlave().getSelfLabel());
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", null, null)));
        project.setScm((SCM)scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.testRepo.git.deleteBranch("integration");
        this.testRepo.git.checkout("topic1", "integration");
        this.testRepo.git.checkout("master", "topic2");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeFailed() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", "", MergeCommand.GitPluginFastForwardMode.FF)));
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.testRepo.git.deleteBranch("integration");
        this.testRepo.git.checkout("topic1", "integration");
        this.testRepo.git.checkout("master", "topic2");
        this.commit("commitFile1", "other content", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.FAILURE, new String[0]);
        this.rule.assertBuildStatus(Result.FAILURE, (Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMultipleMergeFailed() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration1", "", MergeCommand.GitPluginFastForwardMode.FF)));
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration2", "", MergeCommand.GitPluginFastForwardMode.FF)));
        this.commit("dummyFile", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration1");
        this.testRepo.git.branch("integration2");
        this.build(project, Result.SUCCESS, new String[0]);
        String commitFile = "commitFile";
        this.testRepo.git.checkoutBranch("integration1", "master");
        this.commit("commitFile", "abc", this.johnDoe, "merge conflict with integration2");
        this.testRepo.git.checkoutBranch("integration2", "master");
        this.commit("commitFile", "cde", this.johnDoe, "merge conflict with integration1");
        FreeStyleBuild build = this.build(project, Result.FAILURE, new String[0]);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeFailedWithSlave() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        project.setAssignedLabel((Label)this.rule.createSlave().getSelfLabel());
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", null, null)));
        project.setScm((SCM)scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.testRepo.git.deleteBranch("integration");
        this.testRepo.git.checkout("topic1", "integration");
        this.testRepo.git.checkout("master", "topic2");
        this.commit("commitFile1", "other content", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.FAILURE, new String[0]);
        this.rule.assertBuildStatus(Result.FAILURE, (Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeWithMatrixBuild() throws Exception {
        MatrixProject project = (MatrixProject)this.rule.jenkins.createProject(MatrixProject.class, "xyz");
        project.setAxes(new AxisList(new Axis[]{new Axis("VAR", new String[]{"a", "b"})}));
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", null, null)));
        project.setScm((SCM)scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        MatrixBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.testRepo.git.deleteBranch("integration");
        this.testRepo.git.checkout("topic1", "integration");
        this.testRepo.git.checkout("master", "topic2");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        MatrixBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.rule.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testEnvironmentVariableExpansion() throws Exception {
        FreeStyleProject project = this.createFreeStyleProject();
        project.setScm((SCM)new GitSCM("${CAT}" + this.testRepo.gitDir.getPath()));
        this.commit("a.txt", this.johnDoe, "Initial Commit");
        this.build(project, Result.SUCCESS, "a.txt");
        PollingResult r = project.poll((TaskListener)StreamTaskListener.fromStdout());
        Assert.assertFalse((boolean)r.hasChanges());
        this.commit("b.txt", this.johnDoe, "Another commit");
        r = project.poll((TaskListener)StreamTaskListener.fromStdout());
        Assert.assertTrue((boolean)r.hasChanges());
        this.build(project, Result.SUCCESS, "b.txt");
    }

    private List<UserRemoteConfig> createRepoList(String url) {
        ArrayList<UserRemoteConfig> repoList = new ArrayList<UserRemoteConfig>();
        repoList.add(new UserRemoteConfig(url, null, null, null));
        return repoList;
    }

    @Test
    public void testConfigRoundtripURLPreserved() throws Exception {
        FreeStyleProject p = this.createFreeStyleProject();
        String url = "https://github.com/jenkinsci/jenkins";
        GithubWeb browser = new GithubWeb("https://github.com/jenkinsci/jenkins");
        GitSCM scm = new GitSCM(this.createRepoList("https://github.com/jenkinsci/jenkins"), Collections.singletonList(new BranchSpec("")), Boolean.valueOf(false), Collections.emptyList(), (GitRepositoryBrowser)browser, null, null);
        p.setScm((SCM)scm);
        this.rule.configRoundtrip((Item)p);
        this.rule.assertEqualDataBoundBeans((Object)scm, (Object)p.getScm());
        Assert.assertEquals((String)"Wrong key", (Object)"git https://github.com/jenkinsci/jenkins", (Object)scm.getKey());
    }

    @Test
    public void testConfigRoundtripExtensionsPreserved() throws Exception {
        FreeStyleProject p = this.createFreeStyleProject();
        String url = "git://github.com/jenkinsci/git-plugin.git";
        GithubWeb browser = new GithubWeb("git://github.com/jenkinsci/git-plugin.git");
        GitSCM scm = new GitSCM(this.createRepoList("git://github.com/jenkinsci/git-plugin.git"), Collections.singletonList(new BranchSpec("*/master")), Boolean.valueOf(false), Collections.emptyList(), (GitRepositoryBrowser)browser, null, null);
        p.setScm((SCM)scm);
        Assert.assertEquals(Collections.emptyList(), (Object)scm.getExtensions().toList());
        LocalBranch localBranchExtension = new LocalBranch("**");
        scm.getExtensions().add((Object)localBranchExtension);
        Assert.assertTrue((boolean)scm.getExtensions().toList().contains(localBranchExtension));
        this.rule.configRoundtrip((Item)p);
        List extensions = scm.getExtensions().toList();
        Assert.assertTrue((boolean)extensions.contains(localBranchExtension));
        Assert.assertEquals((String)"Wrong extension count before reload", (long)1L, (long)extensions.size());
        p.doReload();
        GitSCM reloadedGit = (GitSCM)p.getScm();
        List reloadedExtensions = reloadedGit.getExtensions().toList();
        Assert.assertEquals((String)"Wrong extension count after reload", (long)1L, (long)reloadedExtensions.size());
        LocalBranch reloadedLocalBranch = (LocalBranch)reloadedExtensions.get(0);
        Assert.assertEquals((Object)localBranchExtension.getLocalBranch(), (Object)reloadedLocalBranch.getLocalBranch());
    }

    @Test
    public void testConfigRoundtrip() throws Exception {
        FreeStyleProject p = this.createFreeStyleProject();
        GitSCM scm = new GitSCM("https://github.com/jenkinsci/jenkins");
        p.setScm((SCM)scm);
        this.rule.configRoundtrip((Item)p);
        this.rule.assertEqualDataBoundBeans((Object)scm, (Object)p.getScm());
    }

    @Test
    public void testDataCompatibility1() throws Exception {
        FreeStyleProject p = (FreeStyleProject)this.rule.jenkins.createProjectFromXML("foo", this.getClass().getResourceAsStream("GitSCMTest/old1.xml"));
        GitSCM oldGit = (GitSCM)p.getScm();
        Assert.assertEquals(Collections.emptyList(), (Object)oldGit.getExtensions().toList());
        Assert.assertEquals((long)0L, (long)oldGit.getSubmoduleCfg().size());
        Assert.assertEquals((Object)"git git://github.com/jenkinsci/model-ant-project.git", (Object)oldGit.getKey());
        Assert.assertThat((Object)oldGit.getEffectiveBrowser(), (Matcher)CoreMatchers.instanceOf(GithubWeb.class));
        GithubWeb browser = (GithubWeb)oldGit.getEffectiveBrowser();
        Assert.assertEquals((Object)browser.getRepoUrl(), (Object)"https://github.com/jenkinsci/model-ant-project.git/");
    }

    @Test
    public void testPleaseDontContinueAnyway() throws Exception {
        this.testRepo.commit("a", "foo", this.johnDoe, "added");
        FreeStyleProject p = this.createFreeStyleProject();
        p.setScm((SCM)new GitSCM(this.testRepo.gitDir.getAbsolutePath()));
        this.rule.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        p.setScm((SCM)new GitSCM("http://localhost:4321/no/such/repository.git"));
        this.rule.assertBuildStatus(Result.FAILURE, (Run)p.scheduleBuild2(0).get());
    }

    @Test
    public void testCheckoutToSpecificBranch() throws Exception {
        FreeStyleProject p = this.createFreeStyleProject();
        GitSCM oldGit = new GitSCM("https://github.com/jenkinsci/model-ant-project.git/");
        this.setupJGit(oldGit);
        oldGit.getExtensions().add((Object)new LocalBranch("master"));
        p.setScm((SCM)oldGit);
        FreeStyleBuild b = (FreeStyleBuild)this.rule.assertBuildStatusSuccess((Future)p.scheduleBuild2(0));
        GitClient gc = Git.with((TaskListener)StreamTaskListener.fromStdout(), null).in(b.getWorkspace()).getClient();
        gc.withRepository((RepositoryCallback)new RepositoryCallback<Void>(){

            public Void invoke(Repository repo, VirtualChannel channel) throws IOException, InterruptedException {
                Ref head = repo.getRef("HEAD");
                Assert.assertTrue((String)"Detached HEAD", (boolean)head.isSymbolic());
                Ref t = head.getTarget();
                Assert.assertEquals((Object)t.getName(), (Object)"refs/heads/master");
                return null;
            }
        });
    }

    @Test
    public void testCheckoutToDefaultLocalBranch_StarStar() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        GitSCM git = (GitSCM)project.getScm();
        git.getExtensions().add((Object)new LocalBranch("**"));
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)this.getEnvVars(project).get((Object)"GIT_BRANCH"));
        Assert.assertEquals((String)"GIT_LOCAL_BRANCH", (Object)"master", (Object)this.getEnvVars(project).get((Object)"GIT_LOCAL_BRANCH"));
    }

    @Test
    public void testCheckoutToDefaultLocalBranch_NULL() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        GitSCM git = (GitSCM)project.getScm();
        git.getExtensions().add((Object)new LocalBranch(""));
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)this.getEnvVars(project).get((Object)"GIT_BRANCH"));
        Assert.assertEquals((String)"GIT_LOCAL_BRANCH", (Object)"master", (Object)this.getEnvVars(project).get((Object)"GIT_LOCAL_BRANCH"));
    }

    @Test
    public void testCheckoutSansLocalBranchExtension() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)this.getEnvVars(project).get((Object)"GIT_BRANCH"));
        Assert.assertEquals((String)"GIT_LOCAL_BRANCH", null, (Object)this.getEnvVars(project).get((Object)"GIT_LOCAL_BRANCH"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckoutFailureIsRetryable() throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        File lock = new File(build1.getWorkspace().toString(), ".git/index.lock");
        try {
            FileUtils.touch((File)lock);
            FreeStyleBuild build2 = this.build(project, Result.FAILURE, new String[0]);
            this.rule.assertLogContains("java.io.IOException: Could not checkout", (Run)build2);
        }
        finally {
            lock.delete();
        }
    }

    @Test
    public void testInitSparseCheckout() throws Exception {
        if (!this.sampleRepo.gitVersionAtLeast(1, 7, 10)) {
            return;
        }
        FreeStyleProject project = this.setupProject("master", Lists.newArrayList((Object[])new SparseCheckoutPath[]{new SparseCheckoutPath("toto")}));
        String commitFile1 = "toto/commitFile1";
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String commitFile2 = "titi/commitFile2";
        this.commit("titi/commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto/commitFile1").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("titi").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("titi/commitFile2").exists());
    }

    @Test
    public void testInitSparseCheckoutBis() throws Exception {
        if (!this.sampleRepo.gitVersionAtLeast(1, 7, 10)) {
            return;
        }
        FreeStyleProject project = this.setupProject("master", Lists.newArrayList((Object[])new SparseCheckoutPath[]{new SparseCheckoutPath("titi")}));
        String commitFile1 = "toto/commitFile1";
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String commitFile2 = "titi/commitFile2";
        this.commit("titi/commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("toto").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("toto/commitFile1").exists());
    }

    @Test
    public void testSparseCheckoutAfterNormalCheckout() throws Exception {
        if (!this.sampleRepo.gitVersionAtLeast(1, 7, 10)) {
            return;
        }
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "toto/commitFile1";
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String commitFile2 = "titi/commitFile2";
        this.commit("titi/commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto/commitFile1").exists());
        ((GitSCM)project.getScm()).getExtensions().add((Object)new SparseCheckoutPaths((List)Lists.newArrayList((Object[])new SparseCheckoutPath[]{new SparseCheckoutPath("titi")})));
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build2.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertFalse((boolean)build2.getWorkspace().child("toto").exists());
        Assert.assertFalse((boolean)build2.getWorkspace().child("toto/commitFile1").exists());
    }

    @Test
    public void testNormalCheckoutAfterSparseCheckout() throws Exception {
        if (!this.sampleRepo.gitVersionAtLeast(1, 7, 10)) {
            return;
        }
        FreeStyleProject project = this.setupProject("master", Lists.newArrayList((Object[])new SparseCheckoutPath[]{new SparseCheckoutPath("titi")}));
        String commitFile1 = "toto/commitFile1";
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String commitFile2 = "titi/commitFile2";
        this.commit("titi/commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build2.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertFalse((boolean)build2.getWorkspace().child("toto").exists());
        Assert.assertFalse((boolean)build2.getWorkspace().child("toto/commitFile1").exists());
        ((GitSCM)project.getScm()).getExtensions().remove(SparseCheckoutPaths.class);
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto/commitFile1").exists());
    }

    @Test
    public void testInitSparseCheckoutOverSlave() throws Exception {
        if (!this.sampleRepo.gitVersionAtLeast(1, 7, 10)) {
            return;
        }
        FreeStyleProject project = this.setupProject("master", Lists.newArrayList((Object[])new SparseCheckoutPath[]{new SparseCheckoutPath("titi")}));
        project.setAssignedLabel((Label)this.rule.createSlave().getSelfLabel());
        String commitFile1 = "toto/commitFile1";
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String commitFile2 = "titi/commitFile2";
        this.commit("titi/commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("toto").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("toto/commitFile1").exists());
    }

    @Test
    public void testPolling_environmentValueInBranchSpec() throws Exception {
        FreeStyleProject project = this.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("${MY_BRANCH}")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        project.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("MY_BRANCH", "master")}));
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertFalse((String)"No changes to git since last build, thus no new build is expected", (boolean)project.poll(this.listener).hasChanges());
    }

    public void baseTestPolling_parentHead(List<GitSCMExtension> extensions) throws Exception {
        FreeStyleProject project = this.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("**")), Boolean.valueOf(false), Collections.emptyList(), null, null, extensions);
        project.setScm((SCM)scm);
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        this.git.branch("someBranch");
        this.commit("toto/commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"polling should detect changes", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertEquals((String)"Wrong number of builds", (long)1L, (long)project.getBuilds().size());
        Assert.assertFalse((String)"polling should not detect changes", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testPolling_parentHead() throws Exception {
        this.baseTestPolling_parentHead(Collections.emptyList());
    }

    @Test
    public void testPolling_parentHead_DisableRemotePoll() throws Exception {
        this.baseTestPolling_parentHead(Collections.singletonList(new DisableRemotePoll()));
    }

    @Test
    public void testPollingAfterManualBuildWithParametrizedBranchSpec() throws Exception {
        FreeStyleProject project = this.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("${MY_BRANCH}")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        project.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("MY_BRANCH", "trackedbranch")}));
        this.commit("file1", this.johnDoe, "Initial Commit");
        this.git.branch("trackedbranch");
        this.git.branch("manualbranch");
        StringParameterValue branchParam = new StringParameterValue("MY_BRANCH", "manualbranch");
        Action[] actions = new Action[]{new ParametersAction(new ParameterValue[]{branchParam})};
        FreeStyleBuild build = (FreeStyleBuild)project.scheduleBuild2(0, (Cause)new Cause.UserCause(), actions).get();
        this.rule.assertBuildStatus(Result.SUCCESS, (Run)build);
        Assert.assertFalse((String)"No changes to git since last build", (boolean)project.poll(this.listener).hasChanges());
        this.git.checkout("manualbranch");
        this.commit("file2", this.johnDoe, "Commit to manually build branch");
        Assert.assertFalse((String)"No changes to tracked branch", (boolean)project.poll(this.listener).hasChanges());
        this.git.checkout("trackedbranch");
        this.commit("file3", this.johnDoe, "Commit to tracked branch");
        Assert.assertTrue((String)"A change should be detected in tracked branch", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testPolling_CanDoRemotePollingIfOneBranchButMultipleRepositories() throws Exception {
        FreeStyleProject project = this.createFreeStyleProject();
        ArrayList<UserRemoteConfig> remoteConfigs = new ArrayList<UserRemoteConfig>();
        remoteConfigs.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", "", null));
        remoteConfigs.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "someOtherRepo", "", null));
        GitSCM scm = new GitSCM(remoteConfigs, Collections.singletonList(new BranchSpec("origin/master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild first_build = (FreeStyleBuild)project.scheduleBuild2(0, (Cause)new Cause.UserCause()).get();
        this.rule.assertBuildStatus(Result.SUCCESS, (Run)first_build);
        first_build.getWorkspace().deleteContents();
        PollingResult pollingResult = scm.poll((AbstractProject)project, null, first_build.getWorkspace(), this.listener, null);
        Assert.assertFalse((boolean)pollingResult.hasChanges());
    }

    @Test
    public void testPolling_environmentValueAsEnvironmentContributingAction() throws Exception {
        FreeStyleProject project = this.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("${MY_BRANCH}")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String brokenPath = "\\broken/path\\of/doom";
        if (!this.sampleRepo.gitVersionAtLeast(1, 8)) {
            String systemPath = System.getenv("PATH");
            brokenPath = systemPath + File.pathSeparator + brokenPath;
        }
        StringParameterValue real_param = new StringParameterValue("MY_BRANCH", "master");
        StringParameterValue fake_param = new StringParameterValue("PATH", brokenPath);
        Action[] actions = new Action[]{new ParametersAction(new ParameterValue[]{real_param}), new FakeParametersAction(fake_param)};
        project.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("MY_BRANCH", "master")}));
        FreeStyleBuild first_build = (FreeStyleBuild)project.scheduleBuild2(0, (Cause)new Cause.UserCause(), actions).get();
        this.rule.assertBuildStatus(Result.SUCCESS, (Run)first_build);
        Launcher launcher = this.workspace.createLauncher(this.listener);
        EnvVars environment = GitUtils.getPollEnvironment((AbstractProject)project, (FilePath)this.workspace, (Launcher)launcher, (TaskListener)this.listener);
        Assert.assertEquals((Object)environment.get((Object)"MY_BRANCH"), (Object)"master");
        Assert.assertNotSame((String)"Enviroment path should not be broken path", (Object)environment.get((Object)"PATH"), (Object)brokenPath);
    }

    @Test
    public void testCustomSCMName() throws Exception {
        String branchName = "master";
        FreeStyleProject project = this.setupProject("master", false);
        project.addTrigger((Trigger)new SCMTrigger(""));
        GitSCM git = (GitSCM)project.getScm();
        this.setupJGit(git);
        String commitFile1 = "commitFile1";
        String scmNameString1 = "";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        Assert.assertTrue((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, "commitFile1");
        ObjectId commit1 = (ObjectId)this.testRepo.git.revListAll().get(0);
        int buildNumber1 = this.notifyAndCheckScmName(project, commit1, "", 1, git);
        String scmNameString2 = "ScmName2";
        git.getExtensions().replace((Describable)new ScmName("ScmName2"));
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling should detect commit 2", (boolean)project.poll(this.listener).hasChanges());
        ObjectId commit2 = (ObjectId)this.testRepo.git.revListAll().get(0);
        int buildNumber2 = this.notifyAndCheckScmName(project, commit2, "ScmName2", 2, git);
        this.checkNumberedBuildScmName(project, buildNumber1, "", git);
        String scmNameString3 = "ScmName3";
        git.getExtensions().replace((Describable)new ScmName("ScmName3"));
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertTrue((String)"scm polling should detect commit 3", (boolean)project.poll(this.listener).hasChanges());
        ObjectId commit3 = (ObjectId)this.testRepo.git.revListAll().get(0);
        int buildNumber3 = this.notifyAndCheckScmName(project, commit3, "ScmName3", 3, git);
        this.checkNumberedBuildScmName(project, buildNumber1, "", git);
        this.checkNumberedBuildScmName(project, buildNumber2, "ScmName2", git);
        this.commit("commitFile4", this.johnDoe, "Commit number 4");
        Assert.assertTrue((String)"scm polling should detect commit 4", (boolean)project.poll(this.listener).hasChanges());
        ObjectId commit4 = (ObjectId)this.testRepo.git.revListAll().get(0);
        int buildNumber4 = this.notifyAndCheckScmName(project, commit4, "ScmName3", 4, git);
        this.checkNumberedBuildScmName(project, buildNumber1, "", git);
        this.checkNumberedBuildScmName(project, buildNumber2, "ScmName2", git);
        this.checkNumberedBuildScmName(project, buildNumber3, "ScmName3", git);
    }

    private int notifyAndCheckScmName(FreeStyleProject project, ObjectId commit, String expectedScmName, int ordinal, GitSCM git) throws Exception {
        Assert.assertTrue((String)("scm polling should detect commit " + ordinal), (boolean)this.notifyCommit(project, commit));
        Build build = (Build)project.getLastBuild();
        BuildData buildData = git.getBuildData((Run)build);
        Assert.assertEquals((String)("Expected SHA1 != built SHA1 for commit " + ordinal), (Object)commit, (Object)buildData.getLastBuiltRevision().getSha1());
        Assert.assertEquals((String)("Expected SHA1 != retrieved SHA1 for commit " + ordinal), (Object)commit, (Object)buildData.getLastBuild(commit).getSHA1());
        Assert.assertTrue((String)("Commit " + ordinal + " not marked as built"), (boolean)buildData.hasBeenBuilt(commit));
        Assert.assertEquals((String)("Wrong SCM Name for commit " + ordinal), (Object)expectedScmName, (Object)buildData.getScmName());
        return build.getNumber();
    }

    private void checkNumberedBuildScmName(FreeStyleProject project, int buildNumber, String expectedScmName, GitSCM git) throws Exception {
        BuildData buildData = git.getBuildData((Run)project.getBuildByNumber(buildNumber));
        Assert.assertEquals((String)"Wrong SCM Name", (Object)expectedScmName, (Object)buildData.getScmName());
    }

    @Test
    public void testSha1NotificationBranches() throws Exception {
        String branchName = "master";
        FreeStyleProject project = this.setupProject("master", false);
        project.addTrigger((Trigger)new SCMTrigger(""));
        GitSCM git = (GitSCM)project.getScm();
        this.setupJGit(git);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        Assert.assertTrue((String)"scm polling should detect commit 1", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, "commitFile1");
        ObjectId commit1 = (ObjectId)this.testRepo.git.revListAll().get(0);
        this.notifyAndCheckBranch(project, commit1, "master", 1, git);
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling should detect commit 2", (boolean)project.poll(this.listener).hasChanges());
        ObjectId commit2 = (ObjectId)this.testRepo.git.revListAll().get(0);
        this.notifyAndCheckBranch(project, commit2, "master", 2, git);
        this.notifyAndCheckBranch(project, commit1, "master", 1, git);
    }

    @Test
    public void testNoNullPointerExceptionWithNullBranch() throws Exception {
        ObjectId sha1 = ObjectId.fromString((String)"2cec153f34767f7638378735dc2b907ed251a67d");
        Branch branch = new Branch(null, sha1);
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        branchList.add(branch);
        Revision revision = new Revision(sha1, branchList);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        Mockito.when((Object)buildData.hasBeenReferenced(Matchers.anyString())).thenReturn((Object)true);
        ArrayList<BuildData> buildDataList = new ArrayList<BuildData>();
        buildDataList.add(buildData);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)build.getActions(BuildData.class)).thenReturn(buildDataList);
        FreeStyleProject project = this.setupProject("*/*", false);
        GitSCM scm = (GitSCM)project.getScm();
        scm.buildEnvVars(build, (Map)new EnvVars());
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).getLastBuiltRevision();
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).hasBeenReferenced(Matchers.anyString());
        ((AbstractBuild)Mockito.verify((Object)build, (VerificationMode)Mockito.times((int)1))).getActions(BuildData.class);
    }

    @Test
    public void testBuildEnvVarsLocalBranchStarStar() throws Exception {
        ObjectId sha1 = ObjectId.fromString((String)"2cec153f34767f7638378735dc2b907ed251a67d");
        Branch branch = new Branch("origin/master", sha1);
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        branchList.add(branch);
        Revision revision = new Revision(sha1, branchList);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        Mockito.when((Object)buildData.hasBeenReferenced(Matchers.anyString())).thenReturn((Object)true);
        ArrayList<BuildData> buildDataList = new ArrayList<BuildData>();
        buildDataList.add(buildData);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)build.getActions(BuildData.class)).thenReturn(buildDataList);
        FreeStyleProject project = this.setupProject("*/*", false);
        GitSCM scm = (GitSCM)project.getScm();
        scm.getExtensions().add((Object)new LocalBranch("**"));
        EnvVars env = new EnvVars();
        scm.buildEnvVars(build, (Map)env);
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)env.get((Object)"GIT_BRANCH"));
        Assert.assertEquals((String)"GIT_LOCAL_BRANCH", (Object)"master", (Object)env.get((Object)"GIT_LOCAL_BRANCH"));
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).getLastBuiltRevision();
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).hasBeenReferenced(Matchers.anyString());
        ((AbstractBuild)Mockito.verify((Object)build, (VerificationMode)Mockito.times((int)1))).getActions(BuildData.class);
    }

    @Test
    public void testBuildEnvVarsLocalBranchNull() throws Exception {
        ObjectId sha1 = ObjectId.fromString((String)"2cec153f34767f7638378735dc2b907ed251a67d");
        Branch branch = new Branch("origin/master", sha1);
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        branchList.add(branch);
        Revision revision = new Revision(sha1, branchList);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        Mockito.when((Object)buildData.hasBeenReferenced(Matchers.anyString())).thenReturn((Object)true);
        ArrayList<BuildData> buildDataList = new ArrayList<BuildData>();
        buildDataList.add(buildData);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)build.getActions(BuildData.class)).thenReturn(buildDataList);
        FreeStyleProject project = this.setupProject("*/*", false);
        GitSCM scm = (GitSCM)project.getScm();
        scm.getExtensions().add((Object)new LocalBranch(""));
        EnvVars env = new EnvVars();
        scm.buildEnvVars(build, (Map)env);
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)env.get((Object)"GIT_BRANCH"));
        Assert.assertEquals((String)"GIT_LOCAL_BRANCH", (Object)"master", (Object)env.get((Object)"GIT_LOCAL_BRANCH"));
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).getLastBuiltRevision();
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).hasBeenReferenced(Matchers.anyString());
        ((AbstractBuild)Mockito.verify((Object)build, (VerificationMode)Mockito.times((int)1))).getActions(BuildData.class);
    }

    @Test
    public void testBuildEnvVarsLocalBranchNotSet() throws Exception {
        ObjectId sha1 = ObjectId.fromString((String)"2cec153f34767f7638378735dc2b907ed251a67d");
        Branch branch = new Branch("origin/master", sha1);
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        branchList.add(branch);
        Revision revision = new Revision(sha1, branchList);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        Mockito.when((Object)buildData.hasBeenReferenced(Matchers.anyString())).thenReturn((Object)true);
        ArrayList<BuildData> buildDataList = new ArrayList<BuildData>();
        buildDataList.add(buildData);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)build.getActions(BuildData.class)).thenReturn(buildDataList);
        FreeStyleProject project = this.setupProject("*/*", false);
        GitSCM scm = (GitSCM)project.getScm();
        EnvVars env = new EnvVars();
        scm.buildEnvVars(build, (Map)env);
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)env.get((Object)"GIT_BRANCH"));
        Assert.assertEquals((String)"GIT_LOCAL_BRANCH", null, (Object)env.get((Object)"GIT_LOCAL_BRANCH"));
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).getLastBuiltRevision();
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).hasBeenReferenced(Matchers.anyString());
        ((AbstractBuild)Mockito.verify((Object)build, (VerificationMode)Mockito.times((int)1))).getActions(BuildData.class);
    }

    private void notifyAndCheckBranch(FreeStyleProject project, ObjectId commit, String expectedBranch, int ordinal, GitSCM git) throws Exception {
        Assert.assertTrue((String)("scm polling should detect commit " + ordinal), (boolean)this.notifyCommit(project, commit));
        BuildData buildData = git.getBuildData((Run)project.getLastBuild());
        Collection builtBranches = buildData.lastBuild.getRevision().getBranches();
        Assert.assertEquals((String)("Commit " + ordinal + " should be built"), (Object)commit, (Object)buildData.getLastBuiltRevision().getSha1());
        String expectedBranchString = "origin/" + expectedBranch;
        Assert.assertFalse((String)"Branches should be detected for the build", (boolean)builtBranches.isEmpty());
        Assert.assertEquals((String)(expectedBranch + " branch should be detected"), (Object)expectedBranchString, (Object)((Branch)builtBranches.iterator().next()).getName());
        Assert.assertEquals((Object)expectedBranchString, (Object)this.getEnvVars(project).get((Object)"GIT_BRANCH"));
    }

    private boolean notifyCommit(FreeStyleProject project, ObjectId commitId) throws Exception {
        int initialBuildNumber = ((FreeStyleBuild)project.getLastBuild()).getNumber();
        String commit1 = ObjectId.toString((ObjectId)commitId);
        String notificationPath = this.rule.getURL().toExternalForm() + "git/notifyCommit?url=" + this.testRepo.gitDir.toString() + "&sha1=" + commit1;
        URL notifyUrl = new URL(notificationPath);
        InputStream is = notifyUrl.openStream();
        IOUtils.toString((InputStream)is);
        IOUtils.closeQuietly((InputStream)is);
        if (((FreeStyleBuild)project.getLastBuild()).getNumber() == initialBuildNumber && this.rule.jenkins.getQueue().isEmpty()) {
            return false;
        }
        while (!this.rule.jenkins.getQueue().isEmpty()) {
            Thread.sleep(100L);
        }
        FreeStyleBuild build = (FreeStyleBuild)project.getLastBuild();
        while (build.isBuilding()) {
            Thread.sleep(100L);
        }
        return true;
    }

    private void setupJGit(GitSCM git) {
        git.gitTool = "jgit";
        ((GitTool.DescriptorImpl)this.rule.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{new JGitTool(Collections.emptyList())});
    }

    @TestExtension
    public static class CleanEnvironment
    extends EnvironmentContributor {
        public void buildEnvironmentFor(Run run, EnvVars envs, TaskListener listener) {
            envs.remove((Object)"GIT_BRANCH");
            envs.remove((Object)"GIT_LOCAL_BRANCH");
            envs.remove((Object)"GIT_COMMIT");
            envs.remove((Object)"GIT_PREVIOUS_COMMIT");
            envs.remove((Object)"GIT_PREVIOUS_SUCCESSFUL_COMMIT");
        }
    }

    private final class FakeParametersAction
    implements EnvironmentContributingAction,
    Serializable {
        final ParametersAction m_forwardingAction;

        public FakeParametersAction(StringParameterValue params) {
            this.m_forwardingAction = new ParametersAction(new ParameterValue[]{params});
        }

        public void buildEnvVars(AbstractBuild<?, ?> ab, EnvVars ev) {
            this.m_forwardingAction.buildEnvVars(ab, ev);
        }

        public String getIconFileName() {
            return this.m_forwardingAction.getIconFileName();
        }

        public String getDisplayName() {
            return this.m_forwardingAction.getDisplayName();
        }

        public String getUrlName() {
            return this.m_forwardingAction.getUrlName();
        }

        public List<ParameterValue> getParameters() {
            return this.m_forwardingAction.getParameters();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        }

        private void readObjectNoData() throws ObjectStreamException {
        }
    }

    @TestExtension(value={"testEnvironmentVariableExpansion"})
    public static class SupplySomeEnvVars
    extends EnvironmentContributor {
        public void buildEnvironmentFor(Run r, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
            envs.put("CAT", "");
        }
    }

    private static class BuildChooserContextTestCallable
    extends MasterToSlaveCallable<String, IOException> {
        private final BuildChooserContext c;

        public BuildChooserContextTestCallable(BuildChooserContext c) {
            this.c = c;
        }

        public String call() throws IOException {
            try {
                return (String)this.c.actOnProject(new BuildChooserContext.ContextCallable<Job<?, ?>, String>(){

                    public String invoke(Job<?, ?> param, VirtualChannel channel) throws IOException, InterruptedException {
                        Assert.assertTrue((boolean)(channel instanceof Channel));
                        Assert.assertTrue((Hudson.getInstance() != null ? 1 : 0) != 0);
                        return param.toString();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }
}

