/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.DisableRemotePoll;
import hudson.plugins.git.extensions.impl.EnforceGitClient;
import hudson.plugins.git.extensions.impl.PathRestriction;
import hudson.plugins.git.extensions.impl.RelativeTargetDirectory;
import hudson.plugins.git.extensions.impl.SparseCheckoutPath;
import hudson.plugins.git.extensions.impl.SparseCheckoutPaths;
import hudson.plugins.git.extensions.impl.UserExclusion;
import hudson.remoting.VirtualChannel;
import hudson.scm.SCM;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.tasks.Builder;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.git.GitSampleRepoRule;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.jvnet.hudson.test.CaptureEnvironmentBuilder;
import org.jvnet.hudson.test.JenkinsRule;

public abstract class AbstractGitTestCase {
    @Rule
    public JenkinsRule rule = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    protected TaskListener listener;
    protected TestGitRepo testRepo;
    protected PersonIdent johnDoe;
    protected PersonIdent janeDoe;
    protected File workDir;
    protected FilePath workspace;
    protected GitClient git;

    @Before
    public void setUp() throws Exception {
        this.listener = StreamTaskListener.fromStderr();
        this.testRepo = new TestGitRepo("unnamed", this.sampleRepo.getRoot(), this.listener);
        this.johnDoe = this.testRepo.johnDoe;
        this.janeDoe = this.testRepo.janeDoe;
        this.workDir = this.testRepo.gitDir;
        this.workspace = this.testRepo.gitDirPath;
        this.git = this.testRepo.git;
    }

    protected void commit(String fileName, PersonIdent committer, String message) throws GitException, InterruptedException {
        this.testRepo.commit(fileName, committer, message);
    }

    protected void commit(String fileName, String fileContent, PersonIdent committer, String message) throws GitException, InterruptedException {
        this.testRepo.commit(fileName, fileContent, committer, message);
    }

    protected void commit(String fileName, PersonIdent author, PersonIdent committer, String message) throws GitException, InterruptedException {
        this.testRepo.commit(fileName, author, committer, message);
    }

    protected List<UserRemoteConfig> createRemoteRepositories() throws IOException {
        return this.testRepo.remoteConfigs();
    }

    protected FreeStyleProject createFreeStyleProject() throws IOException {
        return this.rule.createFreeStyleProject();
    }

    protected FreeStyleProject setupProject(String branchString, boolean authorOrCommitter) throws Exception {
        return this.setupProject(branchString, authorOrCommitter, null);
    }

    protected FreeStyleProject setupProject(String branchString, boolean authorOrCommitter, String relativeTargetDir) throws Exception {
        return this.setupProject(branchString, authorOrCommitter, relativeTargetDir, null, null, null);
    }

    protected FreeStyleProject setupProject(String branchString, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String includedRegions) throws Exception {
        return this.setupProject(branchString, authorOrCommitter, relativeTargetDir, excludedRegions, excludedUsers, null, false, includedRegions);
    }

    protected FreeStyleProject setupProject(String branchString, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, boolean fastRemotePoll, String includedRegions) throws Exception {
        return this.setupProject(branchString, authorOrCommitter, relativeTargetDir, excludedRegions, excludedUsers, null, fastRemotePoll, includedRegions);
    }

    protected FreeStyleProject setupProject(String branchString, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String localBranch, boolean fastRemotePoll, String includedRegions) throws Exception {
        return this.setupProject(Collections.singletonList(new BranchSpec(branchString)), authorOrCommitter, relativeTargetDir, excludedRegions, excludedUsers, localBranch, fastRemotePoll, includedRegions);
    }

    protected FreeStyleProject setupProject(List<BranchSpec> branches, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String localBranch, boolean fastRemotePoll, String includedRegions) throws Exception {
        return this.setupProject(branches, authorOrCommitter, relativeTargetDir, excludedRegions, excludedUsers, localBranch, fastRemotePoll, includedRegions, null);
    }

    protected FreeStyleProject setupProject(String branchString, List<SparseCheckoutPath> sparseCheckoutPaths) throws Exception {
        return this.setupProject(Collections.singletonList(new BranchSpec(branchString)), false, null, null, null, null, false, null, sparseCheckoutPaths);
    }

    protected FreeStyleProject setupProject(List<BranchSpec> branches, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String localBranch, boolean fastRemotePoll, String includedRegions, List<SparseCheckoutPath> sparseCheckoutPaths) throws Exception {
        FreeStyleProject project = this.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), branches, Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new DisableRemotePoll());
        if (relativeTargetDir != null) {
            scm.getExtensions().add((Object)new RelativeTargetDirectory(relativeTargetDir));
        }
        if (excludedUsers != null) {
            scm.getExtensions().add((Object)new UserExclusion(excludedUsers));
        }
        if (excludedRegions != null || includedRegions != null) {
            scm.getExtensions().add((Object)new PathRestriction(includedRegions, excludedRegions));
        }
        scm.getExtensions().add((Object)new SparseCheckoutPaths(sparseCheckoutPaths));
        project.setScm((SCM)scm);
        project.getBuildersList().add((Object)new CaptureEnvironmentBuilder());
        return project;
    }

    protected FreeStyleProject setupProject(List<UserRemoteConfig> repos, List<BranchSpec> branchSpecs, String scmTriggerSpec, boolean disableRemotePoll, EnforceGitClient enforceGitClient) throws Exception {
        FreeStyleProject project = this.createFreeStyleProject();
        GitSCM scm = new GitSCM(repos, branchSpecs, Boolean.valueOf(false), Collections.emptyList(), null, "jgit", Collections.emptyList());
        if (disableRemotePoll) {
            scm.getExtensions().add((Object)new DisableRemotePoll());
        }
        if (enforceGitClient != null) {
            scm.getExtensions().add((Object)enforceGitClient);
        }
        project.setScm((SCM)scm);
        if (scmTriggerSpec != null) {
            SCMTrigger trigger = new SCMTrigger(scmTriggerSpec);
            project.addTrigger((Trigger)trigger);
            trigger.start((Item)project, true);
        }
        project.save();
        return project;
    }

    protected FreeStyleProject setupSimpleProject(String branchString) throws Exception {
        return this.setupProject(branchString, false);
    }

    protected FreeStyleBuild build(FreeStyleProject project, Result expectedResult, String ... expectedNewlyCommittedFiles) throws Exception {
        FreeStyleBuild build = (FreeStyleBuild)project.scheduleBuild2(0).get();
        System.out.println(build.getLog());
        for (String expectedNewlyCommittedFile : expectedNewlyCommittedFiles) {
            Assert.assertTrue((String)(expectedNewlyCommittedFile + " file not found in workspace"), (boolean)build.getWorkspace().child(expectedNewlyCommittedFile).exists());
        }
        if (expectedResult != null) {
            this.rule.assertBuildStatus(expectedResult, (Run)build);
        }
        return build;
    }

    protected FreeStyleBuild build(FreeStyleProject project, String parentDir, Result expectedResult, String ... expectedNewlyCommittedFiles) throws Exception {
        FreeStyleBuild build = (FreeStyleBuild)project.scheduleBuild2(0).get();
        System.out.println(build.getLog());
        for (String expectedNewlyCommittedFile : expectedNewlyCommittedFiles) {
            Assert.assertTrue((boolean)build.getWorkspace().child(parentDir).child(expectedNewlyCommittedFile).exists());
        }
        if (expectedResult != null) {
            this.rule.assertBuildStatus(expectedResult, (Run)build);
        }
        return build;
    }

    protected MatrixBuild build(MatrixProject project, Result expectedResult, String ... expectedNewlyCommittedFiles) throws Exception {
        MatrixBuild build = (MatrixBuild)project.scheduleBuild2(0).get();
        System.out.println(build.getLog());
        for (String expectedNewlyCommittedFile : expectedNewlyCommittedFiles) {
            Assert.assertTrue((String)(expectedNewlyCommittedFile + " file not found in workspace"), (boolean)build.getWorkspace().child(expectedNewlyCommittedFile).exists());
        }
        if (expectedResult != null) {
            this.rule.assertBuildStatus(expectedResult, (Run)build);
        }
        return build;
    }

    protected EnvVars getEnvVars(FreeStyleProject project) {
        for (Builder b : project.getBuilders()) {
            if (!(b instanceof CaptureEnvironmentBuilder)) continue;
            return ((CaptureEnvironmentBuilder)b).getEnvVars();
        }
        return new EnvVars();
    }

    protected void setVariables(Node node, EnvironmentVariablesNodeProperty.Entry ... entries) throws IOException {
        node.getNodeProperties().replaceBy(Collections.singleton(new EnvironmentVariablesNodeProperty(entries)));
    }

    protected String getHeadRevision(AbstractBuild build, final String branch) throws IOException, InterruptedException {
        return (String)build.getWorkspace().act((FilePath.FileCallable)new MasterToSlaveFileCallable<String>(){

            public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                try {
                    ObjectId oid = Git.with(null, null).in(f).getClient().getRepository().resolve("refs/heads/" + branch);
                    return oid.name();
                }
                catch (GitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void showRepo(TestGitRepo repo, String msg) throws Exception {
        System.out.println("*********** " + msg + " ***********");
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int returnCode = new Launcher.LocalLauncher(this.listener).launch().cmds(new String[]{"git", "log", "--all", "--graph", "--decorate", "--oneline"}).pwd(repo.gitDir.getCanonicalPath()).stdout((OutputStream)out).join();
            System.out.println(out.toString());
        }
    }
}

