/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GitWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GitWeb(String repoUrl) {
        super(repoUrl);
    }

    @Override
    protected boolean getNormalizeUrl() {
        return false;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + this.param(url).add("a=commit").add("h=" + changeSet.getId()).toString());
    }

    private QueryBuilder param(URL url) {
        return new QueryBuilder(url.getQuery());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        String spec = this.param(url).add("a=blobdiff").add("f=" + path.getPath()).add("fp=" + path.getPath()).add("h=" + path.getSrc()).add("hp=" + path.getDst()).add("hb=" + changeSet.getId()).add("hpb=" + changeSet.getParentCommit()).toString();
        return new URL(url, url.getPath() + spec);
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        URL url = this.getUrl();
        String h = path.getDst() != null ? path.getDst() : path.getSrc();
        String spec = this.param(url).add("a=blob").add("f=" + path.getPath()).add("h=" + h).add("hb=" + path.getChangeSet().getId()).toString();
        return new URL(url, url.getPath() + spec);
    }

    @Extension
    public static class GitWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @Nonnull
        public String getDisplayName() {
            return "gitweb";
        }

        public GitWeb newInstance(StaplerRequest req, @Nonnull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (GitWeb)((Object)req.bindJSON(GitWeb.class, jsonObject));
        }
    }
}

