/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.google.common.base.Joiner;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Pattern;

public class SubmoduleConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    String submoduleName;
    String[] branches;

    public String getSubmoduleName() {
        return this.submoduleName;
    }

    public void setSubmoduleName(String submoduleName) {
        this.submoduleName = submoduleName;
    }

    public String[] getBranches() {
        return Arrays.copyOf(this.branches, this.branches.length);
    }

    public void setBranches(String[] branches) {
        this.branches = Arrays.copyOf(branches, branches.length);
    }

    public boolean revisionMatchesInterest(Revision r) {
        for (Branch br : r.getBranches()) {
            if (!this.branchMatchesInterest(br)) continue;
            return true;
        }
        return false;
    }

    public boolean branchMatchesInterest(Branch br) {
        for (String regex : this.branches) {
            if (Pattern.matches(regex, br.getName())) continue;
            return false;
        }
        return true;
    }

    public String getBranchesString() {
        return Joiner.on((char)',').join((Object[])this.branches);
    }
}

