/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.scm.SCM;
import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;

public abstract class AbstractGitSCMSource
extends SCMSource {
    private static final ConcurrentMap<String, Lock> cacheLocks = new ConcurrentHashMap<String, Lock>();
    private static final Logger LOGGER = Logger.getLogger(AbstractGitSCMSource.class.getName());

    public AbstractGitSCMSource(String id) {
        super(id);
    }

    public abstract String getCredentialsId();

    public abstract String getRemote();

    public abstract String getIncludes();

    public abstract String getExcludes();

    @CheckForNull
    public GitRepositoryBrowser getBrowser() {
        return null;
    }

    @CheckForNull
    public String getGitTool() {
        return null;
    }

    @NonNull
    public List<GitSCMExtension> getExtensions() {
        return Collections.emptyList();
    }

    public String getRemoteName() {
        return "origin";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    protected SCMRevision retrieve(@NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        String cacheEntry = this.getCacheEntry();
        Lock cacheLock = AbstractGitSCMSource.getCacheLock(cacheEntry);
        cacheLock.lock();
        try {
            File cacheDir = AbstractGitSCMSource.getCacheDir(cacheEntry);
            Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars)).in(cacheDir);
            GitClient client = git.getClient();
            client.addDefaultCredentials((StandardCredentials)this.getCredentials());
            if (!client.hasGitRepo()) {
                listener.getLogger().println("Creating git repository in " + cacheDir);
                client.init();
            }
            String remoteName = this.getRemoteName();
            listener.getLogger().println("Setting " + remoteName + " to " + this.getRemote());
            client.setRemoteUrl(remoteName, this.getRemote());
            listener.getLogger().println("Fetching " + remoteName + "...");
            List<RefSpec> refSpecs = this.getRefSpecs();
            client.fetch(remoteName, refSpecs.toArray(new RefSpec[refSpecs.size()]));
            for (Branch b : client.getRemoteBranches()) {
                String branchName = StringUtils.removeStart((String)b.getName(), (String)(remoteName + "/"));
                if (!branchName.equals(head.getName())) continue;
                SCMRevisionImpl sCMRevisionImpl = new SCMRevisionImpl(head, b.getSHA1String());
                return sCMRevisionImpl;
            }
            SCMRevision sCMRevision = null;
            return sCMRevision;
        }
        finally {
            cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected void retrieve(@NonNull SCMHeadObserver observer, @NonNull TaskListener listener) throws IOException, InterruptedException {
        String cacheEntry = this.getCacheEntry();
        Lock cacheLock = AbstractGitSCMSource.getCacheLock(cacheEntry);
        cacheLock.lock();
        try {
            File cacheDir = AbstractGitSCMSource.getCacheDir(cacheEntry);
            Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars)).in(cacheDir);
            GitClient client = git.getClient();
            client.addDefaultCredentials((StandardCredentials)this.getCredentials());
            if (!client.hasGitRepo()) {
                listener.getLogger().println("Creating git repository in " + cacheDir);
                client.init();
            }
            String remoteName = this.getRemoteName();
            listener.getLogger().println("Setting " + remoteName + " to " + this.getRemote());
            client.setRemoteUrl(remoteName, this.getRemote());
            listener.getLogger().println("Fetching " + remoteName + "...");
            List<RefSpec> refSpecs = this.getRefSpecs();
            client.fetch(remoteName, refSpecs.toArray(new RefSpec[refSpecs.size()]));
            listener.getLogger().println("Pruning stale remotes...");
            final Repository repository = client.getRepository();
            try {
                client.prune(new RemoteConfig((Config)repository.getConfig(), remoteName));
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace(listener.error("Could not prune stale remotes"));
            }
            catch (URISyntaxException e) {
                e.printStackTrace(listener.error("Could not prune stale remotes"));
            }
            listener.getLogger().println("Getting remote branches...");
            SCMSourceCriteria branchCriteria = this.getCriteria();
            RevWalk walk = new RevWalk(repository);
            try {
                walk.setRetainBody(false);
                Iterator i$ = client.getRemoteBranches().iterator();
                while (true) {
                    if (i$.hasNext()) {
                        Branch b = (Branch)i$.next();
                        if (!b.getName().startsWith(remoteName + "/")) continue;
                        final String branchName = StringUtils.removeStart((String)b.getName(), (String)(remoteName + "/"));
                        listener.getLogger().println("Checking branch " + branchName);
                        if (this.isExcluded(branchName)) continue;
                        if (branchCriteria != null) {
                            RevTree tree;
                            RevCommit commit = walk.parseCommit((AnyObjectId)b.getSHA1());
                            final long lastModified = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                            SCMSourceCriteria.Probe probe = new SCMSourceCriteria.Probe(tree = commit.getTree()){
                                final /* synthetic */ RevTree val$tree;
                                {
                                    this.val$tree = revTree;
                                }

                                public String name() {
                                    return branchName;
                                }

                                public long lastModified() {
                                    return lastModified;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public boolean exists(@NonNull String path) throws IOException {
                                    TreeWalk tw = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)this.val$tree);
                                    try {
                                        boolean bl = tw != null;
                                        return bl;
                                    }
                                    finally {
                                        if (tw != null) {
                                            tw.release();
                                        }
                                    }
                                }
                            };
                            if (branchCriteria.isHead(probe, listener)) {
                                listener.getLogger().println("Met criteria");
                            } else {
                                listener.getLogger().println("Does not meet criteria");
                                continue;
                            }
                        }
                        SCMHead head = new SCMHead(branchName);
                        SCMRevisionImpl hash = new SCMRevisionImpl(head, b.getSHA1String());
                        observer.observe(head, (SCMRevision)hash);
                        if (observer.isObserving()) continue;
                        return;
                        continue;
                    }
                    break;
                }
            }
            finally {
                walk.dispose();
            }
            listener.getLogger().println("Done.");
        }
        finally {
            cacheLock.unlock();
        }
    }

    protected String getCacheEntry() {
        return "git-" + Util.getDigestOf((String)this.getRemote());
    }

    protected static File getCacheDir(String cacheEntry) {
        boolean ok;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            LOGGER.severe("Jenkins instance is null in AbstractGitSCMSource.getCacheDir");
            return null;
        }
        File cacheDir = new File(new File(jenkins.getRootDir(), "caches"), cacheEntry);
        File parentDir = cacheDir.getParentFile();
        if (!parentDir.isDirectory() && !(ok = parentDir.mkdirs())) {
            LOGGER.info("Failed mkdirs of " + parentDir.getPath());
        }
        return cacheDir;
    }

    protected static Lock getCacheLock(String cacheEntry) {
        Lock cacheLock;
        while (null == (cacheLock = (Lock)cacheLocks.get(cacheEntry))) {
            cacheLocks.putIfAbsent(cacheEntry, new ReentrantLock());
        }
        return cacheLock;
    }

    protected StandardUsernameCredentials getCredentials() {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)this.getOwner(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.getRemote()).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)this.getCredentialsId()), GitClient.CREDENTIALS_MATCHER}));
    }

    protected abstract List<RefSpec> getRefSpecs();

    @NonNull
    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        BuildChooser buildChooser = revision instanceof SCMRevisionImpl ? new SpecificRevisionBuildChooser((SCMRevisionImpl)revision) : new DefaultBuildChooser();
        List<GitSCMExtension> extensions = this.getExtensions();
        return new GitSCM(this.getRemoteConfigs(), Collections.singletonList(new BranchSpec(head.getName())), false, Collections.<SubmoduleConfig>emptyList(), this.getBrowser(), this.getGitTool(), extensions.isEmpty() ? Collections.singletonList(new BuildChooserSetting(buildChooser)) : extensions);
    }

    protected List<UserRemoteConfig> getRemoteConfigs() {
        List<RefSpec> refSpecs = this.getRefSpecs();
        ArrayList<UserRemoteConfig> result = new ArrayList<UserRemoteConfig>(refSpecs.size());
        String remote = this.getRemote();
        for (RefSpec refSpec : refSpecs) {
            result.add(new UserRemoteConfig(remote, this.getRemoteName(), refSpec.toString(), this.getCredentialsId()));
        }
        return result;
    }

    protected boolean isExcluded(String branchName) {
        return !Pattern.matches(this.getPattern(this.getIncludes()), branchName) || Pattern.matches(this.getPattern(this.getExcludes()), branchName);
    }

    private String getPattern(String branches) {
        StringBuilder quotedBranches = new StringBuilder();
        for (String wildcard : branches.split(" ")) {
            StringBuilder quotedBranch = new StringBuilder();
            for (String branch : wildcard.split("(?=[*])|(?<=[*])")) {
                if (branch.equals("*")) {
                    quotedBranch.append(".*");
                    continue;
                }
                if (branch.isEmpty()) continue;
                quotedBranch.append(Pattern.quote(branch));
            }
            if (quotedBranches.length() > 0) {
                quotedBranches.append("|");
            }
            quotedBranches.append((CharSequence)quotedBranch);
        }
        return quotedBranches.toString();
    }

    public static class SpecificRevisionBuildChooser
    extends BuildChooser {
        private final Revision revision;

        public SpecificRevisionBuildChooser(SCMRevisionImpl revision) {
            ObjectId sha1 = ObjectId.fromString((String)revision.getHash());
            String name = revision.getHead().getName();
            this.revision = new Revision(sha1, Collections.singleton(new Branch(name, sha1)));
        }

        @Override
        public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, GitClient git, TaskListener listener, BuildData buildData, BuildChooserContext context) throws GitException, IOException, InterruptedException {
            return Collections.singleton(this.revision);
        }

        @Override
        public Build prevBuildForChangelog(String branch, @Nullable BuildData data, GitClient git, BuildChooserContext context) throws IOException, InterruptedException {
            return data == null ? null : data.lastBuild;
        }

        @Extension
        public static class DescriptorImpl
        extends BuildChooserDescriptor {
            public String getDisplayName() {
                return "Specific revision";
            }

            @Override
            public boolean isApplicable(Class<? extends Item> job) {
                return SCMSourceOwner.class.isAssignableFrom(job);
            }
        }
    }

    public static class SCMRevisionImpl
    extends SCMRevision {
        private String hash;

        public SCMRevisionImpl(SCMHead head, String hash) {
            super(head);
            this.hash = hash;
        }

        public String getHash() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            SCMRevisionImpl that = (SCMRevisionImpl)((Object)o);
            return StringUtils.equals((String)this.hash, (String)that.hash) && this.getHead().equals((Object)that.getHead());
        }

        public int hashCode() {
            return this.hash != null ? this.hash.hashCode() : 0;
        }

        public String toString() {
            return this.hash;
        }
    }
}

