/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Messages;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.GitURIRequirementsBuilder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public class UserRemoteConfig
extends AbstractDescribableImpl<UserRemoteConfig>
implements Serializable {
    private String name;
    private String refspec;
    private String url;
    private String credentialsId;
    private static final Pattern SCP_LIKE = Pattern.compile("(.*):(.*)");

    @DataBoundConstructor
    public UserRemoteConfig(String url, String name, String refspec, String credentialsId) {
        this.url = Util.fixEmptyAndTrim((String)url);
        this.name = Util.fixEmpty((String)name);
        this.refspec = Util.fixEmpty((String)refspec);
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getRefspec() {
        return this.refspec;
    }

    @Exported
    public String getUrl() {
        return this.url;
    }

    @Exported
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String toString() {
        return this.getRefspec() + " => " + this.getUrl() + " (" + this.getName() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<UserRemoteConfig> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String url) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withMatching(GitClient.CREDENTIALS_MATCHER, (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)GitURIRequirementsBuilder.fromUri((String)url).build()));
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String value) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((url = Util.fixEmptyAndTrim((String)url)) == null) {
                return FormValidation.ok();
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            StandardCredentials credentials = DescriptorImpl.lookupCredentials(project, value, url);
            if (credentials == null) {
                return FormValidation.warning((String)("Cannot find any credentials with id " + value));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@AncestorInPath Item project, @QueryParameter String credentialsId, @QueryParameter String value) throws IOException, InterruptedException {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)"Please enter Git repository.");
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            EnvVars environment = new EnvVars(System.getenv());
            GitClient git = Git.with((TaskListener)TaskListener.NULL, (EnvVars)environment).using(GitTool.getDefaultInstallation().getGitExe()).getClient();
            git.addDefaultCredentials(DescriptorImpl.lookupCredentials(project, credentialsId, url));
            try {
                git.getHeadRev(url, "HEAD");
            }
            catch (GitException e) {
                return FormValidation.error((String)Messages.UserRemoteConfig_FailedToConnect(e.getMessage()));
            }
            return FormValidation.ok();
        }

        private static StandardCredentials lookupCredentials(Item project, String credentialId, String uri) {
            return credentialId == null ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)GitURIRequirementsBuilder.fromUri((String)uri).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        }

        public String getDisplayName() {
            return "";
        }
    }
}

