/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserMergeOptions
extends AbstractDescribableImpl<UserMergeOptions>
implements Serializable {
    private String mergeRemote;
    private String mergeTarget;
    private String mergeStrategy;

    @DataBoundConstructor
    public UserMergeOptions(String mergeRemote, String mergeTarget, String mergeStrategy) {
        this.mergeRemote = mergeRemote;
        this.mergeTarget = mergeTarget;
        this.mergeStrategy = mergeStrategy;
    }

    public UserMergeOptions(PreBuildMergeOptions pbm) {
        this(pbm.getRemoteBranchName(), pbm.getMergeTarget(), pbm.getMergeStrategy().toString());
    }

    public String getMergeRemote() {
        return this.mergeRemote;
    }

    public String getMergeTarget() {
        return this.mergeTarget;
    }

    public String getRef() {
        return this.mergeRemote + "/" + this.mergeTarget;
    }

    public MergeCommand.Strategy getMergeStrategy() {
        for (MergeCommand.Strategy strategy : MergeCommand.Strategy.values()) {
            if (!strategy.toString().equals(this.mergeStrategy)) continue;
            return strategy;
        }
        return MergeCommand.Strategy.DEFAULT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<UserMergeOptions> {
        public String getDisplayName() {
            return "";
        }

        public ListBoxModel doFillMergeStrategyItems() {
            ListBoxModel m = new ListBoxModel();
            for (MergeCommand.Strategy strategy : MergeCommand.Strategy.values()) {
                m.add(strategy.toString(), strategy.toString());
            }
            return m;
        }
    }
}

