/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.EnvVars;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GitRepositoryBrowser
extends RepositoryBrowser<GitChangeSet> {
    private String url;
    private static final long serialVersionUID = 1L;

    @Deprecated
    protected GitRepositoryBrowser() {
    }

    protected GitRepositoryBrowser(String repourl) {
        this.url = repourl;
    }

    public final String getRepoUrl() {
        return this.url;
    }

    public final URL getUrl() throws IOException {
        Job job;
        String u = this.url;
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && (job = (Job)req.findAncestorObject(Job.class)) != null) {
            EnvVars env = null;
            try {
                env = job.getEnvironment(null, TaskListener.NULL);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to retrieve job environment", e);
            }
            u = env.expand(this.url);
        }
        return GitRepositoryBrowser.normalizeToEndWithSlash((URL)new URL(u));
    }

    public abstract URL getDiffLink(GitChangeSet.Path var1) throws IOException;

    public abstract URL getFileLink(GitChangeSet.Path var1) throws IOException;
}

