/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.Describable;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.extensions.impl.AuthorInChangelog;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.extensions.impl.CleanCheckout;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.plugins.git.extensions.impl.DisableRemotePoll;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.plugins.git.extensions.impl.PathRestriction;
import hudson.plugins.git.extensions.impl.PerBuildTag;
import hudson.plugins.git.extensions.impl.PreBuildMerge;
import hudson.plugins.git.extensions.impl.PruneStaleBranch;
import hudson.plugins.git.extensions.impl.RelativeTargetDirectory;
import hudson.plugins.git.extensions.impl.ScmName;
import hudson.plugins.git.extensions.impl.SubmoduleOption;
import hudson.plugins.git.extensions.impl.UserExclusion;
import hudson.plugins.git.extensions.impl.UserIdentity;
import hudson.plugins.git.extensions.impl.WipeWorkspace;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.scm.SCM;
import hudson.util.DescribableList;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GitSCMBackwardCompatibility
extends SCM
implements Serializable {
    @Deprecated
    transient String source;
    @Deprecated
    transient String branch;
    transient String choosingStrategy;
    private transient String relativeTargetDir;
    private transient String includedRegions;
    private transient String excludedRegions;
    private transient String excludedUsers;
    private transient Boolean skipTag;
    private transient boolean disableSubmodules;
    private transient boolean recursiveSubmodules;
    private transient String gitConfigName;
    private transient String gitConfigEmail;
    private transient boolean pruneBranches;
    private transient UserMergeOptions userMergeOptions;
    private transient PreBuildMergeOptions mergeOptions;
    private transient boolean clean;
    private transient boolean wipeOutWorkspace;
    private transient boolean useShallowClone;
    private transient String reference;
    private transient boolean remotePoll;
    private transient boolean authorOrCommitter;
    private transient boolean ignoreNotifyCommit;
    private transient String scmName;
    private transient String localBranch;
    private transient BuildChooser buildChooser;
    private static final long serialVersionUID = 1L;

    abstract DescribableList<GitSCMExtension, GitSCMExtensionDescriptor> getExtensions();

    public GitSCM.DescriptorImpl getDescriptor() {
        return (GitSCM.DescriptorImpl)super.getDescriptor();
    }

    void readBackExtensionsFromLegacy() {
        try {
            if (StringUtils.isNotBlank((String)this.excludedUsers)) {
                this.addIfMissing(new UserExclusion(this.excludedUsers));
                this.excludedUsers = null;
            }
            if (StringUtils.isNotBlank((String)this.excludedRegions) || StringUtils.isNotBlank((String)this.includedRegions)) {
                this.addIfMissing(new PathRestriction(this.includedRegions, this.excludedRegions));
                this.includedRegions = null;
                this.excludedRegions = null;
            }
            if (StringUtils.isNotBlank((String)this.relativeTargetDir)) {
                this.addIfMissing(new RelativeTargetDirectory(this.relativeTargetDir));
                this.relativeTargetDir = null;
            }
            if (this.skipTag != null && !this.skipTag.booleanValue()) {
                this.addIfMissing(new PerBuildTag());
                this.skipTag = null;
            }
            if (this.disableSubmodules || this.recursiveSubmodules) {
                this.addIfMissing(new SubmoduleOption(this.disableSubmodules, this.recursiveSubmodules));
            }
            if (StringUtils.isNotBlank((String)this.gitConfigName) || StringUtils.isNotBlank((String)this.gitConfigEmail)) {
                this.addIfMissing(new UserIdentity(this.gitConfigName, this.gitConfigEmail));
                this.gitConfigEmail = null;
                this.gitConfigName = null;
            }
            if (this.pruneBranches) {
                this.addIfMissing(new PruneStaleBranch());
            }
            if (this.mergeOptions != null && this.mergeOptions.doMerge()) {
                this.getExtensions().replace((Describable)new PreBuildMerge(new UserMergeOptions(this.mergeOptions)));
                this.mergeOptions = null;
            }
            if (this.userMergeOptions != null) {
                this.addIfMissing(new PreBuildMerge(this.userMergeOptions));
                this.userMergeOptions = null;
            }
            if (this.clean) {
                this.addIfMissing(new CleanCheckout());
            }
            if (this.wipeOutWorkspace) {
                this.addIfMissing(new WipeWorkspace());
            }
            if (this.authorOrCommitter) {
                this.addIfMissing(new AuthorInChangelog());
            }
            if (this.ignoreNotifyCommit) {
                this.addIfMissing(new IgnoreNotifyCommit());
            }
            if (StringUtils.isNotBlank((String)this.scmName)) {
                this.addIfMissing(new ScmName(this.scmName));
            }
            if (this.localBranch != null) {
                this.addIfMissing(new LocalBranch(this.localBranch));
            }
            if (this.buildChooser != null && this.buildChooser.getClass() != DefaultBuildChooser.class) {
                this.addIfMissing(new BuildChooserSetting(this.buildChooser));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void addIfMissing(GitSCMExtension ext) throws IOException {
        if (this.getExtensions().get(((Object)((Object)ext)).getClass()) == null) {
            this.getExtensions().add((Object)ext);
        }
    }

    @Deprecated
    public String getIncludedRegions() {
        PathRestriction pr = (PathRestriction)this.getExtensions().get(PathRestriction.class);
        return pr != null ? pr.getIncludedRegions() : null;
    }

    @Deprecated
    public String getExcludedRegions() {
        PathRestriction pr = (PathRestriction)this.getExtensions().get(PathRestriction.class);
        return pr != null ? pr.getExcludedRegions() : null;
    }

    @Deprecated
    public String[] getExcludedRegionsNormalized() {
        PathRestriction pr = (PathRestriction)this.getExtensions().get(PathRestriction.class);
        return pr != null ? pr.getExcludedRegionsNormalized() : null;
    }

    @Deprecated
    public String[] getIncludedRegionsNormalized() {
        PathRestriction pr = (PathRestriction)this.getExtensions().get(PathRestriction.class);
        return pr != null ? pr.getIncludedRegionsNormalized() : null;
    }

    @Deprecated
    public String getRelativeTargetDir() {
        RelativeTargetDirectory rt = (RelativeTargetDirectory)this.getExtensions().get(RelativeTargetDirectory.class);
        return rt != null ? rt.getRelativeTargetDir() : null;
    }

    @Deprecated
    public String getExcludedUsers() {
        UserExclusion ue = (UserExclusion)this.getExtensions().get(UserExclusion.class);
        return ue != null ? ue.getExcludedUsers() : null;
    }

    @Deprecated
    public Set<String> getExcludedUsersNormalized() {
        UserExclusion ue = (UserExclusion)this.getExtensions().get(UserExclusion.class);
        return ue != null ? ue.getExcludedUsersNormalized() : null;
    }

    @Deprecated
    public boolean getSkipTag() {
        return this.getExtensions().get(PerBuildTag.class) != null;
    }

    @Deprecated
    public boolean getDisableSubmodules() {
        SubmoduleOption sm = (SubmoduleOption)this.getExtensions().get(SubmoduleOption.class);
        return sm != null && sm.isDisableSubmodules();
    }

    @Deprecated
    public boolean getRecursiveSubmodules() {
        SubmoduleOption sm = (SubmoduleOption)this.getExtensions().get(SubmoduleOption.class);
        return sm != null && sm.isRecursiveSubmodules();
    }

    @Deprecated
    public String getGitConfigName() {
        UserIdentity ui = (UserIdentity)this.getExtensions().get(UserIdentity.class);
        return ui != null ? ui.getName() : null;
    }

    @Deprecated
    public String getGitConfigEmail() {
        UserIdentity ui = (UserIdentity)this.getExtensions().get(UserIdentity.class);
        return ui != null ? ui.getEmail() : null;
    }

    @Deprecated
    public String getGitConfigNameToUse() {
        String n = this.getGitConfigName();
        if (n == null) {
            n = this.getDescriptor().getGlobalConfigName();
        }
        return n;
    }

    @Deprecated
    public String getGitConfigEmailToUse() {
        String n = this.getGitConfigEmail();
        if (n == null) {
            n = this.getDescriptor().getGlobalConfigEmail();
        }
        return n;
    }

    @Deprecated
    public boolean getPruneBranches() {
        return this.getExtensions().get(PruneStaleBranch.class) != null;
    }

    @Deprecated
    public UserMergeOptions getUserMergeOptions() {
        PreBuildMerge m = (PreBuildMerge)this.getExtensions().get(PreBuildMerge.class);
        return m != null ? m.getOptions() : null;
    }

    public boolean getClean() {
        return this.getExtensions().get(CleanCheckout.class) != null;
    }

    public boolean getWipeOutWorkspace() {
        return this.getExtensions().get(WipeWorkspace.class) != null;
    }

    public boolean getUseShallowClone() {
        CloneOption m = (CloneOption)this.getExtensions().get(CloneOption.class);
        return m != null && m.isShallow();
    }

    public String getReference() {
        CloneOption m = (CloneOption)this.getExtensions().get(CloneOption.class);
        return m != null ? m.getReference() : null;
    }

    public boolean getRemotePoll() {
        return this.getExtensions().get(DisableRemotePoll.class) == null;
    }

    public boolean getAuthorOrCommitter() {
        return this.getExtensions().get(AuthorInChangelog.class) != null;
    }

    public boolean isIgnoreNotifyCommit() {
        return this.getExtensions().get(IgnoreNotifyCommit.class) != null;
    }

    public String getScmName() {
        ScmName sn = (ScmName)this.getExtensions().get(ScmName.class);
        return sn != null ? sn.getName() : null;
    }

    public String getLocalBranch() {
        LocalBranch lb = (LocalBranch)this.getExtensions().get(LocalBranch.class);
        return lb != null ? lb.getLocalBranch() : null;
    }
}

