/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GitLab
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final URL url;
    private final double version;

    @DataBoundConstructor
    public GitLab(String url, String version) throws MalformedURLException {
        this.version = Double.valueOf(version);
        this.url = GitLab.normalizeToEndWithSlash((URL)new URL(url));
    }

    public URL getUrl() {
        return this.url;
    }

    public double getVersion() {
        return this.version;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.url, this.calculatePrefix() + changeSet.getId().toString());
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        return new URL(this.url, this.calculatePrefix() + changeSet.getId().toString() + "#" + path.getPath());
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLink(path);
        }
        String spec = "/" + path.getChangeSet().getId() + "/tree/" + path.getPath();
        return new URL(this.url, this.url.getPath() + spec);
    }

    private String calculatePrefix() {
        if (this.getVersion() >= 3.0) {
            return "commit/";
        }
        return "commits/";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class GitLabDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "gitlab";
        }

        public GitLab newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (GitLab)((Object)req.bindParameters(GitLab.class, "Gitlab."));
        }
    }
}

