/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.util.GitUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;
import org.jenkinsci.plugins.gitclient.GitClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmoduleCombinator {
    GitClient git;
    File workspace;
    TaskListener listener;
    long tid = new Date().getTime();
    long idx = 1L;
    Collection<SubmoduleConfig> submoduleConfig;

    public SubmoduleCombinator(GitClient git, TaskListener listener, File workspace, Collection<SubmoduleConfig> cfg) {
        this.git = git;
        this.listener = listener;
        this.workspace = workspace;
        this.submoduleConfig = cfg;
    }

    public void createSubmoduleCombinations() throws GitException, IOException {
        HashMap<IndexEntry, Collection<Revision>> moduleBranches = new HashMap<IndexEntry, Collection<Revision>>();
        for (IndexEntry indexEntry : this.git.getSubmodules("HEAD")) {
            GitClient subGit = this.git.subGit(indexEntry.getFile());
            GitUtils gu = new GitUtils(this.listener, subGit);
            Collection items = gu.filterTipBranches((Collection)gu.getAllBranchRevisions());
            this.filterRevisions(indexEntry.getFile(), items);
            moduleBranches.put(indexEntry, items);
        }
        for (Map.Entry entry : moduleBranches.entrySet()) {
            this.listener.getLogger().print("Submodule " + ((IndexEntry)entry.getKey()).getFile() + " branches");
            for (Revision br : (Collection)entry.getValue()) {
                this.listener.getLogger().print(" " + br.toString());
            }
            this.listener.getLogger().print('\n');
        }
        List<Map<IndexEntry, Revision>> combinations = this.createCombinations(moduleBranches);
        this.listener.getLogger().println("There are " + combinations.size() + " submodule/revision combinations possible");
        HashMap<ObjectId, List> hashMap = new HashMap<ObjectId, List>();
        for (ObjectId sha1 : this.git.revListAll()) {
            List entries = this.git.getSubmodules(sha1.name());
            hashMap.put(sha1, entries);
        }
        block4: for (List entries : hashMap.values()) {
            Iterator<Map<IndexEntry, Revision>> it = combinations.iterator();
            while (it.hasNext()) {
                Map<IndexEntry, Revision> item = it.next();
                if (!this.matches(item, entries)) continue;
                it.remove();
                continue block4;
            }
        }
        this.listener.getLogger().println("There are " + combinations.size() + " configurations that could be generated.");
        ObjectId headSha1 = this.git.revParse("HEAD");
        for (Map<IndexEntry, Revision> combination : combinations) {
            ObjectId sha1 = headSha1;
            int min = Integer.MAX_VALUE;
            for (Map.Entry entry : hashMap.entrySet()) {
                int value = this.difference(combination, (List)entry.getValue());
                if (value > 0 && value < min) {
                    min = value;
                    sha1 = (ObjectId)entry.getKey();
                }
                if (min != 1) continue;
                break;
            }
            this.git.checkout(sha1.name());
            this.makeCombination(combination);
        }
    }

    private Collection<Revision> filterRevisions(String name, Collection<Revision> items) {
        SubmoduleConfig config = this.getSubmoduleConfig(name);
        if (config == null) {
            return items;
        }
        Iterator<Revision> it = items.iterator();
        while (it.hasNext()) {
            Revision r = it.next();
            if (config.revisionMatchesInterest(r)) continue;
            it.remove();
        }
        return items;
    }

    private SubmoduleConfig getSubmoduleConfig(String name) {
        for (SubmoduleConfig config : this.submoduleConfig) {
            if (!config.getSubmoduleName().equals(name)) continue;
            return config;
        }
        return null;
    }

    protected void makeCombination(Map<IndexEntry, Revision> settings) {
        String name = "combine-" + this.tid + "-" + this.idx++;
        this.git.branch(name);
        this.git.checkout(name);
        StringBuilder commit = new StringBuilder("Jenkins generated combination of:\n");
        for (Map.Entry<IndexEntry, Revision> setting : settings.entrySet()) {
            commit.append(' ').append(' ');
            commit.append(setting.getKey().getFile());
            commit.append(' ');
            commit.append(setting.getValue());
            commit.append('\n');
        }
        this.listener.getLogger().print(commit);
        for (Map.Entry<IndexEntry, Revision> setting : settings.entrySet()) {
            IndexEntry submodule = setting.getKey();
            Revision branch = setting.getValue();
            GitClient subGit = this.git.subGit(submodule.getFile());
            subGit.checkout(branch.getSha1().name());
            this.git.add(submodule.getFile());
        }
        this.git.commit(commit.toString());
    }

    public int difference(Map<IndexEntry, Revision> item, List<IndexEntry> entries) {
        int difference = 0;
        if (entries.size() != item.keySet().size()) {
            return -1;
        }
        for (IndexEntry entry : entries) {
            Revision b = null;
            for (IndexEntry e : item.keySet()) {
                if (!e.getFile().equals(entry.getFile())) continue;
                b = item.get(e);
            }
            if (b == null) {
                return -1;
            }
            if (entry.getObject().equals(b.getSha1())) continue;
            ++difference;
        }
        return difference;
    }

    protected boolean matches(Map<IndexEntry, Revision> item, List<IndexEntry> entries) {
        return this.difference(item, entries) == 0;
    }

    public List<Map<IndexEntry, Revision>> createCombinations(Map<IndexEntry, Collection<Revision>> moduleBranches) {
        if (moduleBranches.keySet().size() == 0) {
            return new ArrayList<Map<IndexEntry, Revision>>();
        }
        ArrayList<Map<IndexEntry, Revision>> thisLevel = new ArrayList<Map<IndexEntry, Revision>>();
        IndexEntry e = moduleBranches.keySet().iterator().next();
        for (Revision b : moduleBranches.remove(e)) {
            HashMap<IndexEntry, Revision> result = new HashMap<IndexEntry, Revision>();
            result.put(e, b);
            thisLevel.add(result);
        }
        List<Map<IndexEntry, Revision>> children = this.createCombinations(moduleBranches);
        if (children.size() == 0) {
            return thisLevel;
        }
        ArrayList<Map<IndexEntry, Revision>> result = new ArrayList<Map<IndexEntry, Revision>>();
        for (Map map : thisLevel) {
            for (Map<IndexEntry, Revision> childLevelEntry : children) {
                HashMap<IndexEntry, Revision> r = new HashMap<IndexEntry, Revision>();
                r.putAll(map);
                r.putAll(childLevelEntry);
                result.add(r);
            }
        }
        return result;
    }
}

