/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Messages;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public class UserRemoteConfig
extends AbstractDescribableImpl<UserRemoteConfig>
implements Serializable {
    private String name;
    private String refspec;
    private String url;

    @DataBoundConstructor
    public UserRemoteConfig(String url, String name, String refspec) {
        this.url = StringUtils.trim((String)url);
        this.name = name;
        this.refspec = refspec;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getRefspec() {
        return this.refspec;
    }

    @Exported
    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return this.getRefspec() + " => " + this.getUrl() + " (" + this.getName() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<UserRemoteConfig> {
        public FormValidation doCheckUrl(@QueryParameter String value) throws IOException, InterruptedException {
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)"Please enter Git repository.");
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            if (!Jenkins.getInstance().hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            EnvVars environment = new EnvVars(System.getenv());
            GitClient git = Git.with((TaskListener)TaskListener.NULL, (EnvVars)environment).using(GitTool.getDefaultInstallation().getGitExe()).getClient();
            try {
                git.getHeadRev(url, "HEAD");
            }
            catch (GitException e) {
                return FormValidation.error((String)Messages.UserRemoteConfig_FailedToConnect(e.getMessage()));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "";
        }
    }
}

