/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.thoughtworks.xstream.converters.Converter;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Items;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitTagAction;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.ObjectIdConverter;
import hudson.plugins.git.RemoteConfigConverter;
import hudson.plugins.git.Revision;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.SubmoduleCombinator;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GitWeb;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.plugins.git.util.GitUtils;
import hudson.plugins.git.util.MergeBuild;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.triggers.SCMTrigger;
import hudson.util.FormValidation;
import hudson.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends SCM
implements Serializable {
    @Deprecated
    transient String source;
    @Deprecated
    transient String branch;
    private Long configVersion;
    private List<UserRemoteConfig> userRemoteConfigs;
    private transient List<RemoteConfig> remoteRepositories;
    private List<BranchSpec> branches;
    private String localBranch;
    private UserMergeOptions userMergeOptions;
    private transient PreBuildMergeOptions mergeOptions;
    private boolean disableSubmodules;
    private boolean recursiveSubmodules;
    private boolean doGenerateSubmoduleConfigurations;
    private boolean authorOrCommitter;
    private boolean clean;
    private boolean wipeOutWorkspace;
    private boolean pruneBranches;
    private boolean remotePoll;
    private boolean ignoreNotifyCommit;
    private boolean useShallowClone;
    private transient String choosingStrategy;
    private BuildChooser buildChooser;
    public String gitTool = null;
    private GitRepositoryBrowser browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_COMMIT = "GIT_COMMIT";
    public static final String GIT_PREVIOUS_COMMIT = "GIT_PREVIOUS_COMMIT";
    private String relativeTargetDir;
    private String reference;
    private String excludedRegions;
    private String excludedUsers;
    private String gitConfigName;
    private String gitConfigEmail;
    private boolean skipTag;
    private String includedRegions;
    private String scmName;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(GitSCM.class.getName());
    public static boolean VERBOSE = Boolean.getBoolean(GitSCM.class.getName() + ".verbose");

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    private static List<UserRemoteConfig> createRepoList(String url) {
        ArrayList<UserRemoteConfig> repoList = new ArrayList<UserRemoteConfig>();
        repoList.add(new UserRemoteConfig(url, null, null));
        return repoList;
    }

    public GitSCM(String repositoryUrl) {
        this(null, GitSCM.createRepoList(repositoryUrl), Collections.singletonList(new BranchSpec("")), null, false, Collections.emptyList(), false, false, new DefaultBuildChooser(), null, null, false, null, null, null, null, null, false, false, false, false, null, null, false, null, false, false);
    }

    @DataBoundConstructor
    public GitSCM(String scmName, List<UserRemoteConfig> userRemoteConfigs, List<BranchSpec> branches, UserMergeOptions userMergeOptions, Boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, boolean clean, boolean wipeOutWorkspace, BuildChooser buildChooser, GitRepositoryBrowser browser, String gitTool, boolean authorOrCommitter, String relativeTargetDir, String reference, String excludedRegions, String excludedUsers, String localBranch, boolean disableSubmodules, boolean recursiveSubmodules, boolean pruneBranches, boolean remotePoll, String gitConfigName, String gitConfigEmail, boolean skipTag, String includedRegions, boolean ignoreNotifyCommit, boolean useShallowClone) {
        this.scmName = scmName;
        if (branches == null) {
            branches = new ArrayList<BranchSpec>();
        }
        if (branches.isEmpty()) {
            branches.add(new BranchSpec("*/master"));
        }
        this.branches = branches;
        this.localBranch = Util.fixEmptyAndTrim((String)localBranch);
        this.userRemoteConfigs = userRemoteConfigs;
        this.userMergeOptions = userMergeOptions;
        this.updateFromUserData();
        this.browser = browser;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations != null ? doGenerateSubmoduleConfigurations : false;
        if (submoduleCfg == null) {
            submoduleCfg = new ArrayList<SubmoduleConfig>();
        }
        this.submoduleCfg = submoduleCfg;
        this.clean = clean;
        this.wipeOutWorkspace = wipeOutWorkspace;
        this.configVersion = 2L;
        this.gitTool = gitTool;
        this.authorOrCommitter = authorOrCommitter;
        this.buildChooser = buildChooser;
        this.relativeTargetDir = relativeTargetDir;
        this.reference = reference;
        this.excludedRegions = excludedRegions;
        this.excludedUsers = excludedUsers;
        this.disableSubmodules = disableSubmodules;
        this.recursiveSubmodules = recursiveSubmodules;
        this.pruneBranches = pruneBranches;
        this.ignoreNotifyCommit = ignoreNotifyCommit;
        this.useShallowClone = useShallowClone;
        if (remotePoll && (branches.size() != 1 || branches.get(0).getName().contains("*") || userRemoteConfigs.size() != 1 || excludedRegions != null && excludedRegions.length() > 0 || submoduleCfg.size() != 0 || excludedUsers != null && excludedUsers.length() > 0)) {
            LOGGER.log(Level.WARNING, "Cannot poll remotely with current configuration.");
            this.remotePoll = false;
        } else {
            this.remotePoll = remotePoll;
        }
        this.gitConfigName = gitConfigName;
        this.gitConfigEmail = gitConfigEmail;
        this.skipTag = skipTag;
        this.includedRegions = includedRegions;
        buildChooser.gitSCM = this;
    }

    private void updateFromUserData() throws GitException {
        try {
            String[] pUrls = new String[this.userRemoteConfigs.size()];
            String[] repoNames = new String[this.userRemoteConfigs.size()];
            String[] refSpecs = new String[this.userRemoteConfigs.size()];
            for (int i = 0; i < this.userRemoteConfigs.size(); ++i) {
                pUrls[i] = this.userRemoteConfigs.get(i).getUrl();
                repoNames[i] = this.userRemoteConfigs.get(i).getName();
                refSpecs[i] = this.userRemoteConfigs.get(i).getRefspec();
            }
            this.remoteRepositories = DescriptorImpl.createRepositoryConfigurations(pUrls, repoNames, refSpecs);
        }
        catch (IOException e1) {
            throw new GitException("Error creating repositories", (Throwable)e1);
        }
        try {
            this.mergeOptions = DescriptorImpl.createMergeOptions(this.userMergeOptions, this.remoteRepositories);
            if (this.userMergeOptions != null) {
                this.userMergeOptions = new UserMergeOptions(this.userMergeOptions.getMergeRemote(), this.userMergeOptions.getMergeTarget());
            }
        }
        catch (Descriptor.FormException ex) {
            throw new GitException("Error creating JGit merge options", (Throwable)ex);
        }
    }

    public Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.source != null) {
            this.remoteRepositories = new ArrayList<RemoteConfig>();
            this.branches = new ArrayList<BranchSpec>();
            this.doGenerateSubmoduleConfigurations = false;
            this.mergeOptions = new PreBuildMergeOptions();
            this.recursiveSubmodules = false;
            this.remoteRepositories.add(this.newRemoteConfig("origin", this.source, new RefSpec("+refs/heads/*:refs/remotes/origin/*")));
            if (this.branch != null) {
                this.branches.add(new BranchSpec(this.branch));
            } else {
                this.branches.add(new BranchSpec("*/master"));
            }
        }
        if (this.configVersion < 1L && this.branches != null) {
            for (BranchSpec branchSpec : this.branches) {
                String name = branchSpec.getName();
                name = name.replace("*", "**");
                branchSpec.setName(name);
            }
        }
        if (this.mergeOptions != null && this.userMergeOptions == null && this.mergeOptions.doMerge()) {
            this.userMergeOptions = new UserMergeOptions(this.mergeOptions.getRemoteBranchName(), this.mergeOptions.getMergeTarget());
        }
        if (this.remoteRepositories != null && this.userRemoteConfigs == null) {
            this.userRemoteConfigs = new ArrayList<UserRemoteConfig>();
            for (RemoteConfig cfg : this.remoteRepositories) {
                String url = "";
                if (cfg.getURIs().size() > 0 && cfg.getURIs().get(0) != null) {
                    url = ((URIish)cfg.getURIs().get(0)).toPrivateString();
                }
                String refspec = "";
                if (cfg.getFetchRefSpecs().size() > 0 && cfg.getFetchRefSpecs().get(0) != null) {
                    refspec = ((RefSpec)cfg.getFetchRefSpecs().get(0)).toString();
                }
                this.userRemoteConfigs.add(new UserRemoteConfig(url, cfg.getName(), refspec));
            }
        }
        if (this.remoteRepositories == null || this.mergeOptions == null) {
            try {
                this.updateFromUserData();
            }
            catch (GitException e) {
                LOGGER.log(Level.WARNING, "Failed to load SCM data", e);
                this.mergeOptions = new PreBuildMergeOptions();
            }
        }
        if (this.mergeOptions.doMerge() && this.mergeOptions.getMergeRemote() == null) {
            this.mergeOptions.setMergeRemote(this.remoteRepositories.get(0));
        }
        if (this.choosingStrategy != null && this.buildChooser == null) {
            for (BuildChooserDescriptor d : BuildChooser.all()) {
                if (!this.choosingStrategy.equals(d.getLegacyId())) continue;
                try {
                    this.buildChooser = (BuildChooser)d.clazz.newInstance();
                }
                catch (InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
            }
        }
        if (this.buildChooser == null) {
            this.buildChooser = new DefaultBuildChooser();
        }
        this.buildChooser.gitSCM = this;
        return this;
    }

    public String getIncludedRegions() {
        return this.includedRegions;
    }

    public String[] getIncludedRegionsNormalized() {
        return this.includedRegions == null || this.includedRegions.trim().equals("") ? null : this.includedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getIncludedRegionsPatterns() {
        String[] included = this.getIncludedRegionsNormalized();
        return this.getRegionsPatterns(included);
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null || this.excludedRegions.trim().equals("") ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excluded = this.getExcludedRegionsNormalized();
        return this.getRegionsPatterns(excluded);
    }

    private Pattern[] getRegionsPatterns(String[] regions) {
        if (regions != null) {
            Pattern[] patterns = new Pattern[regions.length];
            int i = 0;
            for (String region : regions) {
                patterns[i++] = Pattern.compile(region);
            }
            return patterns;
        }
        return new Pattern[0];
    }

    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedUsersNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedUsers);
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        for (String user : s.split("[\\r\\n]+")) {
            users.add(user.trim());
        }
        return users;
    }

    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public String getGitConfigName() {
        return this.gitConfigName;
    }

    public String getGitConfigEmail() {
        return this.gitConfigEmail;
    }

    public String getReference() {
        return this.reference;
    }

    public String getGitConfigNameToUse() {
        String confName = Util.fixEmptyAndTrim((String)this.gitConfigName);
        if (confName == null) {
            String globalConfigName = ((DescriptorImpl)this.getDescriptor()).getGlobalConfigName();
            confName = Util.fixEmptyAndTrim((String)globalConfigName);
        }
        return confName;
    }

    public String getGitConfigEmailToUse() {
        String confEmail = Util.fixEmptyAndTrim((String)this.gitConfigEmail);
        if (confEmail == null) {
            String globalConfigEmail = ((DescriptorImpl)this.getDescriptor()).getGlobalConfigEmail();
            confEmail = Util.fixEmptyAndTrim((String)globalConfigEmail);
        }
        return confEmail;
    }

    public boolean isCreateAccountBasedOnEmail() {
        DescriptorImpl gitDescriptor = (DescriptorImpl)this.getDescriptor();
        return gitDescriptor != null && gitDescriptor.isCreateAccountBasedOnEmail();
    }

    public boolean getSkipTag() {
        return this.skipTag;
    }

    public boolean getPruneBranches() {
        return this.pruneBranches;
    }

    public boolean getRemotePoll() {
        return this.remotePoll;
    }

    public boolean getWipeOutWorkspace() {
        return this.wipeOutWorkspace;
    }

    public boolean getClean() {
        return this.clean;
    }

    public boolean isIgnoreNotifyCommit() {
        return this.ignoreNotifyCommit;
    }

    public boolean getUseShallowClone() {
        return this.useShallowClone;
    }

    public BuildChooser getBuildChooser() {
        return this.buildChooser;
    }

    public void setBuildChooser(BuildChooser buildChooser) {
        this.buildChooser = buildChooser;
    }

    public List<RemoteConfig> getParamExpandedRepos(AbstractBuild<?, ?> build) {
        ArrayList<RemoteConfig> expandedRepos = new ArrayList<RemoteConfig>();
        for (RemoteConfig oldRepo : Util.fixNull(this.remoteRepositories)) {
            expandedRepos.add(this.newRemoteConfig(this.getParameterString(oldRepo.getName(), build), this.getParameterString(((URIish)oldRepo.getURIs().get(0)).toPrivateString(), build), new RefSpec(this.getRefSpec(oldRepo, build))));
        }
        return expandedRepos;
    }

    public RemoteConfig getRepositoryByName(String repoName) {
        for (RemoteConfig r : this.getRepositories()) {
            if (!r.getName().equals(repoName)) continue;
            return r;
        }
        return null;
    }

    @Exported
    public List<UserRemoteConfig> getUserRemoteConfigs() {
        return Collections.unmodifiableList(this.userRemoteConfigs);
    }

    @Exported
    public List<RemoteConfig> getRepositories() {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        return this.remoteRepositories;
    }

    public String getGitTool() {
        return this.gitTool;
    }

    private String getParameterString(String original, AbstractBuild<?, ?> build) {
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            original = parameters.substitute(build, original);
        }
        return original;
    }

    private String getRefSpec(RemoteConfig repo, AbstractBuild<?, ?> build) {
        String refSpec = ((RefSpec)repo.getFetchRefSpecs().get(0)).toString();
        return this.getParameterString(refSpec, build);
    }

    private String getSingleBranch(AbstractBuild<?, ?> build) {
        if (this.getBranches().size() != 1 || this.getRepositories().size() != 1) {
            return null;
        }
        String branch = this.getBranches().get(0).getName();
        String repository = this.getRepositories().get(0).getName();
        if (branch.startsWith("*/")) {
            branch = repository + branch.substring(1);
        }
        if (branch.contains("*")) {
            return null;
        }
        if ((branch = this.getParameterString(branch, build)).equals("")) {
            branch = "**";
        }
        return branch;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> abstractBuild, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    public boolean requiresWorkspaceForPolling() {
        return !this.remotePoll;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        try {
            return this.compareRemoteRevisionWithImpl(project, launcher, workspace, listener, baseline);
        }
        catch (GitException e) {
            throw new IOException(e);
        }
    }

    private PollingResult compareRemoteRevisionWithImpl(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, final TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        BuildChooserContextImpl context;
        String gitExe;
        listener.getLogger().println("Using strategy: " + this.buildChooser.getDisplayName());
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("[poll] No previous build, so forcing an initial build.");
            return PollingResult.BUILD_NOW;
        }
        listener.getLogger().println("[poll] Last Build : #" + lastBuild.getNumber());
        final BuildData buildData = this.fixNull(this.getBuildData((Run)lastBuild, false));
        if (buildData.lastBuild != null) {
            listener.getLogger().println("[poll] Last Built Revision: " + buildData.lastBuild.revision);
        }
        final String singleBranch = this.getSingleBranch(lastBuild);
        if (this.remotePoll && singleBranch != null && buildData.lastBuild != null && buildData.lastBuild.getRevision() != null) {
            String gitRepo;
            EnvVars environment = GitUtils.getPollEnvironment(project, workspace, launcher, listener, false);
            GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).using(this.getGitExe((Node)Jenkins.getInstance(), environment, listener)).getClient();
            ObjectId head = git.getHeadRev(gitRepo = ((URIish)this.getParamExpandedRepos(lastBuild).get(0).getURIs().get(0)).toString(), this.getBranches().get(0).getName());
            if (head != null && buildData.lastBuild.getRevision().getSha1().name().equals(head.name())) {
                return PollingResult.NO_CHANGES;
            }
            return PollingResult.BUILD_NOW;
        }
        Label label = project.getAssignedLabel();
        if (label != null && label.isSelfLabel()) {
            if (label.getNodes().iterator().next() != project.getLastBuiltOn()) {
                listener.getLogger().println("Last build was not on tied node, forcing rebuild.");
                return PollingResult.BUILD_NOW;
            }
            gitExe = this.getGitExe((Node)label.getNodes().iterator().next(), listener);
        } else {
            gitExe = this.getGitExe(project.getLastBuiltOn(), listener);
        }
        final EnvVars environment = GitUtils.getPollEnvironment(project, workspace, launcher, listener);
        FilePath workingDirectory = this.workingDirectory(workspace, environment);
        if (workingDirectory == null || !workingDirectory.exists()) {
            return PollingResult.BUILD_NOW;
        }
        final List<RemoteConfig> paramRepos = this.getParamExpandedRepos(lastBuild);
        boolean pollChangesResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>((BuildChooserContext)(context = new BuildChooserContextImpl(project, null))){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ BuildChooserContext val$context;
            {
                this.val$context = buildChooserContext;
            }

            public Boolean invoke(File localWorkspace, VirtualChannel channel) throws IOException, InterruptedException {
                GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).in(localWorkspace).using(gitExe).getClient();
                if (git.hasGitRepo()) {
                    listener.getLogger().println("Fetching changes from the remote Git repositories");
                    for (RemoteConfig remoteRepository : paramRepos) {
                        GitSCM.this.fetchFrom(git, listener, remoteRepository);
                    }
                    listener.getLogger().println("Polling for changes in");
                    Collection<Revision> origCandidates = GitSCM.this.buildChooser.getCandidateRevisions(true, singleBranch, git, listener, buildData, this.val$context);
                    ArrayList<Revision> candidates = new ArrayList<Revision>();
                    for (Revision c : origCandidates) {
                        if (GitSCM.this.isRevExcluded(git, c, listener, buildData)) continue;
                        candidates.add(c);
                    }
                    return candidates.size() > 0;
                }
                listener.getLogger().println("No Git repository yet, an initial checkout is required");
                return true;
            }
        });
        return pollChangesResult ? PollingResult.SIGNIFICANT : PollingResult.NO_CHANGES;
    }

    private BuildData fixNull(BuildData bd) {
        return bd != null ? bd : new BuildData(this.getScmName(), this.getUserRemoteConfigs());
    }

    private void cleanSubmodules(GitClient parentGit, File workspace, TaskListener listener, RemoteConfig remoteRepository) {
        List submodules = parentGit.getSubmodules("HEAD");
        for (IndexEntry submodule : submodules) {
            String subdir = submodule.getFile();
            try {
                listener.getLogger().println("Trying to clean submodule in " + subdir);
                GitClient subGit = parentGit.subGit(subdir);
                subGit.clean();
            }
            catch (Exception ex) {
                listener.getLogger().println("Problem cleaning submodule in " + subdir + " - could be unavailable. Continuing anyway");
            }
        }
    }

    private boolean fetchFrom(GitClient git, TaskListener listener, RemoteConfig remoteRepository) {
        try {
            git.fetch(remoteRepository.getName(), (RefSpec)remoteRepository.getFetchRefSpecs().get(0));
            return true;
        }
        catch (GitException ex) {
            ex.printStackTrace(listener.error("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway"));
            return false;
        }
    }

    private RemoteConfig newRemoteConfig(String name, String refUrl, RefSpec refSpec) {
        try {
            Config repoConfig = new Config();
            repoConfig.setString("remote", name, "url", refUrl);
            repoConfig.setString("remote", name, "fetch", refSpec.toString());
            return (RemoteConfig)RemoteConfig.getAllRemoteConfigs((Config)repoConfig).get(0);
        }
        catch (Exception ex) {
            throw new GitException("Error trying to create JGit configuration", (Throwable)ex);
        }
    }

    public GitTool resolveGitTool() {
        if (this.gitTool == null) {
            return GitTool.getDefaultInstallation();
        }
        return ((GitTool.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallation(this.gitTool);
    }

    public String getGitExe(Node builtOn, TaskListener listener) {
        return this.getGitExe(builtOn, null, listener);
    }

    public String getGitExe(Node builtOn, EnvVars env, TaskListener listener) {
        GitTool tool = this.resolveGitTool();
        if (builtOn != null) {
            try {
                tool = tool.forNode(builtOn, listener);
            }
            catch (IOException e) {
                listener.getLogger().println("Failed to get git executable");
            }
            catch (InterruptedException e) {
                listener.getLogger().println("Failed to get git executable");
            }
        }
        if (env != null) {
            tool = tool.forEnvironment(env);
        }
        return tool.getGitExe();
    }

    public boolean getAuthorOrCommitter() {
        return this.authorOrCommitter;
    }

    public AbstractBuild<?, ?> getBySHA1(String sha1) {
        AbstractProject p = (AbstractProject)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
        for (AbstractBuild b : p.getBuilds()) {
            Build lb;
            BuildData d = (BuildData)b.getAction(BuildData.class);
            if (d == null || d.lastBuild == null || !(lb = d.lastBuild).isFor(sha1)) continue;
            return b;
        }
        return null;
    }

    private Revision determineRevisionToBuild(AbstractBuild build, final BuildData buildData, final List<RemoteConfig> repos, FilePath workingDirectory, final EnvVars environment, final String gitExe, final BuildListener listener) throws IOException, InterruptedException {
        Collection candidates;
        BuildData parentBuildData;
        MatrixBuild parentBuild;
        Revision tempParentLastBuiltRev = null;
        if (build instanceof MatrixRun && (parentBuild = ((MatrixRun)build).getParentBuild()) != null && (parentBuildData = this.getBuildData((Run)parentBuild, false)) != null) {
            tempParentLastBuiltRev = parentBuildData.getLastBuiltRevision();
        }
        final Revision parentLastBuiltRev = tempParentLastBuiltRev;
        final String singleBranch = environment.expand(this.getSingleBranch(build));
        final RevisionParameterAction rpa = (RevisionParameterAction)build.getAction(RevisionParameterAction.class);
        final BuildChooserContextImpl context = new BuildChooserContextImpl(build.getProject(), build);
        PrintStream logger = listener.getLogger();
        if (this.useShallowClone) {
            logger.println("Using shallow clone");
        }
        if ((candidates = (Collection)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Collection<Revision>>(){
            private static final long serialVersionUID = 1L;

            public Collection<Revision> invoke(File localWorkspace, VirtualChannel channel) throws IOException, InterruptedException {
                FilePath ws = new FilePath(localWorkspace);
                PrintStream log = listener.getLogger();
                GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).in(localWorkspace).using(gitExe).getClient();
                if (GitSCM.this.wipeOutWorkspace) {
                    log.println("Wiping out workspace first.");
                    try {
                        ws.deleteContents();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (git.hasGitRepo()) {
                    if (repos.size() == 1) {
                        log.println("Fetching changes from 1 remote Git repository");
                    } else {
                        log.println(MessageFormat.format("Fetching changes from {0} remote Git repositories", repos.size()));
                    }
                    boolean fetched = false;
                    for (RemoteConfig remoteRepository : repos) {
                        if (!GitSCM.this.fetchFrom(git, (TaskListener)listener, remoteRepository)) continue;
                        fetched = true;
                    }
                    if (!fetched) {
                        listener.error("Could not fetch from any repository");
                        throw new GitException("Could not fetch from any repository");
                    }
                    if (GitSCM.this.pruneBranches) {
                        log.println("Pruning obsolete local branches");
                        for (RemoteConfig remoteRepository : repos) {
                            git.prune(remoteRepository);
                        }
                    }
                } else {
                    log.println("Cloning the remote Git repository");
                    boolean successfullyCloned = false;
                    for (RemoteConfig rc : repos) {
                        try {
                            git.clone(((URIish)rc.getURIs().get(0)).toPrivateString(), rc.getName(), GitSCM.this.useShallowClone, GitSCM.this.reference);
                            successfullyCloned = true;
                            break;
                        }
                        catch (GitException ex) {
                            ex.printStackTrace(listener.error("Error cloning remote repo '%s' : %s", new Object[]{rc.getName(), ex.getMessage()}));
                            log.println("Trying next repository");
                        }
                    }
                    if (!successfullyCloned) {
                        listener.error("Could not clone repository");
                        throw new GitException("Could not clone");
                    }
                    boolean fetched = false;
                    for (RemoteConfig remoteRepository : repos) {
                        try {
                            git.fetch(remoteRepository.getName(), (RefSpec)remoteRepository.getFetchRefSpecs().get(0));
                            fetched = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace(listener.error("Problem fetching from " + remoteRepository.getName() + " / " + remoteRepository.getName() + " - could be unavailable. Continuing anyway."));
                        }
                    }
                    if (!fetched) {
                        listener.error("Could not fetch from any repository");
                        throw new GitException("Could not fetch from any repository");
                    }
                    if (GitSCM.this.getClean()) {
                        log.println("Cleaning workspace");
                        git.clean();
                        if (git.hasGitModules() && !GitSCM.this.disableSubmodules) {
                            git.submoduleClean(GitSCM.this.recursiveSubmodules);
                        }
                    }
                }
                if (parentLastBuiltRev != null) {
                    return Collections.singleton(parentLastBuiltRev);
                }
                if (rpa != null) {
                    return Collections.singleton(rpa.toRevision(git));
                }
                return GitSCM.this.buildChooser.getCandidateRevisions(false, singleBranch, git, (TaskListener)listener, buildData, context);
            }
        })).size() == 0) {
            logger.println("No candidate revisions");
            return null;
        }
        if (candidates.size() > 1) {
            logger.println("Multiple candidate revisions");
            AbstractProject project = build.getProject();
            if (!project.isDisabled()) {
                logger.println("Scheduling another build to catch up with " + project.getFullDisplayName());
                if (!project.scheduleBuild(0, (Cause)new SCMTrigger.SCMTriggerCause())) {
                    logger.println("WARNING: multiple candidate revisions, but unable to schedule build of " + project.getFullDisplayName());
                }
            }
        }
        return (Revision)candidates.iterator().next();
    }

    public boolean checkout(final AbstractBuild build, Launcher launcher, FilePath workspace, final BuildListener listener, File _changelogFile) throws IOException, InterruptedException {
        final EnvVars environment = build.getEnvironment((TaskListener)listener);
        final FilePath changelogFile = new FilePath(_changelogFile);
        listener.getLogger().println("Checkout:" + workspace.getName() + " / " + workspace.getRemote() + " - " + workspace.getChannel());
        listener.getLogger().println("Using strategy: " + this.buildChooser.getDisplayName());
        FilePath workingDirectory = this.workingDirectory(workspace, environment);
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
        String projectName = build.getProject().getName();
        final int buildNumber = build.getNumber();
        final String gitExe = this.getGitExe(build.getBuiltOn(), (TaskListener)listener);
        final String buildnumber = "jenkins-" + projectName + "-" + buildNumber;
        final BuildData buildData = this.getBuildData(build.getPreviousBuild(), true);
        if (buildData.lastBuild != null) {
            listener.getLogger().println("Last Built Revision: " + buildData.lastBuild.revision);
        }
        final String paramLocalBranch = this.getParamLocalBranch(build);
        List<RemoteConfig> paramRepos = this.getParamExpandedRepos(build);
        final Revision revToBuild = this.determineRevisionToBuild(build, buildData, paramRepos, workingDirectory, environment, gitExe, listener);
        if (revToBuild == null) {
            listener.error("Couldn't find any revision to build. Verify the repository and branch configuration for this job.");
            return false;
        }
        listener.getLogger().println("Commencing build of " + revToBuild);
        environment.put(GIT_COMMIT, revToBuild.getSha1String());
        Branch branch = (Branch)revToBuild.getBranches().iterator().next();
        environment.put(GIT_BRANCH, branch.getName());
        final BuildChooserContextImpl context = new BuildChooserContextImpl(build.getProject(), build);
        final String remoteBranchName = this.getParameterString(this.mergeOptions.getRemoteBranchName(), build);
        Build returnedBuildData = this.mergeOptions.doMerge() && !revToBuild.containsBranchName(remoteBranchName) ? (Build)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Build>(){
            private static final long serialVersionUID = 1L;

            public Build invoke(File localWorkspace, VirtualChannel channel) throws IOException, InterruptedException {
                GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).in(localWorkspace).using(gitExe).getClient();
                listener.getLogger().println("Merging " + revToBuild + " onto " + GitSCM.this.getParameterString(GitSCM.this.mergeOptions.getMergeTarget(), build));
                ObjectId target = git.revParse(remoteBranchName);
                GitSCM.this.checkout(git, target, paramLocalBranch);
                try {
                    git.merge(revToBuild.getSha1());
                }
                catch (Exception ex) {
                    GitSCM.this.checkout(git, revToBuild.getSha1(), paramLocalBranch);
                    if (!GitSCM.this.getSkipTag()) {
                        git.tag(buildnumber, "Jenkins Build #" + buildNumber);
                    }
                    buildData.saveBuild(new Build(revToBuild, buildNumber, Result.FAILURE));
                    throw new AbortException("Branch not suitable for integration as it does not merge cleanly");
                }
                if (git.hasGitModules() && !GitSCM.this.disableSubmodules) {
                    git.setupSubmoduleUrls(revToBuild, (TaskListener)listener);
                    git.submoduleUpdate(GitSCM.this.recursiveSubmodules);
                }
                if (!GitSCM.this.getSkipTag()) {
                    git.tag(buildnumber, "Jenkins Build #" + buildNumber);
                }
                GitSCM.this.computeMergeChangeLog(git, revToBuild, remoteBranchName, listener, changelogFile);
                GitUtils gu = new GitUtils((TaskListener)listener, git);
                Revision mergeRevision = gu.getRevisionForSHA1(target);
                MergeBuild build2 = new MergeBuild(revToBuild, buildNumber, mergeRevision, null);
                if (GitSCM.this.getClean()) {
                    listener.getLogger().println("Cleaning workspace");
                    git.clean();
                    if (git.hasGitModules() && !GitSCM.this.disableSubmodules) {
                        git.submoduleClean(GitSCM.this.recursiveSubmodules);
                    }
                }
                return build2;
            }
        }) : (Build)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Build>(){
            private static final long serialVersionUID = 1L;

            public Build invoke(File localWorkspace, VirtualChannel channel) throws IOException, InterruptedException {
                GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).in(localWorkspace).using(gitExe).getClient();
                listener.getLogger().println("Checking out " + revToBuild);
                if (GitSCM.this.getClean()) {
                    listener.getLogger().println("Cleaning workspace");
                    git.clean();
                    if (git.hasGitModules() && !GitSCM.this.disableSubmodules) {
                        git.submoduleClean(GitSCM.this.recursiveSubmodules);
                    }
                }
                GitSCM.this.checkout(git, revToBuild.getSha1(), paramLocalBranch);
                if (git.hasGitModules() && !GitSCM.this.disableSubmodules) {
                    git.setupSubmoduleUrls(revToBuild, (TaskListener)listener);
                    git.submoduleUpdate(GitSCM.this.recursiveSubmodules);
                }
                if (GitSCM.this.doGenerateSubmoduleConfigurations) {
                    SubmoduleCombinator combinator = new SubmoduleCombinator(git, (TaskListener)listener, localWorkspace, GitSCM.this.submoduleCfg);
                    combinator.createSubmoduleCombinations();
                }
                if (!GitSCM.this.getSkipTag()) {
                    git.tag(buildnumber, "Jenkins Build #" + buildNumber);
                }
                GitSCM.this.computeChangeLog(git, revToBuild, listener, buildData, changelogFile, context);
                return new Build(revToBuild, buildNumber, null);
            }
        });
        buildData.saveBuild(returnedBuildData);
        build.addAction((Action)buildData);
        build.addAction((Action)new GitTagAction(build, buildData));
        return true;
    }

    private void checkout(GitClient git, ObjectId commit, String branch) throws GitException {
        git.checkout(commit.name());
        if (branch != null) {
            for (Branch b : git.getBranches()) {
                if (!b.getName().equals(branch)) continue;
                git.deleteBranch(branch);
            }
            git.checkout(commit.name(), branch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeChangeLog(GitClient git, Revision revToBuild, BuildListener listener, BuildData buildData, FilePath changelogFile, BuildChooserContext context) throws IOException, InterruptedException {
        int histories = 0;
        PrintStream out = new PrintStream(changelogFile.write());
        try {
            for (Branch b : revToBuild.getBranches()) {
                Build lastRevWas = this.buildChooser.prevBuildForChangelog(b.getName(), buildData, git, context);
                if (lastRevWas != null) {
                    if (git.isCommitInRepo(lastRevWas.getSHA1())) {
                        this.putChangelogDiffs(git, b.getName(), lastRevWas.getSHA1().name(), revToBuild.getSha1().name(), out);
                        ++histories;
                        continue;
                    }
                    listener.getLogger().println("Could not record history. Previous build's commit, " + lastRevWas.getSHA1().name() + ", does not exist in the current repository.");
                    continue;
                }
                listener.getLogger().println("No change to record in branch " + b.getName());
            }
        }
        catch (GitException ge) {
            out.println("Unable to retrieve changeset");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        if (histories > 1) {
            listener.getLogger().println("Warning : There are multiple branch changesets here");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeMergeChangeLog(GitClient git, Revision revToBuild, String revFrom, BuildListener listener, FilePath changelogFile) throws IOException, InterruptedException {
        if (!git.isCommitInRepo(ObjectId.fromString((String)revFrom))) {
            listener.getLogger().println("Could not record history. Previous build's commit, " + revFrom + ", does not exist in the current repository.");
        } else {
            int histories = 0;
            PrintStream out = new PrintStream(changelogFile.write());
            try {
                for (Branch b : revToBuild.getBranches()) {
                    this.putChangelogDiffs(git, b.getName(), revFrom, revToBuild.getSha1().name(), out);
                    ++histories;
                }
            }
            catch (GitException ge) {
                out.println("Unable to retrieve changeset");
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            if (histories > 1) {
                listener.getLogger().println("Warning : There are multiple branch changesets here");
            }
        }
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        String confEmail;
        String confName;
        Branch branch;
        super.buildEnvVars(build, env);
        Revision rev = this.fixNull(this.getBuildData((Run)build, false)).getLastBuiltRevision();
        String singleBranch = this.getSingleBranch(build);
        if (singleBranch != null) {
            env.put(GIT_BRANCH, singleBranch);
        } else if (rev != null) {
            branch = (Branch)rev.getBranches().iterator().next();
            env.put(GIT_BRANCH, branch.getName());
        }
        if (rev != null) {
            String commit;
            branch = (Branch)rev.getBranches().iterator().next();
            String prevCommit = this.getLastBuiltCommitOfBranch(build, branch);
            if (prevCommit != null) {
                env.put(GIT_PREVIOUS_COMMIT, prevCommit);
            }
            if ((commit = rev.getSha1String()) != null) {
                env.put(GIT_COMMIT, commit);
            }
        }
        if ((confName = this.getGitConfigNameToUse()) != null && !confName.equals("")) {
            env.put("GIT_COMMITTER_NAME", confName);
            env.put("GIT_AUTHOR_NAME", confName);
        }
        if ((confEmail = this.getGitConfigEmailToUse()) != null && !confEmail.equals("")) {
            env.put("GIT_COMMITTER_EMAIL", confEmail);
            env.put("GIT_AUTHOR_EMAIL", confEmail);
        }
    }

    private String getLastBuiltCommitOfBranch(AbstractBuild<?, ?> build, Branch branch) {
        Revision previousRev;
        Build lastBuildOfBranch;
        String prevCommit = null;
        if (build.getPreviousBuiltBuild() != null && (lastBuildOfBranch = this.fixNull(this.getBuildData(build.getPreviousBuiltBuild(), false)).getLastBuildOfBranch(branch.getName())) != null && (previousRev = lastBuildOfBranch.getRevision()) != null) {
            prevCommit = previousRev.getSha1String();
        }
        return prevCommit;
    }

    private void putChangelogDiffs(GitClient git, String branchName, String revFrom, String revTo, PrintStream fos) throws IOException {
        fos.println("Changes in branch " + branchName + ", between " + revFrom + " and " + revTo);
        git.changelog(revFrom, revTo, (OutputStream)fos);
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser(this.getAuthorOrCommitter());
    }

    public String getScmName() {
        return this.scmName;
    }

    public boolean getDisableSubmodules() {
        return this.disableSubmodules;
    }

    public boolean getRecursiveSubmodules() {
        return this.recursiveSubmodules;
    }

    public boolean getDoGenerate() {
        return this.doGenerateSubmoduleConfigurations;
    }

    @Exported
    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    @Exported
    public PreBuildMergeOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public UserMergeOptions getUserMergeOptions() {
        return this.userMergeOptions;
    }

    private boolean isRelevantBuildData(BuildData bd) {
        for (UserRemoteConfig c : this.getUserRemoteConfigs()) {
            if (!bd.hasBeenReferenced(c.getUrl())) continue;
            return true;
        }
        return false;
    }

    public BuildData getBuildData(Run build, boolean clone) {
        BuildData buildData = null;
        while (build != null) {
            List buildDataList = build.getActions(BuildData.class);
            for (BuildData bd : buildDataList) {
                if (bd == null || !this.isRelevantBuildData(bd)) continue;
                buildData = bd;
                break;
            }
            if (buildData != null) break;
            build = build.getPreviousBuild();
        }
        if (buildData == null) {
            return clone ? new BuildData(this.getScmName(), this.getUserRemoteConfigs()) : null;
        }
        if (clone) {
            return buildData.clone();
        }
        return buildData;
    }

    protected FilePath workingDirectory(FilePath workspace) {
        return this.workingDirectory(workspace, null);
    }

    protected FilePath workingDirectory(FilePath workspace, EnvVars environment) {
        if (workspace == null) {
            return null;
        }
        if (this.relativeTargetDir == null || this.relativeTargetDir.length() == 0 || this.relativeTargetDir.equals(".")) {
            return workspace;
        }
        return workspace.child(environment.expand(this.relativeTargetDir));
    }

    public String getLocalBranch() {
        return Util.fixEmpty((String)this.localBranch);
    }

    public String getParamLocalBranch(AbstractBuild<?, ?> build) {
        String branch = this.getLocalBranch();
        return this.getParameterString(branch, build);
    }

    public String getRelativeTargetDir() {
        return this.relativeTargetDir;
    }

    private boolean isRevExcluded(GitClient git, Revision r, TaskListener listener, BuildData buildData) {
        try {
            Pattern[] includedPatterns = this.getIncludedRegionsPatterns();
            Pattern[] excludedPatterns = this.getExcludedRegionsPatterns();
            Set<String> excludedUsers = this.getExcludedUsersNormalized();
            if (includedPatterns.length == 0 && excludedPatterns.length == 0 && excludedUsers.isEmpty()) {
                return false;
            }
            List revShow = buildData != null && buildData.lastBuild != null ? git.showRevision(buildData.lastBuild.revision.getSha1(), r.getSha1()) : git.showRevision(r.getSha1());
            if (revShow.size() == 0) {
                return false;
            }
            GitChangeSet change = new GitChangeSet(revShow, this.authorOrCommitter);
            String author = change.getAuthorName();
            if (excludedUsers.contains(author)) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": Found excluded author: " + author);
                return true;
            }
            ArrayList<String> paths = new ArrayList<String>(change.getAffectedPaths());
            if (paths.isEmpty()) {
                return false;
            }
            ArrayList<Object> includedPaths = new ArrayList();
            if (includedPatterns.length > 0) {
                block2: for (String path : paths) {
                    for (Pattern pattern : includedPatterns) {
                        if (!pattern.matcher(path).matches()) continue;
                        includedPaths.add(path);
                        continue block2;
                    }
                }
            } else {
                includedPaths = paths;
            }
            ArrayList<String> excludedPaths = new ArrayList<String>();
            if (excludedPatterns.length > 0) {
                block4: for (String string : includedPaths) {
                    for (Pattern pattern : excludedPatterns) {
                        if (!pattern.matcher(string).matches()) continue;
                        excludedPaths.add(string);
                        continue block4;
                    }
                }
            }
            if (includedPaths.size() == excludedPaths.size()) {
                listener.getLogger().println("Ignored commit " + r.getSha1String() + ": Found only excluded paths: " + Util.join(excludedPaths, (String)", "));
                return true;
            }
        }
        catch (GitException e) {
            return false;
        }
        return false;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void onLoaded() {
        GitTool.DescriptorImpl gitTools = (GitTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class);
        DescriptorImpl desc = (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
        if (desc.getOldGitExe() != null) {
            String exe = desc.getOldGitExe();
            GitTool tool = gitTools.getInstallation("Default");
            if (tool.getGitExe().equals(exe)) {
                return;
            }
            System.err.println("[WARNING] you're using deprecated gitexe attribute to configure git plugin. Use Git installations");
        }
    }

    @Initializer(before=InitMilestone.JOB_LOADED)
    public static void configureXtream() {
        Run.XSTREAM.registerConverter((Converter)new ObjectIdConverter());
        Items.XSTREAM.registerConverter((Converter)new RemoteConfigConverter(Items.XSTREAM));
        Items.XSTREAM.alias("org.spearce.jgit.transport.RemoteConfig", RemoteConfig.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends SCMDescriptor<GitSCM> {
        private String gitExe;
        private String globalConfigName;
        private String globalConfigEmail;
        private boolean createAccountBasedOnEmail;

        public DescriptorImpl() {
            super(GitSCM.class, GitRepositoryBrowser.class);
            this.load();
        }

        public String getDisplayName() {
            return "Git";
        }

        public List<BuildChooserDescriptor> getBuildChooserDescriptors() {
            return BuildChooser.all();
        }

        public List<GitTool> getGitTools() {
            GitTool[] gitToolInstallations = (GitTool[])((GitTool.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(gitToolInstallations);
        }

        @Deprecated
        public String getGitExe() {
            return this.gitExe;
        }

        public String getGlobalConfigName() {
            return this.globalConfigName;
        }

        public void setGlobalConfigName(String globalConfigName) {
            this.globalConfigName = globalConfigName;
        }

        public String getGlobalConfigEmail() {
            return this.globalConfigEmail;
        }

        public void setGlobalConfigEmail(String globalConfigEmail) {
            this.globalConfigEmail = globalConfigEmail;
        }

        public boolean isCreateAccountBasedOnEmail() {
            return this.createAccountBasedOnEmail;
        }

        public void setCreateAccountBasedOnEmail(boolean createAccountBasedOnEmail) {
            this.createAccountBasedOnEmail = createAccountBasedOnEmail;
        }

        public String getOldGitExe() {
            return this.gitExe;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (SCM)super.newInstance(req, formData);
        }

        private GitRepositoryBrowser getBrowserFromRequest(StaplerRequest req, JSONObject scmData) {
            if (scmData.containsKey((Object)"browser")) {
                return (GitRepositoryBrowser)((Object)req.bindJSON(GitRepositoryBrowser.class, scmData.getJSONObject("browser")));
            }
            return null;
        }

        public static List<RemoteConfig> createRepositoryConfigurations(String[] pUrls, String[] repoNames, String[] refSpecs) throws IOException {
            List remoteRepositories;
            Config repoConfig = new Config();
            String[] urls = pUrls;
            String[] names = repoNames;
            names = GitUtils.fixupNames(names, urls);
            String[] refs = refSpecs;
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    name = name.replace(' ', '_');
                    if (refs[i] == null || refs[i].length() == 0) {
                        refs[i] = "+refs/heads/*:refs/remotes/" + name + "/*";
                    }
                    repoConfig.setString("remote", name, "url", urls[i]);
                    repoConfig.setString("remote", name, "fetch", refs[i]);
                }
            }
            try {
                remoteRepositories = RemoteConfig.getAllRemoteConfigs((Config)repoConfig);
            }
            catch (Exception e) {
                throw new GitException("Error creating repositories", (Throwable)e);
            }
            return remoteRepositories;
        }

        public static PreBuildMergeOptions createMergeOptions(UserMergeOptions mergeOptionsBean, List<RemoteConfig> remoteRepositories) throws Descriptor.FormException {
            PreBuildMergeOptions mergeOptions = new PreBuildMergeOptions();
            if (mergeOptionsBean != null) {
                RemoteConfig mergeRemote = null;
                String mergeRemoteName = mergeOptionsBean.getMergeRemote().trim();
                if (mergeRemoteName.length() == 0) {
                    mergeRemote = remoteRepositories.get(0);
                } else {
                    for (RemoteConfig remote : remoteRepositories) {
                        if (!remote.getName().equals(mergeRemoteName)) continue;
                        mergeRemote = remote;
                        break;
                    }
                }
                if (mergeRemote == null) {
                    throw new Descriptor.FormException("No remote repository configured with name '" + mergeRemoteName + "'", "git.mergeRemote");
                }
                mergeOptions.setMergeRemote(mergeRemote);
                mergeOptions.setMergeTarget(mergeOptionsBean.getMergeTarget());
            }
            return mergeOptions;
        }

        public static GitWeb createGitWeb(String url) {
            GitWeb gitWeb = null;
            String gitWebUrl = url;
            if (gitWebUrl != null && gitWebUrl.length() > 0) {
                try {
                    gitWeb = new GitWeb(gitWebUrl);
                }
                catch (MalformedURLException e) {
                    throw new GitException("Error creating GitWeb", (Throwable)e);
                }
            }
            return gitWeb;
        }

        public FormValidation doGitRemoteNameCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            boolean isMerge;
            String mergeRemoteName = req.getParameter("value");
            boolean bl = isMerge = req.getParameter("isMerge") != null;
            if (mergeRemoteName.length() == 0 && isMerge) {
                return FormValidation.ok();
            }
            String[] urls = req.getParameterValues("repo.url");
            String[] names = req.getParameterValues("repo.name");
            if (urls != null && names != null) {
                for (String name : GitUtils.fixupNames(names, urls)) {
                    if (!name.equals(mergeRemoteName)) continue;
                    return FormValidation.ok();
                }
            }
            return FormValidation.error((String)("No remote repository configured with name '" + mergeRemoteName + "'"));
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BuildChooserContextImpl
    implements BuildChooserContext,
    Serializable {
        final AbstractProject project;
        final AbstractBuild build;

        BuildChooserContextImpl(AbstractProject project, AbstractBuild build) {
            this.project = project;
            this.build = build;
        }

        @Override
        public <T> T actOnBuild(BuildChooserContext.ContextCallable<AbstractBuild<?, ?>, T> callable) throws IOException, InterruptedException {
            return callable.invoke(this.build, (VirtualChannel)Hudson.MasterComputer.localChannel);
        }

        @Override
        public <T> T actOnProject(BuildChooserContext.ContextCallable<AbstractProject<?, ?>, T> callable) throws IOException, InterruptedException {
            return callable.invoke(this.project, (VirtualChannel)Hudson.MasterComputer.localChannel);
        }

        private Object writeReplace() {
            return Channel.current().export(BuildChooserContext.class, (Object)new BuildChooserContext(){

                @Override
                public <T> T actOnBuild(BuildChooserContext.ContextCallable<AbstractBuild<?, ?>, T> callable) throws IOException, InterruptedException {
                    return callable.invoke(BuildChooserContextImpl.this.build, (VirtualChannel)Channel.current());
                }

                @Override
                public <T> T actOnProject(BuildChooserContext.ContextCallable<AbstractProject<?, ?>, T> callable) throws IOException, InterruptedException {
                    return callable.invoke(BuildChooserContextImpl.this.project, (VirtualChannel)Channel.current());
                }
            });
        }
    }
}

