/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.trilead;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.trilead.ssh2.Connection;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.jenkinsci.plugins.gitclient.trilead.CredentialsProviderImpl;
import org.jenkinsci.plugins.gitclient.trilead.JGitConnection;
import org.jenkinsci.plugins.gitclient.trilead.SmartCredentialsProvider;
import org.jenkinsci.plugins.gitclient.trilead.StandardUsernameCredentialsCredentialItem;
import org.jenkinsci.plugins.gitclient.trilead.TrileadSession;
import org.jenkinsci.plugins.gitclient.verifier.AcceptFirstConnectionVerifier;
import org.jenkinsci.plugins.gitclient.verifier.HostKeyVerifierFactory;

public class TrileadSessionFactory
extends SshSessionFactory {
    private static final ReentrantLock JGIT_ACCEPT_FIRST_LOCK = new ReentrantLock();
    private final HostKeyVerifierFactory hostKeyVerifierFactory;
    private final TaskListener listener;

    public TrileadSessionFactory(HostKeyVerifierFactory hostKeyVerifierFactory, TaskListener listener) {
        this.hostKeyVerifierFactory = hostKeyVerifierFactory;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        try {
            boolean authenticated;
            int p = uri.getPort();
            if (p < 0) {
                p = 22;
            }
            JGitConnection con = new JGitConnection(uri.getHost(), p);
            con.setTCPNoDelay(true);
            if (this.hostKeyVerifierFactory instanceof AcceptFirstConnectionVerifier) {
                JGIT_ACCEPT_FIRST_LOCK.lock();
                try {
                    con.connect(this.hostKeyVerifierFactory.forJGit(this.listener));
                }
                finally {
                    JGIT_ACCEPT_FIRST_LOCK.unlock();
                }
            } else {
                con.connect(this.hostKeyVerifierFactory.forJGit(this.listener));
            }
            if (credentialsProvider instanceof SmartCredentialsProvider) {
                SmartCredentialsProvider smart = (SmartCredentialsProvider)credentialsProvider;
                StandardUsernameCredentialsCredentialItem item = new StandardUsernameCredentialsCredentialItem("Credentials for " + uri, false);
                authenticated = smart.supports(item) && smart.get(uri, item) && SSHAuthenticator.newInstance((Object)((Object)con), (StandardUsernameCredentials)item.getValue(), (String)uri.getUser()).authenticate(smart.listener);
            } else if (credentialsProvider instanceof CredentialsProviderImpl) {
                CredentialsProviderImpl sshcp = (CredentialsProviderImpl)credentialsProvider;
                authenticated = SSHAuthenticator.newInstance((Object)((Object)con), (StandardUsernameCredentials)sshcp.cred).authenticate(sshcp.listener);
            } else {
                authenticated = false;
            }
            if (!authenticated && con.isAuthenticationComplete()) {
                throw new TransportException("Authentication failure");
            }
            return this.wrap(con);
        }
        catch (IOException | InterruptedException | UnsupportedCredentialItem e) {
            throw new TransportException(uri, "Failed to connect", e);
        }
    }

    public String getType() {
        return "Jenkins credentials Trilead ssh session factory";
    }

    protected TrileadSession wrap(Connection con) {
        return new TrileadSession(con);
    }
}

