/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.verifier;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.KnownHosts;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.gitclient.verifier.AbstractCliGitHostKeyVerifier;
import org.jenkinsci.plugins.gitclient.verifier.AbstractJGitHostKeyVerifier;
import org.jenkinsci.plugins.gitclient.verifier.HostKeyVerifierFactory;

public class AcceptFirstConnectionVerifier
extends HostKeyVerifierFactory {
    private static final Logger LOGGER = Logger.getLogger(AcceptFirstConnectionVerifier.class.getName());

    @Override
    public AbstractCliGitHostKeyVerifier forCliGit(TaskListener listener) {
        return (AbstractCliGitHostKeyVerifier & Serializable)tempKnownHosts -> {
            listener.getLogger().println("Verifying host key using known hosts file, will automatically accept unseen keys");
            return "-o StrictHostKeyChecking=accept-new -o HashKnownHosts=yes";
        };
    }

    @Override
    public AbstractJGitHostKeyVerifier forJGit(TaskListener listener) {
        KnownHosts knownHosts;
        try {
            knownHosts = Files.exists(this.getKnownHostsFile().toPath(), new LinkOption[0]) ? new KnownHosts(this.getKnownHostsFile()) : new KnownHosts();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e, () -> "Could not load known hosts.");
            knownHosts = new KnownHosts();
        }
        return new AcceptFirstConnectionJGitHostKeyVerifier(listener, knownHosts);
    }

    public class AcceptFirstConnectionJGitHostKeyVerifier
    extends AbstractJGitHostKeyVerifier {
        private final TaskListener listener;

        public AcceptFirstConnectionJGitHostKeyVerifier(TaskListener listener, KnownHosts knownHosts) {
            super(knownHosts);
            this.listener = listener;
        }

        @Override
        public String[] getServerHostKeyAlgorithms(Connection connection) throws IOException {
            return this.getPreferredServerHostkeyAlgorithmOrder(connection);
        }

        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            this.listener.getLogger().printf("Verifying host key for %s using %s %n", hostname, AcceptFirstConnectionVerifier.this.getKnownHostsFile().toPath());
            File knownHostsFile = AcceptFirstConnectionVerifier.this.getKnownHostsFile();
            Path path = Paths.get(knownHostsFile.getAbsolutePath(), new String[0]);
            String hostnamePort = hostname + ":" + port;
            boolean isValid = false;
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(knownHostsFile.getParentFile().toPath(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
                this.listener.getLogger().println("Creating new known hosts file " + path);
                this.writeToFile(knownHostsFile, hostnamePort, serverHostKeyAlgorithm, serverHostKey);
                isValid = true;
            } else {
                KnownHosts knownHosts = this.getKnownHosts();
                int hostPortResult = knownHosts.verifyHostkey(hostnamePort, serverHostKeyAlgorithm, serverHostKey);
                if (0 == hostPortResult || 0 == knownHosts.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey)) {
                    isValid = true;
                } else if (1 == hostPortResult) {
                    this.writeToFile(knownHostsFile, hostnamePort, serverHostKeyAlgorithm, serverHostKey);
                    isValid = true;
                }
            }
            if (!isValid) {
                LOGGER.log(Level.FINER, "Host key for {0} was not accepted on accept first verifier known hosts file {1}", new Object[]{hostnamePort, path.toString()});
                this.listener.getLogger().printf("Host key for host %s was not accepted.%n", hostnamePort);
            }
            return isValid;
        }

        private void writeToFile(File knownHostsFile, String hostnamePort, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
            this.listener.getLogger().println("Adding " + hostnamePort + " to " + knownHostsFile.toPath());
            LOGGER.log(Level.FINEST, "Adding {0} to known hosts {1} in accept first verifier with host key {2} {3}", new Object[]{hostnamePort, knownHostsFile.toPath().toString(), serverHostKeyAlgorithm, Base64.getEncoder().encodeToString(serverHostKey)});
            KnownHosts.addHostkeyToFile((File)knownHostsFile, (String[])new String[]{KnownHosts.createHashedHostname((String)hostnamePort)}, (String)serverHostKeyAlgorithm, (byte[])serverHostKey);
            this.getKnownHosts().addHostkey(new String[]{KnownHosts.createHashedHostname((String)hostnamePort)}, serverHostKeyAlgorithm, serverHostKey);
        }
    }
}

