/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt.resolvers;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.gwt.resolvers.FlattenerUtils;

public class JsonFlattener {
    private static Gson GSON = new GsonBuilder().serializeNulls().create();

    public Map<String, String> flattenJson(String key, String regexFilter, Object resolved) {
        HashMap resolvedVariables = Maps.newHashMap();
        this.doFlatternJson(key, regexFilter, resolved, resolvedVariables);
        if (resolved != null && !(resolved instanceof String)) {
            String variableName = FlattenerUtils.toVariableName(key);
            resolvedVariables.put(variableName, FlattenerUtils.filter(GSON.toJson(resolved).toString(), regexFilter));
        }
        return resolvedVariables;
    }

    private void doFlatternJson(String key, String regexFilter, Object resolved, Map<String, String> resolvedVariables) {
        if (resolved instanceof List) {
            int i = 0;
            for (Object o : (List)resolved) {
                this.doFlatternJson(key + "_" + i, regexFilter, o, resolvedVariables);
                ++i;
            }
        } else if (resolved instanceof Map) {
            for (Map.Entry entry : ((Map)resolved).entrySet()) {
                this.doFlatternJson(key + "_" + (String)entry.getKey(), regexFilter, entry.getValue(), resolvedVariables);
            }
        } else if (resolved != null) {
            String variableName = FlattenerUtils.toVariableName(key);
            String string = resolved.toString();
            if (!(resolved instanceof String)) {
                string = GSON.toJson(resolved).toString();
            }
            resolvedVariables.put(variableName, FlattenerUtils.filter(string, regexFilter));
        }
    }
}

