/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Renderer {
    private static Logger LOGGER = Logger.getLogger(Renderer.class.getSimpleName());

    @VisibleForTesting
    public static boolean isMatching(String renderedRegexpFilterText, String regexpFilterExpression) {
        boolean noFilterConfigured;
        boolean bl = noFilterConfigured = Strings.isNullOrEmpty((String)renderedRegexpFilterText) && Strings.isNullOrEmpty((String)regexpFilterExpression);
        if (noFilterConfigured) {
            return true;
        }
        boolean isMatching = Pattern.compile(Strings.nullToEmpty((String)regexpFilterExpression)).matcher(Strings.nullToEmpty((String)renderedRegexpFilterText)).find();
        if (!isMatching) {
            LOGGER.log(Level.FINE, "Not triggering \"" + regexpFilterExpression + "\" not matching \"" + renderedRegexpFilterText + "\".");
        }
        return isMatching;
    }

    @VisibleForTesting
    public static String renderText(String regexpFilterText, Map<String, String> resolvedVariables) {
        if (Strings.isNullOrEmpty((String)regexpFilterText)) {
            return "";
        }
        List<String> variables = Renderer.getVariablesInResolveOrder(resolvedVariables.keySet());
        for (String variable : variables) {
            regexpFilterText = Renderer.replaceKey(regexpFilterText, resolvedVariables.get(variable), "$" + variable);
            regexpFilterText = Renderer.replaceKey(regexpFilterText, resolvedVariables.get(variable), "${" + variable + "}");
        }
        return regexpFilterText;
    }

    private static String replaceKey(String regexpFilterText, String resolvedVariable, String key) {
        try {
            regexpFilterText = regexpFilterText.replace(key, resolvedVariable);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Tried to replace " + key + " with " + resolvedVariable, e);
        }
        return regexpFilterText;
    }

    @VisibleForTesting
    static List<String> getVariablesInResolveOrder(Set<String> unsorted) {
        ArrayList<String> variables = new ArrayList<String>(unsorted);
        Collections.sort(variables, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() == o2.length()) {
                    return o1.compareTo(o2);
                }
                if (o1.length() > o2.length()) {
                    return -1;
                }
                return 1;
            }
        });
        return variables;
    }
}

