/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.triggers.filecontent;

import hudson.Extension;
import hudson.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileType;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileTypeDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class SimpleFileContent
extends FSTriggerContentFileType {
    private transient String md5;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public SimpleFileContent() {
    }

    @Override
    public Object getMemoryInfo() {
        return this.md5;
    }

    @Override
    public void setMemoryInfo(Object memoryInfo) {
        if (!(memoryInfo instanceof String)) {
            throw new IllegalArgumentException(String.format("The memory info %s object is not a String object.", memoryInfo));
        }
        this.md5 = (String)memoryInfo;
    }

    @Override
    protected void initForContent(File file) throws XTriggerException {
        try {
            FileInputStream fis = new FileInputStream(file);
            this.md5 = Util.getDigestOf((InputStream)fis);
            fis.close();
        }
        catch (IOException fne) {
            throw new XTriggerException((Throwable)fne);
        }
    }

    @Override
    protected boolean isTriggeringBuildForContent(File file, XTriggerLog log) throws XTriggerException {
        String newComputedMd5;
        try {
            FileInputStream fis = new FileInputStream(file);
            newComputedMd5 = Util.getDigestOf((InputStream)fis);
            fis.close();
        }
        catch (IOException fne) {
            throw new XTriggerException((Throwable)fne);
        }
        assert (this.md5 != null);
        if (!newComputedMd5.equals(this.md5)) {
            String msg = "The content of the file '%s' has changed.";
            log.info(String.format(msg, file.getPath()));
            return true;
        }
        return false;
    }

    @Extension
    public static class SimpleFileContentDescriptor
    extends FSTriggerContentFileTypeDescriptor<SimpleFileContent> {
        @Override
        public Class<? extends FSTriggerContentFileType> getType() {
            return SimpleFileContent.class;
        }

        public String getDisplayName() {
            return "Monitor a change of the content";
        }

        @Override
        public String getLabel() {
            return this.getDisplayName();
        }
    }
}

