/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.triggers.filecontent;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.triggers.filecontent.PropertiesFileContent;

public abstract class ManifestFileContent
extends PropertiesFileContent {
    protected transient Attributes attributes;

    public ManifestFileContent(String keys2Inspect, boolean allKeys) {
        super(keys2Inspect, allKeys);
    }

    @Override
    public Object getMemoryInfo() {
        return this.attributes;
    }

    @Override
    public void setMemoryInfo(Object memoryInfo) {
        if (memoryInfo != null && !(memoryInfo instanceof Attributes)) {
            throw new IllegalArgumentException(String.format("The memory info %s object is not an Attributes object.", memoryInfo));
        }
        this.attributes = (Attributes)memoryInfo;
    }

    protected abstract Manifest getManifest(File var1);

    private Attributes computeAttributesObject(File file) throws XTriggerException {
        Manifest manifest = this.getManifest(file);
        if (manifest == null) {
            throw new XTriggerException(String.format("The file '%s' doesn't contain any MANIFEST file", file));
        }
        Attributes ats = manifest.getMainAttributes();
        if (ats.isEmpty()) {
            throw new XTriggerException(String.format("The MANIFEST file '%s' doesn't contain any attributes", file));
        }
        if (this.allKeys) {
            return ats;
        }
        Attributes attributes2Writer = new Attributes();
        if (this.keys2Inspect != null) {
            String[] inputKeys = this.keys2Inspect.split(",");
            for (int i = 0; i < inputKeys.length; ++i) {
                inputKeys[i] = inputKeys[i].trim();
            }
            List<String> inputKeyList = Arrays.asList(inputKeys);
            for (Map.Entry<Object, Object> entry : ats.entrySet()) {
                Object fileKeyObject = entry.getKey();
                Attributes.Name fileKey = null;
                if (!(fileKeyObject instanceof Attributes.Name)) {
                    throw new XTriggerException("Internal Error of conversion");
                }
                fileKey = (Attributes.Name)fileKeyObject;
                if (!inputKeyList.contains(fileKey.toString())) continue;
                attributes2Writer.put(fileKeyObject, entry.getValue());
            }
        }
        return attributes2Writer;
    }

    @Override
    protected void initForContent(File file) throws XTriggerException {
        this.attributes = this.computeAttributesObject(file);
    }

    @Override
    protected boolean isTriggeringBuildForContent(File file, XTriggerLog log) throws XTriggerException {
        if (this.attributes == null) {
            return false;
        }
        Attributes newAttributes = this.computeAttributesObject(file);
        if (this.attributes.size() != newAttributes.size()) {
            String msg = String.format("The new content file contains %d attribute(s) whereas the previous content contains %d attribute(s)", newAttributes.size(), this.attributes.size());
            log.info(msg);
            return true;
        }
        for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object newValue = newAttributes.get(key);
            if (newValue == null) {
                String msg = String.format("The '%s' attribute is not longer available.", key);
                log.info(msg);
                return true;
            }
            if (newValue.equals(value)) continue;
            String msg = String.format("The previous value for the attribute '%s' was '%s' but it's now '%s'.", key, value, newValue);
            log.info(msg);
            return true;
        }
        return false;
    }
}

