/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.triggers;

import antlr.ANTLRException;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.FormValidation;
import hudson.util.SequentialExecutionQueue;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.lib.xtrigger.AbstractTrigger;
import org.jenkinsci.lib.xtrigger.XTriggerDescriptor;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.Messages;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerAction;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileType;
import org.jenkinsci.plugins.fstrigger.service.FSTriggerComputeFileService;
import org.jenkinsci.plugins.fstrigger.service.FSTriggerFileNameCheckedModifiedService;
import org.jenkinsci.plugins.fstrigger.triggers.FileNameTriggerInfo;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class FileNameTrigger
extends AbstractTrigger {
    public static final String STRATEGY_IGNORE = "IGNORE";
    public static final String STRATEGY_LATEST = "LATEST";
    private static final Logger LOGGER = Logger.getLogger(FileNameTrigger.class.getName());
    private static final String CAUSE = "Triggered by a change to a file";
    private FileNameTriggerInfo[] fileInfo;
    @Deprecated
    private transient String folderPath;
    @Deprecated
    private transient String fileName;
    @Deprecated
    private transient String strategy;
    @Deprecated
    private transient boolean inspectingContentFile;
    @Deprecated
    private transient boolean doNotCheckLastModificationDate;
    @Deprecated
    private transient FSTriggerContentFileType[] contentFileTypes;
    private static final long serialVersionUID = 1L;

    public FileNameTrigger(String cronTabSpec, FileNameTriggerInfo[] fileInfo) throws ANTLRException {
        super(cronTabSpec);
        this.fileInfo = Arrays.copyOf(fileInfo, fileInfo.length);
    }

    public FileNameTriggerInfo[] getFileInfo() {
        return Arrays.copyOf(this.fileInfo, this.fileInfo.length);
    }

    protected File getLogFile() {
        if (this.job == null) {
            return null;
        }
        return new File(((BuildableItem)this.job).getRootDir(), "trigger-polling-files.log");
    }

    protected Action[] getScheduledActions(Node node, XTriggerLog log) {
        return new Action[0];
    }

    protected boolean requiresWorkspaceForPolling() {
        return false;
    }

    public void start(Node pollingNode, BuildableItem project, boolean newInstance, XTriggerLog log) {
        try {
            FSTriggerComputeFileService service = new FSTriggerComputeFileService();
            for (FileNameTriggerInfo info : this.fileInfo) {
                FilePath resolvedFile = service.computedFile(pollingNode, (AbstractProject)project, info, new XTriggerLog((StreamTaskListener)TaskListener.NULL));
                if (resolvedFile == null) continue;
                info.setResolvedFile(resolvedFile);
                info.setLastModifications(resolvedFile.lastModified());
                this.initContentElementsIfNeed(info);
            }
        }
        catch (XTriggerException fse) {
            LOGGER.log(Level.SEVERE, "Error on trigger startup " + fse.getMessage());
            fse.printStackTrace();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Severe error on trigger startup " + t.getMessage());
            t.printStackTrace();
        }
    }

    private void initContentElementsIfNeed(FileNameTriggerInfo info) throws XTriggerException {
        FSTriggerContentFileType[] contentFileTypes;
        boolean inspectingContentFile;
        if (this.job == null) {
            return;
        }
        FilePath resolvedFile = info.getResolvedFile();
        if (resolvedFile != null && (inspectingContentFile = info.isInspectingContentFile()) && (contentFileTypes = info.getContentFileTypes()) != null) {
            for (FSTriggerContentFileType type : contentFileTypes) {
                if (type == null) continue;
                String jobName = ((BuildableItem)this.job).getName();
                try {
                    Object memoryInfo = resolvedFile.act((FilePath.FileCallable)new MemoryInfo(jobName, type));
                    type.setMemoryInfo(memoryInfo);
                }
                catch (Throwable ie) {
                    throw new XTriggerException(ie);
                }
            }
        }
    }

    private void refreshMemoryInfo(FileNameTriggerInfo info, FilePath newComputedFile) throws XTriggerException {
        try {
            if (newComputedFile != null && newComputedFile.exists()) {
                info.setResolvedFile(newComputedFile);
                info.setLastModifications(newComputedFile.lastModified());
                this.initContentElementsIfNeed(info);
            } else {
                info.setResolvedFile(null);
                info.setLastModifications(0L);
            }
        }
        catch (IOException | InterruptedException ioe) {
            throw new XTriggerException((Throwable)ioe);
        }
    }

    protected boolean checkIfModified(Node pollingNode, XTriggerLog log) throws XTriggerException {
        FilePath[] resolvedFiles = this.getNewResolvedFiles(pollingNode, log);
        boolean changeResult = this.checkIfThereAreAtLeastOneChange(resolvedFiles, log);
        this.refreshNewResolvedFiles(resolvedFiles);
        return changeResult;
    }

    private FilePath[] getNewResolvedFiles(Node pollingNode, XTriggerLog log) throws XTriggerException {
        FilePath[] resolvedFiles = new FilePath[this.fileInfo.length];
        for (int i = 0; i < this.fileInfo.length; ++i) {
            FilePath resolvedFile;
            FileNameTriggerInfo info = this.fileInfo[i];
            resolvedFiles[i] = resolvedFile = new FSTriggerComputeFileService().computedFile(pollingNode, (AbstractProject)this.job, info, log);
        }
        return resolvedFiles;
    }

    private boolean checkIfThereAreAtLeastOneChange(FilePath[] resolvedFiles, XTriggerLog log) throws XTriggerException {
        for (int i = 0; i < resolvedFiles.length; ++i) {
            if (this.offlineSlaveOnStartup) {
                log.info("No nodes were available at startup or at previous poll.");
                this.offlineSlaveOnStartup = false;
                return false;
            }
            FilePath resolvedFile = resolvedFiles[i];
            FileNameTriggerInfo info = this.fileInfo[i];
            boolean changed = this.checkIfModifiedFile(resolvedFile, info, log);
            if (!changed) continue;
            return true;
        }
        return false;
    }

    private void refreshNewResolvedFiles(FilePath[] resolvedFiles) throws XTriggerException {
        for (int i = 0; i < resolvedFiles.length; ++i) {
            this.refreshMemoryInfo(this.fileInfo[i], resolvedFiles[i]);
        }
    }

    private boolean checkIfModifiedFile(FilePath newResolvedFile, final FileNameTriggerInfo info, final XTriggerLog log) throws XTriggerException {
        if (newResolvedFile == null) {
            log.info("The computed file doesn't exist.");
            return false;
        }
        try {
            FilePath resolvedFile = info.getResolvedFile();
            final Long lastModification = info.getLastModifications();
            final String resolvedFilePath = resolvedFile != null ? resolvedFile.getRemote() : null;
            boolean changedFileName = (Boolean)newResolvedFile.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Boolean>(){

                public Boolean invoke(File newResolvedFile, VirtualChannel channel) {
                    try {
                        FSTriggerFileNameCheckedModifiedService service = new FSTriggerFileNameCheckedModifiedService(log, info, resolvedFilePath, lastModification, newResolvedFile);
                        return service.checkFileName();
                    }
                    catch (XTriggerException fse) {
                        throw new RuntimeException(fse);
                    }
                }
            });
            if (changedFileName) {
                return true;
            }
            boolean inspectingContentFile = info.isInspectingContentFile();
            FSTriggerContentFileType[] contentFileTypes = info.getContentFileTypes();
            if (inspectingContentFile) {
                log.info("Inspecting the contents of '" + newResolvedFile + "'");
                for (final FSTriggerContentFileType type : contentFileTypes) {
                    final Object memoryObject = type.getMemoryInfo();
                    if (memoryObject == null) {
                        log.info("No modifications according the given criteria.");
                        return false;
                    }
                    boolean isTriggered = (Boolean)newResolvedFile.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Boolean>(){

                        public Boolean invoke(File newResolvedFile, VirtualChannel channel) {
                            boolean isTriggered;
                            try {
                                FSTriggerFileNameCheckedModifiedService service = new FSTriggerFileNameCheckedModifiedService(log, info, resolvedFilePath, lastModification, newResolvedFile);
                                type.setMemoryInfo(memoryObject);
                                isTriggered = service.checkContentType(type);
                            }
                            catch (XTriggerException fse) {
                                throw new RuntimeException(fse);
                            }
                            return isTriggered;
                        }
                    });
                    if (!isTriggered) continue;
                    return true;
                }
                return false;
            }
        }
        catch (Throwable ie) {
            throw new XTriggerException(ie);
        }
        return false;
    }

    protected String getName() {
        return "FSTrigger";
    }

    public String getCause() {
        return CAUSE;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new FSTriggerFilesAction(this.getDescriptor().getDisplayName()));
    }

    public FileNameTriggerDescriptor getDescriptor() {
        return (FileNameTriggerDescriptor)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Deprecated
    public String getFolderPath() {
        return this.folderPath;
    }

    @Deprecated
    public String getFileName() {
        return this.fileName;
    }

    @Deprecated
    public String getStrategy() {
        return this.strategy;
    }

    @Deprecated
    public boolean isInspectingContentFile() {
        return this.inspectingContentFile;
    }

    @Deprecated
    public boolean isDoNotCheckLastModificationDate() {
        return this.doNotCheckLastModificationDate;
    }

    @Deprecated
    public FSTriggerContentFileType[] getContentFileTypes() {
        return Arrays.copyOf(this.contentFileTypes, this.contentFileTypes.length);
    }

    protected Object readResolve() throws ObjectStreamException {
        super.readResolve();
        if (this.folderPath != null) {
            FileNameTriggerInfo info = new FileNameTriggerInfo();
            info.setFilePathPattern(this.folderPath + File.separatorChar + this.fileName);
            info.setStrategy(this.strategy);
            info.setInspectingContentFile(this.inspectingContentFile);
            info.setDoNotCheckLastModificationDate(this.doNotCheckLastModificationDate);
            info.setContentFileTypes(this.contentFileTypes);
            this.fileInfo = new FileNameTriggerInfo[]{info};
        }
        return this;
    }

    @Extension
    public static class FileNameTriggerDescriptor
    extends XTriggerDescriptor {
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Executors.newSingleThreadExecutor());

        public ExecutorService getExecutor() {
            return this.queue.getExecutors();
        }

        public boolean isApplicable(Item item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.fstrigger_fileNameContent_displayName();
        }

        public String getHelpFile() {
            return "/plugin/fstrigger/help-monitorFile.html";
        }

        public DescriptorExtensionList getListFSTriggerFileNameDescriptors() {
            return DescriptorExtensionList.createDescriptorList((Jenkins)Jenkins.get(), FSTriggerContentFileType.class);
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"You must provide a file to monitor");
            }
            value = value.replaceAll("[\t\r\n]+", " ");
            if ((value = value.trim()).length() < 2) {
                return FormValidation.error((String)"You must provide a folder.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckContentNature() {
            return FormValidation.ok();
        }

        public FileNameTrigger newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String cronTab = formData.getString("cronTabSpec");
            Object entryObject = formData.get("fileElement");
            ArrayList<FileNameTriggerInfo> entries = new ArrayList<FileNameTriggerInfo>();
            if (entryObject instanceof JSONObject) {
                entries.add(this.fillAndGetEntry(req, (JSONObject)entryObject));
            } else {
                JSONArray jsonArray = (JSONArray)entryObject;
                if (jsonArray != null) {
                    for (Object aJsonArray : jsonArray) {
                        entries.add(this.fillAndGetEntry(req, (JSONObject)aJsonArray));
                    }
                }
            }
            try {
                return new FileNameTrigger(cronTab, entries.toArray(new FileNameTriggerInfo[entries.size()]));
            }
            catch (ANTLRException ae) {
                throw new Descriptor.FormException((Throwable)ae, "cronTabSpec");
            }
        }

        private FileNameTriggerInfo fillAndGetEntry(StaplerRequest req, JSONObject entryObject) {
            FileNameTriggerInfo info = new FileNameTriggerInfo();
            info.setFilePathPattern(Util.fixEmpty((String)entryObject.getString("filePathPattern")));
            info.setStrategy(entryObject.getString("strategy"));
            this.setInfoContentType(req, entryObject, info);
            return info;
        }

        private void setInfoContentType(StaplerRequest req, JSONObject entryObject, FileNameTriggerInfo info) {
            Object inspectingFileContentObject = entryObject.get("inspectingContentFile");
            if (inspectingFileContentObject == null) {
                this.unsetContentType(info);
            } else {
                JSONObject inspectingFileContentJSONObject = entryObject.getJSONObject("inspectingContentFile");
                if (this.isNoContentNatureSelected(inspectingFileContentJSONObject)) {
                    this.unsetContentType(info);
                } else {
                    info.setInspectingContentFile(true);
                    info.setDoNotCheckLastModificationDate(inspectingFileContentJSONObject.getBoolean("doNotCheckLastModificationDate"));
                    this.setContentNature(req, info, inspectingFileContentJSONObject);
                }
            }
        }

        private void unsetContentType(FileNameTriggerInfo info) {
            info.setInspectingContentFile(false);
            info.setDoNotCheckLastModificationDate(false);
            info.setContentFileTypes(new FSTriggerContentFileType[0]);
        }

        private boolean isNoContentNatureSelected(JSONObject inspectingFileContentJSONObject) {
            return inspectingFileContentJSONObject.size() == 1;
        }

        private void setContentNature(StaplerRequest req, FileNameTriggerInfo info, JSONObject inspectingFileContentJSONObject) {
            JSONArray contentFileTypesJsonElt;
            try {
                contentFileTypesJsonElt = inspectingFileContentJSONObject.getJSONArray("contentFileTypes");
            }
            catch (JSONException jsone) {
                contentFileTypesJsonElt = inspectingFileContentJSONObject.getJSONObject("contentFileTypes");
            }
            List types = req.bindJSONToList(FSTriggerContentFileType.class, (Object)contentFileTypesJsonElt);
            info.setContentFileTypes(types.toArray(new FSTriggerContentFileType[types.size()]));
        }
    }

    public final class FSTriggerFilesAction
    extends FSTriggerAction {
        private final transient String actionTitle;

        public FSTriggerFilesAction(String actionTitle) {
            this.actionTitle = actionTitle;
        }

        public String getDisplayName() {
            return "FSTrigger Files Log";
        }

        public String getUrlName() {
            return "triggerPollLogFiles";
        }

        public String getIconFileName() {
            return "clipboard.gif";
        }

        public String getActionTitle() {
            return this.actionTitle;
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)FileNameTrigger.this.getLogFile());
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            long pos = new AnnotatedLargeText(FileNameTrigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
            if (pos == 0L) {
                LOGGER.warning("Failed to write log for FileNameTrigger");
            }
        }
    }

    private static class MemoryInfo
    extends MasterToSlaveFileCallable<Object> {
        private final String jobName;
        private final FSTriggerContentFileType type;

        public MemoryInfo(String jobName, FSTriggerContentFileType type) {
            this.jobName = jobName;
            this.type = type;
        }

        public Object invoke(File file, VirtualChannel virtualChannel) {
            try {
                this.type.initMemoryFields(this.jobName, file);
            }
            catch (XTriggerException fse) {
                throw new RuntimeException(fse);
            }
            return this.type.getMemoryInfo();
        }
    }
}

