/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.triggers.filecontent;

import hudson.Extension;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileType;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileTypeDescriptor;
import org.jenkinsci.plugins.fstrigger.triggers.filecontent.ManifestFileContent;
import org.kohsuke.stapler.DataBoundConstructor;

public class JARManifestFileContent
extends ManifestFileContent {
    @DataBoundConstructor
    public JARManifestFileContent(String keys2Inspect, boolean allKeys) {
        super(keys2Inspect, allKeys);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Manifest getManifest(File file) {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            return manifest;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Extension
    public static class JARManifestFileContentDescriptor
    extends FSTriggerContentFileTypeDescriptor<JARManifestFileContent> {
        @Override
        public Class<? extends FSTriggerContentFileType> getType() {
            return JARManifestFileContent.class;
        }

        public String getDisplayName() {
            return "Monitor a MANIFEST file (contained in a Jar file)";
        }

        @Override
        public String getLabel() {
            return "JAR MANIFEST File";
        }
    }
}

