/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.triggers;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Node;
import hudson.remoting.VirtualChannel;
import hudson.util.SequentialExecutionQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.XMLOutput;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.service.EnvVarsResolver;
import org.jenkinsci.lib.xtrigger.AbstractTrigger;
import org.jenkinsci.lib.xtrigger.XTriggerDescriptor;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.Messages;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerAction;
import org.kohsuke.stapler.DataBoundConstructor;

public class FolderContentTrigger
extends AbstractTrigger {
    private static final Logger LOGGER = Logger.getLogger(FolderContentTrigger.class.getName());
    private static final String CAUSE = "Triggered by a change to a folder";
    private final String path;
    private final String includes;
    private final String excludes;
    private final boolean excludeCheckLastModificationDate;
    private final boolean excludeCheckContent;
    private final boolean excludeCheckFewerOrMoreFiles;
    private transient Map<String, FileInfo> md5Map = new HashMap<String, FileInfo>();
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public FolderContentTrigger(String cronTabSpec, String path, String includes, String excludes, boolean excludeCheckLastModificationDate, boolean excludeCheckContent, boolean excludeCheckFewerOrMoreFiles) throws ANTLRException {
        super(cronTabSpec);
        this.path = Util.fixEmpty((String)path);
        this.includes = Util.fixEmpty((String)includes);
        this.excludes = Util.fixEmpty((String)excludes);
        this.excludeCheckLastModificationDate = excludeCheckLastModificationDate;
        this.excludeCheckContent = excludeCheckContent;
        this.excludeCheckFewerOrMoreFiles = excludeCheckFewerOrMoreFiles;
    }

    public String getPath() {
        return this.path;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public boolean isExcludeCheckLastModificationDate() {
        return this.excludeCheckLastModificationDate;
    }

    public boolean isExcludeCheckContent() {
        return this.excludeCheckContent;
    }

    public boolean isExcludeCheckFewerOrMoreFiles() {
        return this.excludeCheckFewerOrMoreFiles;
    }

    protected File getLogFile() {
        if (this.job == null) {
            return null;
        }
        return new File(((BuildableItem)this.job).getRootDir(), "trigger-polling-folder.log");
    }

    protected Action[] getScheduledActions(Node node, XTriggerLog log) {
        return new Action[0];
    }

    protected boolean requiresWorkspaceForPolling() {
        return false;
    }

    protected synchronized boolean checkIfModified(Node pollingNode, XTriggerLog log) throws XTriggerException {
        Map envVars;
        EnvVarsResolver varsRetriever = new EnvVarsResolver();
        try {
            envVars = varsRetriever.getPollingEnvVars((AbstractProject)this.job, pollingNode);
        }
        catch (EnvInjectException e) {
            throw new XTriggerException((Throwable)e);
        }
        String pathResolved = Util.replaceMacro((String)this.path, (Map)envVars);
        String includesResolved = Util.replaceMacro((String)this.includes, (Map)envVars);
        String excludesResolved = Util.replaceMacro((String)this.excludes, (Map)envVars);
        Map<String, FileInfo> newMd5Map = this.getMd5Map(pollingNode, pathResolved, includesResolved, excludesResolved, log);
        if (this.offlineSlaveOnStartup) {
            this.refreshMemoryInfo(newMd5Map);
            log.info("Slave(s) were offline at startup. Waiting for next schedule to check if there are modifications.");
            this.offlineSlaveOnStartup = false;
            return false;
        }
        boolean changed = this.checkIfModified(pollingNode, pathResolved, log, newMd5Map);
        this.refreshMemoryInfo(newMd5Map);
        return changed;
    }

    private void refreshMemoryInfo(Map<String, FileInfo> newMd5Map) throws XTriggerException {
        this.md5Map = newMd5Map;
    }

    private Map<String, FileInfo> getMd5Map(Node launcherNode, final String path, final String includes, final String excludes, final XTriggerLog log) throws XTriggerException {
        Map result;
        if (path == null) {
            throw new XTriggerException("A folder path must be set.");
        }
        if (launcherNode == null) {
            throw new XTriggerException("A node must be set.");
        }
        FilePath rootPath = launcherNode.getRootPath();
        if (rootPath == null) {
            log.info("The node is now offline. Waiting next schedule");
            return null;
        }
        try {
            result = (Map)rootPath.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Map<String, FileInfo>>(){

                public Map<String, FileInfo> invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
                    try {
                        return FolderContentTrigger.this.getFileInfo(path, includes, excludes, log);
                    }
                    catch (XTriggerException fse) {
                        throw new RuntimeException(fse);
                    }
                }
            });
        }
        catch (IOException | InterruptedException e) {
            throw new XTriggerException((Throwable)e);
        }
        return result;
    }

    private Map<String, FileInfo> getFileInfo(String path, String includes, String excludes, XTriggerLog log) throws XTriggerException {
        log.info(String.format("%nTrying to monitor the folder '%s'", path));
        File folder = new File(path);
        if (!folder.exists()) {
            return null;
        }
        if (!folder.isDirectory()) {
            return null;
        }
        HashMap<String, FileInfo> result = new HashMap<String, FileInfo>();
        if (includes == null) {
            includes = "**/*.*, **/*";
        }
        DirSet dirSet = new DirSet();
        dirSet.setProject(new Project());
        dirSet.setDir(new File(path));
        dirSet.setIncludes("*");
        if (excludes != null) {
            dirSet.setExcludes(excludes);
        }
        for (FileResource fileResource : dirSet) {
            this.processDirectoryResource(log, result, fileResource);
        }
        FileSet fileSet = Util.createFileSet((File)new File(path), (String)includes, (String)excludes);
        for (FileResource fileResource : fileSet) {
            this.processFileResource(log, result, fileResource);
        }
        return result;
    }

    private void processDirectoryResource(XTriggerLog log, Map<String, FileInfo> result, FileResource folderResource) throws XTriggerException {
        if (!folderResource.isExists()) {
            log.info(String.format("%nThe folder '%s' doesn't exist anymore ", folderResource.getFile().getPath()));
        } else {
            FileInfo fileInfo = new FileInfo(null, folderResource.getLastModified());
            result.put(folderResource.getFile().getAbsolutePath(), fileInfo);
        }
    }

    private void processFileResource(XTriggerLog log, Map<String, FileInfo> result, FileResource fileResource) throws XTriggerException {
        if (!fileResource.isExists()) {
            log.info(String.format("%nThe file '%s' doesn't exist anymore ", fileResource.getFile().getPath()));
        } else {
            String currentMd5;
            try {
                FileInputStream fis = new FileInputStream(fileResource.getFile());
                currentMd5 = Util.getDigestOf((InputStream)fis);
                fis.close();
            }
            catch (IOException e) {
                throw new XTriggerException((Throwable)e);
            }
            FileInfo fileInfo = new FileInfo(currentMd5, fileResource.getLastModified());
            result.put(fileResource.getFile().getAbsolutePath(), fileInfo);
        }
    }

    public String getCause() {
        return CAUSE;
    }

    private boolean checkIfModified(Node launcherNode, String path, final XTriggerLog log, final Map<String, FileInfo> newMd5Map) throws XTriggerException {
        boolean isTriggering;
        assert (launcherNode != null);
        assert (launcherNode.getRootPath() != null);
        if (newMd5Map == null) {
            log.info("The directory '" + new File(path) + "' doesn't exist.");
            return false;
        }
        if (newMd5Map.isEmpty()) {
            log.info("The folder '" + new File(path) + "' does not contain any files matching the includes/excludes information.");
            return false;
        }
        if (this.md5Map == null) {
            log.info("The folder '" + new File(path) + "' contains new files matching the includes/excludes information.");
            return true;
        }
        if (!this.excludeCheckFewerOrMoreFiles && this.md5Map.size() != newMd5Map.size()) {
            log.info("The folder '" + new File(path) + "' content has changed.");
            return true;
        }
        FilePath rootPath = launcherNode.getRootPath();
        if (rootPath == null) {
            log.info("The node is now offline. Skipping");
            return false;
        }
        try {
            final Map<String, FileInfo> originMd5Map = this.md5Map;
            isTriggering = (Boolean)rootPath.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Boolean>(){

                public Boolean invoke(File nodePath, VirtualChannel channel) throws IOException, InterruptedException {
                    return FolderContentTrigger.this.checkIfModifiedFile(log, originMd5Map, newMd5Map);
                }
            });
        }
        catch (IOException | InterruptedException ioe) {
            throw new XTriggerException((Throwable)ioe);
        }
        return isTriggering;
    }

    private boolean checkIfModifiedFile(XTriggerLog log, Map<String, FileInfo> originMd5Map, Map<String, FileInfo> newMd5Map) {
        assert (log != null);
        assert (originMd5Map != null);
        assert (newMd5Map != null);
        for (Map.Entry<String, FileInfo> entry : originMd5Map.entrySet()) {
            String originFilePath = entry.getKey();
            FileInfo originFileInfo = entry.getValue();
            assert (originFileInfo != null);
            FileInfo newFileInfo = newMd5Map.get(originFilePath);
            if (newFileInfo == null) {
                log.info(String.format("The path '%s' doesn't exist anymore.", originFilePath));
                return true;
            }
            if (!this.excludeCheckLastModificationDate && originFileInfo.getLastModified() != newFileInfo.getLastModified()) {
                log.info(String.format("The last modification date of '%s' has changed.", originFilePath));
                return true;
            }
            if (this.excludeCheckContent || originFileInfo.getMd5() == null || originFileInfo.getMd5().equals(newFileInfo.getMd5())) continue;
            log.info(String.format("The content of '%s' has changed.", originFilePath));
            return true;
        }
        return false;
    }

    public void start(Node pollingNode, BuildableItem project, boolean newInstance, XTriggerLog log) {
        EnvVarsResolver varsRetriever = new EnvVarsResolver();
        Map envVars = null;
        try {
            envVars = varsRetriever.getPollingEnvVars((AbstractProject)project, pollingNode);
        }
        catch (EnvInjectException e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
        }
        String pathResolved = Util.replaceMacro((String)this.path, (Map)envVars);
        String includesResolved = Util.replaceMacro((String)this.includes, (Map)envVars);
        String excludesResolved = Util.replaceMacro((String)this.excludes, (Map)envVars);
        try {
            Map<String, FileInfo> md5Map = this.getMd5Map(pollingNode, pathResolved, includesResolved, excludesResolved, log);
            this.refreshMemoryInfo(md5Map);
        }
        catch (XTriggerException fse) {
            LOGGER.log(Level.SEVERE, "Error on trigger startup " + fse.getMessage());
            fse.printStackTrace();
        }
    }

    protected String getName() {
        return "FSTrigger";
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new FSTriggerFolderAction(this.getDescriptor().getDisplayName()));
    }

    public FolderContentTriggerDescriptor getDescriptor() {
        return (FolderContentTriggerDescriptor)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    protected Object readResolve() throws ObjectStreamException {
        super.readResolve();
        this.md5Map = new HashMap<String, FileInfo>();
        return this;
    }

    @Extension
    public static class FolderContentTriggerDescriptor
    extends XTriggerDescriptor {
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Executors.newSingleThreadExecutor());

        public ExecutorService getExecutor() {
            return this.queue.getExecutors();
        }

        public boolean isApplicable(Item item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.fstrigger_folderContent_displayName();
        }

        public String getHelpFile() {
            return "/plugin/fstrigger/help-monitorFolder.html";
        }
    }

    public final class FSTriggerFolderAction
    extends FSTriggerAction {
        private final transient String actionTitle;

        public FSTriggerFolderAction(String actionTitle) {
            this.actionTitle = actionTitle;
        }

        public String getDisplayName() {
            return "FSTrigger Folder Log";
        }

        public String getUrlName() {
            return "triggerPollLogFolder";
        }

        public String getIconFileName() {
            return "clipboard.gif";
        }

        public String getActionTitle() {
            return this.actionTitle;
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)FolderContentTrigger.this.getLogFile());
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            long pos = new AnnotatedLargeText(FolderContentTrigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
            if (pos == 0L) {
                LOGGER.warning("Failed to write log for FolderContentTrigger");
            }
        }
    }

    static class FileInfo
    implements Serializable {
        private final String md5;
        private final long lastModified;

        public FileInfo(String md5, long lastModified) {
            this.md5 = md5;
            this.lastModified = lastModified;
        }

        public String getMd5() {
            return this.md5;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

