/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.plugin;

import com.google.common.collect.Maps;
import com.google.jenkins.flakyTestHandler.plugin.HistoryAggregatedFlakyTestResultAction;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class TestFlakyStatsOverRevision
implements Action {
    public final AbstractProject<?, ?> project;
    public HistoryAggregatedFlakyTestResultAction parentAction;
    public Map<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStats> flakyStatsRevisionMap = Maps.newLinkedHashMap();

    public TestFlakyStatsOverRevision(AbstractProject<?, ?> project, HistoryAggregatedFlakyTestResultAction action) {
        this.project = project;
        this.parentAction = action;
    }

    private CategoryDataset buildDataSet() {
        DataSetBuilder dsb = new DataSetBuilder();
        int number = 1;
        for (Map.Entry<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStats> entry : this.flakyStatsRevisionMap.entrySet()) {
            dsb.add((Number)entry.getValue().fail, (Comparable)((Object)"failed"), (Comparable)new RevisionLabel(number, entry.getKey()));
            dsb.add((Number)entry.getValue().pass, (Comparable)((Object)"passed"), (Comparable)new RevisionLabel(number, entry.getKey()));
            ++number;
        }
        return dsb.build();
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                RevisionLabel label = (RevisionLabel)dataset.getColumnKey(column);
                Number value = dataset.getValue(row, column);
                switch (row) {
                    case 0: {
                        return label.revision + ": " + value + " fails";
                    }
                    case 1: {
                        return label.revision + ": " + value + " passes";
                    }
                }
                return label.revision;
            }
        };
        plot.setRenderer((CategoryItemRenderer)ar);
        ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
        ar.setSeriesPaint(1, (Paint)ColorPalette.BLUE);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public Map<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStats> getFlakyStatsMap(String test) {
        if (test != null) {
            for (String testName : this.parentAction.getAggregatedTestFlakyStatsWithRevision().keySet()) {
                if (!test.equals(TestFlakyStatsOverRevision.getSafeTestName(testName))) continue;
                this.flakyStatsRevisionMap = this.parentAction.getAggregatedTestFlakyStatsWithRevision().get(testName);
                return this.flakyStatsRevisionMap;
            }
        }
        return Maps.newHashMap();
    }

    public Graph getStatsGraph() {
        return new Graph(-1L, 900, 360){

            protected JFreeChart createGraph() {
                return TestFlakyStatsOverRevision.this.createChart(TestFlakyStatsOverRevision.this.buildDataSet());
            }
        };
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "flakyStatsRevision";
    }

    public static String getSafeTestName(String testName) {
        StringBuilder buf = new StringBuilder(testName);
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            buf.setCharAt(i, '_');
        }
        return buf.toString();
    }

    public static final class RevisionLabel
    implements Comparable<RevisionLabel> {
        public final String revision;
        public final int number;

        public RevisionLabel(int number, String revision) {
            this.number = number;
            this.revision = revision;
        }

        @Override
        public int compareTo(RevisionLabel that) {
            return this.number - that.number;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RevisionLabel)) {
                return false;
            }
            RevisionLabel that = (RevisionLabel)o;
            return this.revision.equals(that.revision);
        }

        public int hashCode() {
            return this.revision.hashCode();
        }

        public String toString() {
            return "Rev #" + this.number;
        }
    }
}

