/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.plugin;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.jenkins.flakyTestHandler.plugin.FlakyTestResultAction;
import com.google.jenkins.flakyTestHandler.plugin.deflake.DeflakeCause;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import hudson.scm.SCM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.triggers.SCMTriggerItem;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class HistoryAggregatedFlakyTestResultAction
implements Action {
    AbstractProject<?, ?> project;
    Map<String, SingleTestFlakyStats> aggregatedFlakyStats;
    Map<String, Map<String, SingleTestFlakyStats>> aggregatedTestFlakyStatsWithRevision;
    Set<String> allTests;
    boolean onlyShowFlakyTests;
    public static final Function<Map<String, SingleTestFlakyStats>, SingleTestFlakyStats> REVISION_STATS_MAP_TO_AGGREGATED_STATS = new Function<Map<String, SingleTestFlakyStats>, SingleTestFlakyStats>(){

        @Nonnull
        public SingleTestFlakyStats apply(@Nonnull Map<String, SingleTestFlakyStats> revisionStatsMap) {
            SingleTestFlakyStats aggregatedStatsOverRevision = new SingleTestFlakyStats(0, 0, 0);
            for (SingleTestFlakyStats singleTestFlakyStats : revisionStatsMap.values()) {
                if (singleTestFlakyStats.isPassed()) {
                    aggregatedStatsOverRevision.increasePass();
                    continue;
                }
                if (singleTestFlakyStats.isFlaked()) {
                    aggregatedStatsOverRevision.increaseFlake();
                    continue;
                }
                if (!singleTestFlakyStats.isFailed()) continue;
                aggregatedStatsOverRevision.increaseFail();
            }
            return aggregatedStatsOverRevision;
        }
    };

    public HistoryAggregatedFlakyTestResultAction(AbstractProject<?, ?> project) {
        this.project = project;
        this.aggregatedTestFlakyStatsWithRevision = new TreeMap<String, Map<String, SingleTestFlakyStats>>();
        this.aggregatedFlakyStats = new TreeMap<String, SingleTestFlakyStats>();
        this.allTests = new HashSet<String>();
        this.onlyShowFlakyTests = true;
    }

    void aggregate() {
        Stack<Run> builds = new Stack<Run>();
        for (Run build : this.project._getRuns().values()) {
            builds.push(build);
        }
        while (!builds.empty()) {
            this.aggregateOneBuild((Run)builds.pop());
        }
    }

    public void aggregateOneBuild(Run<?, ?> build) {
        FlakyTestResultAction action = (FlakyTestResultAction)build.getAction(FlakyTestResultAction.class);
        if (action == null) {
            return;
        }
        FlakyTestResultAction.FlakyRunStats runStats = action.getFlakyRunStats();
        if (runStats == null) {
            return;
        }
        Map<String, SingleTestFlakyStatsWithRevision> testFlakyStatsMap = runStats.getTestFlakyStatsWithRevisionMap();
        if (testFlakyStatsMap == null) {
            return;
        }
        if (build.getCause(DeflakeCause.class) == null) {
            this.allTests = testFlakyStatsMap.keySet();
        }
        for (Map.Entry<String, SingleTestFlakyStatsWithRevision> testFlakyStat : testFlakyStatsMap.entrySet()) {
            Map<Object, Object> testFlakyStatMap;
            String testName = testFlakyStat.getKey();
            String revision = testFlakyStat.getValue().getRevision();
            SingleTestFlakyStats stats = testFlakyStat.getValue().getStats();
            if (this.aggregatedTestFlakyStatsWithRevision.containsKey(testName)) {
                testFlakyStatMap = this.aggregatedTestFlakyStatsWithRevision.get(testName);
                if (testFlakyStatMap.containsKey(revision)) {
                    ((SingleTestFlakyStats)testFlakyStatMap.get(revision)).merge(stats);
                    continue;
                }
                testFlakyStatMap.put(revision, new SingleTestFlakyStats(stats));
                continue;
            }
            testFlakyStatMap = new LinkedHashMap<String, SingleTestFlakyStats>();
            testFlakyStatMap.put(revision, new SingleTestFlakyStats(stats));
            this.aggregatedTestFlakyStatsWithRevision.put(testName, testFlakyStatMap);
        }
        this.aggregatedFlakyStats = Maps.filterKeys((Map)Maps.transformValues(this.aggregatedTestFlakyStatsWithRevision, REVISION_STATS_MAP_TO_AGGREGATED_STATS), (Predicate)Predicates.in(this.allTests));
    }

    public Map<String, Map<String, SingleTestFlakyStats>> getAggregatedTestFlakyStatsWithRevision() {
        return this.aggregatedTestFlakyStatsWithRevision;
    }

    public boolean getOnlyShowFlakyTests() {
        return this.onlyShowFlakyTests;
    }

    public void doShowAll(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.onlyShowFlakyTests = !this.onlyShowFlakyTests;
        rsp.sendRedirect("..");
    }

    public Map<String, SingleTestFlakyStats> getAggregatedFlakyStats() {
        return this.aggregatedFlakyStats;
    }

    public Map<String, SingleTestFlakyStats> getFilteredAggregatedFlakyStats() {
        Object flakyTestsFilter = this.onlyShowFlakyTests ? new Predicate<Map.Entry<String, SingleTestFlakyStats>>(){

            public boolean apply(Map.Entry<String, SingleTestFlakyStats> singleTestFlakyStatsEntry) {
                return singleTestFlakyStatsEntry.getValue().getFlake() > 0;
            }
        } : Predicates.alwaysTrue();
        return Maps.filterEntries(this.aggregatedFlakyStats, (Predicate)flakyTestsFilter);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "historyAggregate";
    }

    public static class SingleTestFlakyStatsWithRevision {
        private SingleTestFlakyStats stats;
        private String revision;

        public SingleTestFlakyStatsWithRevision(SingleTestFlakyStats stats, Run build) {
            this.stats = stats;
            this.revision = Integer.toString(build.getNumber());
            Job job = build.getParent();
            SCMTriggerItem s = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)job);
            if (s != null) {
                Revision gitRevision;
                GitSCM gitSCM;
                BuildData buildData;
                SCM scm;
                ArrayList scms = new ArrayList(s.getSCMs());
                SCM sCM = scm = scms.size() > 0 ? (SCM)scms.get(0) : null;
                if (scm != null && "hudson.plugins.git.GitSCM".equalsIgnoreCase(scm.getType()) && (buildData = (gitSCM = (GitSCM)scm).getBuildData(build)) != null && (gitRevision = buildData.getLastBuiltRevision()) != null) {
                    this.revision = gitRevision.getSha1String();
                }
            }
        }

        public SingleTestFlakyStatsWithRevision(SingleTestFlakyStats stats, String revision) {
            this.stats = stats;
            this.revision = revision;
        }

        public String getRevision() {
            return this.revision;
        }

        public SingleTestFlakyStats getStats() {
            return this.stats;
        }
    }

    public static class SingleTestFlakyStats {
        int flake;
        int pass;
        int fail;

        public int getFlake() {
            return this.flake;
        }

        public int getPass() {
            return this.pass;
        }

        public int getFail() {
            return this.fail;
        }

        public void increasePass() {
            ++this.pass;
        }

        public void increaseFail() {
            ++this.fail;
        }

        public void increaseFlake() {
            ++this.flake;
        }

        public SingleTestFlakyStats(int pass, int fail, int flake) {
            this.pass = pass;
            this.fail = fail;
            this.flake = flake;
        }

        public SingleTestFlakyStats(SingleTestFlakyStats stats) {
            this.pass = stats.pass;
            this.fail = stats.fail;
            this.flake = stats.flake;
        }

        public void merge(SingleTestFlakyStats otherTestStats) {
            this.pass += otherTestStats.pass;
            this.fail += otherTestStats.fail;
            this.flake += otherTestStats.flake;
        }

        public boolean isPassed() {
            return this.pass > 0 && this.fail == 0 && this.flake == 0;
        }

        public boolean isFailed() {
            return this.fail > 0 && this.pass == 0 && this.flake == 0;
        }

        public boolean isFlaked() {
            return this.pass > 0 && this.fail > 0 || this.flake > 0;
        }

        public boolean isUnknown() {
            return this.pass == 0 && this.fail == 0 && this.flake == 0;
        }
    }
}

