/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.junit;

import com.google.jenkins.flakyTestHandler.junit.FlakyCaseResult;
import com.google.jenkins.flakyTestHandler.junit.FlakyTestResult;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import hudson.util.io.ParserConfigurator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.xml.sax.SAXException;

@ExportedBean
public final class FlakySuiteResult
implements Serializable {
    private final String file;
    private final String name;
    private final String stdout;
    private final String stderr;
    private float duration;
    private String timestamp;
    private String id;
    private final List<FlakyCaseResult> cases = new ArrayList<FlakyCaseResult>();
    private transient Map<String, FlakyCaseResult> casesByName;
    private transient FlakyTestResult parent;
    private static final long serialVersionUID = 1L;
    private static final Pattern SUREFIRE_FILENAME = Pattern.compile("TEST-(.+)\\.xml");

    FlakySuiteResult(String name, String stdout, String stderr) {
        this.name = name;
        this.stderr = stderr;
        this.stdout = stdout;
        this.file = null;
    }

    private synchronized Map<String, FlakyCaseResult> casesByName() {
        if (this.casesByName == null) {
            this.casesByName = new HashMap<String, FlakyCaseResult>();
            for (FlakyCaseResult c : this.cases) {
                this.casesByName.put(c.getName(), c);
            }
        }
        return this.casesByName;
    }

    static List<FlakySuiteResult> parse(File xmlReport, boolean keepLongStdio) throws DocumentException, IOException, InterruptedException, SAXException {
        ArrayList<FlakySuiteResult> r = new ArrayList<FlakySuiteResult>();
        SAXReader saxReader = new SAXReader();
        saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        ParserConfigurator.applyConfiguration((SAXReader)saxReader, (Object)new SuiteResultParserConfigurationContext(xmlReport));
        Document result = saxReader.read(xmlReport);
        Element root = result.getRootElement();
        FlakySuiteResult.parseSuite(xmlReport, keepLongStdio, r, root);
        return r;
    }

    private static void parseSuite(File xmlReport, boolean keepLongStdio, List<FlakySuiteResult> r, Element root) throws DocumentException, IOException {
        List testSuites = root.elements("testsuite");
        for (Element suite : testSuites) {
            FlakySuiteResult.parseSuite(xmlReport, keepLongStdio, r, suite);
        }
        if (root.element("testcase") != null || root.element("error") != null) {
            r.add(new FlakySuiteResult(xmlReport, root, keepLongStdio));
        }
    }

    private FlakySuiteResult(File xmlReport, Element suite, boolean keepLongStdio) throws DocumentException, IOException {
        File mavenOutputFile;
        Matcher m;
        this.file = xmlReport.getAbsolutePath();
        String name = suite.attributeValue("name");
        if (name == null) {
            name = '(' + xmlReport.getName() + ')';
        } else {
            String pkg = suite.attributeValue("package");
            if (pkg != null && pkg.length() > 0) {
                name = pkg + '.' + name;
            }
        }
        this.name = TestObject.safe((String)name);
        this.timestamp = suite.attributeValue("timestamp");
        this.id = suite.attributeValue("id");
        Element ex = suite.element("error");
        if (ex != null) {
            this.addCase(new FlakyCaseResult(this, suite, "<init>", keepLongStdio));
        }
        List testCases = suite.elements("testcase");
        for (Element e : testCases) {
            String classname = e.attributeValue("classname");
            if (classname == null) {
                classname = suite.attributeValue("name");
            }
            this.addCase(new FlakyCaseResult(this, e, classname, keepLongStdio));
        }
        String stdout = FlakyCaseResult.possiblyTrimStdio(this.cases, keepLongStdio, suite.elementText("system-out"));
        String stderr = FlakyCaseResult.possiblyTrimStdio(this.cases, keepLongStdio, suite.elementText("system-err"));
        if (stdout == null && stderr == null && (m = SUREFIRE_FILENAME.matcher(xmlReport.getName())).matches() && (mavenOutputFile = new File(xmlReport.getParentFile(), m.group(1) + "-output.txt")).exists()) {
            try {
                stdout = FlakyCaseResult.possiblyTrimStdio(this.cases, keepLongStdio, mavenOutputFile);
            }
            catch (IOException e) {
                throw new IOException("Failed to read " + mavenOutputFile, e);
            }
        }
        this.stdout = stdout;
        this.stderr = stderr;
    }

    void addCase(FlakyCaseResult cr) {
        this.cases.add(cr);
        this.casesByName().put(cr.getName(), cr);
        this.duration += cr.getDuration();
    }

    @Exported(visibility=9)
    public String getName() {
        return this.name;
    }

    @Exported(visibility=9)
    public float getDuration() {
        return this.duration;
    }

    @Exported
    public String getStdout() {
        return this.stdout;
    }

    @Exported
    public String getStderr() {
        return this.stderr;
    }

    public String getFile() {
        return this.file;
    }

    public FlakyTestResult getParent() {
        return this.parent;
    }

    @Exported(visibility=9)
    public String getTimestamp() {
        return this.timestamp;
    }

    @Exported(visibility=9)
    public String getId() {
        return this.id;
    }

    @Exported(inline=true, visibility=9)
    public List<FlakyCaseResult> getCases() {
        return this.cases;
    }

    public FlakySuiteResult getPreviousResult() {
        TestResult pr = this.parent.getPreviousResult();
        if (pr == null) {
            return null;
        }
        if (pr instanceof FlakyTestResult) {
            return ((FlakyTestResult)pr).getSuite(this.name);
        }
        return null;
    }

    public FlakyCaseResult getCase(String name) {
        return this.casesByName().get(name);
    }

    public Set<String> getClassNames() {
        HashSet<String> result = new HashSet<String>();
        for (FlakyCaseResult c : this.cases) {
            result.add(c.getClassName());
        }
        return result;
    }

    void setParent(FlakyTestResult parent) {
        this.parent = parent;
    }

    boolean freeze(FlakyTestResult owner) {
        if (this.parent != null) {
            return false;
        }
        this.parent = owner;
        for (FlakyCaseResult c : this.cases) {
            c.freeze(this);
        }
        return true;
    }

    public static class SuiteResultParserConfigurationContext {
        public final File xmlReport;

        SuiteResultParserConfigurationContext(File xmlReport) {
            this.xmlReport = xmlReport;
        }
    }
}

