/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.plugin;

import com.google.jenkins.flakyTestHandler.junit.ActionableFlakyTestObject;
import com.google.jenkins.flakyTestHandler.junit.FlakyCaseResult;
import com.google.jenkins.flakyTestHandler.junit.FlakyClassResult;
import com.google.jenkins.flakyTestHandler.junit.FlakyPackageResult;
import com.google.jenkins.flakyTestHandler.junit.FlakyTestResult;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResultAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JUnitFlakyTestData
extends TestResultAction.Data {
    Map<String, ActionableFlakyTestObject> testCaseFlakyInfoMap = new HashMap<String, ActionableFlakyTestObject>();

    public JUnitFlakyTestData(FlakyTestResult flakyTestResult) {
        this.putClassAndCaseResults(flakyTestResult);
    }

    public List<? extends TestAction> getTestAction(TestObject testObject) {
        ActionableFlakyTestObject flakyTestObject = this.testCaseFlakyInfoMap.get(testObject.getId());
        if (flakyTestObject != null) {
            return Collections.singletonList(flakyTestObject.getTestAction());
        }
        return Collections.emptyList();
    }

    private void putClassAndCaseResults(FlakyTestResult testResult) {
        Collection<FlakyPackageResult> packageResults = testResult.getChildren();
        for (FlakyPackageResult pkgResult : packageResults) {
            Collection<FlakyClassResult> classResults = pkgResult.getChildren();
            for (FlakyClassResult classResult : classResults) {
                this.testCaseFlakyInfoMap.put(classResult.getId(), classResult);
                for (FlakyCaseResult childCaseResult : classResult.getChildren()) {
                    this.testCaseFlakyInfoMap.put(childCaseResult.getId(), childCaseResult);
                }
            }
        }
    }
}

