/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesfoundtrigger;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.plugins.filesfoundtrigger.FileSearch;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.RobustReflectionConverter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class FilesFoundTriggerConfig
extends AbstractDescribableImpl<FilesFoundTriggerConfig> {
    private final String node;
    private final String directory;
    private final String files;
    private final String ignoredFiles;
    private final String triggerNumber;

    public static Descriptor<?> getClassDescriptor() {
        Jenkins jenkins = Jenkins.getInstance();
        return jenkins == null ? null : jenkins.getDescriptor(FilesFoundTriggerConfig.class);
    }

    private static String fixNode(String node) {
        if (node != null && ((node = node.trim()).isEmpty() || node.equalsIgnoreCase("master"))) {
            node = null;
        }
        return node;
    }

    @DataBoundConstructor
    public FilesFoundTriggerConfig(String node, String directory, String files, String ignoredFiles, String triggerNumber) {
        this.node = FilesFoundTriggerConfig.fixNode(node);
        this.directory = Util.fixNull((String)directory).trim();
        this.files = Util.fixNull((String)files).trim();
        this.ignoredFiles = Util.fixNull((String)ignoredFiles).trim();
        this.triggerNumber = Util.fixNull((String)triggerNumber).trim();
    }

    private FilesFoundTriggerConfig() {
        this.node = null;
        this.directory = "";
        this.files = "";
        this.ignoredFiles = "";
        this.triggerNumber = "1";
    }

    public String getNode() {
        return this.node;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFiles() {
        return this.files;
    }

    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public String getTriggerNumber() {
        return this.triggerNumber;
    }

    public int hashCode() {
        return Objects.hash(this.node, this.directory, this.files, this.ignoredFiles, this.triggerNumber);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilesFoundTriggerConfig) {
            FilesFoundTriggerConfig other = (FilesFoundTriggerConfig)((Object)obj);
            return Objects.equals(this.node, other.node) && Objects.equals(this.directory, other.directory) && Objects.equals(this.files, other.files) && Objects.equals(this.ignoredFiles, other.ignoredFiles) && Objects.equals(this.triggerNumber, other.triggerNumber);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("node", (Object)(this.node == null ? "master" : this.node)).append("directory", (Object)this.directory).append("files", (Object)this.files).append("ignoredFiles", (Object)this.ignoredFiles).append("triggerNumber", (Object)this.triggerNumber).toString();
    }

    FilesFoundTriggerConfig expand() {
        EnvVars vars = new EnvVars();
        vars.overrideAll(System.getenv());
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            for (NodeProperty property : jenkins.getGlobalNodeProperties()) {
                if (!(property instanceof EnvironmentVariablesNodeProperty)) continue;
                vars.overrideAll((Map)((EnvironmentVariablesNodeProperty)property).getEnvVars());
            }
        }
        String expNode = this.node == null ? null : vars.expand(this.node);
        String expDirectory = vars.expand(this.directory);
        String expFiles = vars.expand(this.files);
        String expIgnoredFiles = vars.expand(this.ignoredFiles);
        String expTriggerNumber = vars.expand(this.triggerNumber);
        return new FilesFoundTriggerConfig(expNode, expDirectory, expFiles, expIgnoredFiles, expTriggerNumber);
    }

    List<String> findFiles() throws IOException, InterruptedException {
        return FileSearch.perform((FilesFoundTriggerConfig)this).files;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<FilesFoundTriggerConfig> {
        public String getDisplayName() {
            return "";
        }

        public FormValidation doTestConfiguration(@QueryParameter(value="node") String node, @QueryParameter(value="directory") String directory, @QueryParameter(value="files") String files, @QueryParameter(value="ignoredFiles") String ignoredFiles, @QueryParameter(value="triggerNumber") String triggerNumber) throws IOException, InterruptedException {
            FilesFoundTriggerConfig config = new FilesFoundTriggerConfig(node, directory, files, ignoredFiles, triggerNumber);
            return FileSearch.perform((FilesFoundTriggerConfig)config.expand()).formValidation;
        }

        public ComboBoxModel doFillNodeItems() {
            ComboBoxModel model = new ComboBoxModel();
            model.add((Object)"master");
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null) {
                for (Node node : jenkins.getNodes()) {
                    model.add((Object)node.getNodeName());
                }
            }
            return model;
        }
    }

    public static final class ConverterImpl
    extends RobustReflectionConverter {
        public ConverterImpl(Mapper mapper) {
            super(mapper, (ReflectionProvider)new PureJavaReflectionProvider());
        }
    }
}

